import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type FreyrAIM::Spider::ECS::MODULE
 *
 * @schema CfnEcsModuleProps
 */
export interface CfnEcsModuleProps {
    /**
     * @schema CfnEcsModuleProps#Parameters
     */
    readonly parameters?: CfnEcsModulePropsParameters;
    /**
     * @schema CfnEcsModuleProps#Resources
     */
    readonly resources?: CfnEcsModulePropsResources;
}
/**
 * Converts an object of type 'CfnEcsModuleProps' to JSON representation.
 */
export declare function toJson_CfnEcsModuleProps(obj: CfnEcsModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnEcsModulePropsParameters
 */
export interface CfnEcsModulePropsParameters {
    /**
     * The environment name
     *
     * @schema CfnEcsModulePropsParameters#EnvName
     */
    readonly envName?: CfnEcsModulePropsParametersEnvName;
}
/**
 * Converts an object of type 'CfnEcsModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnEcsModulePropsParameters(obj: CfnEcsModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnEcsModulePropsResources
 */
export interface CfnEcsModulePropsResources {
    /**
     * @schema CfnEcsModulePropsResources#TaskDefinition
     */
    readonly taskDefinition?: CfnEcsModulePropsResourcesTaskDefinition;
    /**
     * @schema CfnEcsModulePropsResources#Cluster
     */
    readonly cluster?: CfnEcsModulePropsResourcesCluster;
}
/**
 * Converts an object of type 'CfnEcsModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnEcsModulePropsResources(obj: CfnEcsModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The environment name
 *
 * @schema CfnEcsModulePropsParametersEnvName
 */
export interface CfnEcsModulePropsParametersEnvName {
    /**
     * @schema CfnEcsModulePropsParametersEnvName#Type
     */
    readonly type: string;
    /**
     * @schema CfnEcsModulePropsParametersEnvName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnEcsModulePropsParametersEnvName' to JSON representation.
 */
export declare function toJson_CfnEcsModulePropsParametersEnvName(obj: CfnEcsModulePropsParametersEnvName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnEcsModulePropsResourcesTaskDefinition
 */
export interface CfnEcsModulePropsResourcesTaskDefinition {
    /**
     * @schema CfnEcsModulePropsResourcesTaskDefinition#Type
     */
    readonly type?: string;
    /**
     * @schema CfnEcsModulePropsResourcesTaskDefinition#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnEcsModulePropsResourcesTaskDefinition' to JSON representation.
 */
export declare function toJson_CfnEcsModulePropsResourcesTaskDefinition(obj: CfnEcsModulePropsResourcesTaskDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema CfnEcsModulePropsResourcesCluster
 */
export interface CfnEcsModulePropsResourcesCluster {
    /**
     * @schema CfnEcsModulePropsResourcesCluster#Type
     */
    readonly type?: string;
    /**
     * @schema CfnEcsModulePropsResourcesCluster#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnEcsModulePropsResourcesCluster' to JSON representation.
 */
export declare function toJson_CfnEcsModulePropsResourcesCluster(obj: CfnEcsModulePropsResourcesCluster | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `FreyrAIM::Spider::ECS::MODULE`
 *
 * @cloudformationResource FreyrAIM::Spider::ECS::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnEcsModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "FreyrAIM::Spider::ECS::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnEcsModuleProps;
    /**
     * Create a new `FreyrAIM::Spider::ECS::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnEcsModuleProps);
}
