# Resistant documents client

This tool facilitates communication with the [resistant.ai](https://resistant.ai/products/documents/) document forjerry analysis service using
Python. [Here](https://pdf.resistant.ai/docs/v2-preview.html) you can find a description of the underlying REST service. Below we describe the Python
interface. For a detailed description, go directly to the referenced API docs.

## Prerequisites

You will need two strings to perform further steps. Both you receive during the customer onboarding process.

- CLIENT_ID
- CLIENT_SECRET

## Basic usage

The following example runs fraud analysis on a given document. It is the most usual usage of the API.

```python
from resistant_documents_client.client import ResistantDocumentsClient

client = ResistantDocumentsClient(client_id="YOUR_CLIENT_ID", client_secret="YOUR_CLIENT_SECRET")
with open("local_file.pdf", "rb") as fp:
    report = client.analyze(fp.read(), query_id="local_file.pdf")
print(report["score"])
``` 

## Customized usage

Suppose you want to customize parameters of the process or perform another type of analysis. Below we describe what are the particular steps which you
have to run.

### Create client with you credentials

```python
client = ResistantDocumentsClient(client_id="YOUR_CLIENT_ID", client_secret="YOUR_CLIENT_SECRET")
```

### Create submission with pipeline setup

```python
with open("local_file.pdf", "rb") as fp:
    my_submission_id = client.submit(fp.read(), query_id="local_file.pdf", pipeline_configuration="CONTENT_AFTER_FRAUD_AFTER_QUALITY")
```

Possible pipeline configurations are listed in REST API docs.
### Retrieve analysis result
You can retrieve only those types of analysis which were specified in previous `pipeline_configuration`.

```python
result_content = client.content(submission_id=submission_id)
result_fraud = client.content(submission_id=submission_id)
result_quality = client.quality(submission_id=submission_id)

print(result_content)
print(result_fraud)
print(result_quality)
```
These methods also accept `max_num_retries`, which represents how many times will the client poll the server before failing (because the communication is asynchronous). It might be customized but has a default
value. Other parameters correspond to the ones in the REST API docs.