# -*- coding: utf-8 -*-
# pylint: skip-file
"""This module contains implemtation of F16.

When using it, please cite :cite:`Blumlein:2009ta`.
Mellin transform is defined with the convention x^(N).
"""
import numba as nb
import numpy as np


@nb.njit(cache=True)
def F16(n, S1, Sm1, Sm2, Sm3, Sm21):
    """Implements eq 9.32 of :cite:`Blumlein:2009ta`"""
    return (
        -0.23444040559418688
        - 0.9999999952263307
        * (
            -0.419833592426477 / (1.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 1.0 + n)) / (1.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 2.0 + n)) / (1.0 + n)
            - (0.8224670334241131 * np.power(-1.0, 1.0 + n) * (1 / (1.0 + n) + S1))
            / (1.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 2.0 + n)
                * (Sm1 - (1.0 * np.power(-1.0, n)) / (1.0 + n))
            )
            / (1.0 + n)
            + (
                np.power(-1.0, 2.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    + (1 / (1.0 + n) + S1)
                    * (Sm2 - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2))
                )
            )
            / (1.0 + n)
            + n
            * (
                np.power(1.0 + n, -5)
                - 0.8224670334241131 / np.power(1.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, n)) / np.power(1.0 + n, 3)
                + 0.419833592426477 / np.power(1.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 1.0 + n)) / np.power(1.0 + n, 2)
                - 0.3382260105347306 / (1.0 + n)
                - (0.8224670334241131 * np.power(-1.0, n) * S1) / np.power(1.0 + n, 2)
                - (0.8224670334241131 * np.power(-1.0, 1.0 + n) * Sm1)
                / np.power(1.0 + n, 2)
                + (np.power(-1.0, 1.0 + n) * Sm2) / np.power(1.0 + n, 3)
                + (
                    np.power(-1.0, 1.0 + n)
                    * (
                        S1 * Sm2
                        - 1.0 * Sm21
                        + Sm3
                        + np.power(-1.0, n) / np.power(1.0 + n, 3)
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (1.0 * (1 / (1.0 + n) + S1) * np.power(-1.0, n))
                        / np.power(1.0 + n, 2)
                    )
                )
                / np.power(1.0 + n, 2)
            )
        )
        + 0.49999902059348167
        * (
            -0.419833592426477 / (2.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 2.0 + n)) / (2.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 3.0 + n)) / (2.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 2.0 + n)
                * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)
            )
            / (2.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 3.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    + np.power(-1.0, n) / (2.0 + n)
                )
            )
            / (2.0 + n)
            + (
                np.power(-1.0, 3.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    - (1.0 * (1 / (1.0 + n) + S1) * np.power(-1.0, n))
                    / np.power(2.0 + n, 2)
                    + (1 / (1.0 + n) + 1 / (2.0 + n) + S1)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + np.power(-1.0, n) / np.power(2.0 + n, 2)
                    )
                )
            )
            / (2.0 + n)
            + n
            * (
                np.power(2.0 + n, -5)
                - 0.8224670334241131 / np.power(2.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 1.0 + n)) / np.power(2.0 + n, 3)
                + 0.419833592426477 / np.power(2.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 1.0 + n)) / np.power(2.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 2.0 + n)) / np.power(2.0 + n, 2)
                - 0.3382260105347306 / (2.0 + n)
                - (0.8224670334241131 * np.power(-1.0, 1.0 + n) * (1 / (1.0 + n) + S1))
                / np.power(2.0 + n, 2)
                + (
                    np.power(-1.0, 2.0 + n)
                    * (Sm2 - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2))
                )
                / np.power(2.0 + n, 3)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 2.0 + n)
                    * (Sm1 - (1.0 * np.power(-1.0, n)) / (1.0 + n))
                )
                / np.power(2.0 + n, 2)
                + (
                    np.power(-1.0, 2.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (1 / (1.0 + n) + S1)
                        * (Sm2 - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2))
                    )
                )
                / np.power(2.0 + n, 2)
            )
        )
        - 0.3332995604546604
        * (
            -0.419833592426477 / (3.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 3.0 + n)) / (3.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 4.0 + n)) / (3.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 3.0 + n)
                * (
                    1 / (1.0 + n)
                    + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                    + S1
                )
            )
            / (3.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 4.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    + np.power(-1.0, n) / ((2.0 + n) * (3.0 + n))
                )
            )
            / (3.0 + n)
            + (
                np.power(-1.0, 4.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    - (
                        1.0
                        * (-7.0 - 9.0 * (1.0 + n) - 3.0 * np.power(1.0 + n, 2))
                        * np.power(-1.0, n)
                    )
                    / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3))
                    + (
                        (
                            -5.0
                            - 4.0 * (1.0 + n)
                            + np.power(1.0 + n, 2)
                            + np.power(1.0 + n, 3)
                        )
                        * np.power(-1.0, n)
                    )
                    / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3))
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    + (
                        (-3.0 - 2.0 * (1.0 + n))
                        * (1 / (1.0 + n) + S1)
                        * np.power(-1.0, n)
                    )
                    / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                    + (
                        1 / (1.0 + n)
                        + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                        + S1
                    )
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (1.0 * (-3.0 - 2.0 * (1.0 + n)) * np.power(-1.0, n))
                        / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                    )
                )
            )
            / (3.0 + n)
            + n
            * (
                np.power(3.0 + n, -5)
                - 0.8224670334241131 / np.power(3.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 2.0 + n)) / np.power(3.0 + n, 3)
                + 0.419833592426477 / np.power(3.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 2.0 + n)) / np.power(3.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 3.0 + n)) / np.power(3.0 + n, 2)
                - 0.3382260105347306 / (3.0 + n)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 2.0 + n)
                    * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)
                )
                / np.power(3.0 + n, 2)
                + (
                    np.power(-1.0, 3.0 + n)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + np.power(-1.0, n) / np.power(2.0 + n, 2)
                    )
                )
                / np.power(3.0 + n, 3)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 3.0 + n)
                    * (
                        Sm1
                        - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                        + np.power(-1.0, n) / (2.0 + n)
                    )
                )
                / np.power(3.0 + n, 2)
                + (
                    np.power(-1.0, 3.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (1.0 * (1 / (1.0 + n) + S1) * np.power(-1.0, n))
                        / np.power(2.0 + n, 2)
                        + (1 / (1.0 + n) + 1 / (2.0 + n) + S1)
                        * (
                            Sm2
                            - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                            + np.power(-1.0, n) / np.power(2.0 + n, 2)
                        )
                    )
                )
                / np.power(3.0 + n, 2)
            )
        )
        + 0.24954082848379078
        * (
            -0.419833592426477 / (4.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 4.0 + n)) / (4.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 5.0 + n)) / (4.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 4.0 + n)
                * (
                    1 / (1.0 + n)
                    + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                    + S1
                )
            )
            / (4.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 5.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    - (
                        1.0
                        * (-5.0 - 4.0 * (1.0 + n) - 1.0 * np.power(1.0 + n, 2))
                        * np.power(-1.0, n)
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                )
            )
            / (4.0 + n)
            + (
                np.power(-1.0, 5.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    + (
                        (
                            -179.0
                            - 423.0 * (1.0 + n)
                            - 425.0 * np.power(1.0 + n, 2)
                            - 245.0 * np.power(1.0 + n, 3)
                            - 90.0 * np.power(1.0 + n, 4)
                            - 20.0 * np.power(1.0 + n, 5)
                            - 2.0 * np.power(1.0 + n, 6)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                    )
                    - (
                        1.0
                        * (
                            -197.0
                            - 468.0 * (1.0 + n)
                            - 453.0 * np.power(1.0 + n, 2)
                            - 232.0 * np.power(1.0 + n, 3)
                            - 69.0 * np.power(1.0 + n, 4)
                            - 12.0 * np.power(1.0 + n, 5)
                            - 1.0 * np.power(1.0 + n, 6)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                    )
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    + (
                        (
                            -31.0
                            - 48.0 * (1.0 + n)
                            - 28.0 * np.power(1.0 + n, 2)
                            - 8.0 * np.power(1.0 + n, 3)
                            - 1.0 * np.power(1.0 + n, 4)
                        )
                        * (1 / (1.0 + n) + S1)
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                    )
                    + (
                        1 / (1.0 + n)
                        + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                        + S1
                    )
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            1.0
                            * (
                                -31.0
                                - 48.0 * (1.0 + n)
                                - 28.0 * np.power(1.0 + n, 2)
                                - 8.0 * np.power(1.0 + n, 3)
                                - 1.0 * np.power(1.0 + n, 4)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                        )
                    )
                )
            )
            / (4.0 + n)
            + n
            * (
                np.power(4.0 + n, -5)
                - 0.8224670334241131 / np.power(4.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 3.0 + n)) / np.power(4.0 + n, 3)
                + 0.419833592426477 / np.power(4.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 3.0 + n)) / np.power(4.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 4.0 + n)) / np.power(4.0 + n, 2)
                - 0.3382260105347306 / (4.0 + n)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 3.0 + n)
                    * (
                        1 / (1.0 + n)
                        + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                        + S1
                    )
                )
                / np.power(4.0 + n, 2)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 4.0 + n)
                    * (
                        Sm1
                        - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                        + np.power(-1.0, n) / ((2.0 + n) * (3.0 + n))
                    )
                )
                / np.power(4.0 + n, 2)
                + (
                    np.power(-1.0, 4.0 + n)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (1.0 * (-3.0 - 2.0 * (1.0 + n)) * np.power(-1.0, n))
                        / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                    )
                )
                / np.power(4.0 + n, 3)
                + (
                    np.power(-1.0, 4.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        - (
                            1.0
                            * (-7.0 - 9.0 * (1.0 + n) - 3.0 * np.power(1.0 + n, 2))
                            * np.power(-1.0, n)
                        )
                        / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3))
                        + (
                            (
                                -5.0
                                - 4.0 * (1.0 + n)
                                + np.power(1.0 + n, 2)
                                + np.power(1.0 + n, 3)
                            )
                            * np.power(-1.0, n)
                        )
                        / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3))
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            (-3.0 - 2.0 * (1.0 + n))
                            * (1 / (1.0 + n) + S1)
                            * np.power(-1.0, n)
                        )
                        / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                        + (
                            1 / (1.0 + n)
                            + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                            + S1
                        )
                        * (
                            Sm2
                            - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                            - (1.0 * (-3.0 - 2.0 * (1.0 + n)) * np.power(-1.0, n))
                            / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                        )
                    )
                )
                / np.power(4.0 + n, 2)
            )
        )
        - 0.1967571967137462
        * (
            -0.419833592426477 / (5.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 5.0 + n)) / (5.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 6.0 + n)) / (5.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 5.0 + n)
                * (
                    1 / (1.0 + n)
                    + (
                        2.0
                        * (5.0 + 2.0 * (1.0 + n))
                        * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                    + S1
                )
            )
            / (5.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 6.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    + (
                        2.0
                        * (7.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                        * np.power(-1.0, n)
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                )
            )
            / (5.0 + n)
            + (
                np.power(-1.0, 6.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    + (
                        2.0
                        * (
                            6196.0
                            + 19110.0 * (1.0 + n)
                            + 25497.0 * np.power(1.0 + n, 2)
                            + 19295.0 * np.power(1.0 + n, 3)
                            + 9117.0 * np.power(1.0 + n, 4)
                            + 2775.0 * np.power(1.0 + n, 5)
                            + 535.0 * np.power(1.0 + n, 6)
                            + 60.0 * np.power(1.0 + n, 7)
                            + 3.0 * np.power(1.0 + n, 8)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                    )
                    + (
                        (
                            -9656.0
                            - 26544.0 * (1.0 + n)
                            - 29682.0 * np.power(1.0 + n, 2)
                            - 16521.0 * np.power(1.0 + n, 3)
                            - 3745.0 * np.power(1.0 + n, 4)
                            + 787.0 * np.power(1.0 + n, 5)
                            + 793.0 * np.power(1.0 + n, 6)
                            + 236.0 * np.power(1.0 + n, 7)
                            + 34.0 * np.power(1.0 + n, 8)
                            + 2.0 * np.power(1.0 + n, 9)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                    )
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    - (
                        2.0
                        * (5.0 + 2.0 * (1.0 + n))
                        * (
                            46.0
                            + 70.0 * (1.0 + n)
                            + 39.0 * np.power(1.0 + n, 2)
                            + 10.0 * np.power(1.0 + n, 3)
                            + np.power(1.0 + n, 4)
                        )
                        * (1 / (1.0 + n) + S1)
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                    )
                    + (
                        1 / (1.0 + n)
                        + (
                            2.0
                            * (5.0 + 2.0 * (1.0 + n))
                            * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                        + S1
                    )
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            2.0
                            * (5.0 + 2.0 * (1.0 + n))
                            * (
                                46.0
                                + 70.0 * (1.0 + n)
                                + 39.0 * np.power(1.0 + n, 2)
                                + 10.0 * np.power(1.0 + n, 3)
                                + np.power(1.0 + n, 4)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                        )
                    )
                )
            )
            / (5.0 + n)
            + n
            * (
                np.power(5.0 + n, -5)
                - 0.8224670334241131 / np.power(5.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 4.0 + n)) / np.power(5.0 + n, 3)
                + 0.419833592426477 / np.power(5.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 4.0 + n)) / np.power(5.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 5.0 + n)) / np.power(5.0 + n, 2)
                - 0.3382260105347306 / (5.0 + n)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 4.0 + n)
                    * (
                        1 / (1.0 + n)
                        + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                        + S1
                    )
                )
                / np.power(5.0 + n, 2)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 5.0 + n)
                    * (
                        Sm1
                        - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                        - (
                            1.0
                            * (-5.0 - 4.0 * (1.0 + n) - 1.0 * np.power(1.0 + n, 2))
                            * np.power(-1.0, n)
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                    )
                )
                / np.power(5.0 + n, 2)
                + (
                    np.power(-1.0, 5.0 + n)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            1.0
                            * (
                                -31.0
                                - 48.0 * (1.0 + n)
                                - 28.0 * np.power(1.0 + n, 2)
                                - 8.0 * np.power(1.0 + n, 3)
                                - 1.0 * np.power(1.0 + n, 4)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                        )
                    )
                )
                / np.power(5.0 + n, 3)
                + (
                    np.power(-1.0, 5.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        + (
                            (
                                -179.0
                                - 423.0 * (1.0 + n)
                                - 425.0 * np.power(1.0 + n, 2)
                                - 245.0 * np.power(1.0 + n, 3)
                                - 90.0 * np.power(1.0 + n, 4)
                                - 20.0 * np.power(1.0 + n, 5)
                                - 2.0 * np.power(1.0 + n, 6)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                        )
                        - (
                            1.0
                            * (
                                -197.0
                                - 468.0 * (1.0 + n)
                                - 453.0 * np.power(1.0 + n, 2)
                                - 232.0 * np.power(1.0 + n, 3)
                                - 69.0 * np.power(1.0 + n, 4)
                                - 12.0 * np.power(1.0 + n, 5)
                                - 1.0 * np.power(1.0 + n, 6)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                        )
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            (
                                -31.0
                                - 48.0 * (1.0 + n)
                                - 28.0 * np.power(1.0 + n, 2)
                                - 8.0 * np.power(1.0 + n, 3)
                                - 1.0 * np.power(1.0 + n, 4)
                            )
                            * (1 / (1.0 + n) + S1)
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                        )
                        + (
                            1 / (1.0 + n)
                            + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                            / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                            + S1
                        )
                        * (
                            Sm2
                            - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                            - (
                                1.0
                                * (
                                    -31.0
                                    - 48.0 * (1.0 + n)
                                    - 28.0 * np.power(1.0 + n, 2)
                                    - 8.0 * np.power(1.0 + n, 3)
                                    - 1.0 * np.power(1.0 + n, 4)
                                )
                                * np.power(-1.0, n)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                            )
                        )
                    )
                )
                / np.power(5.0 + n, 2)
            )
        )
        + 0.1530503487172192
        * (
            -0.419833592426477 / (6.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 6.0 + n)) / (6.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 7.0 + n)) / (6.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 6.0 + n)
                * (
                    1 / (1.0 + n)
                    + (
                        274.0
                        + 450.0 * (1.0 + n)
                        + 255.0 * np.power(1.0 + n, 2)
                        + 60.0 * np.power(1.0 + n, 3)
                        + 5.0 * np.power(1.0 + n, 4)
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                    + S1
                )
            )
            / (6.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 7.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    - (
                        1.0
                        * (
                            -94.0
                            - 114.0 * (1.0 + n)
                            - 55.0 * np.power(1.0 + n, 2)
                            - 12.0 * np.power(1.0 + n, 3)
                            - 1.0 * np.power(1.0 + n, 4)
                        )
                        * np.power(-1.0, n)
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                )
            )
            / (6.0 + n)
            + (
                np.power(-1.0, 7.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    + (
                        (
                            -1.364824e6
                            - 4.959e6 * (1.0 + n)
                            - 8.21809e6 * np.power(1.0 + n, 2)
                            - 8.317171e6 * np.power(1.0 + n, 3)
                            - 5.805556e6 * np.power(1.0 + n, 4)
                            - 2.979747e6 * np.power(1.0 + n, 5)
                            - 1.160441e6 * np.power(1.0 + n, 6)
                            - 345225.0 * np.power(1.0 + n, 7)
                            - 77357.0 * np.power(1.0 + n, 8)
                            - 12617.0 * np.power(1.0 + n, 9)
                            - 1409.0 * np.power(1.0 + n, 10)
                            - 96.0 * np.power(1.0 + n, 11)
                            - 3.0 * np.power(1.0 + n, 12)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                    )
                    - (
                        1.0
                        * (
                            -1.562824e6
                            - 5.7933e6 * (1.0 + n)
                            - 9.66711e6 * np.power(1.0 + n, 2)
                            - 9.628272e6 * np.power(1.0 + n, 3)
                            - 6.401058e6 * np.power(1.0 + n, 4)
                            - 3.007494e6 * np.power(1.0 + n, 5)
                            - 1.029715e6 * np.power(1.0 + n, 6)
                            - 260424.0 * np.power(1.0 + n, 7)
                            - 48597.0 * np.power(1.0 + n, 8)
                            - 6570.0 * np.power(1.0 + n, 9)
                            - 615.0 * np.power(1.0 + n, 10)
                            - 36.0 * np.power(1.0 + n, 11)
                            - 1.0 * np.power(1.0 + n, 12)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                    )
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    + (
                        (
                            -12076.0
                            - 29100.0 * (1.0 + n)
                            - 30230.0 * np.power(1.0 + n, 2)
                            - 17964.0 * np.power(1.0 + n, 3)
                            - 6753.0 * np.power(1.0 + n, 4)
                            - 1656.0 * np.power(1.0 + n, 5)
                            - 260.0 * np.power(1.0 + n, 6)
                            - 24.0 * np.power(1.0 + n, 7)
                            - 1.0 * np.power(1.0 + n, 8)
                        )
                        * (1 / (1.0 + n) + S1)
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                    )
                    + (
                        1 / (1.0 + n)
                        + (
                            274.0
                            + 450.0 * (1.0 + n)
                            + 255.0 * np.power(1.0 + n, 2)
                            + 60.0 * np.power(1.0 + n, 3)
                            + 5.0 * np.power(1.0 + n, 4)
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                        + S1
                    )
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            1.0
                            * (
                                -12076.0
                                - 29100.0 * (1.0 + n)
                                - 30230.0 * np.power(1.0 + n, 2)
                                - 17964.0 * np.power(1.0 + n, 3)
                                - 6753.0 * np.power(1.0 + n, 4)
                                - 1656.0 * np.power(1.0 + n, 5)
                                - 260.0 * np.power(1.0 + n, 6)
                                - 24.0 * np.power(1.0 + n, 7)
                                - 1.0 * np.power(1.0 + n, 8)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                        )
                    )
                )
            )
            / (6.0 + n)
            + n
            * (
                np.power(6.0 + n, -5)
                - 0.8224670334241131 / np.power(6.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 5.0 + n)) / np.power(6.0 + n, 3)
                + 0.419833592426477 / np.power(6.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 5.0 + n)) / np.power(6.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 6.0 + n)) / np.power(6.0 + n, 2)
                - 0.3382260105347306 / (6.0 + n)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 5.0 + n)
                    * (
                        1 / (1.0 + n)
                        + (
                            2.0
                            * (5.0 + 2.0 * (1.0 + n))
                            * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                        + S1
                    )
                )
                / np.power(6.0 + n, 2)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 6.0 + n)
                    * (
                        Sm1
                        - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                        + (
                            2.0
                            * (7.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                            * np.power(-1.0, n)
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                    )
                )
                / np.power(6.0 + n, 2)
                + (
                    np.power(-1.0, 6.0 + n)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            2.0
                            * (5.0 + 2.0 * (1.0 + n))
                            * (
                                46.0
                                + 70.0 * (1.0 + n)
                                + 39.0 * np.power(1.0 + n, 2)
                                + 10.0 * np.power(1.0 + n, 3)
                                + np.power(1.0 + n, 4)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                        )
                    )
                )
                / np.power(6.0 + n, 3)
                + (
                    np.power(-1.0, 6.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        + (
                            2.0
                            * (
                                6196.0
                                + 19110.0 * (1.0 + n)
                                + 25497.0 * np.power(1.0 + n, 2)
                                + 19295.0 * np.power(1.0 + n, 3)
                                + 9117.0 * np.power(1.0 + n, 4)
                                + 2775.0 * np.power(1.0 + n, 5)
                                + 535.0 * np.power(1.0 + n, 6)
                                + 60.0 * np.power(1.0 + n, 7)
                                + 3.0 * np.power(1.0 + n, 8)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                        )
                        + (
                            (
                                -9656.0
                                - 26544.0 * (1.0 + n)
                                - 29682.0 * np.power(1.0 + n, 2)
                                - 16521.0 * np.power(1.0 + n, 3)
                                - 3745.0 * np.power(1.0 + n, 4)
                                + 787.0 * np.power(1.0 + n, 5)
                                + 793.0 * np.power(1.0 + n, 6)
                                + 236.0 * np.power(1.0 + n, 7)
                                + 34.0 * np.power(1.0 + n, 8)
                                + 2.0 * np.power(1.0 + n, 9)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                        )
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            2.0
                            * (5.0 + 2.0 * (1.0 + n))
                            * (
                                46.0
                                + 70.0 * (1.0 + n)
                                + 39.0 * np.power(1.0 + n, 2)
                                + 10.0 * np.power(1.0 + n, 3)
                                + np.power(1.0 + n, 4)
                            )
                            * (1 / (1.0 + n) + S1)
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                        )
                        + (
                            1 / (1.0 + n)
                            + (
                                2.0
                                * (5.0 + 2.0 * (1.0 + n))
                                * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                            )
                            / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                            + S1
                        )
                        * (
                            Sm2
                            - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                            + (
                                2.0
                                * (5.0 + 2.0 * (1.0 + n))
                                * (
                                    46.0
                                    + 70.0 * (1.0 + n)
                                    + 39.0 * np.power(1.0 + n, 2)
                                    + 10.0 * np.power(1.0 + n, 3)
                                    + np.power(1.0 + n, 4)
                                )
                                * np.power(-1.0, n)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                            )
                        )
                    )
                )
                / np.power(6.0 + n, 2)
            )
        )
        - 0.10602798528818422
        * (
            -0.419833592426477 / (7.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 7.0 + n)) / (7.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 8.0 + n)) / (7.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 7.0 + n)
                * (
                    1 / (1.0 + n)
                    + (
                        (7.0 + 2.0 * (1.0 + n))
                        * (
                            252.0
                            + 392.0 * (1.0 + n)
                            + 203.0 * np.power(1.0 + n, 2)
                            + 42.0 * np.power(1.0 + n, 3)
                            + 3.0 * np.power(1.0 + n, 4)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                    )
                    + S1
                )
            )
            / (7.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 8.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    + (
                        3.0
                        * (
                            148.0
                            + 168.0 * (1.0 + n)
                            + 73.0 * np.power(1.0 + n, 2)
                            + 14.0 * np.power(1.0 + n, 3)
                            + np.power(1.0 + n, 4)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                    )
                )
            )
            / (7.0 + n)
            + (
                np.power(-1.0, 8.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    + (
                        9.0
                        * (
                            3.7315776e7
                            + 1.56477888e8 * (1.0 + n)
                            + 3.00572848e8 * np.power(1.0 + n, 2)
                            + 3.51218448e8 * np.power(1.0 + n, 3)
                            + 2.79551676e8 * np.power(1.0 + n, 4)
                            + 1.60708716e8 * np.power(1.0 + n, 5)
                            + 6.8959587e7 * np.power(1.0 + n, 6)
                            + 2.2477189e7 * np.power(1.0 + n, 7)
                            + 5.600212e6 * np.power(1.0 + n, 8)
                            + 1.062467e6 * np.power(1.0 + n, 9)
                            + 151200.0 * np.power(1.0 + n, 10)
                            + 15659.0 * np.power(1.0 + n, 11)
                            + 1116.0 * np.power(1.0 + n, 12)
                            + 49.0 * np.power(1.0 + n, 13)
                            + np.power(1.0 + n, 14)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                    )
                    + (
                        (
                            -2.69400384e8
                            - 1.055773152e9 * (1.0 + n)
                            - 1.862215728e9 * np.power(1.0 + n, 2)
                            - 1.946883032e9 * np.power(1.0 + n, 3)
                            - 1.328424984e9 * np.power(1.0 + n, 4)
                            - 6.04538588e8 * np.power(1.0 + n, 5)
                            - 1.71139894e8 * np.power(1.0 + n, 6)
                            - 1.745252e7 * np.power(1.0 + n, 7)
                            + 8.746623e6 * np.power(1.0 + n, 8)
                            + 5.172041e6 * np.power(1.0 + n, 9)
                            + 1.470723e6 * np.power(1.0 + n, 10)
                            + 270665.0 * np.power(1.0 + n, 11)
                            + 33685.0 * np.power(1.0 + n, 12)
                            + 2759.0 * np.power(1.0 + n, 13)
                            + 135.0 * np.power(1.0 + n, 14)
                            + 3.0 * np.power(1.0 + n, 15)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                    )
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    - (
                        3.0
                        * (7.0 + 2.0 * (1.0 + n))
                        * (
                            20016.0
                            + 47936.0 * (1.0 + n)
                            + 49184.0 * np.power(1.0 + n, 2)
                            + 28560.0 * np.power(1.0 + n, 3)
                            + 10321.0 * np.power(1.0 + n, 4)
                            + 2380.0 * np.power(1.0 + n, 5)
                            + 342.0 * np.power(1.0 + n, 6)
                            + 28.0 * np.power(1.0 + n, 7)
                            + np.power(1.0 + n, 8)
                        )
                        * (1 / (1.0 + n) + S1)
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                        * np.power(7.0 + n, 2)
                    )
                    + (
                        1 / (1.0 + n)
                        + (
                            (7.0 + 2.0 * (1.0 + n))
                            * (
                                252.0
                                + 392.0 * (1.0 + n)
                                + 203.0 * np.power(1.0 + n, 2)
                                + 42.0 * np.power(1.0 + n, 3)
                                + 3.0 * np.power(1.0 + n, 4)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                        )
                        + S1
                    )
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            3.0
                            * (7.0 + 2.0 * (1.0 + n))
                            * (
                                20016.0
                                + 47936.0 * (1.0 + n)
                                + 49184.0 * np.power(1.0 + n, 2)
                                + 28560.0 * np.power(1.0 + n, 3)
                                + 10321.0 * np.power(1.0 + n, 4)
                                + 2380.0 * np.power(1.0 + n, 5)
                                + 342.0 * np.power(1.0 + n, 6)
                                + 28.0 * np.power(1.0 + n, 7)
                                + np.power(1.0 + n, 8)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                        )
                    )
                )
            )
            / (7.0 + n)
            + n
            * (
                np.power(7.0 + n, -5)
                - 0.8224670334241131 / np.power(7.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 6.0 + n)) / np.power(7.0 + n, 3)
                + 0.419833592426477 / np.power(7.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 6.0 + n)) / np.power(7.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 7.0 + n)) / np.power(7.0 + n, 2)
                - 0.3382260105347306 / (7.0 + n)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 6.0 + n)
                    * (
                        1 / (1.0 + n)
                        + (
                            274.0
                            + 450.0 * (1.0 + n)
                            + 255.0 * np.power(1.0 + n, 2)
                            + 60.0 * np.power(1.0 + n, 3)
                            + 5.0 * np.power(1.0 + n, 4)
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                        + S1
                    )
                )
                / np.power(7.0 + n, 2)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 7.0 + n)
                    * (
                        Sm1
                        - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                        - (
                            1.0
                            * (
                                -94.0
                                - 114.0 * (1.0 + n)
                                - 55.0 * np.power(1.0 + n, 2)
                                - 12.0 * np.power(1.0 + n, 3)
                                - 1.0 * np.power(1.0 + n, 4)
                            )
                            * np.power(-1.0, n)
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                    )
                )
                / np.power(7.0 + n, 2)
                + (
                    np.power(-1.0, 7.0 + n)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            1.0
                            * (
                                -12076.0
                                - 29100.0 * (1.0 + n)
                                - 30230.0 * np.power(1.0 + n, 2)
                                - 17964.0 * np.power(1.0 + n, 3)
                                - 6753.0 * np.power(1.0 + n, 4)
                                - 1656.0 * np.power(1.0 + n, 5)
                                - 260.0 * np.power(1.0 + n, 6)
                                - 24.0 * np.power(1.0 + n, 7)
                                - 1.0 * np.power(1.0 + n, 8)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                        )
                    )
                )
                / np.power(7.0 + n, 3)
                + (
                    np.power(-1.0, 7.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        + (
                            (
                                -1.364824e6
                                - 4.959e6 * (1.0 + n)
                                - 8.21809e6 * np.power(1.0 + n, 2)
                                - 8.317171e6 * np.power(1.0 + n, 3)
                                - 5.805556e6 * np.power(1.0 + n, 4)
                                - 2.979747e6 * np.power(1.0 + n, 5)
                                - 1.160441e6 * np.power(1.0 + n, 6)
                                - 345225.0 * np.power(1.0 + n, 7)
                                - 77357.0 * np.power(1.0 + n, 8)
                                - 12617.0 * np.power(1.0 + n, 9)
                                - 1409.0 * np.power(1.0 + n, 10)
                                - 96.0 * np.power(1.0 + n, 11)
                                - 3.0 * np.power(1.0 + n, 12)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                        )
                        - (
                            1.0
                            * (
                                -1.562824e6
                                - 5.7933e6 * (1.0 + n)
                                - 9.66711e6 * np.power(1.0 + n, 2)
                                - 9.628272e6 * np.power(1.0 + n, 3)
                                - 6.401058e6 * np.power(1.0 + n, 4)
                                - 3.007494e6 * np.power(1.0 + n, 5)
                                - 1.029715e6 * np.power(1.0 + n, 6)
                                - 260424.0 * np.power(1.0 + n, 7)
                                - 48597.0 * np.power(1.0 + n, 8)
                                - 6570.0 * np.power(1.0 + n, 9)
                                - 615.0 * np.power(1.0 + n, 10)
                                - 36.0 * np.power(1.0 + n, 11)
                                - 1.0 * np.power(1.0 + n, 12)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                        )
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            (
                                -12076.0
                                - 29100.0 * (1.0 + n)
                                - 30230.0 * np.power(1.0 + n, 2)
                                - 17964.0 * np.power(1.0 + n, 3)
                                - 6753.0 * np.power(1.0 + n, 4)
                                - 1656.0 * np.power(1.0 + n, 5)
                                - 260.0 * np.power(1.0 + n, 6)
                                - 24.0 * np.power(1.0 + n, 7)
                                - 1.0 * np.power(1.0 + n, 8)
                            )
                            * (1 / (1.0 + n) + S1)
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                        )
                        + (
                            1 / (1.0 + n)
                            + (
                                274.0
                                + 450.0 * (1.0 + n)
                                + 255.0 * np.power(1.0 + n, 2)
                                + 60.0 * np.power(1.0 + n, 3)
                                + 5.0 * np.power(1.0 + n, 4)
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                            )
                            + S1
                        )
                        * (
                            Sm2
                            - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                            - (
                                1.0
                                * (
                                    -12076.0
                                    - 29100.0 * (1.0 + n)
                                    - 30230.0 * np.power(1.0 + n, 2)
                                    - 17964.0 * np.power(1.0 + n, 3)
                                    - 6753.0 * np.power(1.0 + n, 4)
                                    - 1656.0 * np.power(1.0 + n, 5)
                                    - 260.0 * np.power(1.0 + n, 6)
                                    - 24.0 * np.power(1.0 + n, 7)
                                    - 1.0 * np.power(1.0 + n, 8)
                                )
                                * np.power(-1.0, n)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                            )
                        )
                    )
                )
                / np.power(7.0 + n, 2)
            )
        )
        + 0.056951717764149916
        * (
            -0.419833592426477 / (8.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 8.0 + n)) / (8.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 9.0 + n)) / (8.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 8.0 + n)
                * (
                    1 / (1.0 + n)
                    + (
                        13068.0
                        + 26264.0 * (1.0 + n)
                        + 20307.0 * np.power(1.0 + n, 2)
                        + 7840.0 * np.power(1.0 + n, 3)
                        + 1610.0 * np.power(1.0 + n, 4)
                        + 168.0 * np.power(1.0 + n, 5)
                        + 7.0 * np.power(1.0 + n, 6)
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                    )
                    + S1
                )
            )
            / (8.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 9.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    - (
                        1.0
                        * (
                            -3828.0
                            - 5736.0 * (1.0 + n)
                            - 3661.0 * np.power(1.0 + n, 2)
                            - 1248.0 * np.power(1.0 + n, 3)
                            - 238.0 * np.power(1.0 + n, 4)
                            - 24.0 * np.power(1.0 + n, 5)
                            - 1.0 * np.power(1.0 + n, 6)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                    )
                )
            )
            / (8.0 + n)
            + (
                np.power(-1.0, 9.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    - (
                        1.0
                        * (
                            -1.15567048512e11
                            - 5.35159384704e11 * (1.0 + n)
                            - 1.151188217424e12 * np.power(1.0 + n, 2)
                            - 1.53078715296e12 * np.power(1.0 + n, 3)
                            - 1.412584727652e12 * np.power(1.0 + n, 4)
                            - 9.62381167416e11 * np.power(1.0 + n, 5)
                            - 5.02598549197e11 * np.power(1.0 + n, 6)
                            - 2.0609943264e11 * np.power(1.0 + n, 7)
                            - 6.7393018182e10 * np.power(1.0 + n, 8)
                            - 1.7735954328e10 * np.power(1.0 + n, 9)
                            - 3.772650903e9 * np.power(1.0 + n, 10)
                            - 6.48395136e8 * np.power(1.0 + n, 11)
                            - 8.9565928e7 * np.power(1.0 + n, 12)
                            - 9.831528e6 * np.power(1.0 + n, 13)
                            - 840651.0 * np.power(1.0 + n, 14)
                            - 54144.0 * np.power(1.0 + n, 15)
                            - 2478.0 * np.power(1.0 + n, 16)
                            - 72.0 * np.power(1.0 + n, 17)
                            - 1.0 * np.power(1.0 + n, 18)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                    )
                    - (
                        2.0
                        * (
                            4.9589391456e10
                            + 2.24271058032e11 * (1.0 + n)
                            + 4.7403095628e11 * np.power(1.0 + n, 2)
                            + 6.25731974284e11 * np.power(1.0 + n, 3)
                            + 5.81676555432e11 * np.power(1.0 + n, 4)
                            + 4.0689079961e11 * np.power(1.0 + n, 5)
                            + 2.23175026185e11 * np.power(1.0 + n, 6)
                            + 9.8520885539e10 * np.power(1.0 + n, 7)
                            + 3.554804558e10 * np.power(1.0 + n, 8)
                            + 1.0556408108e10 * np.power(1.0 + n, 9)
                            + 2.579863556e9 * np.power(1.0 + n, 10)
                            + 5.15736142e8 * np.power(1.0 + n, 11)
                            + 8.3361904e7 * np.power(1.0 + n, 12)
                            + 1.0703902e7 * np.power(1.0 + n, 13)
                            + 1.064065e6 * np.power(1.0 + n, 14)
                            + 78795.0 * np.power(1.0 + n, 15)
                            + 4084.0 * np.power(1.0 + n, 16)
                            + 132.0 * np.power(1.0 + n, 17)
                            + 2.0 * np.power(1.0 + n, 18)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                    )
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    + (
                        (
                            -2.1114864e7
                            - 6.3635712e7 * (1.0 + n)
                            - 8.634864e7 * np.power(1.0 + n, 2)
                            - 7.024968e7 * np.power(1.0 + n, 3)
                            - 3.8347981e7 * np.power(1.0 + n, 4)
                            - 1.4846592e7 * np.power(1.0 + n, 5)
                            - 4.190576e6 * np.power(1.0 + n, 6)
                            - 870720.0 * np.power(1.0 + n, 7)
                            - 132426.0 * np.power(1.0 + n, 8)
                            - 14400.0 * np.power(1.0 + n, 9)
                            - 1064.0 * np.power(1.0 + n, 10)
                            - 48.0 * np.power(1.0 + n, 11)
                            - 1.0 * np.power(1.0 + n, 12)
                        )
                        * (1 / (1.0 + n) + S1)
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                        * np.power(7.0 + n, 2)
                        * np.power(8.0 + n, 2)
                    )
                    + (
                        1 / (1.0 + n)
                        + (
                            13068.0
                            + 26264.0 * (1.0 + n)
                            + 20307.0 * np.power(1.0 + n, 2)
                            + 7840.0 * np.power(1.0 + n, 3)
                            + 1610.0 * np.power(1.0 + n, 4)
                            + 168.0 * np.power(1.0 + n, 5)
                            + 7.0 * np.power(1.0 + n, 6)
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                        )
                        + S1
                    )
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            1.0
                            * (
                                -2.1114864e7
                                - 6.3635712e7 * (1.0 + n)
                                - 8.634864e7 * np.power(1.0 + n, 2)
                                - 7.024968e7 * np.power(1.0 + n, 3)
                                - 3.8347981e7 * np.power(1.0 + n, 4)
                                - 1.4846592e7 * np.power(1.0 + n, 5)
                                - 4.190576e6 * np.power(1.0 + n, 6)
                                - 870720.0 * np.power(1.0 + n, 7)
                                - 132426.0 * np.power(1.0 + n, 8)
                                - 14400.0 * np.power(1.0 + n, 9)
                                - 1064.0 * np.power(1.0 + n, 10)
                                - 48.0 * np.power(1.0 + n, 11)
                                - 1.0 * np.power(1.0 + n, 12)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                        )
                    )
                )
            )
            / (8.0 + n)
            + n
            * (
                np.power(8.0 + n, -5)
                - 0.8224670334241131 / np.power(8.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 7.0 + n)) / np.power(8.0 + n, 3)
                + 0.419833592426477 / np.power(8.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 7.0 + n)) / np.power(8.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 8.0 + n)) / np.power(8.0 + n, 2)
                - 0.3382260105347306 / (8.0 + n)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 7.0 + n)
                    * (
                        1 / (1.0 + n)
                        + (
                            (7.0 + 2.0 * (1.0 + n))
                            * (
                                252.0
                                + 392.0 * (1.0 + n)
                                + 203.0 * np.power(1.0 + n, 2)
                                + 42.0 * np.power(1.0 + n, 3)
                                + 3.0 * np.power(1.0 + n, 4)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(8.0 + n, 2)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 8.0 + n)
                    * (
                        Sm1
                        - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                        + (
                            3.0
                            * (
                                148.0
                                + 168.0 * (1.0 + n)
                                + 73.0 * np.power(1.0 + n, 2)
                                + 14.0 * np.power(1.0 + n, 3)
                                + np.power(1.0 + n, 4)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                        )
                    )
                )
                / np.power(8.0 + n, 2)
                + (
                    np.power(-1.0, 8.0 + n)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            3.0
                            * (7.0 + 2.0 * (1.0 + n))
                            * (
                                20016.0
                                + 47936.0 * (1.0 + n)
                                + 49184.0 * np.power(1.0 + n, 2)
                                + 28560.0 * np.power(1.0 + n, 3)
                                + 10321.0 * np.power(1.0 + n, 4)
                                + 2380.0 * np.power(1.0 + n, 5)
                                + 342.0 * np.power(1.0 + n, 6)
                                + 28.0 * np.power(1.0 + n, 7)
                                + np.power(1.0 + n, 8)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                        )
                    )
                )
                / np.power(8.0 + n, 3)
                + (
                    np.power(-1.0, 8.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        + (
                            9.0
                            * (
                                3.7315776e7
                                + 1.56477888e8 * (1.0 + n)
                                + 3.00572848e8 * np.power(1.0 + n, 2)
                                + 3.51218448e8 * np.power(1.0 + n, 3)
                                + 2.79551676e8 * np.power(1.0 + n, 4)
                                + 1.60708716e8 * np.power(1.0 + n, 5)
                                + 6.8959587e7 * np.power(1.0 + n, 6)
                                + 2.2477189e7 * np.power(1.0 + n, 7)
                                + 5.600212e6 * np.power(1.0 + n, 8)
                                + 1.062467e6 * np.power(1.0 + n, 9)
                                + 151200.0 * np.power(1.0 + n, 10)
                                + 15659.0 * np.power(1.0 + n, 11)
                                + 1116.0 * np.power(1.0 + n, 12)
                                + 49.0 * np.power(1.0 + n, 13)
                                + np.power(1.0 + n, 14)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                        )
                        + (
                            (
                                -2.69400384e8
                                - 1.055773152e9 * (1.0 + n)
                                - 1.862215728e9 * np.power(1.0 + n, 2)
                                - 1.946883032e9 * np.power(1.0 + n, 3)
                                - 1.328424984e9 * np.power(1.0 + n, 4)
                                - 6.04538588e8 * np.power(1.0 + n, 5)
                                - 1.71139894e8 * np.power(1.0 + n, 6)
                                - 1.745252e7 * np.power(1.0 + n, 7)
                                + 8.746623e6 * np.power(1.0 + n, 8)
                                + 5.172041e6 * np.power(1.0 + n, 9)
                                + 1.470723e6 * np.power(1.0 + n, 10)
                                + 270665.0 * np.power(1.0 + n, 11)
                                + 33685.0 * np.power(1.0 + n, 12)
                                + 2759.0 * np.power(1.0 + n, 13)
                                + 135.0 * np.power(1.0 + n, 14)
                                + 3.0 * np.power(1.0 + n, 15)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                        )
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            3.0
                            * (7.0 + 2.0 * (1.0 + n))
                            * (
                                20016.0
                                + 47936.0 * (1.0 + n)
                                + 49184.0 * np.power(1.0 + n, 2)
                                + 28560.0 * np.power(1.0 + n, 3)
                                + 10321.0 * np.power(1.0 + n, 4)
                                + 2380.0 * np.power(1.0 + n, 5)
                                + 342.0 * np.power(1.0 + n, 6)
                                + 28.0 * np.power(1.0 + n, 7)
                                + np.power(1.0 + n, 8)
                            )
                            * (1 / (1.0 + n) + S1)
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                        )
                        + (
                            1 / (1.0 + n)
                            + (
                                (7.0 + 2.0 * (1.0 + n))
                                * (
                                    252.0
                                    + 392.0 * (1.0 + n)
                                    + 203.0 * np.power(1.0 + n, 2)
                                    + 42.0 * np.power(1.0 + n, 3)
                                    + 3.0 * np.power(1.0 + n, 4)
                                )
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                            )
                            + S1
                        )
                        * (
                            Sm2
                            - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                            + (
                                3.0
                                * (7.0 + 2.0 * (1.0 + n))
                                * (
                                    20016.0
                                    + 47936.0 * (1.0 + n)
                                    + 49184.0 * np.power(1.0 + n, 2)
                                    + 28560.0 * np.power(1.0 + n, 3)
                                    + 10321.0 * np.power(1.0 + n, 4)
                                    + 2380.0 * np.power(1.0 + n, 5)
                                    + 342.0 * np.power(1.0 + n, 6)
                                    + 28.0 * np.power(1.0 + n, 7)
                                    + np.power(1.0 + n, 8)
                                )
                                * np.power(-1.0, n)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                            )
                        )
                    )
                )
                / np.power(8.0 + n, 2)
            )
        )
        - 0.019847559824380426
        * (
            -0.419833592426477 / (9.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 9.0 + n)) / (9.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 10.0 + n)) / (9.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 9.0 + n)
                * (
                    1 / (1.0 + n)
                    + (
                        4.0
                        * (9.0 + 2.0 * (1.0 + n))
                        * (
                            3044.0
                            + 5886.0 * (1.0 + n)
                            + 4299.0 * np.power(1.0 + n, 2)
                            + 1539.0 * np.power(1.0 + n, 3)
                            + 288.0 * np.power(1.0 + n, 4)
                            + 27.0 * np.power(1.0 + n, 5)
                            + np.power(1.0 + n, 6)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                    )
                    + S1
                )
            )
            / (9.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 10.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    + (
                        4.0
                        * (
                            6396.0
                            + 9162.0 * (1.0 + n)
                            + 5473.0 * np.power(1.0 + n, 2)
                            + 1719.0 * np.power(1.0 + n, 3)
                            + 298.0 * np.power(1.0 + n, 4)
                            + 27.0 * np.power(1.0 + n, 5)
                            + np.power(1.0 + n, 6)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                    )
                )
            )
            / (9.0 + n)
            + (
                np.power(-1.0, 10.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    + (
                        4.0
                        * (
                            1.4760576193536e13
                            + 7.3798658489088e13 * (1.0 + n)
                            + 1.72837443710016e14 * np.power(1.0 + n, 2)
                            + 2.52453402491616e14 * np.power(1.0 + n, 3)
                            + 2.5828967175624e14 * np.power(1.0 + n, 4)
                            + 1.97032446481464e14 * np.power(1.0 + n, 5)
                            + 1.16425369498108e14 * np.power(1.0 + n, 6)
                            + 5.4627507667116e13 * np.power(1.0 + n, 7)
                            + 2.0690074606371e13 * np.power(1.0 + n, 8)
                            + 6.392775359655e12 * np.power(1.0 + n, 9)
                            + 1.621160332314e12 * np.power(1.0 + n, 10)
                            + 3.38175413478e11 * np.power(1.0 + n, 11)
                            + 5.7948536701e10 * np.power(1.0 + n, 12)
                            + 8.115008166e9 * np.power(1.0 + n, 13)
                            + 9.1986012e8 * np.power(1.0 + n, 14)
                            + 8.3116584e7 * np.power(1.0 + n, 15)
                            + 5.847213e6 * np.power(1.0 + n, 16)
                            + 308691.0 * np.power(1.0 + n, 17)
                            + 11506.0 * np.power(1.0 + n, 18)
                            + 270.0 * np.power(1.0 + n, 19)
                            + 3.0 * np.power(1.0 + n, 20)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                        * np.power(9.0 + n, 3)
                    )
                    + (
                        2.0
                        * (
                            -2.3997963958272e13
                            - 1.14129905965056e14 * (1.0 + n)
                            - 2.5222059905856e14 * np.power(1.0 + n, 2)
                            - 3.44033181492512e14 * np.power(1.0 + n, 3)
                            - 3.23935732772496e14 * np.power(1.0 + n, 4)
                            - 2.22502088875352e14 * np.power(1.0 + n, 5)
                            - 1.14348498644148e14 * np.power(1.0 + n, 6)
                            - 4.3968646592044e13 * np.power(1.0 + n, 7)
                            - 1.21438136977e13 * np.power(1.0 + n, 8)
                            - 2.010931672623e12 * np.power(1.0 + n, 9)
                            + 4.9482178305e10 * np.power(1.0 + n, 10)
                            + 1.59991878826e11 * np.power(1.0 + n, 11)
                            + 6.0723226806e10 * np.power(1.0 + n, 12)
                            + 1.4651858516e10 * np.power(1.0 + n, 13)
                            + 2.59766429e9 * np.power(1.0 + n, 14)
                            + 3.51680472e8 * np.power(1.0 + n, 15)
                            + 3.6575004e7 * np.power(1.0 + n, 16)
                            + 2.886025e6 * np.power(1.0 + n, 17)
                            + 167625.0 * np.power(1.0 + n, 18)
                            + 6770.0 * np.power(1.0 + n, 19)
                            + 170.0 * np.power(1.0 + n, 20)
                            + 2.0 * np.power(1.0 + n, 21)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                        * np.power(9.0 + n, 3)
                    )
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    - (
                        4.0
                        * (9.0 + 2.0 * (1.0 + n))
                        * (
                            3.6831936e7
                            + 1.10670624e8 * (1.0 + n)
                            + 1.4936364e8 * np.power(1.0 + n, 2)
                            + 1.2041208e8 * np.power(1.0 + n, 3)
                            + 6.4783246e7 * np.power(1.0 + n, 4)
                            + 2.454111e7 * np.power(1.0 + n, 5)
                            + 6.715739e6 * np.power(1.0 + n, 6)
                            + 1.33785e6 * np.power(1.0 + n, 7)
                            + 192561.0 * np.power(1.0 + n, 8)
                            + 19530.0 * np.power(1.0 + n, 9)
                            + 1325.0 * np.power(1.0 + n, 10)
                            + 54.0 * np.power(1.0 + n, 11)
                            + np.power(1.0 + n, 12)
                        )
                        * (1 / (1.0 + n) + S1)
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                        * np.power(7.0 + n, 2)
                        * np.power(8.0 + n, 2)
                        * np.power(9.0 + n, 2)
                    )
                    + (
                        1 / (1.0 + n)
                        + (
                            4.0
                            * (9.0 + 2.0 * (1.0 + n))
                            * (
                                3044.0
                                + 5886.0 * (1.0 + n)
                                + 4299.0 * np.power(1.0 + n, 2)
                                + 1539.0 * np.power(1.0 + n, 3)
                                + 288.0 * np.power(1.0 + n, 4)
                                + 27.0 * np.power(1.0 + n, 5)
                                + np.power(1.0 + n, 6)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                            * (9.0 + n)
                        )
                        + S1
                    )
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            4.0
                            * (9.0 + 2.0 * (1.0 + n))
                            * (
                                3.6831936e7
                                + 1.10670624e8 * (1.0 + n)
                                + 1.4936364e8 * np.power(1.0 + n, 2)
                                + 1.2041208e8 * np.power(1.0 + n, 3)
                                + 6.4783246e7 * np.power(1.0 + n, 4)
                                + 2.454111e7 * np.power(1.0 + n, 5)
                                + 6.715739e6 * np.power(1.0 + n, 6)
                                + 1.33785e6 * np.power(1.0 + n, 7)
                                + 192561.0 * np.power(1.0 + n, 8)
                                + 19530.0 * np.power(1.0 + n, 9)
                                + 1325.0 * np.power(1.0 + n, 10)
                                + 54.0 * np.power(1.0 + n, 11)
                                + np.power(1.0 + n, 12)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                            * np.power(9.0 + n, 2)
                        )
                    )
                )
            )
            / (9.0 + n)
            + n
            * (
                np.power(9.0 + n, -5)
                - 0.8224670334241131 / np.power(9.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 8.0 + n)) / np.power(9.0 + n, 3)
                + 0.419833592426477 / np.power(9.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 8.0 + n)) / np.power(9.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 9.0 + n)) / np.power(9.0 + n, 2)
                - 0.3382260105347306 / (9.0 + n)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 8.0 + n)
                    * (
                        1 / (1.0 + n)
                        + (
                            13068.0
                            + 26264.0 * (1.0 + n)
                            + 20307.0 * np.power(1.0 + n, 2)
                            + 7840.0 * np.power(1.0 + n, 3)
                            + 1610.0 * np.power(1.0 + n, 4)
                            + 168.0 * np.power(1.0 + n, 5)
                            + 7.0 * np.power(1.0 + n, 6)
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(9.0 + n, 2)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 9.0 + n)
                    * (
                        Sm1
                        - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                        - (
                            1.0
                            * (
                                -3828.0
                                - 5736.0 * (1.0 + n)
                                - 3661.0 * np.power(1.0 + n, 2)
                                - 1248.0 * np.power(1.0 + n, 3)
                                - 238.0 * np.power(1.0 + n, 4)
                                - 24.0 * np.power(1.0 + n, 5)
                                - 1.0 * np.power(1.0 + n, 6)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                        )
                    )
                )
                / np.power(9.0 + n, 2)
                + (
                    np.power(-1.0, 9.0 + n)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            1.0
                            * (
                                -2.1114864e7
                                - 6.3635712e7 * (1.0 + n)
                                - 8.634864e7 * np.power(1.0 + n, 2)
                                - 7.024968e7 * np.power(1.0 + n, 3)
                                - 3.8347981e7 * np.power(1.0 + n, 4)
                                - 1.4846592e7 * np.power(1.0 + n, 5)
                                - 4.190576e6 * np.power(1.0 + n, 6)
                                - 870720.0 * np.power(1.0 + n, 7)
                                - 132426.0 * np.power(1.0 + n, 8)
                                - 14400.0 * np.power(1.0 + n, 9)
                                - 1064.0 * np.power(1.0 + n, 10)
                                - 48.0 * np.power(1.0 + n, 11)
                                - 1.0 * np.power(1.0 + n, 12)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                        )
                    )
                )
                / np.power(9.0 + n, 3)
                + (
                    np.power(-1.0, 9.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        - (
                            1.0
                            * (
                                -1.15567048512e11
                                - 5.35159384704e11 * (1.0 + n)
                                - 1.151188217424e12 * np.power(1.0 + n, 2)
                                - 1.53078715296e12 * np.power(1.0 + n, 3)
                                - 1.412584727652e12 * np.power(1.0 + n, 4)
                                - 9.62381167416e11 * np.power(1.0 + n, 5)
                                - 5.02598549197e11 * np.power(1.0 + n, 6)
                                - 2.0609943264e11 * np.power(1.0 + n, 7)
                                - 6.7393018182e10 * np.power(1.0 + n, 8)
                                - 1.7735954328e10 * np.power(1.0 + n, 9)
                                - 3.772650903e9 * np.power(1.0 + n, 10)
                                - 6.48395136e8 * np.power(1.0 + n, 11)
                                - 8.9565928e7 * np.power(1.0 + n, 12)
                                - 9.831528e6 * np.power(1.0 + n, 13)
                                - 840651.0 * np.power(1.0 + n, 14)
                                - 54144.0 * np.power(1.0 + n, 15)
                                - 2478.0 * np.power(1.0 + n, 16)
                                - 72.0 * np.power(1.0 + n, 17)
                                - 1.0 * np.power(1.0 + n, 18)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                            * np.power(8.0 + n, 3)
                        )
                        - (
                            2.0
                            * (
                                4.9589391456e10
                                + 2.24271058032e11 * (1.0 + n)
                                + 4.7403095628e11 * np.power(1.0 + n, 2)
                                + 6.25731974284e11 * np.power(1.0 + n, 3)
                                + 5.81676555432e11 * np.power(1.0 + n, 4)
                                + 4.0689079961e11 * np.power(1.0 + n, 5)
                                + 2.23175026185e11 * np.power(1.0 + n, 6)
                                + 9.8520885539e10 * np.power(1.0 + n, 7)
                                + 3.554804558e10 * np.power(1.0 + n, 8)
                                + 1.0556408108e10 * np.power(1.0 + n, 9)
                                + 2.579863556e9 * np.power(1.0 + n, 10)
                                + 5.15736142e8 * np.power(1.0 + n, 11)
                                + 8.3361904e7 * np.power(1.0 + n, 12)
                                + 1.0703902e7 * np.power(1.0 + n, 13)
                                + 1.064065e6 * np.power(1.0 + n, 14)
                                + 78795.0 * np.power(1.0 + n, 15)
                                + 4084.0 * np.power(1.0 + n, 16)
                                + 132.0 * np.power(1.0 + n, 17)
                                + 2.0 * np.power(1.0 + n, 18)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                            * np.power(8.0 + n, 3)
                        )
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            (
                                -2.1114864e7
                                - 6.3635712e7 * (1.0 + n)
                                - 8.634864e7 * np.power(1.0 + n, 2)
                                - 7.024968e7 * np.power(1.0 + n, 3)
                                - 3.8347981e7 * np.power(1.0 + n, 4)
                                - 1.4846592e7 * np.power(1.0 + n, 5)
                                - 4.190576e6 * np.power(1.0 + n, 6)
                                - 870720.0 * np.power(1.0 + n, 7)
                                - 132426.0 * np.power(1.0 + n, 8)
                                - 14400.0 * np.power(1.0 + n, 9)
                                - 1064.0 * np.power(1.0 + n, 10)
                                - 48.0 * np.power(1.0 + n, 11)
                                - 1.0 * np.power(1.0 + n, 12)
                            )
                            * (1 / (1.0 + n) + S1)
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                        )
                        + (
                            1 / (1.0 + n)
                            + (
                                13068.0
                                + 26264.0 * (1.0 + n)
                                + 20307.0 * np.power(1.0 + n, 2)
                                + 7840.0 * np.power(1.0 + n, 3)
                                + 1610.0 * np.power(1.0 + n, 4)
                                + 168.0 * np.power(1.0 + n, 5)
                                + 7.0 * np.power(1.0 + n, 6)
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                                * (8.0 + n)
                            )
                            + S1
                        )
                        * (
                            Sm2
                            - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                            - (
                                1.0
                                * (
                                    -2.1114864e7
                                    - 6.3635712e7 * (1.0 + n)
                                    - 8.634864e7 * np.power(1.0 + n, 2)
                                    - 7.024968e7 * np.power(1.0 + n, 3)
                                    - 3.8347981e7 * np.power(1.0 + n, 4)
                                    - 1.4846592e7 * np.power(1.0 + n, 5)
                                    - 4.190576e6 * np.power(1.0 + n, 6)
                                    - 870720.0 * np.power(1.0 + n, 7)
                                    - 132426.0 * np.power(1.0 + n, 8)
                                    - 14400.0 * np.power(1.0 + n, 9)
                                    - 1064.0 * np.power(1.0 + n, 10)
                                    - 48.0 * np.power(1.0 + n, 11)
                                    - 1.0 * np.power(1.0 + n, 12)
                                )
                                * np.power(-1.0, n)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                                * np.power(8.0 + n, 2)
                            )
                        )
                    )
                )
                / np.power(9.0 + n, 2)
            )
        )
        + 0.003243204652309423
        * (
            -0.419833592426477 / (10.0 + n)
            - (0.18119485915332012 * np.power(-1.0, 10.0 + n)) / (10.0 + n)
            - (0.6010284515797971 * np.power(-1.0, 11.0 + n)) / (10.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 10.0 + n)
                * (
                    1 / (1.0 + n)
                    + (
                        3.0
                        * (
                            342192.0
                            + 781800.0 * (1.0 + n)
                            + 723680.0 * np.power(1.0 + n, 2)
                            + 359100.0 * np.power(1.0 + n, 3)
                            + 105455.0 * np.power(1.0 + n, 4)
                            + 18900.0 * np.power(1.0 + n, 5)
                            + 2030.0 * np.power(1.0 + n, 6)
                            + 120.0 * np.power(1.0 + n, 7)
                            + 3.0 * np.power(1.0 + n, 8)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                        * (10.0 + n)
                    )
                    + S1
                )
            )
            / (10.0 + n)
            - (
                0.8224670334241131
                * np.power(-1.0, 11.0 + n)
                * (
                    Sm1
                    - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                    - (
                        1.0
                        * (
                            -270576.0
                            - 465000.0 * (1.0 + n)
                            - 351800.0 * np.power(1.0 + n, 2)
                            - 151060.0 * np.power(1.0 + n, 3)
                            - 40053.0 * np.power(1.0 + n, 4)
                            - 6700.0 * np.power(1.0 + n, 5)
                            - 690.0 * np.power(1.0 + n, 6)
                            - 40.0 * np.power(1.0 + n, 7)
                            - 1.0 * np.power(1.0 + n, 8)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                        * (10.0 + n)
                    )
                )
            )
            / (10.0 + n)
            + (
                np.power(-1.0, 11.0 + n)
                * (
                    -1.0 * Sm21
                    + Sm3
                    + (
                        (
                            -3.665793851814298e16
                            - 1.909490377752576e17 * (1.0 + n)
                            - 4.70862544109472e17 * np.power(1.0 + n, 2)
                            - 7.33980385029854e17 * np.power(1.0 + n, 3)
                            - 8.148989973914079e17 * np.power(1.0 + n, 4)
                            - 6.882981306584479e17 * np.power(1.0 + n, 5)
                            - 4.611713296031033e17 * np.power(1.0 + n, 6)
                            - 2.5219843129581005e17 * np.power(1.0 + n, 7)
                            - 1.14842783872951e17 * np.power(1.0 + n, 8)
                            - 4.415488009076552e16 * np.power(1.0 + n, 9)
                            - 1.44652124073368e16 * np.power(1.0 + n, 10)
                            - 4.05880131245378e15 * np.power(1.0 + n, 11)
                            - 9.77306344262685e14 * np.power(1.0 + n, 12)
                            - 2.01769269859842e14 * np.power(1.0 + n, 13)
                            - 3.560081466145e13 * np.power(1.0 + n, 14)
                            - 5.339127383592e12 * np.power(1.0 + n, 15)
                            - 6.75333270995e11 * np.power(1.0 + n, 16)
                            - 7.1298201266e10 * np.power(1.0 + n, 17)
                            - 6.19612062e9 * np.power(1.0 + n, 18)
                            - 4.34978004e8 * np.power(1.0 + n, 19)
                            - 2.4024499e7 * np.power(1.0 + n, 20)
                            - 1.00395e6 * np.power(1.0 + n, 21)
                            - 29810.0 * np.power(1.0 + n, 22)
                            - 560.0 * np.power(1.0 + n, 23)
                            - 5.0 * np.power(1.0 + n, 24)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                        * np.power(9.0 + n, 3)
                        * np.power(10.0 + n, 3)
                    )
                    - (
                        1.0
                        * (
                            -4.310738850111898e16
                            - 2.300786211297024e17 * (1.0 + n)
                            - 5.793490942232486e17 * np.power(1.0 + n, 2)
                            - 9.169570554312557e17 * np.power(1.0 + n, 3)
                            - 1.0253555704764628e18 * np.power(1.0 + n, 4)
                            - 8.63111634551316e17 * np.power(1.0 + n, 5)
                            - 5.689117565311652e17 * np.power(1.0 + n, 6)
                            - 3.014933810188104e17 * np.power(1.0 + n, 7)
                            - 1.3085272169429526e17 * np.power(1.0 + n, 8)
                            - 4.712719391395e16 * np.power(1.0 + n, 9)
                            - 1.42167692592585e16 * np.power(1.0 + n, 10)
                            - 3.6154166212347e15 * np.power(1.0 + n, 11)
                            - 7.78200392291745e14 * np.power(1.0 + n, 12)
                            - 1.420469104479e14 * np.power(1.0 + n, 13)
                            - 2.198557186497e13 * np.power(1.0 + n, 14)
                            - 2.8791357052e12 * np.power(1.0 + n, 15)
                            - 3.17567574315e11 * np.power(1.0 + n, 16)
                            - 2.92849434e10 * np.power(1.0 + n, 17)
                            - 2.23273176e9 * np.power(1.0 + n, 18)
                            - 1.384419e8 * np.power(1.0 + n, 19)
                            - 6.812919e6 * np.power(1.0 + n, 20)
                            - 256300.0 * np.power(1.0 + n, 21)
                            - 6930.0 * np.power(1.0 + n, 22)
                            - 120.0 * np.power(1.0 + n, 23)
                            - 1.0 * np.power(1.0 + n, 24)
                        )
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                        * np.power(9.0 + n, 3)
                        * np.power(10.0 + n, 3)
                    )
                    + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                    + (
                        (
                            -1.09027627776e11
                            - 3.792865824e11 * (1.0 + n)
                            - 6.0713742384e11 * np.power(1.0 + n, 2)
                            - 5.9622705312e11 * np.power(1.0 + n, 3)
                            - 4.03242887656e11 * np.power(1.0 + n, 4)
                            - 1.99571643e11 * np.power(1.0 + n, 5)
                            - 7.48814979e10 * np.power(1.0 + n, 6)
                            - 2.175554084e10 * np.power(1.0 + n, 7)
                            - 4.951843521e9 * np.power(1.0 + n, 8)
                            - 8.86903e8 * np.power(1.0 + n, 9)
                            - 1.2470866e8 * np.power(1.0 + n, 10)
                            - 1.363476e7 * np.power(1.0 + n, 11)
                            - 1.137246e6 * np.power(1.0 + n, 12)
                            - 70000.0 * np.power(1.0 + n, 13)
                            - 3000.0 * np.power(1.0 + n, 14)
                            - 80.0 * np.power(1.0 + n, 15)
                            - 1.0 * np.power(1.0 + n, 16)
                        )
                        * (1 / (1.0 + n) + S1)
                        * np.power(-1.0, n)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                        * np.power(7.0 + n, 2)
                        * np.power(8.0 + n, 2)
                        * np.power(9.0 + n, 2)
                        * np.power(10.0 + n, 2)
                    )
                    + (
                        1 / (1.0 + n)
                        + (
                            3.0
                            * (
                                342192.0
                                + 781800.0 * (1.0 + n)
                                + 723680.0 * np.power(1.0 + n, 2)
                                + 359100.0 * np.power(1.0 + n, 3)
                                + 105455.0 * np.power(1.0 + n, 4)
                                + 18900.0 * np.power(1.0 + n, 5)
                                + 2030.0 * np.power(1.0 + n, 6)
                                + 120.0 * np.power(1.0 + n, 7)
                                + 3.0 * np.power(1.0 + n, 8)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                            * (9.0 + n)
                            * (10.0 + n)
                        )
                        + S1
                    )
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            1.0
                            * (
                                -1.09027627776e11
                                - 3.792865824e11 * (1.0 + n)
                                - 6.0713742384e11 * np.power(1.0 + n, 2)
                                - 5.9622705312e11 * np.power(1.0 + n, 3)
                                - 4.03242887656e11 * np.power(1.0 + n, 4)
                                - 1.99571643e11 * np.power(1.0 + n, 5)
                                - 7.48814979e10 * np.power(1.0 + n, 6)
                                - 2.175554084e10 * np.power(1.0 + n, 7)
                                - 4.951843521e9 * np.power(1.0 + n, 8)
                                - 8.86903e8 * np.power(1.0 + n, 9)
                                - 1.2470866e8 * np.power(1.0 + n, 10)
                                - 1.363476e7 * np.power(1.0 + n, 11)
                                - 1.137246e6 * np.power(1.0 + n, 12)
                                - 70000.0 * np.power(1.0 + n, 13)
                                - 3000.0 * np.power(1.0 + n, 14)
                                - 80.0 * np.power(1.0 + n, 15)
                                - 1.0 * np.power(1.0 + n, 16)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                            * np.power(9.0 + n, 2)
                            * np.power(10.0 + n, 2)
                        )
                    )
                )
            )
            / (10.0 + n)
            + n
            * (
                np.power(10.0 + n, -5)
                - 0.8224670334241131 / np.power(10.0 + n, 3)
                - (0.8224670334241131 * np.power(-1.0, 9.0 + n)) / np.power(10.0 + n, 3)
                + 0.419833592426477 / np.power(10.0 + n, 2)
                + (1.6218904955860713 * np.power(-1.0, 9.0 + n)) / np.power(10.0 + n, 2)
                + (1.2020569031595942 * np.power(-1.0, 10.0 + n))
                / np.power(10.0 + n, 2)
                - 0.3382260105347306 / (10.0 + n)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 9.0 + n)
                    * (
                        1 / (1.0 + n)
                        + (
                            4.0
                            * (9.0 + 2.0 * (1.0 + n))
                            * (
                                3044.0
                                + 5886.0 * (1.0 + n)
                                + 4299.0 * np.power(1.0 + n, 2)
                                + 1539.0 * np.power(1.0 + n, 3)
                                + 288.0 * np.power(1.0 + n, 4)
                                + 27.0 * np.power(1.0 + n, 5)
                                + np.power(1.0 + n, 6)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                            * (9.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(10.0 + n, 2)
                - (
                    0.8224670334241131
                    * np.power(-1.0, 10.0 + n)
                    * (
                        Sm1
                        - (1.0 * np.power(-1.0, n)) / (1.0 + n)
                        + (
                            4.0
                            * (
                                6396.0
                                + 9162.0 * (1.0 + n)
                                + 5473.0 * np.power(1.0 + n, 2)
                                + 1719.0 * np.power(1.0 + n, 3)
                                + 298.0 * np.power(1.0 + n, 4)
                                + 27.0 * np.power(1.0 + n, 5)
                                + np.power(1.0 + n, 6)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                            * (9.0 + n)
                        )
                    )
                )
                / np.power(10.0 + n, 2)
                + (
                    np.power(-1.0, 10.0 + n)
                    * (
                        Sm2
                        - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        + (
                            4.0
                            * (9.0 + 2.0 * (1.0 + n))
                            * (
                                3.6831936e7
                                + 1.10670624e8 * (1.0 + n)
                                + 1.4936364e8 * np.power(1.0 + n, 2)
                                + 1.2041208e8 * np.power(1.0 + n, 3)
                                + 6.4783246e7 * np.power(1.0 + n, 4)
                                + 2.454111e7 * np.power(1.0 + n, 5)
                                + 6.715739e6 * np.power(1.0 + n, 6)
                                + 1.33785e6 * np.power(1.0 + n, 7)
                                + 192561.0 * np.power(1.0 + n, 8)
                                + 19530.0 * np.power(1.0 + n, 9)
                                + 1325.0 * np.power(1.0 + n, 10)
                                + 54.0 * np.power(1.0 + n, 11)
                                + np.power(1.0 + n, 12)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                            * np.power(9.0 + n, 2)
                        )
                    )
                )
                / np.power(10.0 + n, 3)
                + (
                    np.power(-1.0, 10.0 + n)
                    * (
                        -1.0 * Sm21
                        + Sm3
                        + (
                            4.0
                            * (
                                1.4760576193536e13
                                + 7.3798658489088e13 * (1.0 + n)
                                + 1.72837443710016e14 * np.power(1.0 + n, 2)
                                + 2.52453402491616e14 * np.power(1.0 + n, 3)
                                + 2.5828967175624e14 * np.power(1.0 + n, 4)
                                + 1.97032446481464e14 * np.power(1.0 + n, 5)
                                + 1.16425369498108e14 * np.power(1.0 + n, 6)
                                + 5.4627507667116e13 * np.power(1.0 + n, 7)
                                + 2.0690074606371e13 * np.power(1.0 + n, 8)
                                + 6.392775359655e12 * np.power(1.0 + n, 9)
                                + 1.621160332314e12 * np.power(1.0 + n, 10)
                                + 3.38175413478e11 * np.power(1.0 + n, 11)
                                + 5.7948536701e10 * np.power(1.0 + n, 12)
                                + 8.115008166e9 * np.power(1.0 + n, 13)
                                + 9.1986012e8 * np.power(1.0 + n, 14)
                                + 8.3116584e7 * np.power(1.0 + n, 15)
                                + 5.847213e6 * np.power(1.0 + n, 16)
                                + 308691.0 * np.power(1.0 + n, 17)
                                + 11506.0 * np.power(1.0 + n, 18)
                                + 270.0 * np.power(1.0 + n, 19)
                                + 3.0 * np.power(1.0 + n, 20)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                            * np.power(8.0 + n, 3)
                            * np.power(9.0 + n, 3)
                        )
                        + (
                            2.0
                            * (
                                -2.3997963958272e13
                                - 1.14129905965056e14 * (1.0 + n)
                                - 2.5222059905856e14 * np.power(1.0 + n, 2)
                                - 3.44033181492512e14 * np.power(1.0 + n, 3)
                                - 3.23935732772496e14 * np.power(1.0 + n, 4)
                                - 2.22502088875352e14 * np.power(1.0 + n, 5)
                                - 1.14348498644148e14 * np.power(1.0 + n, 6)
                                - 4.3968646592044e13 * np.power(1.0 + n, 7)
                                - 1.21438136977e13 * np.power(1.0 + n, 8)
                                - 2.010931672623e12 * np.power(1.0 + n, 9)
                                + 4.9482178305e10 * np.power(1.0 + n, 10)
                                + 1.59991878826e11 * np.power(1.0 + n, 11)
                                + 6.0723226806e10 * np.power(1.0 + n, 12)
                                + 1.4651858516e10 * np.power(1.0 + n, 13)
                                + 2.59766429e9 * np.power(1.0 + n, 14)
                                + 3.51680472e8 * np.power(1.0 + n, 15)
                                + 3.6575004e7 * np.power(1.0 + n, 16)
                                + 2.886025e6 * np.power(1.0 + n, 17)
                                + 167625.0 * np.power(1.0 + n, 18)
                                + 6770.0 * np.power(1.0 + n, 19)
                                + 170.0 * np.power(1.0 + n, 20)
                                + 2.0 * np.power(1.0 + n, 21)
                            )
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                            * np.power(8.0 + n, 3)
                            * np.power(9.0 + n, 3)
                        )
                        + (S1 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                        - (
                            4.0
                            * (9.0 + 2.0 * (1.0 + n))
                            * (
                                3.6831936e7
                                + 1.10670624e8 * (1.0 + n)
                                + 1.4936364e8 * np.power(1.0 + n, 2)
                                + 1.2041208e8 * np.power(1.0 + n, 3)
                                + 6.4783246e7 * np.power(1.0 + n, 4)
                                + 2.454111e7 * np.power(1.0 + n, 5)
                                + 6.715739e6 * np.power(1.0 + n, 6)
                                + 1.33785e6 * np.power(1.0 + n, 7)
                                + 192561.0 * np.power(1.0 + n, 8)
                                + 19530.0 * np.power(1.0 + n, 9)
                                + 1325.0 * np.power(1.0 + n, 10)
                                + 54.0 * np.power(1.0 + n, 11)
                                + np.power(1.0 + n, 12)
                            )
                            * (1 / (1.0 + n) + S1)
                            * np.power(-1.0, n)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                            * np.power(9.0 + n, 2)
                        )
                        + (
                            1 / (1.0 + n)
                            + (
                                4.0
                                * (9.0 + 2.0 * (1.0 + n))
                                * (
                                    3044.0
                                    + 5886.0 * (1.0 + n)
                                    + 4299.0 * np.power(1.0 + n, 2)
                                    + 1539.0 * np.power(1.0 + n, 3)
                                    + 288.0 * np.power(1.0 + n, 4)
                                    + 27.0 * np.power(1.0 + n, 5)
                                    + np.power(1.0 + n, 6)
                                )
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                                * (8.0 + n)
                                * (9.0 + n)
                            )
                            + S1
                        )
                        * (
                            Sm2
                            - (1.0 * np.power(-1.0, n)) / np.power(1.0 + n, 2)
                            + (
                                4.0
                                * (9.0 + 2.0 * (1.0 + n))
                                * (
                                    3.6831936e7
                                    + 1.10670624e8 * (1.0 + n)
                                    + 1.4936364e8 * np.power(1.0 + n, 2)
                                    + 1.2041208e8 * np.power(1.0 + n, 3)
                                    + 6.4783246e7 * np.power(1.0 + n, 4)
                                    + 2.454111e7 * np.power(1.0 + n, 5)
                                    + 6.715739e6 * np.power(1.0 + n, 6)
                                    + 1.33785e6 * np.power(1.0 + n, 7)
                                    + 192561.0 * np.power(1.0 + n, 8)
                                    + 19530.0 * np.power(1.0 + n, 9)
                                    + 1325.0 * np.power(1.0 + n, 10)
                                    + 54.0 * np.power(1.0 + n, 11)
                                    + np.power(1.0 + n, 12)
                                )
                                * np.power(-1.0, n)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                                * np.power(8.0 + n, 2)
                                * np.power(9.0 + n, 2)
                            )
                        )
                    )
                )
                / np.power(10.0 + n, 2)
            )
        )
    )
