# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'OpensearchUserAcl',
    'GetCapabilitiesEngineResult',
    'GetCapabilitiesFlavorResult',
    'GetCapabilitiesOptionResult',
    'GetCapabilitiesPlanResult',
    'GetDatabaseEndpointResult',
    'GetDatabaseNodeResult',
]

@pulumi.output_type
class OpensearchUserAcl(dict):
    def __init__(__self__, *,
                 pattern: str,
                 permission: str):
        """
        :param str pattern: Pattern of the ACL.
        :param str permission: Permission of the ACL
               Available permission:
               * `admin`
               * `read`
               * `write`
               * `readwrite`
               * `deny`
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        Pattern of the ACL.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        Permission of the ACL
        Available permission:
        * `admin`
        * `read`
        * `write`
        * `readwrite`
        * `deny`
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class GetCapabilitiesEngineResult(dict):
    def __init__(__self__, *,
                 default_version: str,
                 description: str,
                 name: str,
                 ssl_modes: Sequence[str],
                 versions: Sequence[str]):
        """
        :param str default_version: Default version used for the engine.
        :param str description: Description of the plan.
        :param str name: Name of the plan.
        :param Sequence[str] ssl_modes: SSL modes for this engine.
        :param Sequence[str] versions: Versions available for this engine.
        """
        pulumi.set(__self__, "default_version", default_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ssl_modes", ssl_modes)
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> str:
        """
        Default version used for the engine.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the plan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sslModes")
    def ssl_modes(self) -> Sequence[str]:
        """
        SSL modes for this engine.
        """
        return pulumi.get(self, "ssl_modes")

    @property
    @pulumi.getter
    def versions(self) -> Sequence[str]:
        """
        Versions available for this engine.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetCapabilitiesFlavorResult(dict):
    def __init__(__self__, *,
                 core: int,
                 memory: int,
                 name: str,
                 storage: int):
        """
        :param int core: Flavor core number.
        :param int memory: Flavor ram size in GB.
        :param str name: Name of the plan.
        :param int storage: Flavor disk size in GB.
        """
        pulumi.set(__self__, "core", core)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def core(self) -> int:
        """
        Flavor core number.
        """
        return pulumi.get(self, "core")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Flavor ram size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def storage(self) -> int:
        """
        Flavor disk size in GB.
        """
        return pulumi.get(self, "storage")


@pulumi.output_type
class GetCapabilitiesOptionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: Name of the plan.
        :param str type: Type of the option.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the option.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCapabilitiesPlanResult(dict):
    def __init__(__self__, *,
                 backup_retention: str,
                 description: str,
                 name: str):
        """
        :param str backup_retention: Automatic backup retention duration.
        :param str description: Description of the plan.
        :param str name: Name of the plan.
        """
        pulumi.set(__self__, "backup_retention", backup_retention)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backupRetention")
    def backup_retention(self) -> str:
        """
        Automatic backup retention duration.
        """
        return pulumi.get(self, "backup_retention")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the plan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatabaseEndpointResult(dict):
    def __init__(__self__, *,
                 component: str,
                 domain: str,
                 path: str,
                 port: int,
                 scheme: str,
                 ssl: bool,
                 ssl_mode: str,
                 uri: str):
        """
        :param str component: Type of component the URI relates to.
        :param str domain: Domain of the cluster.
        :param str path: Path of the endpoint.
        :param int port: Connection port for the endpoint.
        :param str scheme: Scheme used to generate the URI.
        :param bool ssl: Defines whether the endpoint uses SSL.
        :param str ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param str uri: URI of the endpoint.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "ssl", ssl)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def component(self) -> str:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def ssl(self) -> bool:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> str:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetDatabaseNodeResult(dict):
    def __init__(__self__, *,
                 network_id: str,
                 region: str,
                 subnet_id: str):
        """
        :param str network_id: Private network id in which the node should be deployed. It's the regional openstackId of the private network
        :param str region: Public cloud region in which the node should be deployed.
        :param str subnet_id: Private subnet ID in which the node is.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        Private network id in which the node should be deployed. It's the regional openstackId of the private network
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Public cloud region in which the node should be deployed.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Private subnet ID in which the node is.
        """
        return pulumi.get(self, "subnet_id")


