# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ContainerRegistryPlan',
    'ContainerRegistryPlanFeature',
    'ContainerRegistryPlanRegistryLimit',
    'DatabaseEndpoint',
    'DatabaseNode',
    'KubeCustomization',
    'KubeCustomizationApiserver',
    'KubeCustomizationApiserverAdmissionplugins',
    'KubeNodePoolTemplate',
    'KubeNodePoolTemplateMetadata',
    'KubeNodePoolTemplateSpec',
    'KubePrivateNetworkConfiguration',
    'NetworkPrivateRegionsAttribute',
    'NetworkPrivateRegionsStatus',
    'NetworkPrivateSubnetIpPool',
    'ProjectOrder',
    'ProjectOrderDetail',
    'ProjectPlan',
    'ProjectPlanConfiguration',
    'ProjectPlanOption',
    'ProjectPlanOptionConfiguration',
    'UserRole',
    'GetCapabilitiesContainerFilterFeatureResult',
    'GetCapabilitiesContainerFilterRegistryLimitResult',
    'GetCapabilitiesContainerRegistryResultResult',
    'GetCapabilitiesContainerRegistryResultPlanResult',
    'GetCapabilitiesContainerRegistryResultPlanFeatureResult',
    'GetCapabilitiesContainerRegistryResultPlanRegistryLimitResult',
    'GetContainerRegistriesResultResult',
    'GetContainerRegistryUsersResultResult',
    'GetKubeCustomizationResult',
    'GetKubeCustomizationApiserverResult',
    'GetKubeCustomizationApiserverAdmissionpluginsResult',
    'GetOpenSearchUserAclResult',
    'GetRegionServiceResult',
    'GetUserRoleResult',
    'GetUsersUserResult',
    'GetUsersUserRoleResult',
]

@pulumi.output_type
class ContainerRegistryPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "registryLimits":
            suggest = "registry_limits"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRegistryPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRegistryPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRegistryPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 created_at: Optional[str] = None,
                 features: Optional[Sequence['outputs.ContainerRegistryPlanFeature']] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 registry_limits: Optional[Sequence['outputs.ContainerRegistryPlanRegistryLimit']] = None,
                 updated_at: Optional[str] = None):
        """
        :param str code: Plan code from the catalog
        :param str created_at: Plan creation date
        :param Sequence['ContainerRegistryPlanFeatureArgs'] features: Features of the plan
        :param str id: Plan ID
        :param str name: Registry name
        :param Sequence['ContainerRegistryPlanRegistryLimitArgs'] registry_limits: Container registry limits
        :param str updated_at: Registry last update date
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registry_limits is not None:
            pulumi.set(__self__, "registry_limits", registry_limits)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Plan code from the catalog
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        Plan creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def features(self) -> Optional[Sequence['outputs.ContainerRegistryPlanFeature']]:
        """
        Features of the plan
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Plan ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Registry name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registryLimits")
    def registry_limits(self) -> Optional[Sequence['outputs.ContainerRegistryPlanRegistryLimit']]:
        """
        Container registry limits
        """
        return pulumi.get(self, "registry_limits")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        Registry last update date
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class ContainerRegistryPlanFeature(dict):
    def __init__(__self__, *,
                 vulnerability: Optional[bool] = None):
        """
        :param bool vulnerability: Vulnerability scanning
        """
        if vulnerability is not None:
            pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter
    def vulnerability(self) -> Optional[bool]:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class ContainerRegistryPlanRegistryLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageStorage":
            suggest = "image_storage"
        elif key == "parallelRequest":
            suggest = "parallel_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRegistryPlanRegistryLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRegistryPlanRegistryLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRegistryPlanRegistryLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_storage: Optional[int] = None,
                 parallel_request: Optional[int] = None):
        """
        :param int image_storage: Docker image storage limits in bytes
        :param int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        if image_storage is not None:
            pulumi.set(__self__, "image_storage", image_storage)
        if parallel_request is not None:
            pulumi.set(__self__, "parallel_request", parallel_request)

    @property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> Optional[int]:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> Optional[int]:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class DatabaseEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component: Optional[str] = None,
                 domain: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None,
                 scheme: Optional[str] = None,
                 ssl: Optional[bool] = None,
                 ssl_mode: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str component: Type of component the URI relates to.
        :param str domain: Domain of the cluster.
        :param str path: Path of the endpoint.
        :param int port: Connection port for the endpoint.
        :param str scheme: Scheme used to generate the URI.
        :param bool ssl: Defines whether the endpoint uses SSL.
        :param str ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param str uri: URI of the endpoint.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def component(self) -> Optional[str]:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[str]:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def ssl(self) -> Optional[bool]:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[str]:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class DatabaseNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 network_id: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        :param str region: Public cloud region in which the node should be deployed.
               Ex: "GRA'.
        :param str network_id: Private network id in which the node should be deployed. It's the regional openstackId of the private network
        :param str subnet_id: Private subnet ID in which the node is.
        """
        pulumi.set(__self__, "region", region)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Public cloud region in which the node should be deployed.
        Ex: "GRA'.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[str]:
        """
        Private network id in which the node should be deployed. It's the regional openstackId of the private network
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Private subnet ID in which the node is.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class KubeCustomization(dict):
    def __init__(__self__, *,
                 apiserver: Optional['outputs.KubeCustomizationApiserver'] = None):
        if apiserver is not None:
            pulumi.set(__self__, "apiserver", apiserver)

    @property
    @pulumi.getter
    def apiserver(self) -> Optional['outputs.KubeCustomizationApiserver']:
        return pulumi.get(self, "apiserver")


@pulumi.output_type
class KubeCustomizationApiserver(dict):
    def __init__(__self__, *,
                 admissionplugins: Optional['outputs.KubeCustomizationApiserverAdmissionplugins'] = None):
        if admissionplugins is not None:
            pulumi.set(__self__, "admissionplugins", admissionplugins)

    @property
    @pulumi.getter
    def admissionplugins(self) -> Optional['outputs.KubeCustomizationApiserverAdmissionplugins']:
        return pulumi.get(self, "admissionplugins")


@pulumi.output_type
class KubeCustomizationApiserverAdmissionplugins(dict):
    def __init__(__self__, *,
                 disableds: Optional[Sequence[str]] = None,
                 enableds: Optional[Sequence[str]] = None):
        if disableds is not None:
            pulumi.set(__self__, "disableds", disableds)
        if enableds is not None:
            pulumi.set(__self__, "enableds", enableds)

    @property
    @pulumi.getter
    def disableds(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "disableds")

    @property
    @pulumi.getter
    def enableds(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "enableds")


@pulumi.output_type
class KubeNodePoolTemplate(dict):
    def __init__(__self__, *,
                 metadata: Optional['outputs.KubeNodePoolTemplateMetadata'] = None,
                 spec: Optional['outputs.KubeNodePoolTemplateSpec'] = None):
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.KubeNodePoolTemplateMetadata']:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.KubeNodePoolTemplateSpec']:
        return pulumi.get(self, "spec")


@pulumi.output_type
class KubeNodePoolTemplateMetadata(dict):
    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, str]] = None,
                 finalizers: Optional[Sequence[str]] = None,
                 labels: Optional[Mapping[str, str]] = None):
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "finalizers")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "labels")


@pulumi.output_type
class KubeNodePoolTemplateSpec(dict):
    def __init__(__self__, *,
                 taints: Optional[Sequence[Mapping[str, Any]]] = None,
                 unschedulable: Optional[bool] = None):
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence[Mapping[str, Any]]]:
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter
    def unschedulable(self) -> Optional[bool]:
        return pulumi.get(self, "unschedulable")


@pulumi.output_type
class KubePrivateNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultVrackGateway":
            suggest = "default_vrack_gateway"
        elif key == "privateNetworkRoutingAsDefault":
            suggest = "private_network_routing_as_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubePrivateNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubePrivateNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubePrivateNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_vrack_gateway: str,
                 private_network_routing_as_default: bool):
        pulumi.set(__self__, "default_vrack_gateway", default_vrack_gateway)
        pulumi.set(__self__, "private_network_routing_as_default", private_network_routing_as_default)

    @property
    @pulumi.getter(name="defaultVrackGateway")
    def default_vrack_gateway(self) -> str:
        return pulumi.get(self, "default_vrack_gateway")

    @property
    @pulumi.getter(name="privateNetworkRoutingAsDefault")
    def private_network_routing_as_default(self) -> bool:
        return pulumi.get(self, "private_network_routing_as_default")


@pulumi.output_type
class NetworkPrivateRegionsAttribute(dict):
    def __init__(__self__, *,
                 status: str,
                 openstackid: Optional[str] = None,
                 region: Optional[str] = None):
        """
        :param str status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if openstackid is not None:
            pulumi.set(__self__, "openstackid", openstackid)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def openstackid(self) -> Optional[str]:
        return pulumi.get(self, "openstackid")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


@pulumi.output_type
class NetworkPrivateRegionsStatus(dict):
    def __init__(__self__, *,
                 status: str,
                 region: Optional[str] = None):
        """
        :param str status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


@pulumi.output_type
class NetworkPrivateSubnetIpPool(dict):
    def __init__(__self__, *,
                 dhcp: Optional[bool] = None,
                 end: Optional[str] = None,
                 network: Optional[str] = None,
                 region: Optional[str] = None,
                 start: Optional[str] = None):
        """
        :param bool dhcp: Enable DHCP.
               Changing this forces a new resource to be created. Defaults to false.
               _
        :param str end: Last ip for this region.
               Changing this value recreates the subnet.
        :param str network: Global network in CIDR format.
               Changing this value recreates the subnet
        :param str region: The region in which the network subnet will be created.
               Ex.: "GRA1". Changing this value recreates the resource.
        :param str start: First ip for this region.
               Changing this value recreates the subnet.
        """
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def dhcp(self) -> Optional[bool]:
        """
        Enable DHCP.
        Changing this forces a new resource to be created. Defaults to false.
        _
        """
        return pulumi.get(self, "dhcp")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        Last ip for this region.
        Changing this value recreates the subnet.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        Global network in CIDR format.
        Changing this value recreates the subnet
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region in which the network subnet will be created.
        Ex.: "GRA1". Changing this value recreates the resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        First ip for this region.
        Changing this value recreates the subnet.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class ProjectOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 details: Optional[Sequence['outputs.ProjectOrderDetail']] = None,
                 expiration_date: Optional[str] = None,
                 order_id: Optional[int] = None):
        """
        :param str date: date
        :param Sequence['ProjectOrderDetailArgs'] details: Information about a Bill entry
        :param str expiration_date: expiration date
        :param int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ProjectOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class ProjectOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 domain: Optional[str] = None,
                 order_detail_id: Optional[int] = None,
                 quantity: Optional[str] = None):
        """
        :param str description: A description associated with the user.
        :param str domain: expiration date
        :param int order_detail_id: order detail id
        :param str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class ProjectPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.ProjectPlanConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['ProjectPlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ProjectPlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ProjectPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.ProjectPlanOptionConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['ProjectPlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ProjectPlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ProjectPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UserRole(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 permissions: Optional[Sequence[str]] = None):
        """
        :param str description: A description associated with the user.
        :param str id: id of the role
        :param str name: name of the role
        :param Sequence[str] permissions: list of permissions associated with the role
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[str]]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetCapabilitiesContainerFilterFeatureResult(dict):
    def __init__(__self__, *,
                 vulnerability: bool):
        """
        :param bool vulnerability: Vulnerability scanning
        """
        pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter
    def vulnerability(self) -> bool:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class GetCapabilitiesContainerFilterRegistryLimitResult(dict):
    def __init__(__self__, *,
                 image_storage: int,
                 parallel_request: int):
        """
        :param int image_storage: Docker image storage limits in bytes
        :param int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        pulumi.set(__self__, "image_storage", image_storage)
        pulumi.set(__self__, "parallel_request", parallel_request)

    @property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> int:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> int:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class GetCapabilitiesContainerRegistryResultResult(dict):
    def __init__(__self__, *,
                 plans: Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanResult'],
                 region_name: str):
        """
        :param Sequence['GetCapabilitiesContainerRegistryResultPlanArgs'] plans: Available plans in the region
        :param str region_name: The region name
        """
        pulumi.set(__self__, "plans", plans)
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanResult']:
        """
        Available plans in the region
        """
        return pulumi.get(self, "plans")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> str:
        """
        The region name
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class GetCapabilitiesContainerRegistryResultPlanResult(dict):
    def __init__(__self__, *,
                 code: str,
                 created_at: str,
                 features: Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanFeatureResult'],
                 id: str,
                 name: str,
                 registry_limits: Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanRegistryLimitResult'],
                 updated_at: str):
        """
        :param str code: Plan code from the catalog
        :param str created_at: Plan creation date
        :param Sequence['GetCapabilitiesContainerRegistryResultPlanFeatureArgs'] features: Features of the plan
        :param str id: Plan ID
        :param str name: Plan name
        :param Sequence['GetCapabilitiesContainerRegistryResultPlanRegistryLimitArgs'] registry_limits: Container registry limits
        :param str updated_at: Plan last update date
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "registry_limits", registry_limits)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Plan code from the catalog
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Plan creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanFeatureResult']:
        """
        Features of the plan
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Plan ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Plan name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registryLimits")
    def registry_limits(self) -> Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanRegistryLimitResult']:
        """
        Container registry limits
        """
        return pulumi.get(self, "registry_limits")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Plan last update date
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetCapabilitiesContainerRegistryResultPlanFeatureResult(dict):
    def __init__(__self__, *,
                 vulnerability: bool):
        """
        :param bool vulnerability: Vulnerability scanning
        """
        pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter
    def vulnerability(self) -> bool:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class GetCapabilitiesContainerRegistryResultPlanRegistryLimitResult(dict):
    def __init__(__self__, *,
                 image_storage: int,
                 parallel_request: int):
        """
        :param int image_storage: Docker image storage limits in bytes
        :param int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        pulumi.set(__self__, "image_storage", image_storage)
        pulumi.set(__self__, "parallel_request", parallel_request)

    @property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> int:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> int:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class GetContainerRegistriesResultResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 id: str,
                 name: str,
                 project_id: str,
                 region: str,
                 size: int,
                 status: str,
                 updated_at: str,
                 url: str,
                 version: str):
        """
        :param str created_at: Registry creation date
        :param str id: Registry ID
        :param str name: Registry name
        :param str project_id: Project ID of your registry
        :param str region: Region of the registry
        :param int size: Current size of the registry (bytes)
        :param str status: Registry status
        :param str updated_at: Registry last update date
        :param str url: Access url of the registry
        :param str version: Version of your registry
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Registry creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Registry ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Registry name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Project ID of your registry
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region of the registry
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Current size of the registry (bytes)
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Registry status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Registry last update date
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Access url of the registry
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of your registry
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetContainerRegistryUsersResultResult(dict):
    def __init__(__self__, *,
                 email: str,
                 id: str,
                 user: str):
        """
        :param str email: User email
        :param str id: User ID
        :param str user: User name
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        User email
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        User ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        User name
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetKubeCustomizationResult(dict):
    def __init__(__self__, *,
                 apiserver: 'outputs.GetKubeCustomizationApiserverResult'):
        pulumi.set(__self__, "apiserver", apiserver)

    @property
    @pulumi.getter
    def apiserver(self) -> 'outputs.GetKubeCustomizationApiserverResult':
        return pulumi.get(self, "apiserver")


@pulumi.output_type
class GetKubeCustomizationApiserverResult(dict):
    def __init__(__self__, *,
                 admissionplugins: 'outputs.GetKubeCustomizationApiserverAdmissionpluginsResult'):
        pulumi.set(__self__, "admissionplugins", admissionplugins)

    @property
    @pulumi.getter
    def admissionplugins(self) -> 'outputs.GetKubeCustomizationApiserverAdmissionpluginsResult':
        return pulumi.get(self, "admissionplugins")


@pulumi.output_type
class GetKubeCustomizationApiserverAdmissionpluginsResult(dict):
    def __init__(__self__, *,
                 disableds: Sequence[str],
                 enableds: Sequence[str]):
        pulumi.set(__self__, "disableds", disableds)
        pulumi.set(__self__, "enableds", enableds)

    @property
    @pulumi.getter
    def disableds(self) -> Sequence[str]:
        return pulumi.get(self, "disableds")

    @property
    @pulumi.getter
    def enableds(self) -> Sequence[str]:
        return pulumi.get(self, "enableds")


@pulumi.output_type
class GetOpenSearchUserAclResult(dict):
    def __init__(__self__, *,
                 pattern: str,
                 permission: str):
        """
        :param str pattern: Pattern of the ACL.
        :param str permission: Permission of the ACL.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        Pattern of the ACL.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        Permission of the ACL.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class GetRegionServiceResult(dict):
    def __init__(__self__, *,
                 name: str,
                 status: str):
        """
        :param str name: The name of the region associated with the public cloud
               project.
        :param str status: the status of the service
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the region associated with the public cloud
        project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        the status of the service
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetUserRoleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 name: str,
                 permissions: Sequence[str]):
        """
        :param str description: description of the role
        :param str id: id of the role
        :param str name: name of the role
        :param Sequence[str] permissions: list of permissions associated with the role
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        description of the role
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 creation_date: str,
                 description: str,
                 roles: Sequence['outputs.GetUsersUserRoleResult'],
                 status: str,
                 user_id: str,
                 username: str):
        """
        :param str creation_date: the date the user was created.
        :param str description: description of the role
        :param Sequence['GetUsersUserRoleArgs'] roles: A list of roles associated with the user.
        :param str status: the status of the user. should be normally set to 'ok'.
        :param str user_id: The ID of a public cloud project's user.
        :param str username: the username generated for the user. This username can be used with
               the Openstack API.
        """
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> str:
        """
        the date the user was created.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        description of the role
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetUsersUserRoleResult']:
        """
        A list of roles associated with the user.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        the status of the user. should be normally set to 'ok'.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The ID of a public cloud project's user.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        the username generated for the user. This username can be used with
        the Openstack API.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetUsersUserRoleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 name: str,
                 permissions: Sequence[str]):
        """
        :param str description: description of the role
        :param str id: id of the role
        :param str name: name of the role
        :param Sequence[str] permissions: list of permissions associated with the role
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        description of the role
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")


