# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetUserS3PolicyResult',
    'AwaitableGetUserS3PolicyResult',
    'get_user_s3_policy',
    'get_user_s3_policy_output',
]

@pulumi.output_type
class GetUserS3PolicyResult:
    """
    A collection of values returned by getUserS3Policy.
    """
    def __init__(__self__, id=None, policy=None, service_name=None, user_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        (Required) The policy document. This is a JSON formatted string.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        return pulumi.get(self, "user_id")


class AwaitableGetUserS3PolicyResult(GetUserS3PolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserS3PolicyResult(
            id=self.id,
            policy=self.policy,
            service_name=self.service_name,
            user_id=self.user_id)


def get_user_s3_policy(service_name: Optional[str] = None,
                       user_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserS3PolicyResult:
    """
    Get the S3 Policy of a public cloud project user. The policy can be set by using the `CloudProject.S3Policy` resource.


    :param str service_name: The ID of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    :param str user_id: The ID of a public cloud project's user.
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getUserS3Policy:getUserS3Policy', __args__, opts=opts, typ=GetUserS3PolicyResult).value

    return AwaitableGetUserS3PolicyResult(
        id=__ret__.id,
        policy=__ret__.policy,
        service_name=__ret__.service_name,
        user_id=__ret__.user_id)


@_utilities.lift_output_func(get_user_s3_policy)
def get_user_s3_policy_output(service_name: Optional[pulumi.Input[str]] = None,
                              user_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserS3PolicyResult]:
    """
    Get the S3 Policy of a public cloud project user. The policy can be set by using the `CloudProject.S3Policy` resource.


    :param str service_name: The ID of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    :param str user_id: The ID of a public cloud project's user.
    """
    ...
