# Generated by Django 2.2.12 on 2020-06-16 16:09

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid
import uuid_upload_path.storage
import versatileimagefield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="GoogleAuthIntermediateState",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("state", models.CharField(max_length=64, unique=True)),
                ("code_verifier", models.CharField(max_length=50)),
            ],
            options={
                "verbose_name": "Google Auth Intermediate State",
                "verbose_name_plural": "Google Auth Intermediate States",
                "ordering": ("-created_at",),
            },
        ),
        migrations.CreateModel(
            name="UserProfileImage",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "image",
                    versatileimagefield.fields.VersatileImageField(
                        blank=True,
                        null=True,
                        upload_to=uuid_upload_path.storage.upload_to,
                        verbose_name="image",
                    ),
                ),
                (
                    "image_poi",
                    versatileimagefield.fields.PPOIField(
                        default="0.5x0.5",
                        editable=False,
                        max_length=20,
                        verbose_name="image's Point of Interest",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ("-created_at",),
            },
        ),
        migrations.CreateModel(
            name="UserGoogleAuthCredential",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("access_token", models.CharField(max_length=200)),
                ("refresh_token", models.CharField(max_length=200)),
                ("expires_at", models.DateTimeField()),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User Google Auth Credential",
                "verbose_name_plural": "User Google Auth Credentials",
                "ordering": ("-created_at",),
            },
        ),
    ]
