import os
from enum import Enum

ROOT = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources"


class Icon(str, Enum):
    AR_DOCUMENT = os.path.join(ROOT, "ARDocument.icns")
    ARvOBJECT = os.path.join(ROOT, "ARObject.icns")
    ACCOUNTS = os.path.join(ROOT, "Accounts.icns")
    ACTIONS = os.path.join(ROOT, "Actions.icns")
    AIRDROP = os.path.join(ROOT, "AirDrop.icns")
    ALERT_NOTE = os.path.join(ROOT, "AlertNoteIcon.icns")
    ALERT_STOP = os.path.join(ROOT, "AlertStopIcon.icns")
    ALL_MY_FILES = os.path.join(ROOT, "AllMyFiles.icns")
    APPLICATIONS_FOLDER = os.path.join(ROOT, "ApplicationsFolderIcon.icns")
    BACKWARD_ARROW = os.path.join(ROOT, "BackwardArrowIcon.icns")
    BONJOUR = os.path.join(ROOT, "Bonjour.icns")
    BOOKMARK = os.path.join(ROOT, "BookmarkIcon.icns")
    BURNABLE_FOLDER = os.path.join(ROOT, "BurnableFolderIcon.icns")
    BURNING = os.path.join(ROOT, "BurningIcon.icns")
    CD_AUDIO_VOLUME = os.path.join(ROOT, "CDAudioVolumeIcon.icns")
    CLIPPING_PICTURE = os.path.join(ROOT, "ClippingPicture.icns")
    CLIPPING_SOUND = os.path.join(ROOT, "ClippingSound.icns")
    CLIPPING_TEXT = os.path.join(ROOT, "ClippingText.icns")
    CLIPPING_UNKNOWN = os.path.join(ROOT, "ClippingUnknown.icns")
    CLOCK = os.path.join(ROOT, "Clock.icns")
    COLOR_SYNC_PROFILE = os.path.join(ROOT, "ColorSyncProfileIcon.icns")
    CONNECT_TO = os.path.join(ROOT, "ConnectToIcon.icns")
    DESKTOP_FOLDER = os.path.join(ROOT, "DesktopFolderIcon.icns")
    DEVELOPER_FOLDER = os.path.join(ROOT, "DeveloperFolderIcon.icns")
    DOCUMENTS_FOLDER = os.path.join(ROOT, "DocumentsFolderIcon.icns")
    DOWNLOADS_FOLDER = os.path.join(ROOT, "DownloadsFolder.icns")
    DROP_FOLDER_BADGE = os.path.join(ROOT, "DropFolderBadgeIcon.icns")
    EJECT_MEDIA = os.path.join(ROOT, "EjectMediaIcon.icns")
    ERASING = os.path.join(ROOT, "ErasingIcon.icns")
    EVERYONE = os.path.join(ROOT, "Everyone.icns")
    EXECUTABLE_BINARY = os.path.join(ROOT, "ExecutableBinaryIcon.icns")
    FAVORITE_ITEMS = os.path.join(ROOT, "FavoriteItemsIcon.icns")
    FILE_VAULT = os.path.join(ROOT, "FileVaultIcon.icns")
    FINDER = os.path.join(ROOT, "FinderIcon.icns")
    FORWARD_ARROW = os.path.join(ROOT, "ForwardArrowIcon.icns")
    FULL_TRASH = os.path.join(ROOT, "FullTrashIcon.icns")
    GENERAL = os.path.join(ROOT, "General.icns")
    GENERIC_AIRDISK = os.path.join(ROOT, "GenericAirDiskIcon.icns")
    GENERIC_APPLICATION = os.path.join(ROOT, "GenericApplicationIcon.icns")
    GENERIC_DOCUMENT = os.path.join(ROOT, "GenericDocumentIcon.icns")
    GENERIC_FILESERVER = os.path.join(ROOT, "GenericFileServerIcon.icns")
    GENERIC_FOLDER = os.path.join(ROOT, "GenericFolderIcon.icns")
    GENERIC_FONT = os.path.join(ROOT, "GenericFontIcon.icns")
    GENERIC_NETWORK = os.path.join(ROOT, "GenericNetworkIcon.icns")
    GENERIC_QUESTIONMARK = os.path.join(ROOT, "GenericQuestionMarkIcon.icns")
    GENERIC_SHAREPOINT = os.path.join(ROOT, "GenericSharepoint.icns")
    GENERIC_SPEAKER = os.path.join(ROOT, "GenericSpeaker.icns")
    GENERIC_STATIONERY = os.path.join(ROOT, "GenericStationeryIcon.icns")
    GENERIC_TIMEMACHINEDISK = os.path.join(ROOT, "GenericTimeMachineDiskIcon.icns")
    GENERIC_URL = os.path.join(ROOT, "GenericURLIcon.icns")
    GENERIC_WINDOW = os.path.join(ROOT, "GenericWindowIcon.icns")
    GRID = os.path.join(ROOT, "GridIcon.icns")
    GROUP_FOLDER = os.path.join(ROOT, "GroupFolder.icns")
    GROUP = os.path.join(ROOT, "GroupIcon.icns")
    GUEST_USER = os.path.join(ROOT, "GuestUserIcon.icns")
    HELP = os.path.join(ROOT, "HelpIcon.icns")
    HOME_FOLDER = os.path.join(ROOT, "HomeFolderIcon.icns")
    INTERNET_LOCATION = os.path.join(ROOT, "InternetLocation.icns")
    KEXT = os.path.join(ROOT, "KEXT.icns")
    KEEPA_RRANGED = os.path.join(ROOT, "KeepArrangedIcon.icns")
    LIBRARY_FOLDER = os.path.join(ROOT, "LibraryFolderIcon.icns")
    LOCKED_BADGE = os.path.join(ROOT, "LockedBadgeIcon.icns")
    LOCKED = os.path.join(ROOT, "LockedIcon.icns")
    MAGNIFYING_GLASS = os.path.join(ROOT, "MagnifyingGlassIcon.icns")
    MOVIE_FOLDER = os.path.join(ROOT, "MovieFolderIcon.icns")
    MULTIPLEI_TEMS = os.path.join(ROOT, "MultipleItemsIcon.icns")
    MUSIC_FOLDER = os.path.join(ROOT, "MusicFolderIcon.icns")
    NETBOOT_VOLUME = os.path.join(ROOT, "NetBootVolume.icns")
    NEW_FOLDER_BADGE = os.path.join(ROOT, "NewFolderBadgeIcon.icns")
    NO_WRITE = os.path.join(ROOT, "NoWriteIcon.icns")
    NOT_LOADED = os.path.join(ROOT, "NotLoaded.icns")
    NOTIFICATIONS = os.path.join(ROOT, "Notifications.icns")
    OPENF_OLDER = os.path.join(ROOT, "OpenFolderIcon.icns")
    PICTURES_FOLDER = os.path.join(ROOT, "PicturesFolderIcon.icns")
    PRIVATE_FOLDER_BADGE = os.path.join(ROOT, "PrivateFolderBadgeIcon.icns")
    PROBLEMREPORT = os.path.join(ROOT, "ProblemReport.icns")
    PROFILEBACKGROUNDCOLOR = os.path.join(ROOT, "ProfileBackgroundColor.icns")
    PROFILEFONT = os.path.join(ROOT, "ProfileFont.icns")
    PROFILEFONTANDCOLOR = os.path.join(ROOT, "ProfileFontAndColor.icns")
    PUBLICFOLDER = os.path.join(ROOT, "PublicFolderIcon.icns")
    READONLY_FOLDER_BADGE = os.path.join(ROOT, "ReadOnlyFolderBadgeIcon.icns")
    REALITY_FILE = os.path.join(ROOT, "RealityFile.icns")
    RECENT_ITEMS = os.path.join(ROOT, "RecentItemsIcon.icns")
    RIGHT_CONTAINER_ARROW = os.path.join(ROOT, "RightContainerArrowIcon.icns")
    SERVER_APPLICATIONS_FOLDER = os.path.join(ROOT, "ServerApplicationsFolderIcon.icns")
    SITES_FOLDER = os.path.join(ROOT, "SitesFolderIcon.icns")
    SMART_FOLDER = os.path.join(ROOT, "SmartFolderIcon.icns")
    SYNC = os.path.join(ROOT, "Sync.icns")
    SYSTEM_FOLDER = os.path.join(ROOT, "SystemFolderIcon.icns")
    TOOLBAR_ADVANCED = os.path.join(ROOT, "ToolbarAdvanced.icns")
    TOOLBAR_CUSTOMIZE = os.path.join(ROOT, "ToolbarCustomizeIcon.icns")
    TOOLBAR_DELETE = os.path.join(ROOT, "ToolbarDeleteIcon.icns")
    TOOLBAR_FAVORITES = os.path.join(ROOT, "ToolbarFavoritesIcon.icns")
    TOOLBAR_INFO = os.path.join(ROOT, "ToolbarInfo.icns")
    TOOLBAR_LABELS = os.path.join(ROOT, "ToolbarLabels.icns")
    TRASH = os.path.join(ROOT, "TrashIcon.icns")
    UNKNOWN_FSOBJECT = os.path.join(ROOT, "UnknownFSObjectIcon.icns")
    UNLOCKED = os.path.join(ROOT, "UnlockedIcon.icns")
    UNSUPPORTED = os.path.join(ROOT, "Unsupported.icns")
    USER = os.path.join(ROOT, "UserIcon.icns")
    USER_UNKNOWN = os.path.join(ROOT, "UserUnknownIcon.icns")
    USERS_FOLDER = os.path.join(ROOT, "UsersFolderIcon.icns")
    UTILITIES_FOLDER = os.path.join(ROOT, "UtilitiesFolder.icns")
    VCARD = os.path.join(ROOT, "VCard.icns")
