"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticRunnerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild_1 = require("../codebuild");
const common_1 = require("../common");
const codebuild_2 = require("./codebuild");
/**
 * Helper class with methods to use static images that are built outside the context of this project.
 */
class StaticRunnerImage {
    /**
     * Create a builder (that doesn't actually build anything) from an existing image in an existing repository. The image must already have GitHub Actions runner installed. You are responsible to update it and remove it when done.
     *
     * @param repository ECR repository
     * @param tag image tag
     * @param architecture image architecture
     * @param os image OS
     */
    static fromEcrRepository(repository, tag = 'latest', architecture = common_1.Architecture.X86_64, os = common_1.Os.LINUX) {
        return {
            bind() {
                return {
                    imageRepository: repository,
                    imageTag: tag,
                    architecture,
                    os,
                };
            },
        };
    }
    /**
     * Create a builder from an existing Docker Hub image. The image must already have GitHub Actions runner installed. You are responsible to update it and remove it when done.
     *
     * We create a CodeBuild image builder behind the scenes to copy the image over to ECR. This helps avoid Docker Hub rate limits and prevent failures.
     *
     * @param scope
     * @param id
     * @param image Docker Hub image with optional tag
     * @param architecture image architecture
     * @param os image OS
     */
    static fromDockerHub(scope, id, image, architecture = common_1.Architecture.X86_64, os = common_1.Os.LINUX) {
        const builder = new codebuild_2.CodeBuildImageBuilder(scope, id, {
            dockerfilePath: codebuild_1.CodeBuildRunner.LINUX_X64_DOCKERFILE_PATH,
            architecture,
            os,
        });
        builder.addPreBuildCommand(`echo "FROM ${image}" > Dockerfile`);
        return builder;
    }
}
exports.StaticRunnerImage = StaticRunnerImage;
_a = JSII_RTTI_SYMBOL_1;
StaticRunnerImage[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.StaticRunnerImage", version: "0.5.5" };
//# sourceMappingURL=data:application/json;base64,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