"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// src/lambdas/webhook-handler/index.ts
var crypto = __toESM(require("crypto"));
var AWS2 = __toESM(require("aws-sdk"));

// src/lambdas/helpers.ts
var AWS = __toESM(require("aws-sdk"));
var sm = new AWS.SecretsManager();
async function getSecretValue(arn) {
  if (!arn) {
    throw new Error("Missing secret ARN");
  }
  const secret = await sm.getSecretValue({ SecretId: arn }).promise();
  if (!secret.SecretString) {
    throw new Error(`No SecretString in ${arn}`);
  }
  return secret.SecretString;
}
async function getSecretJsonValue(arn) {
  return JSON.parse(await getSecretValue(arn));
}

// src/lambdas/webhook-handler/index.ts
var sf = new AWS2.StepFunctions();
function verifyBody(event, secret) {
  const sig = Buffer.from(event.headers["x-hub-signature-256"] || "", "utf8");
  if (!event.body) {
    throw new Error("No body");
  }
  let body;
  if (event.isBase64Encoded) {
    body = Buffer.from(event.body, "base64");
  } else {
    body = Buffer.from(event.body || "", "utf8");
  }
  const hmac = crypto.createHmac("sha256", secret);
  hmac.update(body);
  const expectedSig = Buffer.from(`sha256=${hmac.digest("hex")}`, "utf8");
  console.log("Calculated signature: ", expectedSig.toString());
  if (sig.length !== expectedSig.length || !crypto.timingSafeEqual(sig, expectedSig)) {
    throw new Error(`Signature mismatch. Expected ${expectedSig.toString()} but got ${sig.toString()}`);
  }
  return body.toString();
}
exports.handler = async function(event) {
  var _a;
  if (!process.env.WEBHOOK_SECRET_ARN || !process.env.STEP_FUNCTION_ARN) {
    throw new Error("Missing environment variables");
  }
  const webhookSecret = (await getSecretJsonValue(process.env.WEBHOOK_SECRET_ARN)).webhookSecret;
  let body;
  try {
    body = verifyBody(event, webhookSecret);
  } catch (e) {
    console.error(e);
    return {
      statusCode: 403,
      body: "Bad signature"
    };
  }
  if (event.headers["content-type"] !== "application/json") {
    console.error(`This webhook only accepts JSON payloads, got ${event.headers["content-type"]}`);
    return {
      statusCode: 400,
      body: "Expecting JSON payload"
    };
  }
  if (event.headers["x-github-event"] === "ping") {
    return {
      statusCode: 200,
      body: "Pong"
    };
  }
  if (event.headers["x-github-event"] !== "workflow_job") {
    console.error(`This webhook only accepts workflow_job, got ${event.headers["x-github-event"]}`);
    return {
      statusCode: 400,
      body: "Expecting workflow_job"
    };
  }
  const payload = JSON.parse(body);
  if (payload.action !== "queued") {
    console.log(`Ignoring action "${payload.action}", expecting "queued"`);
    return {
      statusCode: 200,
      body: "OK. No runner started."
    };
  }
  let labels = {};
  payload.workflow_job.labels.forEach((l) => labels[l] = true);
  let executionName = `${payload.repository.full_name.replace("/", "-")}-${event.headers["x-github-delivery"]}`.slice(0, 64);
  const execution = await sf.startExecution({
    stateMachineArn: process.env.STEP_FUNCTION_ARN,
    input: JSON.stringify({
      owner: payload.repository.owner.login,
      repo: payload.repository.name,
      runId: payload.workflow_job.run_id,
      installationId: (_a = payload.installation) == null ? void 0 : _a.id,
      labels
    }),
    name: executionName
  }).promise();
  console.log(`Started ${execution.executionArn}`);
  return {
    statusCode: 202,
    body: executionName
  };
};
