"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrImageScanNotify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("@aws-cdk/aws-events");
const target = require("@aws-cdk/aws-events-targets");
const _lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
class EcrImageScanNotify extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaFun = new _lambda.Function(this, 'lambda_fun', {
            handler: 'lambda_function.lambda_handler',
            code: _lambda.Code.fromAsset(path.join(__dirname, '../function')),
            runtime: _lambda.Runtime.PYTHON_3_9,
            timeout: cdk.Duration.minutes(3),
            environment: {
                WEBHOOK_URL: props.webhookUrl,
            },
        });
        const ecrScanTarget = new target.LambdaFunction(lambdaFun);
        new events.Rule(this, 'EventBusEcrImageScan', {
            ruleName: 'EventBusEcrImageScanRule',
            description: 'Send ECR Image Scan findings severity counts to slack',
            targets: [ecrScanTarget],
            eventPattern: {
                source: [
                    'aws.ecr',
                    'aws.inspector2',
                ],
                detailType: [
                    'ECR Image Scan',
                    'Inspector2 Scan',
                ],
            },
        });
    }
}
exports.EcrImageScanNotify = EcrImageScanNotify;
_a = JSII_RTTI_SYMBOL_1;
EcrImageScanNotify[_a] = { fqn: "cdk-ecr-image-scan-notify.EcrImageScanNotify", version: "0.0.352" };
//# sourceMappingURL=data:application/json;base64,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