# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['protoletariat', 'protoletariat.tests']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<9', 'protobuf>=3.19.1,<4.0.0']

extras_require = \
{':python_version < "3.9"': ['astunparse>=1.6.3,<2.0.0']}

entry_points = \
{'console_scripts': ['protol = protoletariat.__main__:main']}

setup_kwargs = {
    'name': 'protoletariat',
    'version': '0.7.2',
    'description': 'Python protocol buffers for the rest of us',
    'long_description': '# Protocol Buffers for the Rest of Us\n\n[![CI](https://github.com/cpcloud/protoletariat/actions/workflows/ci.yml/badge.svg?branch=main)](https://github.com/cpcloud/protoletariat/actions/workflows/ci.yml)\n\n## Motivation\n\nAre you annoyed by having to fix the absolute imports generated by `protoc`?\n\nIf so, then `protoletariat` is the tool for you.\n\n`protoletariat` has one goal: fixing the broken imports for the Python code\ngenerated by `protoc`.\n\nSee https://github.com/protocolbuffers/protobuf/issues/1491 for the discussion that inspired this tool.\n\n## Installation\n\n|   Artifact    |                                                              Status                                                               |                Installation Command                |\n| :-----------: | :-------------------------------------------------------------------------------------------------------------------------------: | :------------------------------------------------: |\n| PyPI Package  |                  [![PyPI](https://img.shields.io/pypi/v/protoletariat)](https://pypi.org/project/protoletariat)                   |            `pip install protoletariat`             |\n| Conda Package | [![Conda Version](https://img.shields.io/conda/vn/conda-forge/protoletariat.svg)](https://anaconda.org/conda-forge/protoletariat) |    `conda install protoletariat -c conda-forge`    |\n| Docker Image  |                                                                 ∅                                                                 | `docker pull ghcr.io/cpcloud/protoletariat:latest` |\n\n**Note: the `conda-forge` package version may lag behind the other artifacts by a few hours.**\n\n## Usage\n\n`protoletariat` is designed to be run as a post-processing step _after_ running\n`protoc`. It operates directly on the generated code.\n\n### Example\n\nHere\'s an example of how to use the tool, called `protol`:\n\n1. Create a few protobuf files\n\n```protobuf\n// thing1.proto\nsyntax = "proto3";\n\nimport "thing2.proto";\n\npackage things;\n\nmessage Thing1 {\n  Thing2 thing2 = 1;\n}\n```\n\n```protobuf\n// thing2.proto\nsyntax = "proto3";\n\npackage things;\n\nmessage Thing2 {\n  string data = 1;\n}\n```\n\n2. Run `protoc` on those files\n\n```sh\n$ mkdir out\n$ protoc \\\n  --python_out=out \\\n  --proto_path=directory/containing/protos thing1.proto thing2.proto\n```\n\n3. Run `protol` on the generated code\n\n```sh\n$ protol \\\n  --create-package \\\n  --in-place \\\n  --python-out out \\\n  protoc --proto-path=directory/containing/protos thing1.proto thing2.proto\n```\n\nThe `out/thing1_pb2.py` module should show a diff containing at least these lines:\n\n```patch\n-import thing2_pb2 as thing2__pb2\n-\n+from . import thing2_pb2 as thing2__pb2\n```\n\n## How it works\n\nAt a high level `protoletariat` converts absolute imports to relative imports.\n\nHowever, it doesn\'t convert just any absolute import to a relative import.\n\nThe `protol` tool will only convert imports that were generated from `.proto`\nfiles. It does this by inspecting `FileDescriptorProtos` generated from the\nproto files.\n\nThe core rewrite mechanism is implemented using a simplified form of pattern\nmatching that looks at the Python AST, and invokes rewrite rules for matched\nimport patterns.\n\n## Subcommands\n\n`protoletariat` has a subcommand for each tool that you might like to use to\ngenerate `FileDescriptorSet` bytes:\n\n| Subcommand | Description                                                                |\n| :--------: | :------------------------------------------------------------------------- |\n|  `protoc`  | Uses `protoc` to generate `FileDescriptorSet` bytes                        |\n|   `buf`    | Uses `buf` to generate `FileDescriptorSet` bytes                           |\n|   `raw`    | You provide the `FileDescriptorSet` bytes as a file or directly from stdin |\n\n## Help\n\n```\n$ protol\nUsage: protol [OPTIONS] COMMAND [ARGS]...\n\n  Rewrite protoc or buf-generated imports for use by the protoletariat.\n\nOptions:\n  -o, --python-out DIRECTORY      Directory containing protoc or buf-generated Python code  [required]\n  --in-place / --not-in-place     Overwrite all relevant files under `--python-out` with adjusted imports  [default: not-in-place]\n  --create-package / --dont-create-package\n                                  Recursively create __init__.py files under `--python-out`  [default: dont-create-package]\n  -s, --module-suffixes TEXT      Suffixes of Python/mypy modules to process  [default: _pb2.py, _pb2.pyi, _pb2_grpc.py, _pb2_grpc.pyi]\n  --exclude-google-imports / --dont-exclude-google-imports\n                                  Exclude rewriting imports prefixed with google/protobuf\n  -e, --exclude-imports-glob TEXT\n                                  Exclude imports matching a glob pattern from being rewritten. Multiple values are allowed\n  --help                          Show this message and exit.\n\nCommands:\n  buf     Use buf to generate the FileDescriptorSet blob\n  protoc  Use protoc to generate the FileDescriptorSet blob\n  raw     Rewrite imports using FileDescriptorSet bytes from a file or stdin\n```\n',
    'author': 'Phillip Cloud',
    'author_email': '417981+cpcloud@users.noreply.github.com',
    'maintainer': 'Phillip Cloud',
    'maintainer_email': '417981+cpcloud@users.noreply.github.com',
    'url': 'https://github.com/cpcloud/protoletariat',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
