# Generated by Django 2.2.28 on 2023-03-08 04:56

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
                ('short_description', models.CharField(blank=True, max_length=255, null=True)),
                ('slug', models.SlugField(blank=True, null=True, unique=True)),
                ('creator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='applications', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'application',
                'verbose_name_plural': 'applications',
                'ordering': ['slug'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'lookup_field': 'slug',
                'rdf_type': 'sib:application',
                'rdf_context': {'creator': 'foaf:user', 'friendly_name': 'sib:friendlyName', 'short_description': 'sib:shortDescription'},
                'auto_author': 'creator',
                'owner_field': 'creator',
                'container_path': '/applications/',
                'serializer_fields': ['@id', 'friendly_name', 'short_description', 'creator'],
                'depth': 1,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit', 'add'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['view'],
            },
        ),
    ]
