"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const k8s = require("./imports/k8s");
const probe_1 = require("./probe");
/**
 * Utility class to implement the conversion between our API and the k8s action
 * structure. Used both for probes and handlers.
 *
 * @internal
 */
class Action {
    static fromTcpSocket(container, options = {}) {
        return {
            port: k8s.IntOrString.fromNumber(options.port ?? container.portNumber ?? 80),
            host: options.host,
        };
    }
    static fromCommand(command) {
        return { command };
    }
    static fromHttpGet(container, path, options = {}) {
        return {
            path,
            port: k8s.IntOrString.fromNumber(options.port ?? container.portNumber ?? 80),
            scheme: options.scheme ?? probe_1.ConnectionScheme.HTTP,
        };
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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