# GT4Py - GridTools Framework
#
# Copyright (c) 2014-2023, ETH Zurich
# All rights reserved.
#
# This file is part of the GT4Py project and the GridTools framework.
# GT4Py is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 3 of the License, or any later
# version. See the LICENSE.txt file at the top-level directory of this
# distribution for a copy of the license or check <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from . import attrib, meta, text
from .base import (
    NOTHING,
    BaseFrozen,
    BaseSingleton,
    Registry,
    UniqueIdGenerator,
    classmethod_to_function,
    classproperty,
    compose,
    flatten,
    flatten_iter,
    get_member,
    is_collection,
    is_identifier_name,
    is_iterable_of,
    is_mapping_of,
    jsonify,
    make_dir,
    make_local_dir,
    make_module_from_file,
    namespace_from_nested_dict,
    normalize_mapping,
    patch_module,
    restore_module,
    shash,
    shashed_id,
    slugify,
)


__all__ = [
    # Modules
    "attrib",
    "meta",
    "text",
    # Objects
    "NOTHING",
    "BaseFrozen",
    "BaseSingleton",
    "Registry",
    "UniqueIdGenerator",
    "classmethod_to_function",
    "classproperty",
    "compose",
    "flatten",
    "flatten_iter",
    "get_member",
    "is_collection",
    "is_identifier_name",
    "is_iterable_of",
    "is_mapping_of",
    "jsonify",
    "make_dir",
    "make_local_dir",
    "make_module_from_file",
    "namespace_from_nested_dict",
    "normalize_mapping",
    "patch_module",
    "restore_module",
    "shash",
    "shashed_id",
    "slugify",
]
