# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pdf_split_tool']

package_data = \
{'': ['*']}

install_requires = \
['PyPDF4>=1.27.0,<2.0.0', 'click>=7.0,<8.0']

entry_points = \
{'console_scripts': ['pdf-split-tool = pdf_split_tool.__main__:main']}

setup_kwargs = {
    'name': 'pdf-split-tool',
    'version': '1.0.2',
    'description': 'Pdf Split Tool',
    'long_description': 'Pdf Split Tool\n==============\n\n**MAINTAINER NEEDED: this project is complete but won\'t be updated until further notice. If you have interest in improving it, please contact me by creating an** `issue here`_ **.**\n\n|PyPI| |Python Version| |License|\n\n|Read the Docs| |Tests| |Codecov|\n\n|pre-commit| |Black|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/pdf-split-tool.svg\n   :target: https://pypi.org/project/pdf-split-tool/\n   :alt: PyPI\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/pdf-split-tool\n   :target: https://pypi.org/project/pdf-split-tool\n   :alt: Python Version\n.. |License| image:: https://img.shields.io/pypi/l/pdf-split-tool\n   :target: https://opensource.org/licenses/MIT\n   :alt: License\n.. |Read the Docs| image:: https://img.shields.io/readthedocs/pdf-split-tool/latest.svg?label=Read%20the%20Docs\n   :target: https://pdf-split-tool.readthedocs.io/\n   :alt: Read the documentation at https://pdf-split-tool.readthedocs.io/\n.. |Tests| image:: https://github.com/staticdev/pdf-split-tool/workflows/Tests/badge.svg\n   :target: https://github.com/staticdev/pdf-split-tool/actions?workflow=Tests\n   :alt: Tests\n.. |Codecov| image:: https://codecov.io/gh/staticdev/pdf-split-tool/branch/master/graph/badge.svg\n   :target: https://codecov.io/gh/staticdev/pdf-split-tool\n   :alt: Codecov\n.. |pre-commit| image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n   :target: https://github.com/pre-commit/pre-commit\n   :alt: pre-commit\n.. |Black| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n   :alt: Black\n\n\nFeatures\n--------\n\n* Cross-platform: Windows, Mac, and Linux are officially supported.\n* Works with Python 3.8 and 3.9.\n* Splits documents by max size.\n* Checks for high-resolution PDFs before splitting.\n\n\nRequirements\n------------\n\nYou need Python 3.8 or above (3.9 recommended) installed on your machine.\n\nWindows users should download `Windows x86-64 executable installer` and in the installer screen be ensure the option `Add Python 3.8 to PATH` is checked:\n\n.. image:: docs/_images/winpath.png\n   :alt: Windows Installation PATH checkbox\n\n\nInstallation\n------------\n\nYou can install *Pdf Split Tool* via pip_ from PyPI_:\n\n.. code:: console\n\n   pip install pdf-split-tool\n\nNote: on Windows you can copy the above command in the `cmd` program.\n\n\nUsage\n-----\n\n1) Enter the terminal of your operating system eg. `cmd` program on Windows or shell on Linux and MacOS.\n\n2) Choose the one option and execute the command on the terminal:\n\n* For splits with the default value (20mb) of a specific PDF\n\n.. code:: console\n\n   pdf-split-tool C:\\Users\\John\\myfile.pdf\n\n* For splits with the default value (20mb) of all PDFs in a folder\n\n.. code:: console\n\n   pdf-split-tool\n\n* You can choose the max size in megabytes with the option `-m` or `--max-size`\n\n.. code:: console\n\n   pdf-split-tool --max-size 50 # for 50 megabytes\n\nNote: you can also use --max-size after the path of a specific PDF and fractional numbers such as "50.5".\n\n\nContributing\n------------\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\n\nLicense\n-------\n\nDistributed under the terms of the MIT_ license,\n*Pdf Split Tool* is free and open source software.\n\n\nIssues\n------\n\nIf you encounter any problems,\nplease `file an issue`_ along with a detailed description.\n\n\nCredits\n-------\n\nThis project was generated from `@cjolowicz`_\'s `Hypermodern Python Cookiecutter`_ template.\n\n\n.. _issue here: https://github.com/staticdev/staticdev/issues\n.. _@cjolowicz: https://github.com/cjolowicz\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _MIT: http://opensource.org/licenses/MIT\n.. _PyPI: https://pypi.org/\n.. _Hypermodern Python Cookiecutter: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n.. _file an issue: https://github.com/staticdev/pdf-split-tool/issues\n.. _pip: https://pip.pypa.io/\n.. github-only\n.. _Contributor Guide: CONTRIBUTING.rst\n',
    'author': "Thiago Carvalho D'Ávila",
    'author_email': 'thiagocavila@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/staticdev/pdf-split-tool',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
