# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DesktopDataVolume',
    'DesktopNic',
    'DesktopRootVolume',
    'ServiceAdDomain',
    'ServiceDesktopSecurityGroup',
    'ServiceInfrastructureSecurityGroup',
]

@pulumi.output_type
class DesktopDataVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopDataVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopDataVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopDataVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 created_at: Optional[str] = None,
                 device: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param int size: Specifies the size of system volume, in GB.
               + For root volume, the valid value is range from `80` to `1,020`.
               + For data volume, the valid value is range from `10` to `8,200`.
        :param str type: Specifies the type of system volume.
               The valid values are as follows:
               + **SAS**: High I/O disk type.
               + **SSD**: Ultra-high I/O disk type.
        :param str created_at: The time that the volume was created.
        :param str device: The device location to which the volume is attached.
        :param str id: The volume ID.
        :param str name: Specifies the desktop name.
               The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter or digit and cannot end with a hyphen.
               Changing this will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the size of system volume, in GB.
        + For root volume, the valid value is range from `80` to `1,020`.
        + For data volume, the valid value is range from `10` to `8,200`.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of system volume.
        The valid values are as follows:
        + **SAS**: High I/O disk type.
        + **SSD**: Ultra-high I/O disk type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The time that the volume was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        The device location to which the volume is attached.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The volume ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the desktop name.
        The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
        The name must start with a letter or digit and cannot end with a hyphen.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DesktopNic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopNic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopNic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopNic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_id: str):
        """
        :param str network_id: Specifies the network ID of subnet resource.
               Changing this will create a new resource.
        """
        pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        Specifies the network ID of subnet resource.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "network_id")


@pulumi.output_type
class DesktopRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 created_at: Optional[str] = None,
                 device: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param int size: Specifies the size of system volume, in GB.
               + For root volume, the valid value is range from `80` to `1,020`.
               + For data volume, the valid value is range from `10` to `8,200`.
        :param str type: Specifies the type of system volume.
               The valid values are as follows:
               + **SAS**: High I/O disk type.
               + **SSD**: Ultra-high I/O disk type.
        :param str created_at: The time that the volume was created.
        :param str device: The device location to which the volume is attached.
        :param str id: The volume ID.
        :param str name: Specifies the desktop name.
               The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter or digit and cannot end with a hyphen.
               Changing this will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the size of system volume, in GB.
        + For root volume, the valid value is range from `80` to `1,020`.
        + For data volume, the valid value is range from `10` to `8,200`.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of system volume.
        The valid values are as follows:
        + **SAS**: High I/O disk type.
        + **SSD**: Ultra-high I/O disk type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The time that the volume was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        The device location to which the volume is attached.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The volume ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the desktop name.
        The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
        The name must start with a letter or digit and cannot end with a hyphen.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceAdDomain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDomainIp":
            suggest = "active_domain_ip"
        elif key == "activeDomainName":
            suggest = "active_domain_name"
        elif key == "adminAccount":
            suggest = "admin_account"
        elif key == "activeDnsIp":
            suggest = "active_dns_ip"
        elif key == "deleteComputerObject":
            suggest = "delete_computer_object"
        elif key == "standbyDnsIp":
            suggest = "standby_dns_ip"
        elif key == "standbyDomainIp":
            suggest = "standby_domain_ip"
        elif key == "standbyDomainName":
            suggest = "standby_domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAdDomain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAdDomain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAdDomain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_domain_ip: str,
                 active_domain_name: str,
                 admin_account: str,
                 name: str,
                 password: str,
                 active_dns_ip: Optional[str] = None,
                 delete_computer_object: Optional[bool] = None,
                 standby_dns_ip: Optional[str] = None,
                 standby_domain_ip: Optional[str] = None,
                 standby_domain_name: Optional[str] = None):
        """
        :param str active_domain_ip: Specifies the IP address of primary domain controller.
        :param str active_domain_name: Specifies the name of primary domain controller.
        :param str admin_account: Specifies the domain administrator account.
               It must be an existing domain administrator account on the AD server.
        :param str name: Specifies the domain name.
               The domain name must be an existing domain name on the AD server, and the length cannot exceed `55`.
        :param str password: Specifies the account password of domain administrator.
        :param str active_dns_ip: Specifies the primary DNS IP address.
        :param bool delete_computer_object: Specifies whether to delete the corresponding computer object on AD
               while deleting the desktop.
        :param str standby_dns_ip: Specifies the standby DNS IP address.
        :param str standby_domain_ip: Specifies the IP address of the standby domain controller.
        :param str standby_domain_name: Specifies the name of the standby domain controller.
        """
        pulumi.set(__self__, "active_domain_ip", active_domain_ip)
        pulumi.set(__self__, "active_domain_name", active_domain_name)
        pulumi.set(__self__, "admin_account", admin_account)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        if active_dns_ip is not None:
            pulumi.set(__self__, "active_dns_ip", active_dns_ip)
        if delete_computer_object is not None:
            pulumi.set(__self__, "delete_computer_object", delete_computer_object)
        if standby_dns_ip is not None:
            pulumi.set(__self__, "standby_dns_ip", standby_dns_ip)
        if standby_domain_ip is not None:
            pulumi.set(__self__, "standby_domain_ip", standby_domain_ip)
        if standby_domain_name is not None:
            pulumi.set(__self__, "standby_domain_name", standby_domain_name)

    @property
    @pulumi.getter(name="activeDomainIp")
    def active_domain_ip(self) -> str:
        """
        Specifies the IP address of primary domain controller.
        """
        return pulumi.get(self, "active_domain_ip")

    @property
    @pulumi.getter(name="activeDomainName")
    def active_domain_name(self) -> str:
        """
        Specifies the name of primary domain controller.
        """
        return pulumi.get(self, "active_domain_name")

    @property
    @pulumi.getter(name="adminAccount")
    def admin_account(self) -> str:
        """
        Specifies the domain administrator account.
        It must be an existing domain administrator account on the AD server.
        """
        return pulumi.get(self, "admin_account")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the domain name.
        The domain name must be an existing domain name on the AD server, and the length cannot exceed `55`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Specifies the account password of domain administrator.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="activeDnsIp")
    def active_dns_ip(self) -> Optional[str]:
        """
        Specifies the primary DNS IP address.
        """
        return pulumi.get(self, "active_dns_ip")

    @property
    @pulumi.getter(name="deleteComputerObject")
    def delete_computer_object(self) -> Optional[bool]:
        """
        Specifies whether to delete the corresponding computer object on AD
        while deleting the desktop.
        """
        return pulumi.get(self, "delete_computer_object")

    @property
    @pulumi.getter(name="standbyDnsIp")
    def standby_dns_ip(self) -> Optional[str]:
        """
        Specifies the standby DNS IP address.
        """
        return pulumi.get(self, "standby_dns_ip")

    @property
    @pulumi.getter(name="standbyDomainIp")
    def standby_domain_ip(self) -> Optional[str]:
        """
        Specifies the IP address of the standby domain controller.
        """
        return pulumi.get(self, "standby_domain_ip")

    @property
    @pulumi.getter(name="standbyDomainName")
    def standby_domain_name(self) -> Optional[str]:
        """
        Specifies the name of the standby domain controller.
        """
        return pulumi.get(self, "standby_domain_name")


@pulumi.output_type
class ServiceDesktopSecurityGroup(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str id: Security group ID.
        :param str name: Specifies the domain name.
               The domain name must be an existing domain name on the AD server, and the length cannot exceed `55`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Security group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the domain name.
        The domain name must be an existing domain name on the AD server, and the length cannot exceed `55`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceInfrastructureSecurityGroup(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str id: Security group ID.
        :param str name: Specifies the domain name.
               The domain name must be an existing domain name on the AD server, and the length cannot exceed `55`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Security group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the domain name.
        The domain name must be an existing domain name on the AD server, and the length cannot exceed `55`.
        """
        return pulumi.get(self, "name")


