# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RuleDataMaskingArgs', 'RuleDataMasking']

@pulumi.input_type
class RuleDataMaskingArgs:
    def __init__(__self__, *,
                 field: pulumi.Input[str],
                 path: pulumi.Input[str],
                 policy_id: pulumi.Input[str],
                 subfield: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RuleDataMasking resource.
        :param pulumi.Input[str] field: The position where the masked field stored. Valid values are:
               + `params`: The field in the parameter.
               + `header`: The field in the header.
               + `form`: The field in the form.
               + `cookie`: The field in the cookie.
        :param pulumi.Input[str] path: Specifies the URL to which the data masking rule applies (exact match by default).
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule.
        :param pulumi.Input[str] subfield: Specifies the name of the masked field, e.g.: password.
        :param pulumi.Input[str] region: The region in which to create the WAF Data Masking rule resource. If omitted,
               the provider-level region will be used. Changing this setting will create a new rule.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "subfield", subfield)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def field(self) -> pulumi.Input[str]:
        """
        The position where the masked field stored. Valid values are:
        + `params`: The field in the parameter.
        + `header`: The field in the header.
        + `form`: The field in the form.
        + `cookie`: The field in the cookie.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: pulumi.Input[str]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the URL to which the data masking rule applies (exact match by default).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def subfield(self) -> pulumi.Input[str]:
        """
        Specifies the name of the masked field, e.g.: password.
        """
        return pulumi.get(self, "subfield")

    @subfield.setter
    def subfield(self, value: pulumi.Input[str]):
        pulumi.set(self, "subfield", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF Data Masking rule resource. If omitted,
        the provider-level region will be used. Changing this setting will create a new rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RuleDataMaskingState:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subfield: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RuleDataMasking resources.
        :param pulumi.Input[str] field: The position where the masked field stored. Valid values are:
               + `params`: The field in the parameter.
               + `header`: The field in the header.
               + `form`: The field in the form.
               + `cookie`: The field in the cookie.
        :param pulumi.Input[str] path: Specifies the URL to which the data masking rule applies (exact match by default).
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule.
        :param pulumi.Input[str] region: The region in which to create the WAF Data Masking rule resource. If omitted,
               the provider-level region will be used. Changing this setting will create a new rule.
        :param pulumi.Input[str] subfield: Specifies the name of the masked field, e.g.: password.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subfield is not None:
            pulumi.set(__self__, "subfield", subfield)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The position where the masked field stored. Valid values are:
        + `params`: The field in the parameter.
        + `header`: The field in the header.
        + `form`: The field in the form.
        + `cookie`: The field in the cookie.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the URL to which the data masking rule applies (exact match by default).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF Data Masking rule resource. If omitted,
        the provider-level region will be used. Changing this setting will create a new rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def subfield(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the masked field, e.g.: password.
        """
        return pulumi.get(self, "subfield")

    @subfield.setter
    def subfield(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subfield", value)


class RuleDataMasking(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subfield: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a WAF Data Masking Rule resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The data masking rule resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        policy1 = huaweicloud.waf.Policy("policy1")
        rule1 = huaweicloud.waf.RuleDataMasking("rule1",
            policy_id=policy1.id,
            path="/login",
            field="params",
            subfield="password")
        ```

        ## Import

        Data Masking Rules can be imported using the policy ID and rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/ruleDataMasking:RuleDataMasking rule_1 d78b439fd5e54ea08886e5f63ee7b3f5/ac01a092d50e4e6ba3cd622c1128ba2c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] field: The position where the masked field stored. Valid values are:
               + `params`: The field in the parameter.
               + `header`: The field in the header.
               + `form`: The field in the form.
               + `cookie`: The field in the cookie.
        :param pulumi.Input[str] path: Specifies the URL to which the data masking rule applies (exact match by default).
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule.
        :param pulumi.Input[str] region: The region in which to create the WAF Data Masking rule resource. If omitted,
               the provider-level region will be used. Changing this setting will create a new rule.
        :param pulumi.Input[str] subfield: Specifies the name of the masked field, e.g.: password.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleDataMaskingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a WAF Data Masking Rule resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The data masking rule resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        policy1 = huaweicloud.waf.Policy("policy1")
        rule1 = huaweicloud.waf.RuleDataMasking("rule1",
            policy_id=policy1.id,
            path="/login",
            field="params",
            subfield="password")
        ```

        ## Import

        Data Masking Rules can be imported using the policy ID and rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/ruleDataMasking:RuleDataMasking rule_1 d78b439fd5e54ea08886e5f63ee7b3f5/ac01a092d50e4e6ba3cd622c1128ba2c
        ```

        :param str resource_name: The name of the resource.
        :param RuleDataMaskingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleDataMaskingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subfield: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleDataMaskingArgs.__new__(RuleDataMaskingArgs)

            if field is None and not opts.urn:
                raise TypeError("Missing required property 'field'")
            __props__.__dict__["field"] = field
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["region"] = region
            if subfield is None and not opts.urn:
                raise TypeError("Missing required property 'subfield'")
            __props__.__dict__["subfield"] = subfield
        super(RuleDataMasking, __self__).__init__(
            'huaweicloud:Waf/ruleDataMasking:RuleDataMasking',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            field: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            subfield: Optional[pulumi.Input[str]] = None) -> 'RuleDataMasking':
        """
        Get an existing RuleDataMasking resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] field: The position where the masked field stored. Valid values are:
               + `params`: The field in the parameter.
               + `header`: The field in the header.
               + `form`: The field in the form.
               + `cookie`: The field in the cookie.
        :param pulumi.Input[str] path: Specifies the URL to which the data masking rule applies (exact match by default).
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule.
        :param pulumi.Input[str] region: The region in which to create the WAF Data Masking rule resource. If omitted,
               the provider-level region will be used. Changing this setting will create a new rule.
        :param pulumi.Input[str] subfield: Specifies the name of the masked field, e.g.: password.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleDataMaskingState.__new__(_RuleDataMaskingState)

        __props__.__dict__["field"] = field
        __props__.__dict__["path"] = path
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["region"] = region
        __props__.__dict__["subfield"] = subfield
        return RuleDataMasking(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def field(self) -> pulumi.Output[str]:
        """
        The position where the masked field stored. Valid values are:
        + `params`: The field in the parameter.
        + `header`: The field in the header.
        + `form`: The field in the form.
        + `cookie`: The field in the cookie.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Specifies the URL to which the data masking rule applies (exact match by default).
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the WAF Data Masking rule resource. If omitted,
        the provider-level region will be used. Changing this setting will create a new rule.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def subfield(self) -> pulumi.Output[str]:
        """
        Specifies the name of the masked field, e.g.: password.
        """
        return pulumi.get(self, "subfield")

