# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceGroupArgs', 'InstanceGroup']

@pulumi.input_type
class InstanceGroupArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InstanceGroup resource.
        :param pulumi.Input[str] vpc_id: Specifies the id of the VPC that the WAF dedicated instances belongs to.
        :param pulumi.Input[str] description: Specifies the description of the instance group.
        :param pulumi.Input[str] name: Specifies the instance group name.
               The maximum length is 64 characters. Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the instance group.
               If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the id of the VPC that the WAF dedicated instances belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the instance group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance group name.
        The maximum length is 64 characters. Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the instance group.
        If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _InstanceGroupState:
    def __init__(__self__, *,
                 body_limit: Optional[pulumi.Input[int]] = None,
                 connection_timeout: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 header_limit: Optional[pulumi.Input[int]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_timeout: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 write_timeout: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering InstanceGroup resources.
        :param pulumi.Input[int] body_limit: The body limit of the forwarding policy.
        :param pulumi.Input[int] connection_timeout: The time for connection timeout in the forwarding policy.
        :param pulumi.Input[str] description: Specifies the description of the instance group.
        :param pulumi.Input[int] header_limit: The header limit of the forwarding policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancers: The IDs of the ELB instances that has been bound to the instance group.
        :param pulumi.Input[str] name: Specifies the instance group name.
               The maximum length is 64 characters. Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[int] read_timeout: The time for reading timeout in the forwarding policy.
        :param pulumi.Input[str] region: The region in which to create the instance group.
               If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the id of the VPC that the WAF dedicated instances belongs to.
        :param pulumi.Input[int] write_timeout: The time for writing timeout in the forwarding policy.
        """
        if body_limit is not None:
            pulumi.set(__self__, "body_limit", body_limit)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if header_limit is not None:
            pulumi.set(__self__, "header_limit", header_limit)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if write_timeout is not None:
            pulumi.set(__self__, "write_timeout", write_timeout)

    @property
    @pulumi.getter(name="bodyLimit")
    def body_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The body limit of the forwarding policy.
        """
        return pulumi.get(self, "body_limit")

    @body_limit.setter
    def body_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "body_limit", value)

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time for connection timeout in the forwarding policy.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_timeout", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the instance group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="headerLimit")
    def header_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The header limit of the forwarding policy.
        """
        return pulumi.get(self, "header_limit")

    @header_limit.setter
    def header_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "header_limit", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of the ELB instances that has been bound to the instance group.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance group name.
        The maximum length is 64 characters. Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time for reading timeout in the forwarding policy.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_timeout", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the instance group.
        If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the id of the VPC that the WAF dedicated instances belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time for writing timeout in the forwarding policy.
        """
        return pulumi.get(self, "write_timeout")

    @write_timeout.setter
    def write_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "write_timeout", value)


class InstanceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages WAF instance groups within HuaweiCloud. The groups are used to bind the ELB instance to the ELB mode WAF.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        group1 = huaweicloud.waf.InstanceGroup("group1", vpc_id=vpc_id)
        ```

        ## Import

        The instance group can be imported using the ID, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/instanceGroup:InstanceGroup group_1 0be1e69d-1987-4d9c-9dc5-fc7eed592398
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of the instance group.
        :param pulumi.Input[str] name: Specifies the instance group name.
               The maximum length is 64 characters. Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the instance group.
               If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the id of the VPC that the WAF dedicated instances belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages WAF instance groups within HuaweiCloud. The groups are used to bind the ELB instance to the ELB mode WAF.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        group1 = huaweicloud.waf.InstanceGroup("group1", vpc_id=vpc_id)
        ```

        ## Import

        The instance group can be imported using the ID, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/instanceGroup:InstanceGroup group_1 0be1e69d-1987-4d9c-9dc5-fc7eed592398
        ```

        :param str resource_name: The name of the resource.
        :param InstanceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceGroupArgs.__new__(InstanceGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["body_limit"] = None
            __props__.__dict__["connection_timeout"] = None
            __props__.__dict__["header_limit"] = None
            __props__.__dict__["load_balancers"] = None
            __props__.__dict__["read_timeout"] = None
            __props__.__dict__["write_timeout"] = None
        super(InstanceGroup, __self__).__init__(
            'huaweicloud:Waf/instanceGroup:InstanceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body_limit: Optional[pulumi.Input[int]] = None,
            connection_timeout: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            header_limit: Optional[pulumi.Input[int]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            read_timeout: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            write_timeout: Optional[pulumi.Input[int]] = None) -> 'InstanceGroup':
        """
        Get an existing InstanceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] body_limit: The body limit of the forwarding policy.
        :param pulumi.Input[int] connection_timeout: The time for connection timeout in the forwarding policy.
        :param pulumi.Input[str] description: Specifies the description of the instance group.
        :param pulumi.Input[int] header_limit: The header limit of the forwarding policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancers: The IDs of the ELB instances that has been bound to the instance group.
        :param pulumi.Input[str] name: Specifies the instance group name.
               The maximum length is 64 characters. Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[int] read_timeout: The time for reading timeout in the forwarding policy.
        :param pulumi.Input[str] region: The region in which to create the instance group.
               If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the id of the VPC that the WAF dedicated instances belongs to.
        :param pulumi.Input[int] write_timeout: The time for writing timeout in the forwarding policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceGroupState.__new__(_InstanceGroupState)

        __props__.__dict__["body_limit"] = body_limit
        __props__.__dict__["connection_timeout"] = connection_timeout
        __props__.__dict__["description"] = description
        __props__.__dict__["header_limit"] = header_limit
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["name"] = name
        __props__.__dict__["read_timeout"] = read_timeout
        __props__.__dict__["region"] = region
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["write_timeout"] = write_timeout
        return InstanceGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bodyLimit")
    def body_limit(self) -> pulumi.Output[int]:
        """
        The body limit of the forwarding policy.
        """
        return pulumi.get(self, "body_limit")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> pulumi.Output[int]:
        """
        The time for connection timeout in the forwarding policy.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the instance group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="headerLimit")
    def header_limit(self) -> pulumi.Output[int]:
        """
        The header limit of the forwarding policy.
        """
        return pulumi.get(self, "header_limit")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Sequence[str]]:
        """
        The IDs of the ELB instances that has been bound to the instance group.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the instance group name.
        The maximum length is 64 characters. Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> pulumi.Output[int]:
        """
        The time for reading timeout in the forwarding policy.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the instance group.
        If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the id of the VPC that the WAF dedicated instances belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> pulumi.Output[int]:
        """
        The time for writing timeout in the forwarding policy.
        """
        return pulumi.get(self, "write_timeout")

