# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceGroupsResult',
    'AwaitableGetInstanceGroupsResult',
    'get_instance_groups',
    'get_instance_groups_output',
]

@pulumi.output_type
class GetInstanceGroupsResult:
    """
    A collection of values returned by getInstanceGroups.
    """
    def __init__(__self__, groups=None, id=None, name=None, region=None, vpc_id=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetInstanceGroupsGroupResult']:
        """
        A list of WAF instance groups.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The instance group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to create the instance group.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The id of the VPC that the WAF dedicated instances belongs to.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetInstanceGroupsResult(GetInstanceGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceGroupsResult(
            groups=self.groups,
            id=self.id,
            name=self.name,
            region=self.region,
            vpc_id=self.vpc_id)


def get_instance_groups(name: Optional[str] = None,
                        region: Optional[str] = None,
                        vpc_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceGroupsResult:
    """
    Use this data source to get a list of WAF instance groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    groups1 = huaweicloud.Waf.get_instance_groups(name="example_name")
    ```


    :param str name: The name of WAF instance group used for matching.
           The value is not case-sensitive and supports fuzzy matching.
    :param str region: The region in which to obtain the WAF instance groups.
           If omitted, the provider-level region will be used.
    :param str vpc_id: The id of the VPC that the WAF dedicated instances belongs to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Waf/getInstanceGroups:getInstanceGroups', __args__, opts=opts, typ=GetInstanceGroupsResult).value

    return AwaitableGetInstanceGroupsResult(
        groups=__ret__.groups,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_instance_groups)
def get_instance_groups_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                               region: Optional[pulumi.Input[Optional[str]]] = None,
                               vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceGroupsResult]:
    """
    Use this data source to get a list of WAF instance groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    groups1 = huaweicloud.Waf.get_instance_groups(name="example_name")
    ```


    :param str name: The name of WAF instance group used for matching.
           The value is not case-sensitive and supports fuzzy matching.
    :param str region: The region in which to obtain the WAF instance groups.
           If omitted, the provider-level region will be used.
    :param str vpc_id: The id of the VPC that the WAF dedicated instances belongs to.
    """
    ...
