# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[str],
                 private_key: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[str] certificate: Specifies the certificate content. Changing this creates a new
               certificate.
        :param pulumi.Input[str] private_key: Specifies the private key. Changing this creates a new certificate.
        :param pulumi.Input[str] name: Specifies the certificate name. The maximum length is 256 characters. Only digits,
               letters, underscores(`_`), and hyphens(`-`) are allowed.
        :param pulumi.Input[str] region: The region in which to create the WAF certificate resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[str]:
        """
        Specifies the certificate content. Changing this creates a new
        certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[str]:
        """
        Specifies the private key. Changing this creates a new certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the certificate name. The maximum length is 256 characters. Only digits,
        letters, underscores(`_`), and hyphens(`-`) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF certificate resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[str] certificate: Specifies the certificate content. Changing this creates a new
               certificate.
        :param pulumi.Input[str] expiration: Indicates the time when the certificate expires.
        :param pulumi.Input[str] name: Specifies the certificate name. The maximum length is 256 characters. Only digits,
               letters, underscores(`_`), and hyphens(`-`) are allowed.
        :param pulumi.Input[str] private_key: Specifies the private key. Changing this creates a new certificate.
        :param pulumi.Input[str] region: The region in which to create the WAF certificate resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the certificate content. Changing this creates a new
        certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the time when the certificate expires.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the certificate name. The maximum length is 256 characters. Only digits,
        letters, underscores(`_`), and hyphens(`-`) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the private key. Changing this creates a new certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF certificate resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a WAF certificate resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The certificate resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        certificate1 = huaweicloud.waf.Certificate("certificate1",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIIFmQl5dh2QUAeo39TIKtadgAgh4zHx09kSgayS9Wph9LEqq7MA+2042L3J9aOa
        DAYDVR0TAQH/BAIwADAdBgNVHQ4EFgQUR+SosWwALt6PkP0J9iOIxA6RW8gVsLwq
        ...
        +HhDvD/VeOHytX3RAs2GeTOtxyAV5XpKY5r+PkyUqPJj04t3d0Fopi0gNtLpMF=
        -----END CERTIFICATE-----

        \"\"\",
            private_key=\"\"\"-----BEGIN PRIVATE KEY-----
        MIIJwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAM
        ATAwMC4GCCsGAQUFBwIBFiJodHRwOi8vY3BzLnJvb3QteDEubGV0c2VuY3J5cHQu
        ...
        he8Y4IWS6wY7bCkjCWDcRQJMEhg76fsO3txE+FiYruq9RUWhiF1myv4Q6W+CyBFC
        1qoJFlcDyqSMo5iHq3HLjs
        -----END PRIVATE KEY-----

        \"\"\")
        ```

        ## Import

        Certificates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/certificate:Certificate certificate_2 3ebd3201238d41f9bfc3623b61435954
        ```

         Note that the imported state is not identical to your resource definition, due to security reason. The missing attributes include `certificate`, and `private_key`. You can ignore changes as below. resource "huaweicloud_waf_certificate" "certificate_2" {

         ...

         lifecycle {

         ignore_changes = [

         certificate, private_key

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: Specifies the certificate content. Changing this creates a new
               certificate.
        :param pulumi.Input[str] name: Specifies the certificate name. The maximum length is 256 characters. Only digits,
               letters, underscores(`_`), and hyphens(`-`) are allowed.
        :param pulumi.Input[str] private_key: Specifies the private key. Changing this creates a new certificate.
        :param pulumi.Input[str] region: The region in which to create the WAF certificate resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a WAF certificate resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The certificate resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        certificate1 = huaweicloud.waf.Certificate("certificate1",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIIFmQl5dh2QUAeo39TIKtadgAgh4zHx09kSgayS9Wph9LEqq7MA+2042L3J9aOa
        DAYDVR0TAQH/BAIwADAdBgNVHQ4EFgQUR+SosWwALt6PkP0J9iOIxA6RW8gVsLwq
        ...
        +HhDvD/VeOHytX3RAs2GeTOtxyAV5XpKY5r+PkyUqPJj04t3d0Fopi0gNtLpMF=
        -----END CERTIFICATE-----

        \"\"\",
            private_key=\"\"\"-----BEGIN PRIVATE KEY-----
        MIIJwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAM
        ATAwMC4GCCsGAQUFBwIBFiJodHRwOi8vY3BzLnJvb3QteDEubGV0c2VuY3J5cHQu
        ...
        he8Y4IWS6wY7bCkjCWDcRQJMEhg76fsO3txE+FiYruq9RUWhiF1myv4Q6W+CyBFC
        1qoJFlcDyqSMo5iHq3HLjs
        -----END PRIVATE KEY-----

        \"\"\")
        ```

        ## Import

        Certificates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/certificate:Certificate certificate_2 3ebd3201238d41f9bfc3623b61435954
        ```

         Note that the imported state is not identical to your resource definition, due to security reason. The missing attributes include `certificate`, and `private_key`. You can ignore changes as below. resource "huaweicloud_waf_certificate" "certificate_2" {

         ...

         lifecycle {

         ignore_changes = [

         certificate, private_key

         ]

         } }

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["name"] = name
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["region"] = region
            __props__.__dict__["expiration"] = None
        super(Certificate, __self__).__init__(
            'huaweicloud:Waf/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            expiration: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: Specifies the certificate content. Changing this creates a new
               certificate.
        :param pulumi.Input[str] expiration: Indicates the time when the certificate expires.
        :param pulumi.Input[str] name: Specifies the certificate name. The maximum length is 256 characters. Only digits,
               letters, underscores(`_`), and hyphens(`-`) are allowed.
        :param pulumi.Input[str] private_key: Specifies the private key. Changing this creates a new certificate.
        :param pulumi.Input[str] region: The region in which to create the WAF certificate resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["region"] = region
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        Specifies the certificate content. Changing this creates a new
        certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[str]:
        """
        Indicates the time when the certificate expires.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the certificate name. The maximum length is 256 characters. Only digits,
        letters, underscores(`_`), and hyphens(`-`) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        """
        Specifies the private key. Changing this creates a new certificate.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the WAF certificate resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

