# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 port_id: pulumi.Input[str],
                 port_mappings: pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]],
                 server_type: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 approval: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[str] port_id: - Specifies the ID for identifying the backend resource of the VPC endpoint
               service.
               + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
               + If the `server_type` is **VIP**, the value is the NIC ID of the physical server where virtual resources are
               created.
               + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
               balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]] port_mappings: - Specified the port mappings opened to the VPC endpoint service. Structure is
               documented below.
        :param pulumi.Input[str] server_type: - Specifies the backend resource type. The value can be **VM**, **VIP**
               or **LB**.
        :param pulumi.Input[str] vpc_id: - Specifies the ID of the VPC to which the backend resource of the VPC endpoint
               service belongs. Changing this creates a new VPC endpoint service.
        :param pulumi.Input[bool] approval: - Specifies whether connection approval is required. The default value is false.
        :param pulumi.Input[str] name: - Specifies the name of the VPC endpoint service. The value contains a maximum of 16
               characters, including letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: - Specifies the list of accounts to access the VPC endpoint service. The record is in
               the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        :param pulumi.Input[str] region: The region in which to create the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[str] service_type: The type of the VPC endpoint service. Only **interface** can be configured.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the VPC endpoint service.
        """
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "port_mappings", port_mappings)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if approval is not None:
            pulumi.set(__self__, "approval", approval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Input[str]:
        """
        - Specifies the ID for identifying the backend resource of the VPC endpoint
        service.
        + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
        + If the `server_type` is **VIP**, the value is the NIC ID of the physical server where virtual resources are
        created.
        + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
        balancer.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]:
        """
        - Specified the port mappings opened to the VPC endpoint service. Structure is
        documented below.
        """
        return pulumi.get(self, "port_mappings")

    @port_mappings.setter
    def port_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]):
        pulumi.set(self, "port_mappings", value)

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> pulumi.Input[str]:
        """
        - Specifies the backend resource type. The value can be **VM**, **VIP**
        or **LB**.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        - Specifies the ID of the VPC to which the backend resource of the VPC endpoint
        service belongs. Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def approval(self) -> Optional[pulumi.Input[bool]]:
        """
        - Specifies whether connection approval is required. The default value is false.
        """
        return pulumi.get(self, "approval")

    @approval.setter
    def approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "approval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the name of the VPC endpoint service. The value contains a maximum of 16
        characters, including letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - Specifies the list of accounts to access the VPC endpoint service. The record is in
        the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the VPC endpoint service. Only **interface** can be configured.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the VPC endpoint service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 approval: Optional[pulumi.Input[bool]] = None,
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[bool] approval: - Specifies whether connection approval is required. The default value is false.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceConnectionArgs']]] connections: An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        :param pulumi.Input[str] name: - Specifies the name of the VPC endpoint service. The value contains a maximum of 16
               characters, including letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: - Specifies the list of accounts to access the VPC endpoint service. The record is in
               the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        :param pulumi.Input[str] port_id: - Specifies the ID for identifying the backend resource of the VPC endpoint
               service.
               + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
               + If the `server_type` is **VIP**, the value is the NIC ID of the physical server where virtual resources are
               created.
               + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
               balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]] port_mappings: - Specified the port mappings opened to the VPC endpoint service. Structure is
               documented below.
        :param pulumi.Input[str] region: The region in which to create the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[str] server_type: - Specifies the backend resource type. The value can be **VM**, **VIP**
               or **LB**.
        :param pulumi.Input[str] service_name: The full name of the VPC endpoint service in the format: *region.name.id*.
        :param pulumi.Input[str] service_type: The type of the VPC endpoint service. Only **interface** can be configured.
        :param pulumi.Input[str] status: The connection status of the VPC endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the VPC endpoint service.
        :param pulumi.Input[str] vpc_id: - Specifies the ID of the VPC to which the backend resource of the VPC endpoint
               service belongs. Changing this creates a new VPC endpoint service.
        """
        if approval is not None:
            pulumi.set(__self__, "approval", approval)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if port_mappings is not None:
            pulumi.set(__self__, "port_mappings", port_mappings)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def approval(self) -> Optional[pulumi.Input[bool]]:
        """
        - Specifies whether connection approval is required. The default value is false.
        """
        return pulumi.get(self, "approval")

    @approval.setter
    def approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "approval", value)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionArgs']]]]:
        """
        An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionArgs']]]]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the name of the VPC endpoint service. The value contains a maximum of 16
        characters, including letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - Specifies the list of accounts to access the VPC endpoint service. The record is in
        the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the ID for identifying the backend resource of the VPC endpoint
        service.
        + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
        + If the `server_type` is **VIP**, the value is the NIC ID of the physical server where virtual resources are
        created.
        + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
        balancer.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]]:
        """
        - Specified the port mappings opened to the VPC endpoint service. Structure is
        documented below.
        """
        return pulumi.get(self, "port_mappings")

    @port_mappings.setter
    def port_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]]):
        pulumi.set(self, "port_mappings", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the backend resource type. The value can be **VM**, **VIP**
        or **LB**.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_type", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the VPC endpoint service in the format: *region.name.id*.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the VPC endpoint service. Only **interface** can be configured.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The connection status of the VPC endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the VPC endpoint service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the ID of the VPC to which the backend resource of the VPC endpoint
        service belongs. Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServicePortMappingArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage a VPC endpoint service resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vm_port = config.require_object("vmPort")
        demo = huaweicloud.vpcep.Service("demo",
            server_type="VM",
            vpc_id=vpc_id,
            port_id=vm_port,
            port_mappings=[huaweicloud.vpcep.ServicePortMappingArgs(
                service_port=8080,
                terminal_port=80,
            )])
        ```

        ## Import

        VPC endpoint services can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpcep/service:Service test_service 950cd3ba-9d0e-4451-97c1-3e97dd515d46
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] approval: - Specifies whether connection approval is required. The default value is false.
        :param pulumi.Input[str] name: - Specifies the name of the VPC endpoint service. The value contains a maximum of 16
               characters, including letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: - Specifies the list of accounts to access the VPC endpoint service. The record is in
               the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        :param pulumi.Input[str] port_id: - Specifies the ID for identifying the backend resource of the VPC endpoint
               service.
               + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
               + If the `server_type` is **VIP**, the value is the NIC ID of the physical server where virtual resources are
               created.
               + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
               balancer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServicePortMappingArgs']]]] port_mappings: - Specified the port mappings opened to the VPC endpoint service. Structure is
               documented below.
        :param pulumi.Input[str] region: The region in which to create the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[str] server_type: - Specifies the backend resource type. The value can be **VM**, **VIP**
               or **LB**.
        :param pulumi.Input[str] service_type: The type of the VPC endpoint service. Only **interface** can be configured.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the VPC endpoint service.
        :param pulumi.Input[str] vpc_id: - Specifies the ID of the VPC to which the backend resource of the VPC endpoint
               service belongs. Changing this creates a new VPC endpoint service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a VPC endpoint service resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vm_port = config.require_object("vmPort")
        demo = huaweicloud.vpcep.Service("demo",
            server_type="VM",
            vpc_id=vpc_id,
            port_id=vm_port,
            port_mappings=[huaweicloud.vpcep.ServicePortMappingArgs(
                service_port=8080,
                terminal_port=80,
            )])
        ```

        ## Import

        VPC endpoint services can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpcep/service:Service test_service 950cd3ba-9d0e-4451-97c1-3e97dd515d46
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServicePortMappingArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 server_type: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["approval"] = approval
            __props__.__dict__["name"] = name
            __props__.__dict__["permissions"] = permissions
            if port_id is None and not opts.urn:
                raise TypeError("Missing required property 'port_id'")
            __props__.__dict__["port_id"] = port_id
            if port_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'port_mappings'")
            __props__.__dict__["port_mappings"] = port_mappings
            __props__.__dict__["region"] = region
            if server_type is None and not opts.urn:
                raise TypeError("Missing required property 'server_type'")
            __props__.__dict__["server_type"] = server_type
            __props__.__dict__["service_type"] = service_type
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["connections"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["status"] = None
        super(Service, __self__).__init__(
            'huaweicloud:Vpcep/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval: Optional[pulumi.Input[bool]] = None,
            connections: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceConnectionArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            port_id: Optional[pulumi.Input[str]] = None,
            port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServicePortMappingArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            server_type: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] approval: - Specifies whether connection approval is required. The default value is false.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceConnectionArgs']]]] connections: An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        :param pulumi.Input[str] name: - Specifies the name of the VPC endpoint service. The value contains a maximum of 16
               characters, including letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: - Specifies the list of accounts to access the VPC endpoint service. The record is in
               the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        :param pulumi.Input[str] port_id: - Specifies the ID for identifying the backend resource of the VPC endpoint
               service.
               + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
               + If the `server_type` is **VIP**, the value is the NIC ID of the physical server where virtual resources are
               created.
               + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
               balancer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServicePortMappingArgs']]]] port_mappings: - Specified the port mappings opened to the VPC endpoint service. Structure is
               documented below.
        :param pulumi.Input[str] region: The region in which to create the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[str] server_type: - Specifies the backend resource type. The value can be **VM**, **VIP**
               or **LB**.
        :param pulumi.Input[str] service_name: The full name of the VPC endpoint service in the format: *region.name.id*.
        :param pulumi.Input[str] service_type: The type of the VPC endpoint service. Only **interface** can be configured.
        :param pulumi.Input[str] status: The connection status of the VPC endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the VPC endpoint service.
        :param pulumi.Input[str] vpc_id: - Specifies the ID of the VPC to which the backend resource of the VPC endpoint
               service belongs. Changing this creates a new VPC endpoint service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["approval"] = approval
        __props__.__dict__["connections"] = connections
        __props__.__dict__["name"] = name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["port_mappings"] = port_mappings
        __props__.__dict__["region"] = region
        __props__.__dict__["server_type"] = server_type
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def approval(self) -> pulumi.Output[bool]:
        """
        - Specifies whether connection approval is required. The default value is false.
        """
        return pulumi.get(self, "approval")

    @property
    @pulumi.getter
    def connections(self) -> pulumi.Output[Sequence['outputs.ServiceConnection']]:
        """
        An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        - Specifies the name of the VPC endpoint service. The value contains a maximum of 16
        characters, including letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        - Specifies the list of accounts to access the VPC endpoint service. The record is in
        the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[str]:
        """
        - Specifies the ID for identifying the backend resource of the VPC endpoint
        service.
        + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
        + If the `server_type` is **VIP**, the value is the NIC ID of the physical server where virtual resources are
        created.
        + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
        balancer.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> pulumi.Output[Sequence['outputs.ServicePortMapping']]:
        """
        - Specified the port mappings opened to the VPC endpoint service. Structure is
        documented below.
        """
        return pulumi.get(self, "port_mappings")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> pulumi.Output[str]:
        """
        - Specifies the backend resource type. The value can be **VM**, **VIP**
        or **LB**.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The full name of the VPC endpoint service in the format: *region.name.id*.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the VPC endpoint service. Only **interface** can be configured.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The connection status of the VPC endpoint.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the VPC endpoint service.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        - Specifies the ID of the VPC to which the backend resource of the VPC endpoint
        service belongs. Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "vpc_id")

