# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SubnetArgs', 'Subnet']

@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 gateway_ip: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dhcp_enable: Optional[pulumi.Input[bool]] = None,
                 dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_dns: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secondary_dns: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Subnet resource.
        :param pulumi.Input[str] cidr: - Specifies the network segment on which the subnet resides. The value must be in
               CIDR format and within the CIDR block of the VPC. The subnet mask cannot be greater than 28. Changing this creates a
               new Subnet.
        :param pulumi.Input[str] gateway_ip: - Specifies the gateway of the subnet. The value must be a valid IP address
               in the subnet segment. Changing this creates a new Subnet.
        :param pulumi.Input[str] vpc_id: - Specifies the ID of the VPC to which the subnet belongs. Changing this creates
               a new Subnet.
        :param pulumi.Input[str] availability_zone: - Specifies the availability zone (AZ) to which the subnet belongs.
               The value must be an existing AZ in the system. Changing this creates a new Subnet.
        :param pulumi.Input[str] description: Specifies supplementary information about the subnet. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[bool] dhcp_enable: - Specifies whether the DHCP function is enabled for the subnet. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_lists: - Specifies the DNS server address list of a subnet. This field is required if you need to
               use more than two DNS servers. This parameter value is the superset of both DNS server address 1 and DNS server
               address 2.
        :param pulumi.Input[bool] ipv6_enable: - Specifies whether the IPv6 function is enabled for the subnet. Defaults to false.
        :param pulumi.Input[str] name: - Specifies the subnet name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[str] primary_dns: - Specifies the IP address of DNS server 1 on the subnet. The value must be a valid
               IP address.
        :param pulumi.Input[str] region: Specifies tThe region in which to create the vpc subnet. If omitted, the
               provider-level region will be used. Changing this creates a new Subnet.
        :param pulumi.Input[str] secondary_dns: - Specifies the IP address of DNS server 2 on the subnet. The value must be a valid
               IP address.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the subnet.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dhcp_enable is not None:
            pulumi.set(__self__, "dhcp_enable", dhcp_enable)
        if dns_lists is not None:
            pulumi.set(__self__, "dns_lists", dns_lists)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_dns is not None:
            pulumi.set(__self__, "primary_dns", primary_dns)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_dns is not None:
            pulumi.set(__self__, "secondary_dns", secondary_dns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        """
        - Specifies the network segment on which the subnet resides. The value must be in
        CIDR format and within the CIDR block of the VPC. The subnet mask cannot be greater than 28. Changing this creates a
        new Subnet.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> pulumi.Input[str]:
        """
        - Specifies the gateway of the subnet. The value must be a valid IP address
        in the subnet segment. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @gateway_ip.setter
    def gateway_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_ip", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        - Specifies the ID of the VPC to which the subnet belongs. Changing this creates
        a new Subnet.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the availability zone (AZ) to which the subnet belongs.
        The value must be an existing AZ in the system. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies supplementary information about the subnet. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        - Specifies whether the DHCP function is enabled for the subnet. Defaults to true.
        """
        return pulumi.get(self, "dhcp_enable")

    @dhcp_enable.setter
    def dhcp_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_enable", value)

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - Specifies the DNS server address list of a subnet. This field is required if you need to
        use more than two DNS servers. This parameter value is the superset of both DNS server address 1 and DNS server
        address 2.
        """
        return pulumi.get(self, "dns_lists")

    @dns_lists.setter
    def dns_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_lists", value)

    @property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        - Specifies whether the IPv6 function is enabled for the subnet. Defaults to false.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the subnet name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the IP address of DNS server 1 on the subnet. The value must be a valid
        IP address.
        """
        return pulumi.get(self, "primary_dns")

    @primary_dns.setter
    def primary_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies tThe region in which to create the vpc subnet. If omitted, the
        provider-level region will be used. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the IP address of DNS server 2 on the subnet. The value must be a valid
        IP address.
        """
        return pulumi.get(self, "secondary_dns")

    @secondary_dns.setter
    def secondary_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the subnet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SubnetState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dhcp_enable: Optional[pulumi.Input[bool]] = None,
                 dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[str]] = None,
                 ipv6_cidr: Optional[pulumi.Input[str]] = None,
                 ipv6_enable: Optional[pulumi.Input[bool]] = None,
                 ipv6_gateway: Optional[pulumi.Input[str]] = None,
                 ipv6_subnet_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_dns: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secondary_dns: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Subnet resources.
        :param pulumi.Input[str] availability_zone: - Specifies the availability zone (AZ) to which the subnet belongs.
               The value must be an existing AZ in the system. Changing this creates a new Subnet.
        :param pulumi.Input[str] cidr: - Specifies the network segment on which the subnet resides. The value must be in
               CIDR format and within the CIDR block of the VPC. The subnet mask cannot be greater than 28. Changing this creates a
               new Subnet.
        :param pulumi.Input[str] description: Specifies supplementary information about the subnet. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[bool] dhcp_enable: - Specifies whether the DHCP function is enabled for the subnet. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_lists: - Specifies the DNS server address list of a subnet. This field is required if you need to
               use more than two DNS servers. This parameter value is the superset of both DNS server address 1 and DNS server
               address 2.
        :param pulumi.Input[str] gateway_ip: - Specifies the gateway of the subnet. The value must be a valid IP address
               in the subnet segment. Changing this creates a new Subnet.
        :param pulumi.Input[str] ipv4_subnet_id: The ID of the IPv4 subnet (Native OpenStack API).
        :param pulumi.Input[str] ipv6_cidr: The IPv6 subnet CIDR block.
        :param pulumi.Input[bool] ipv6_enable: - Specifies whether the IPv6 function is enabled for the subnet. Defaults to false.
        :param pulumi.Input[str] ipv6_gateway: The IPv6 subnet gateway.
        :param pulumi.Input[str] ipv6_subnet_id: The ID of the IPv6 subnet (Native OpenStack API).
        :param pulumi.Input[str] name: - Specifies the subnet name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[str] primary_dns: - Specifies the IP address of DNS server 1 on the subnet. The value must be a valid
               IP address.
        :param pulumi.Input[str] region: Specifies tThe region in which to create the vpc subnet. If omitted, the
               provider-level region will be used. Changing this creates a new Subnet.
        :param pulumi.Input[str] secondary_dns: - Specifies the IP address of DNS server 2 on the subnet. The value must be a valid
               IP address.
        :param pulumi.Input[str] subnet_id: schema: Deprecated
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the subnet.
        :param pulumi.Input[str] vpc_id: - Specifies the ID of the VPC to which the subnet belongs. Changing this creates
               a new Subnet.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dhcp_enable is not None:
            pulumi.set(__self__, "dhcp_enable", dhcp_enable)
        if dns_lists is not None:
            pulumi.set(__self__, "dns_lists", dns_lists)
        if gateway_ip is not None:
            pulumi.set(__self__, "gateway_ip", gateway_ip)
        if ipv4_subnet_id is not None:
            pulumi.set(__self__, "ipv4_subnet_id", ipv4_subnet_id)
        if ipv6_cidr is not None:
            pulumi.set(__self__, "ipv6_cidr", ipv6_cidr)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if ipv6_subnet_id is not None:
            pulumi.set(__self__, "ipv6_subnet_id", ipv6_subnet_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_dns is not None:
            pulumi.set(__self__, "primary_dns", primary_dns)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_dns is not None:
            pulumi.set(__self__, "secondary_dns", secondary_dns)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the availability zone (AZ) to which the subnet belongs.
        The value must be an existing AZ in the system. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the network segment on which the subnet resides. The value must be in
        CIDR format and within the CIDR block of the VPC. The subnet mask cannot be greater than 28. Changing this creates a
        new Subnet.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies supplementary information about the subnet. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        - Specifies whether the DHCP function is enabled for the subnet. Defaults to true.
        """
        return pulumi.get(self, "dhcp_enable")

    @dhcp_enable.setter
    def dhcp_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_enable", value)

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - Specifies the DNS server address list of a subnet. This field is required if you need to
        use more than two DNS servers. This parameter value is the superset of both DNS server address 1 and DNS server
        address 2.
        """
        return pulumi.get(self, "dns_lists")

    @dns_lists.setter
    def dns_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_lists", value)

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the gateway of the subnet. The value must be a valid IP address
        in the subnet segment. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @gateway_ip.setter
    def gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_ip", value)

    @property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IPv4 subnet (Native OpenStack API).
        """
        return pulumi.get(self, "ipv4_subnet_id")

    @ipv4_subnet_id.setter
    def ipv4_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_subnet_id", value)

    @property
    @pulumi.getter(name="ipv6Cidr")
    def ipv6_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 subnet CIDR block.
        """
        return pulumi.get(self, "ipv6_cidr")

    @ipv6_cidr.setter
    def ipv6_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr", value)

    @property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        - Specifies whether the IPv6 function is enabled for the subnet. Defaults to false.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 subnet gateway.
        """
        return pulumi.get(self, "ipv6_gateway")

    @ipv6_gateway.setter
    def ipv6_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_gateway", value)

    @property
    @pulumi.getter(name="ipv6SubnetId")
    def ipv6_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IPv6 subnet (Native OpenStack API).
        """
        return pulumi.get(self, "ipv6_subnet_id")

    @ipv6_subnet_id.setter
    def ipv6_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_subnet_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the subnet name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the IP address of DNS server 1 on the subnet. The value must be a valid
        IP address.
        """
        return pulumi.get(self, "primary_dns")

    @primary_dns.setter
    def primary_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies tThe region in which to create the vpc subnet. If omitted, the
        provider-level region will be used. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the IP address of DNS server 2 on the subnet. The value must be a valid
        IP address.
        """
        return pulumi.get(self, "secondary_dns")

    @secondary_dns.setter
    def secondary_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the subnet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the ID of the VPC to which the subnet belongs. Changing this creates
        a new Subnet.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Subnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dhcp_enable: Optional[pulumi.Input[bool]] = None,
                 dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 ipv6_enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_dns: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secondary_dns: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a VPC subnet resource within HuaweiCloud.

        ## Import

        Subnets can be imported using the subnet `Network ID`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/subnet:Subnet huaweicloud_vpc_subnet 4779ab1c-7c1a-44b1-a02e-93dfc361b32d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: - Specifies the availability zone (AZ) to which the subnet belongs.
               The value must be an existing AZ in the system. Changing this creates a new Subnet.
        :param pulumi.Input[str] cidr: - Specifies the network segment on which the subnet resides. The value must be in
               CIDR format and within the CIDR block of the VPC. The subnet mask cannot be greater than 28. Changing this creates a
               new Subnet.
        :param pulumi.Input[str] description: Specifies supplementary information about the subnet. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[bool] dhcp_enable: - Specifies whether the DHCP function is enabled for the subnet. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_lists: - Specifies the DNS server address list of a subnet. This field is required if you need to
               use more than two DNS servers. This parameter value is the superset of both DNS server address 1 and DNS server
               address 2.
        :param pulumi.Input[str] gateway_ip: - Specifies the gateway of the subnet. The value must be a valid IP address
               in the subnet segment. Changing this creates a new Subnet.
        :param pulumi.Input[bool] ipv6_enable: - Specifies whether the IPv6 function is enabled for the subnet. Defaults to false.
        :param pulumi.Input[str] name: - Specifies the subnet name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[str] primary_dns: - Specifies the IP address of DNS server 1 on the subnet. The value must be a valid
               IP address.
        :param pulumi.Input[str] region: Specifies tThe region in which to create the vpc subnet. If omitted, the
               provider-level region will be used. Changing this creates a new Subnet.
        :param pulumi.Input[str] secondary_dns: - Specifies the IP address of DNS server 2 on the subnet. The value must be a valid
               IP address.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the subnet.
        :param pulumi.Input[str] vpc_id: - Specifies the ID of the VPC to which the subnet belongs. Changing this creates
               a new Subnet.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC subnet resource within HuaweiCloud.

        ## Import

        Subnets can be imported using the subnet `Network ID`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/subnet:Subnet huaweicloud_vpc_subnet 4779ab1c-7c1a-44b1-a02e-93dfc361b32d
        ```

        :param str resource_name: The name of the resource.
        :param SubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dhcp_enable: Optional[pulumi.Input[bool]] = None,
                 dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 ipv6_enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_dns: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secondary_dns: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetArgs.__new__(SubnetArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["description"] = description
            __props__.__dict__["dhcp_enable"] = dhcp_enable
            __props__.__dict__["dns_lists"] = dns_lists
            if gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_ip'")
            __props__.__dict__["gateway_ip"] = gateway_ip
            __props__.__dict__["ipv6_enable"] = ipv6_enable
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_dns"] = primary_dns
            __props__.__dict__["region"] = region
            __props__.__dict__["secondary_dns"] = secondary_dns
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["ipv4_subnet_id"] = None
            __props__.__dict__["ipv6_cidr"] = None
            __props__.__dict__["ipv6_gateway"] = None
            __props__.__dict__["ipv6_subnet_id"] = None
            __props__.__dict__["subnet_id"] = None
        super(Subnet, __self__).__init__(
            'huaweicloud:Vpc/subnet:Subnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dhcp_enable: Optional[pulumi.Input[bool]] = None,
            dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            gateway_ip: Optional[pulumi.Input[str]] = None,
            ipv4_subnet_id: Optional[pulumi.Input[str]] = None,
            ipv6_cidr: Optional[pulumi.Input[str]] = None,
            ipv6_enable: Optional[pulumi.Input[bool]] = None,
            ipv6_gateway: Optional[pulumi.Input[str]] = None,
            ipv6_subnet_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            primary_dns: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            secondary_dns: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Subnet':
        """
        Get an existing Subnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: - Specifies the availability zone (AZ) to which the subnet belongs.
               The value must be an existing AZ in the system. Changing this creates a new Subnet.
        :param pulumi.Input[str] cidr: - Specifies the network segment on which the subnet resides. The value must be in
               CIDR format and within the CIDR block of the VPC. The subnet mask cannot be greater than 28. Changing this creates a
               new Subnet.
        :param pulumi.Input[str] description: Specifies supplementary information about the subnet. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[bool] dhcp_enable: - Specifies whether the DHCP function is enabled for the subnet. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_lists: - Specifies the DNS server address list of a subnet. This field is required if you need to
               use more than two DNS servers. This parameter value is the superset of both DNS server address 1 and DNS server
               address 2.
        :param pulumi.Input[str] gateway_ip: - Specifies the gateway of the subnet. The value must be a valid IP address
               in the subnet segment. Changing this creates a new Subnet.
        :param pulumi.Input[str] ipv4_subnet_id: The ID of the IPv4 subnet (Native OpenStack API).
        :param pulumi.Input[str] ipv6_cidr: The IPv6 subnet CIDR block.
        :param pulumi.Input[bool] ipv6_enable: - Specifies whether the IPv6 function is enabled for the subnet. Defaults to false.
        :param pulumi.Input[str] ipv6_gateway: The IPv6 subnet gateway.
        :param pulumi.Input[str] ipv6_subnet_id: The ID of the IPv6 subnet (Native OpenStack API).
        :param pulumi.Input[str] name: - Specifies the subnet name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[str] primary_dns: - Specifies the IP address of DNS server 1 on the subnet. The value must be a valid
               IP address.
        :param pulumi.Input[str] region: Specifies tThe region in which to create the vpc subnet. If omitted, the
               provider-level region will be used. Changing this creates a new Subnet.
        :param pulumi.Input[str] secondary_dns: - Specifies the IP address of DNS server 2 on the subnet. The value must be a valid
               IP address.
        :param pulumi.Input[str] subnet_id: schema: Deprecated
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the subnet.
        :param pulumi.Input[str] vpc_id: - Specifies the ID of the VPC to which the subnet belongs. Changing this creates
               a new Subnet.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetState.__new__(_SubnetState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["description"] = description
        __props__.__dict__["dhcp_enable"] = dhcp_enable
        __props__.__dict__["dns_lists"] = dns_lists
        __props__.__dict__["gateway_ip"] = gateway_ip
        __props__.__dict__["ipv4_subnet_id"] = ipv4_subnet_id
        __props__.__dict__["ipv6_cidr"] = ipv6_cidr
        __props__.__dict__["ipv6_enable"] = ipv6_enable
        __props__.__dict__["ipv6_gateway"] = ipv6_gateway
        __props__.__dict__["ipv6_subnet_id"] = ipv6_subnet_id
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_dns"] = primary_dns
        __props__.__dict__["region"] = region
        __props__.__dict__["secondary_dns"] = secondary_dns
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Subnet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        - Specifies the availability zone (AZ) to which the subnet belongs.
        The value must be an existing AZ in the system. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[str]:
        """
        - Specifies the network segment on which the subnet resides. The value must be in
        CIDR format and within the CIDR block of the VPC. The subnet mask cannot be greater than 28. Changing this creates a
        new Subnet.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies supplementary information about the subnet. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        - Specifies whether the DHCP function is enabled for the subnet. Defaults to true.
        """
        return pulumi.get(self, "dhcp_enable")

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        - Specifies the DNS server address list of a subnet. This field is required if you need to
        use more than two DNS servers. This parameter value is the superset of both DNS server address 1 and DNS server
        address 2.
        """
        return pulumi.get(self, "dns_lists")

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> pulumi.Output[str]:
        """
        - Specifies the gateway of the subnet. The value must be a valid IP address
        in the subnet segment. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> pulumi.Output[str]:
        """
        The ID of the IPv4 subnet (Native OpenStack API).
        """
        return pulumi.get(self, "ipv4_subnet_id")

    @property
    @pulumi.getter(name="ipv6Cidr")
    def ipv6_cidr(self) -> pulumi.Output[str]:
        """
        The IPv6 subnet CIDR block.
        """
        return pulumi.get(self, "ipv6_cidr")

    @property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        - Specifies whether the IPv6 function is enabled for the subnet. Defaults to false.
        """
        return pulumi.get(self, "ipv6_enable")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> pulumi.Output[str]:
        """
        The IPv6 subnet gateway.
        """
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="ipv6SubnetId")
    def ipv6_subnet_id(self) -> pulumi.Output[str]:
        """
        The ID of the IPv6 subnet (Native OpenStack API).
        """
        return pulumi.get(self, "ipv6_subnet_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        - Specifies the subnet name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> pulumi.Output[str]:
        """
        - Specifies the IP address of DNS server 1 on the subnet. The value must be a valid
        IP address.
        """
        return pulumi.get(self, "primary_dns")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies tThe region in which to create the vpc subnet. If omitted, the
        provider-level region will be used. Changing this creates a new Subnet.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> pulumi.Output[str]:
        """
        - Specifies the IP address of DNS server 2 on the subnet. The value must be a valid
        IP address.
        """
        return pulumi.get(self, "secondary_dns")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the subnet.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        - Specifies the ID of the VPC to which the subnet belongs. Changing this creates
        a new Subnet.
        """
        return pulumi.get(self, "vpc_id")

