# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetPeeringConnectionResult',
    'AwaitableGetPeeringConnectionResult',
    'get_peering_connection',
    'get_peering_connection_output',
]

@pulumi.output_type
class GetPeeringConnectionResult:
    """
    A collection of values returned by getPeeringConnection.
    """
    def __init__(__self__, id=None, name=None, peer_tenant_id=None, peer_vpc_id=None, region=None, status=None, vpc_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if peer_tenant_id and not isinstance(peer_tenant_id, str):
            raise TypeError("Expected argument 'peer_tenant_id' to be a str")
        pulumi.set(__self__, "peer_tenant_id", peer_tenant_id)
        if peer_vpc_id and not isinstance(peer_vpc_id, str):
            raise TypeError("Expected argument 'peer_vpc_id' to be a str")
        pulumi.set(__self__, "peer_vpc_id", peer_vpc_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerTenantId")
    def peer_tenant_id(self) -> str:
        return pulumi.get(self, "peer_tenant_id")

    @property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> str:
        return pulumi.get(self, "peer_vpc_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetPeeringConnectionResult(GetPeeringConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPeeringConnectionResult(
            id=self.id,
            name=self.name,
            peer_tenant_id=self.peer_tenant_id,
            peer_vpc_id=self.peer_vpc_id,
            region=self.region,
            status=self.status,
            vpc_id=self.vpc_id)


def get_peering_connection(id: Optional[str] = None,
                           name: Optional[str] = None,
                           peer_tenant_id: Optional[str] = None,
                           peer_vpc_id: Optional[str] = None,
                           region: Optional[str] = None,
                           status: Optional[str] = None,
                           vpc_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPeeringConnectionResult:
    """
    The VPC Peering Connection data source provides details about a specific VPC peering connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    vpc = huaweicloud.Vpc.get_vpc(name="vpc")
    peer_vpc = huaweicloud.Vpc.get_vpc(name="peer_vpc")
    peering = huaweicloud.Vpc.get_peering_connection(vpc_id=vpc.id,
        peer_vpc_id=peer_vpc.id)
    vpc_route = huaweicloud.vpc.Route("vpcRoute",
        type="peering",
        nexthop=peering.id,
        destination="192.168.0.0/16",
        vpc_id=vpc.id)
    ```


    :param str id: The ID of the specific VPC Peering Connection to retrieve.
    :param str name: The name of the specific VPC Peering Connection to retrieve.
    :param str peer_tenant_id: The Tenant ID of the accepter/peer VPC of the specific VPC Peering Connection to
           retrieve.
    :param str peer_vpc_id: The ID of the accepter/peer VPC of the specific VPC Peering Connection to retrieve.
    :param str region: The region in which to obtain the VPC Peering Connection. If omitted, the provider-level
           region will be used.
    :param str status: The status of the specific VPC Peering Connection to retrieve.
    :param str vpc_id: The ID of the requester VPC of the specific VPC Peering Connection to retrieve.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['peerTenantId'] = peer_tenant_id
    __args__['peerVpcId'] = peer_vpc_id
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Vpc/getPeeringConnection:getPeeringConnection', __args__, opts=opts, typ=GetPeeringConnectionResult).value

    return AwaitableGetPeeringConnectionResult(
        id=__ret__.id,
        name=__ret__.name,
        peer_tenant_id=__ret__.peer_tenant_id,
        peer_vpc_id=__ret__.peer_vpc_id,
        region=__ret__.region,
        status=__ret__.status,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_peering_connection)
def get_peering_connection_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                  peer_tenant_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  peer_vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  region: Optional[pulumi.Input[Optional[str]]] = None,
                                  status: Optional[pulumi.Input[Optional[str]]] = None,
                                  vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPeeringConnectionResult]:
    """
    The VPC Peering Connection data source provides details about a specific VPC peering connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    vpc = huaweicloud.Vpc.get_vpc(name="vpc")
    peer_vpc = huaweicloud.Vpc.get_vpc(name="peer_vpc")
    peering = huaweicloud.Vpc.get_peering_connection(vpc_id=vpc.id,
        peer_vpc_id=peer_vpc.id)
    vpc_route = huaweicloud.vpc.Route("vpcRoute",
        type="peering",
        nexthop=peering.id,
        destination="192.168.0.0/16",
        vpc_id=vpc.id)
    ```


    :param str id: The ID of the specific VPC Peering Connection to retrieve.
    :param str name: The name of the specific VPC Peering Connection to retrieve.
    :param str peer_tenant_id: The Tenant ID of the accepter/peer VPC of the specific VPC Peering Connection to
           retrieve.
    :param str peer_vpc_id: The ID of the accepter/peer VPC of the specific VPC Peering Connection to retrieve.
    :param str region: The region in which to obtain the VPC Peering Connection. If omitted, the provider-level
           region will be used.
    :param str status: The status of the specific VPC Peering Connection to retrieve.
    :param str vpc_id: The ID of the requester VPC of the specific VPC Peering Connection to retrieve.
    """
    ...
