# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MediaCategoryArgs', 'MediaCategory']

@pulumi.input_type
class MediaCategoryArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MediaCategory resource.
        :param pulumi.Input[str] name: Specifies the category name, which contains a maximum of 64 characters.
        :param pulumi.Input[str] parent_id: Specifies the parent category ID. If this parameter is left blank,
               the root category is generated by default. The root category ID is "0". Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the category name, which contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parent category ID. If this parameter is left blank,
        the root category is generated by default. The root category ID is "0". Changing this creates a new resource.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MediaCategoryState:
    def __init__(__self__, *,
                 children: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MediaCategory resources.
        :param pulumi.Input[str] children: The json string of subcategory information. It supports up to 3 levels of categories,
               and each catagory supports up to 128 subcategories.
        :param pulumi.Input[str] name: Specifies the category name, which contains a maximum of 64 characters.
        :param pulumi.Input[str] parent_id: Specifies the parent category ID. If this parameter is left blank,
               the root category is generated by default. The root category ID is "0". Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        if children is not None:
            pulumi.set(__self__, "children", children)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def children(self) -> Optional[pulumi.Input[str]]:
        """
        The json string of subcategory information. It supports up to 3 levels of categories,
        and each catagory supports up to 128 subcategories.
        """
        return pulumi.get(self, "children")

    @children.setter
    def children(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "children", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the category name, which contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parent category ID. If this parameter is left blank,
        the root category is generated by default. The root category ID is "0". Changing this creates a new resource.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class MediaCategory(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a VOD media category resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.vod.MediaCategory("test")
        ```

        ## Import

        The category can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vod/mediaCategory:MediaCategory test 132945
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`parent_id`. It is generally recommended running `terraform plan` after importing a media category. You can then decide if changes should be applied to the media category, or the resource definition should be updated to align with the media category. Also you can ignore changes as below. resource "huaweicloud_vod_media_category" "test" {

         ...

         lifecycle {

         ignore_changes = [

         parent_id,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Specifies the category name, which contains a maximum of 64 characters.
        :param pulumi.Input[str] parent_id: Specifies the parent category ID. If this parameter is left blank,
               the root category is generated by default. The root category ID is "0". Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MediaCategoryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VOD media category resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.vod.MediaCategory("test")
        ```

        ## Import

        The category can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vod/mediaCategory:MediaCategory test 132945
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`parent_id`. It is generally recommended running `terraform plan` after importing a media category. You can then decide if changes should be applied to the media category, or the resource definition should be updated to align with the media category. Also you can ignore changes as below. resource "huaweicloud_vod_media_category" "test" {

         ...

         lifecycle {

         ignore_changes = [

         parent_id,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param MediaCategoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MediaCategoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MediaCategoryArgs.__new__(MediaCategoryArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["region"] = region
            __props__.__dict__["children"] = None
        super(MediaCategory, __self__).__init__(
            'huaweicloud:Vod/mediaCategory:MediaCategory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            children: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'MediaCategory':
        """
        Get an existing MediaCategory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] children: The json string of subcategory information. It supports up to 3 levels of categories,
               and each catagory supports up to 128 subcategories.
        :param pulumi.Input[str] name: Specifies the category name, which contains a maximum of 64 characters.
        :param pulumi.Input[str] parent_id: Specifies the parent category ID. If this parameter is left blank,
               the root category is generated by default. The root category ID is "0". Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MediaCategoryState.__new__(_MediaCategoryState)

        __props__.__dict__["children"] = children
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["region"] = region
        return MediaCategory(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def children(self) -> pulumi.Output[str]:
        """
        The json string of subcategory information. It supports up to 3 levels of categories,
        and each catagory supports up to 128 subcategories.
        """
        return pulumi.get(self, "children")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the category name, which contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the parent category ID. If this parameter is left blank,
        the root category is generated by default. The root category ID is "0". Changing this creates a new resource.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

