# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RepositorySharingArgs', 'RepositorySharing']

@pulumi.input_type
class RepositorySharingArgs:
    def __init__(__self__, *,
                 deadline: pulumi.Input[str],
                 organization: pulumi.Input[str],
                 repository: pulumi.Input[str],
                 sharing_account: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RepositorySharing resource.
        :param pulumi.Input[str] deadline: Specifies the end date of image sharing (UTC time in YYYY-MM-DD format,
               for example `2021-10-01`). When the value is set to forever, the image will be permanently available for the domain.
               The validity period is calculated by day. The shared images expire at 00:00:00 on the day after the end date.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) the repository belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] repository: Specifies the name of the repository to be shared.
               Changing this creates a new resource.
        :param pulumi.Input[str] sharing_account: Specifies the name of the account for repository sharing.
               Changing this creates a new resource
               > **NOTE:** `sharing_account` should be an existing HuaweiCloud account.
        :param pulumi.Input[str] description: Specifies the description of the repository sharing.
        :param pulumi.Input[str] permission: Specifies the permission to be granted. Currently, only the **pull** permission is supported.
               Default value is **pull**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "deadline", deadline)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "sharing_account", sharing_account)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def deadline(self) -> pulumi.Input[str]:
        """
        Specifies the end date of image sharing (UTC time in YYYY-MM-DD format,
        for example `2021-10-01`). When the value is set to forever, the image will be permanently available for the domain.
        The validity period is calculated by day. The shared images expire at 00:00:00 on the day after the end date.
        """
        return pulumi.get(self, "deadline")

    @deadline.setter
    def deadline(self, value: pulumi.Input[str]):
        pulumi.set(self, "deadline", value)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[str]:
        """
        Specifies the name of the organization (namespace) the repository belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        Specifies the name of the repository to be shared.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="sharingAccount")
    def sharing_account(self) -> pulumi.Input[str]:
        """
        Specifies the name of the account for repository sharing.
        Changing this creates a new resource
        > **NOTE:** `sharing_account` should be an existing HuaweiCloud account.
        """
        return pulumi.get(self, "sharing_account")

    @sharing_account.setter
    def sharing_account(self, value: pulumi.Input[str]):
        pulumi.set(self, "sharing_account", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the repository sharing.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the permission to be granted. Currently, only the **pull** permission is supported.
        Default value is **pull**.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RepositorySharingState:
    def __init__(__self__, *,
                 deadline: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 sharing_account: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering RepositorySharing resources.
        :param pulumi.Input[str] deadline: Specifies the end date of image sharing (UTC time in YYYY-MM-DD format,
               for example `2021-10-01`). When the value is set to forever, the image will be permanently available for the domain.
               The validity period is calculated by day. The shared images expire at 00:00:00 on the day after the end date.
        :param pulumi.Input[str] description: Specifies the description of the repository sharing.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) the repository belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] permission: Specifies the permission to be granted. Currently, only the **pull** permission is supported.
               Default value is **pull**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] repository: Specifies the name of the repository to be shared.
               Changing this creates a new resource.
        :param pulumi.Input[str] sharing_account: Specifies the name of the account for repository sharing.
               Changing this creates a new resource
               > **NOTE:** `sharing_account` should be an existing HuaweiCloud account.
        :param pulumi.Input[bool] status: Indicates the repository sharing is valid (true) or expired (false).
        """
        if deadline is not None:
            pulumi.set(__self__, "deadline", deadline)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if sharing_account is not None:
            pulumi.set(__self__, "sharing_account", sharing_account)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def deadline(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the end date of image sharing (UTC time in YYYY-MM-DD format,
        for example `2021-10-01`). When the value is set to forever, the image will be permanently available for the domain.
        The validity period is calculated by day. The shared images expire at 00:00:00 on the day after the end date.
        """
        return pulumi.get(self, "deadline")

    @deadline.setter
    def deadline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deadline", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the repository sharing.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the organization (namespace) the repository belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the permission to be granted. Currently, only the **pull** permission is supported.
        Default value is **pull**.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the repository to be shared.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="sharingAccount")
    def sharing_account(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the account for repository sharing.
        Changing this creates a new resource
        > **NOTE:** `sharing_account` should be an existing HuaweiCloud account.
        """
        return pulumi.get(self, "sharing_account")

    @sharing_account.setter
    def sharing_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharing_account", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates the repository sharing is valid (true) or expired (false).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "status", value)


class RepositorySharing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deadline: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 sharing_account: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a SWR repository sharing resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        organization_name = config.require_object("organizationName")
        repository_name = config.require_object("repositoryName")
        sharing_account = config.require_object("sharingAccount")
        test = huaweicloud.swr.RepositorySharing("test",
            organization=organization_name,
            repository=repository_name,
            sharing_account=sharing_account,
            permission="pull",
            deadline="forever")
        ```

        ## Import

        Repository sharing can be imported using the organization name, repository name and sharing account separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Swr/repositorySharing:RepositorySharing test org-name/repo-name/sharing-account
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deadline: Specifies the end date of image sharing (UTC time in YYYY-MM-DD format,
               for example `2021-10-01`). When the value is set to forever, the image will be permanently available for the domain.
               The validity period is calculated by day. The shared images expire at 00:00:00 on the day after the end date.
        :param pulumi.Input[str] description: Specifies the description of the repository sharing.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) the repository belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] permission: Specifies the permission to be granted. Currently, only the **pull** permission is supported.
               Default value is **pull**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] repository: Specifies the name of the repository to be shared.
               Changing this creates a new resource.
        :param pulumi.Input[str] sharing_account: Specifies the name of the account for repository sharing.
               Changing this creates a new resource
               > **NOTE:** `sharing_account` should be an existing HuaweiCloud account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositorySharingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SWR repository sharing resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        organization_name = config.require_object("organizationName")
        repository_name = config.require_object("repositoryName")
        sharing_account = config.require_object("sharingAccount")
        test = huaweicloud.swr.RepositorySharing("test",
            organization=organization_name,
            repository=repository_name,
            sharing_account=sharing_account,
            permission="pull",
            deadline="forever")
        ```

        ## Import

        Repository sharing can be imported using the organization name, repository name and sharing account separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Swr/repositorySharing:RepositorySharing test org-name/repo-name/sharing-account
        ```

        :param str resource_name: The name of the resource.
        :param RepositorySharingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositorySharingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deadline: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 sharing_account: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositorySharingArgs.__new__(RepositorySharingArgs)

            if deadline is None and not opts.urn:
                raise TypeError("Missing required property 'deadline'")
            __props__.__dict__["deadline"] = deadline
            __props__.__dict__["description"] = description
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["permission"] = permission
            __props__.__dict__["region"] = region
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            if sharing_account is None and not opts.urn:
                raise TypeError("Missing required property 'sharing_account'")
            __props__.__dict__["sharing_account"] = sharing_account
            __props__.__dict__["status"] = None
        super(RepositorySharing, __self__).__init__(
            'huaweicloud:Swr/repositorySharing:RepositorySharing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deadline: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            permission: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            sharing_account: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[bool]] = None) -> 'RepositorySharing':
        """
        Get an existing RepositorySharing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deadline: Specifies the end date of image sharing (UTC time in YYYY-MM-DD format,
               for example `2021-10-01`). When the value is set to forever, the image will be permanently available for the domain.
               The validity period is calculated by day. The shared images expire at 00:00:00 on the day after the end date.
        :param pulumi.Input[str] description: Specifies the description of the repository sharing.
        :param pulumi.Input[str] organization: Specifies the name of the organization (namespace) the repository belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] permission: Specifies the permission to be granted. Currently, only the **pull** permission is supported.
               Default value is **pull**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] repository: Specifies the name of the repository to be shared.
               Changing this creates a new resource.
        :param pulumi.Input[str] sharing_account: Specifies the name of the account for repository sharing.
               Changing this creates a new resource
               > **NOTE:** `sharing_account` should be an existing HuaweiCloud account.
        :param pulumi.Input[bool] status: Indicates the repository sharing is valid (true) or expired (false).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositorySharingState.__new__(_RepositorySharingState)

        __props__.__dict__["deadline"] = deadline
        __props__.__dict__["description"] = description
        __props__.__dict__["organization"] = organization
        __props__.__dict__["permission"] = permission
        __props__.__dict__["region"] = region
        __props__.__dict__["repository"] = repository
        __props__.__dict__["sharing_account"] = sharing_account
        __props__.__dict__["status"] = status
        return RepositorySharing(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def deadline(self) -> pulumi.Output[str]:
        """
        Specifies the end date of image sharing (UTC time in YYYY-MM-DD format,
        for example `2021-10-01`). When the value is set to forever, the image will be permanently available for the domain.
        The validity period is calculated by day. The shared images expire at 00:00:00 on the day after the end date.
        """
        return pulumi.get(self, "deadline")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the repository sharing.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        Specifies the name of the organization (namespace) the repository belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the permission to be granted. Currently, only the **pull** permission is supported.
        Default value is **pull**.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        Specifies the name of the repository to be shared.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="sharingAccount")
    def sharing_account(self) -> pulumi.Output[str]:
        """
        Specifies the name of the account for repository sharing.
        Changing this creates a new resource
        > **NOTE:** `sharing_account` should be an existing HuaweiCloud account.
        """
        return pulumi.get(self, "sharing_account")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[bool]:
        """
        Indicates the repository sharing is valid (true) or expired (false).
        """
        return pulumi.get(self, "status")

