# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 backend_type: pulumi.Input[str],
                 example_success_response: pulumi.Input[str],
                 group_id: pulumi.Input[str],
                 request_method: pulumi.Input[str],
                 request_uri: pulumi.Input[str],
                 backend_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParameterArgs']]]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 example_failure_response: Optional[pulumi.Input[str]] = None,
                 function_backend: Optional[pulumi.Input['ApiFunctionBackendArgs']] = None,
                 http_backend: Optional[pulumi.Input['ApiHttpBackendArgs']] = None,
                 mock_backend: Optional[pulumi.Input['ApiMockBackendArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input[str] auth_type: Specifies the security authentication mode. The value can be 'APP', 'IAM', and '
               NONE'.
        :param pulumi.Input[str] backend_type: Specifies the service backend type. The value can be:
               + 'HTTP': the web service backend
               + 'FUNCTION': the FunctionGraph service backend
               + 'MOCK': the Mock service backend
        :param pulumi.Input[str] example_success_response: Specifies the example response for a successful request. The length
               cannot exceed 20,480 characters.
        :param pulumi.Input[str] group_id: Specifies the ID of the API group. Changing this creates a new resource.
        :param pulumi.Input[str] request_method: Specifies the request method, including 'GET','POST','PUT' and etc..
        :param pulumi.Input[str] request_uri: Specifies the request path of the API. The value must comply with URI
               specifications.
        :param pulumi.Input[Sequence[pulumi.Input['ApiBackendParameterArgs']]] backend_parameters: the backend parameter list (documented below).
        :param pulumi.Input[bool] cors: Specifies whether CORS is supported or not.
        :param pulumi.Input[str] description: Specifies the description of the API. The description cannot exceed 255 characters.
        :param pulumi.Input[str] example_failure_response: Specifies the example response for a failed request The length cannot
               exceed 20,480 characters.
        :param pulumi.Input['ApiFunctionBackendArgs'] function_backend: Specifies the configuration when backend_type selected 'FUNCTION' (documented
               below).
        :param pulumi.Input['ApiHttpBackendArgs'] http_backend: Specifies the configuration when backend_type selected 'HTTP' (documented below).
        :param pulumi.Input['ApiMockBackendArgs'] mock_backend: Specifies the configuration when backend_type selected 'MOCK' (documented below).
        :param pulumi.Input[str] name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the API resource. If omitted, the provider-level
               region will be used. Changing this creates a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]] request_parameters: the request parameter list (documented below).
        :param pulumi.Input[str] request_protocol: Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
               which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: the tags of API in format of string list.
        :param pulumi.Input[str] version: Specifies the version of the API. A maximum of 16 characters are allowed.
        :param pulumi.Input[int] visibility: Specifies whether the API is available to the public. The value can be 1 (public) and
               2 (private). Defaults to 2.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "backend_type", backend_type)
        pulumi.set(__self__, "example_success_response", example_success_response)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "request_method", request_method)
        pulumi.set(__self__, "request_uri", request_uri)
        if backend_parameters is not None:
            pulumi.set(__self__, "backend_parameters", backend_parameters)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if example_failure_response is not None:
            pulumi.set(__self__, "example_failure_response", example_failure_response)
        if function_backend is not None:
            pulumi.set(__self__, "function_backend", function_backend)
        if http_backend is not None:
            pulumi.set(__self__, "http_backend", http_backend)
        if mock_backend is not None:
            pulumi.set(__self__, "mock_backend", mock_backend)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Specifies the security authentication mode. The value can be 'APP', 'IAM', and '
        NONE'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> pulumi.Input[str]:
        """
        Specifies the service backend type. The value can be:
        + 'HTTP': the web service backend
        + 'FUNCTION': the FunctionGraph service backend
        + 'MOCK': the Mock service backend
        """
        return pulumi.get(self, "backend_type")

    @backend_type.setter
    def backend_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend_type", value)

    @property
    @pulumi.getter(name="exampleSuccessResponse")
    def example_success_response(self) -> pulumi.Input[str]:
        """
        Specifies the example response for a successful request. The length
        cannot exceed 20,480 characters.
        """
        return pulumi.get(self, "example_success_response")

    @example_success_response.setter
    def example_success_response(self, value: pulumi.Input[str]):
        pulumi.set(self, "example_success_response", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the API group. Changing this creates a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> pulumi.Input[str]:
        """
        Specifies the request method, including 'GET','POST','PUT' and etc..
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: pulumi.Input[str]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter(name="requestUri")
    def request_uri(self) -> pulumi.Input[str]:
        """
        Specifies the request path of the API. The value must comply with URI
        specifications.
        """
        return pulumi.get(self, "request_uri")

    @request_uri.setter
    def request_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "request_uri", value)

    @property
    @pulumi.getter(name="backendParameters")
    def backend_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParameterArgs']]]]:
        """
        the backend parameter list (documented below).
        """
        return pulumi.get(self, "backend_parameters")

    @backend_parameters.setter
    def backend_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParameterArgs']]]]):
        pulumi.set(self, "backend_parameters", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether CORS is supported or not.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the API. The description cannot exceed 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exampleFailureResponse")
    def example_failure_response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the example response for a failed request The length cannot
        exceed 20,480 characters.
        """
        return pulumi.get(self, "example_failure_response")

    @example_failure_response.setter
    def example_failure_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "example_failure_response", value)

    @property
    @pulumi.getter(name="functionBackend")
    def function_backend(self) -> Optional[pulumi.Input['ApiFunctionBackendArgs']]:
        """
        Specifies the configuration when backend_type selected 'FUNCTION' (documented
        below).
        """
        return pulumi.get(self, "function_backend")

    @function_backend.setter
    def function_backend(self, value: Optional[pulumi.Input['ApiFunctionBackendArgs']]):
        pulumi.set(self, "function_backend", value)

    @property
    @pulumi.getter(name="httpBackend")
    def http_backend(self) -> Optional[pulumi.Input['ApiHttpBackendArgs']]:
        """
        Specifies the configuration when backend_type selected 'HTTP' (documented below).
        """
        return pulumi.get(self, "http_backend")

    @http_backend.setter
    def http_backend(self, value: Optional[pulumi.Input['ApiHttpBackendArgs']]):
        pulumi.set(self, "http_backend", value)

    @property
    @pulumi.getter(name="mockBackend")
    def mock_backend(self) -> Optional[pulumi.Input['ApiMockBackendArgs']]:
        """
        Specifies the configuration when backend_type selected 'MOCK' (documented below).
        """
        return pulumi.get(self, "mock_backend")

    @mock_backend.setter
    def mock_backend(self, value: Optional[pulumi.Input['ApiMockBackendArgs']]):
        pulumi.set(self, "mock_backend", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the API resource. If omitted, the provider-level
        region will be used. Changing this creates a new API resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]]:
        """
        the request parameter list (documented below).
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]]):
        pulumi.set(self, "request_parameters", value)

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
        which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_protocol", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        the tags of API in format of string list.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the API. A maximum of 16 characters are allowed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether the API is available to the public. The value can be 1 (public) and
        2 (private). Defaults to 2.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "visibility", value)


@pulumi.input_type
class _ApiState:
    def __init__(__self__, *,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 backend_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParameterArgs']]]] = None,
                 backend_type: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 example_failure_response: Optional[pulumi.Input[str]] = None,
                 example_success_response: Optional[pulumi.Input[str]] = None,
                 function_backend: Optional[pulumi.Input['ApiFunctionBackendArgs']] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 http_backend: Optional[pulumi.Input['ApiHttpBackendArgs']] = None,
                 mock_backend: Optional[pulumi.Input['ApiMockBackendArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_method: Optional[pulumi.Input[str]] = None,
                 request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 request_uri: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Api resources.
        :param pulumi.Input[str] auth_type: Specifies the security authentication mode. The value can be 'APP', 'IAM', and '
               NONE'.
        :param pulumi.Input[Sequence[pulumi.Input['ApiBackendParameterArgs']]] backend_parameters: the backend parameter list (documented below).
        :param pulumi.Input[str] backend_type: Specifies the service backend type. The value can be:
               + 'HTTP': the web service backend
               + 'FUNCTION': the FunctionGraph service backend
               + 'MOCK': the Mock service backend
        :param pulumi.Input[bool] cors: Specifies whether CORS is supported or not.
        :param pulumi.Input[str] description: Specifies the description of the API. The description cannot exceed 255 characters.
        :param pulumi.Input[str] example_failure_response: Specifies the example response for a failed request The length cannot
               exceed 20,480 characters.
        :param pulumi.Input[str] example_success_response: Specifies the example response for a successful request. The length
               cannot exceed 20,480 characters.
        :param pulumi.Input['ApiFunctionBackendArgs'] function_backend: Specifies the configuration when backend_type selected 'FUNCTION' (documented
               below).
        :param pulumi.Input[str] group_id: Specifies the ID of the API group. Changing this creates a new resource.
        :param pulumi.Input[str] group_name: The name of the API group to which the API belongs.
        :param pulumi.Input['ApiHttpBackendArgs'] http_backend: Specifies the configuration when backend_type selected 'HTTP' (documented below).
        :param pulumi.Input['ApiMockBackendArgs'] mock_backend: Specifies the configuration when backend_type selected 'MOCK' (documented below).
        :param pulumi.Input[str] name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the API resource. If omitted, the provider-level
               region will be used. Changing this creates a new API resource.
        :param pulumi.Input[str] request_method: Specifies the request method, including 'GET','POST','PUT' and etc..
        :param pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]] request_parameters: the request parameter list (documented below).
        :param pulumi.Input[str] request_protocol: Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
               which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        :param pulumi.Input[str] request_uri: Specifies the request path of the API. The value must comply with URI
               specifications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: the tags of API in format of string list.
        :param pulumi.Input[str] version: Specifies the version of the API. A maximum of 16 characters are allowed.
        :param pulumi.Input[int] visibility: Specifies whether the API is available to the public. The value can be 1 (public) and
               2 (private). Defaults to 2.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if backend_parameters is not None:
            pulumi.set(__self__, "backend_parameters", backend_parameters)
        if backend_type is not None:
            pulumi.set(__self__, "backend_type", backend_type)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if example_failure_response is not None:
            pulumi.set(__self__, "example_failure_response", example_failure_response)
        if example_success_response is not None:
            pulumi.set(__self__, "example_success_response", example_success_response)
        if function_backend is not None:
            pulumi.set(__self__, "function_backend", function_backend)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if http_backend is not None:
            pulumi.set(__self__, "http_backend", http_backend)
        if mock_backend is not None:
            pulumi.set(__self__, "mock_backend", mock_backend)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if request_uri is not None:
            pulumi.set(__self__, "request_uri", request_uri)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security authentication mode. The value can be 'APP', 'IAM', and '
        NONE'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="backendParameters")
    def backend_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParameterArgs']]]]:
        """
        the backend parameter list (documented below).
        """
        return pulumi.get(self, "backend_parameters")

    @backend_parameters.setter
    def backend_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParameterArgs']]]]):
        pulumi.set(self, "backend_parameters", value)

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the service backend type. The value can be:
        + 'HTTP': the web service backend
        + 'FUNCTION': the FunctionGraph service backend
        + 'MOCK': the Mock service backend
        """
        return pulumi.get(self, "backend_type")

    @backend_type.setter
    def backend_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_type", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether CORS is supported or not.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the API. The description cannot exceed 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exampleFailureResponse")
    def example_failure_response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the example response for a failed request The length cannot
        exceed 20,480 characters.
        """
        return pulumi.get(self, "example_failure_response")

    @example_failure_response.setter
    def example_failure_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "example_failure_response", value)

    @property
    @pulumi.getter(name="exampleSuccessResponse")
    def example_success_response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the example response for a successful request. The length
        cannot exceed 20,480 characters.
        """
        return pulumi.get(self, "example_success_response")

    @example_success_response.setter
    def example_success_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "example_success_response", value)

    @property
    @pulumi.getter(name="functionBackend")
    def function_backend(self) -> Optional[pulumi.Input['ApiFunctionBackendArgs']]:
        """
        Specifies the configuration when backend_type selected 'FUNCTION' (documented
        below).
        """
        return pulumi.get(self, "function_backend")

    @function_backend.setter
    def function_backend(self, value: Optional[pulumi.Input['ApiFunctionBackendArgs']]):
        pulumi.set(self, "function_backend", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the API group. Changing this creates a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the API group to which the API belongs.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="httpBackend")
    def http_backend(self) -> Optional[pulumi.Input['ApiHttpBackendArgs']]:
        """
        Specifies the configuration when backend_type selected 'HTTP' (documented below).
        """
        return pulumi.get(self, "http_backend")

    @http_backend.setter
    def http_backend(self, value: Optional[pulumi.Input['ApiHttpBackendArgs']]):
        pulumi.set(self, "http_backend", value)

    @property
    @pulumi.getter(name="mockBackend")
    def mock_backend(self) -> Optional[pulumi.Input['ApiMockBackendArgs']]:
        """
        Specifies the configuration when backend_type selected 'MOCK' (documented below).
        """
        return pulumi.get(self, "mock_backend")

    @mock_backend.setter
    def mock_backend(self, value: Optional[pulumi.Input['ApiMockBackendArgs']]):
        pulumi.set(self, "mock_backend", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the API resource. If omitted, the provider-level
        region will be used. Changing this creates a new API resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request method, including 'GET','POST','PUT' and etc..
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]]:
        """
        the request parameter list (documented below).
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]]):
        pulumi.set(self, "request_parameters", value)

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
        which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_protocol", value)

    @property
    @pulumi.getter(name="requestUri")
    def request_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request path of the API. The value must comply with URI
        specifications.
        """
        return pulumi.get(self, "request_uri")

    @request_uri.setter
    def request_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_uri", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        the tags of API in format of string list.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the API. A maximum of 16 characters are allowed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether the API is available to the public. The value can be 1 (public) and
        2 (private). Defaults to 2.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "visibility", value)


class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 backend_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParameterArgs']]]]] = None,
                 backend_type: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 example_failure_response: Optional[pulumi.Input[str]] = None,
                 example_success_response: Optional[pulumi.Input[str]] = None,
                 function_backend: Optional[pulumi.Input[pulumi.InputType['ApiFunctionBackendArgs']]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 http_backend: Optional[pulumi.Input[pulumi.InputType['ApiHttpBackendArgs']]] = None,
                 mock_backend: Optional[pulumi.Input[pulumi.InputType['ApiMockBackendArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_method: Optional[pulumi.Input[str]] = None,
                 request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 request_uri: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides an API gateway API resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        tf_apigw_group = huaweicloud.shared_apig.Group("tfApigwGroup", description="your descpiption")
        tf_apigw_api = huaweicloud.shared_apig.Api("tfApigwApi",
            group_id=tf_apigw_group.id,
            description="your descpiption",
            tags=[
                "tag1",
                "tag2",
            ],
            visibility=2,
            auth_type="IAM",
            backend_type="HTTP",
            request_protocol="HTTPS",
            request_method="GET",
            request_uri="/test/path1",
            example_success_response="example response",
            http_backend=huaweicloud.shared_apig.ApiHttpBackendArgs(
                protocol="HTTPS",
                method="GET",
                uri="/web/openapi",
                url_domain="myhuaweicloud.com",
                timeout=10000,
            ))
        ```

        ## Import

        API can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:SharedApig/api:Api api "774438a28a574ac8a496325d1bf51807"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_type: Specifies the security authentication mode. The value can be 'APP', 'IAM', and '
               NONE'.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParameterArgs']]]] backend_parameters: the backend parameter list (documented below).
        :param pulumi.Input[str] backend_type: Specifies the service backend type. The value can be:
               + 'HTTP': the web service backend
               + 'FUNCTION': the FunctionGraph service backend
               + 'MOCK': the Mock service backend
        :param pulumi.Input[bool] cors: Specifies whether CORS is supported or not.
        :param pulumi.Input[str] description: Specifies the description of the API. The description cannot exceed 255 characters.
        :param pulumi.Input[str] example_failure_response: Specifies the example response for a failed request The length cannot
               exceed 20,480 characters.
        :param pulumi.Input[str] example_success_response: Specifies the example response for a successful request. The length
               cannot exceed 20,480 characters.
        :param pulumi.Input[pulumi.InputType['ApiFunctionBackendArgs']] function_backend: Specifies the configuration when backend_type selected 'FUNCTION' (documented
               below).
        :param pulumi.Input[str] group_id: Specifies the ID of the API group. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['ApiHttpBackendArgs']] http_backend: Specifies the configuration when backend_type selected 'HTTP' (documented below).
        :param pulumi.Input[pulumi.InputType['ApiMockBackendArgs']] mock_backend: Specifies the configuration when backend_type selected 'MOCK' (documented below).
        :param pulumi.Input[str] name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the API resource. If omitted, the provider-level
               region will be used. Changing this creates a new API resource.
        :param pulumi.Input[str] request_method: Specifies the request method, including 'GET','POST','PUT' and etc..
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]] request_parameters: the request parameter list (documented below).
        :param pulumi.Input[str] request_protocol: Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
               which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        :param pulumi.Input[str] request_uri: Specifies the request path of the API. The value must comply with URI
               specifications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: the tags of API in format of string list.
        :param pulumi.Input[str] version: Specifies the version of the API. A maximum of 16 characters are allowed.
        :param pulumi.Input[int] visibility: Specifies whether the API is available to the public. The value can be 1 (public) and
               2 (private). Defaults to 2.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an API gateway API resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        tf_apigw_group = huaweicloud.shared_apig.Group("tfApigwGroup", description="your descpiption")
        tf_apigw_api = huaweicloud.shared_apig.Api("tfApigwApi",
            group_id=tf_apigw_group.id,
            description="your descpiption",
            tags=[
                "tag1",
                "tag2",
            ],
            visibility=2,
            auth_type="IAM",
            backend_type="HTTP",
            request_protocol="HTTPS",
            request_method="GET",
            request_uri="/test/path1",
            example_success_response="example response",
            http_backend=huaweicloud.shared_apig.ApiHttpBackendArgs(
                protocol="HTTPS",
                method="GET",
                uri="/web/openapi",
                url_domain="myhuaweicloud.com",
                timeout=10000,
            ))
        ```

        ## Import

        API can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:SharedApig/api:Api api "774438a28a574ac8a496325d1bf51807"
        ```

        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 backend_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParameterArgs']]]]] = None,
                 backend_type: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 example_failure_response: Optional[pulumi.Input[str]] = None,
                 example_success_response: Optional[pulumi.Input[str]] = None,
                 function_backend: Optional[pulumi.Input[pulumi.InputType['ApiFunctionBackendArgs']]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 http_backend: Optional[pulumi.Input[pulumi.InputType['ApiHttpBackendArgs']]] = None,
                 mock_backend: Optional[pulumi.Input[pulumi.InputType['ApiMockBackendArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_method: Optional[pulumi.Input[str]] = None,
                 request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 request_uri: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            if auth_type is None and not opts.urn:
                raise TypeError("Missing required property 'auth_type'")
            __props__.__dict__["auth_type"] = auth_type
            __props__.__dict__["backend_parameters"] = backend_parameters
            if backend_type is None and not opts.urn:
                raise TypeError("Missing required property 'backend_type'")
            __props__.__dict__["backend_type"] = backend_type
            __props__.__dict__["cors"] = cors
            __props__.__dict__["description"] = description
            __props__.__dict__["example_failure_response"] = example_failure_response
            if example_success_response is None and not opts.urn:
                raise TypeError("Missing required property 'example_success_response'")
            __props__.__dict__["example_success_response"] = example_success_response
            __props__.__dict__["function_backend"] = function_backend
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["http_backend"] = http_backend
            __props__.__dict__["mock_backend"] = mock_backend
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if request_method is None and not opts.urn:
                raise TypeError("Missing required property 'request_method'")
            __props__.__dict__["request_method"] = request_method
            __props__.__dict__["request_parameters"] = request_parameters
            __props__.__dict__["request_protocol"] = request_protocol
            if request_uri is None and not opts.urn:
                raise TypeError("Missing required property 'request_uri'")
            __props__.__dict__["request_uri"] = request_uri
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["group_name"] = None
        super(Api, __self__).__init__(
            'huaweicloud:SharedApig/api:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_type: Optional[pulumi.Input[str]] = None,
            backend_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParameterArgs']]]]] = None,
            backend_type: Optional[pulumi.Input[str]] = None,
            cors: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            example_failure_response: Optional[pulumi.Input[str]] = None,
            example_success_response: Optional[pulumi.Input[str]] = None,
            function_backend: Optional[pulumi.Input[pulumi.InputType['ApiFunctionBackendArgs']]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            http_backend: Optional[pulumi.Input[pulumi.InputType['ApiHttpBackendArgs']]] = None,
            mock_backend: Optional[pulumi.Input[pulumi.InputType['ApiMockBackendArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            request_method: Optional[pulumi.Input[str]] = None,
            request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]]] = None,
            request_protocol: Optional[pulumi.Input[str]] = None,
            request_uri: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            version: Optional[pulumi.Input[str]] = None,
            visibility: Optional[pulumi.Input[int]] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_type: Specifies the security authentication mode. The value can be 'APP', 'IAM', and '
               NONE'.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParameterArgs']]]] backend_parameters: the backend parameter list (documented below).
        :param pulumi.Input[str] backend_type: Specifies the service backend type. The value can be:
               + 'HTTP': the web service backend
               + 'FUNCTION': the FunctionGraph service backend
               + 'MOCK': the Mock service backend
        :param pulumi.Input[bool] cors: Specifies whether CORS is supported or not.
        :param pulumi.Input[str] description: Specifies the description of the API. The description cannot exceed 255 characters.
        :param pulumi.Input[str] example_failure_response: Specifies the example response for a failed request The length cannot
               exceed 20,480 characters.
        :param pulumi.Input[str] example_success_response: Specifies the example response for a successful request. The length
               cannot exceed 20,480 characters.
        :param pulumi.Input[pulumi.InputType['ApiFunctionBackendArgs']] function_backend: Specifies the configuration when backend_type selected 'FUNCTION' (documented
               below).
        :param pulumi.Input[str] group_id: Specifies the ID of the API group. Changing this creates a new resource.
        :param pulumi.Input[str] group_name: The name of the API group to which the API belongs.
        :param pulumi.Input[pulumi.InputType['ApiHttpBackendArgs']] http_backend: Specifies the configuration when backend_type selected 'HTTP' (documented below).
        :param pulumi.Input[pulumi.InputType['ApiMockBackendArgs']] mock_backend: Specifies the configuration when backend_type selected 'MOCK' (documented below).
        :param pulumi.Input[str] name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the API resource. If omitted, the provider-level
               region will be used. Changing this creates a new API resource.
        :param pulumi.Input[str] request_method: Specifies the request method, including 'GET','POST','PUT' and etc..
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]] request_parameters: the request parameter list (documented below).
        :param pulumi.Input[str] request_protocol: Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
               which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        :param pulumi.Input[str] request_uri: Specifies the request path of the API. The value must comply with URI
               specifications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: the tags of API in format of string list.
        :param pulumi.Input[str] version: Specifies the version of the API. A maximum of 16 characters are allowed.
        :param pulumi.Input[int] visibility: Specifies whether the API is available to the public. The value can be 1 (public) and
               2 (private). Defaults to 2.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiState.__new__(_ApiState)

        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["backend_parameters"] = backend_parameters
        __props__.__dict__["backend_type"] = backend_type
        __props__.__dict__["cors"] = cors
        __props__.__dict__["description"] = description
        __props__.__dict__["example_failure_response"] = example_failure_response
        __props__.__dict__["example_success_response"] = example_success_response
        __props__.__dict__["function_backend"] = function_backend
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["http_backend"] = http_backend
        __props__.__dict__["mock_backend"] = mock_backend
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["request_method"] = request_method
        __props__.__dict__["request_parameters"] = request_parameters
        __props__.__dict__["request_protocol"] = request_protocol
        __props__.__dict__["request_uri"] = request_uri
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        __props__.__dict__["visibility"] = visibility
        return Api(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[str]:
        """
        Specifies the security authentication mode. The value can be 'APP', 'IAM', and '
        NONE'.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="backendParameters")
    def backend_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ApiBackendParameter']]]:
        """
        the backend parameter list (documented below).
        """
        return pulumi.get(self, "backend_parameters")

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> pulumi.Output[str]:
        """
        Specifies the service backend type. The value can be:
        + 'HTTP': the web service backend
        + 'FUNCTION': the FunctionGraph service backend
        + 'MOCK': the Mock service backend
        """
        return pulumi.get(self, "backend_type")

    @property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether CORS is supported or not.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the API. The description cannot exceed 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="exampleFailureResponse")
    def example_failure_response(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the example response for a failed request The length cannot
        exceed 20,480 characters.
        """
        return pulumi.get(self, "example_failure_response")

    @property
    @pulumi.getter(name="exampleSuccessResponse")
    def example_success_response(self) -> pulumi.Output[str]:
        """
        Specifies the example response for a successful request. The length
        cannot exceed 20,480 characters.
        """
        return pulumi.get(self, "example_success_response")

    @property
    @pulumi.getter(name="functionBackend")
    def function_backend(self) -> pulumi.Output[Optional['outputs.ApiFunctionBackend']]:
        """
        Specifies the configuration when backend_type selected 'FUNCTION' (documented
        below).
        """
        return pulumi.get(self, "function_backend")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the API group. Changing this creates a new resource.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        The name of the API group to which the API belongs.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="httpBackend")
    def http_backend(self) -> pulumi.Output[Optional['outputs.ApiHttpBackend']]:
        """
        Specifies the configuration when backend_type selected 'HTTP' (documented below).
        """
        return pulumi.get(self, "http_backend")

    @property
    @pulumi.getter(name="mockBackend")
    def mock_backend(self) -> pulumi.Output[Optional['outputs.ApiMockBackend']]:
        """
        Specifies the configuration when backend_type selected 'MOCK' (documented below).
        """
        return pulumi.get(self, "mock_backend")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the API resource. If omitted, the provider-level
        region will be used. Changing this creates a new API resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> pulumi.Output[str]:
        """
        Specifies the request method, including 'GET','POST','PUT' and etc..
        """
        return pulumi.get(self, "request_method")

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ApiRequestParameter']]]:
        """
        the request parameter list (documented below).
        """
        return pulumi.get(self, "request_parameters")

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
        which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        """
        return pulumi.get(self, "request_protocol")

    @property
    @pulumi.getter(name="requestUri")
    def request_uri(self) -> pulumi.Output[str]:
        """
        Specifies the request path of the API. The value must comply with URI
        specifications.
        """
        return pulumi.get(self, "request_uri")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        the tags of API in format of string list.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Specifies the version of the API. A maximum of 16 characters are allowed.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies whether the API is available to the public. The value can be 1 (public) and
        2 (private). Defaults to 2.
        """
        return pulumi.get(self, "visibility")

