# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AccessRuleArgs', 'AccessRule']

@pulumi.input_type
class AccessRuleArgs:
    def __init__(__self__, *,
                 access_to: pulumi.Input[str],
                 sfs_id: pulumi.Input[str],
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AccessRule resource.
        :param pulumi.Input[str] access_to: Specifies the value that defines the access rule. The value contains 1 to
               255 characters. Changing this will create a new access rule. The value varies according to the scenario:
               + Set the VPC ID in VPC authorization scenarios.
               + Set this parameter in IP address authorization scenario:
               - For an NFS shared file system, the value in the format of  *VPC_ID#IP_address#priority#user_permission*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
        :param pulumi.Input[str] sfs_id: Specifies the UUID of the shared file system. Changing this will create a new
               access rule.
        :param pulumi.Input[str] access_level: Specifies the access level of the shared file system. Possible values
               are *ro* (read-only)
               and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        :param pulumi.Input[str] access_type: Specifies the type of the share access rule. The default value is *cert*.
               Changing this will create a new access rule.
        :param pulumi.Input[str] region: The region in which to create the sfs access rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new access rule resource.
        """
        pulumi.set(__self__, "access_to", access_to)
        pulumi.set(__self__, "sfs_id", sfs_id)
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> pulumi.Input[str]:
        """
        Specifies the value that defines the access rule. The value contains 1 to
        255 characters. Changing this will create a new access rule. The value varies according to the scenario:
        + Set the VPC ID in VPC authorization scenarios.
        + Set this parameter in IP address authorization scenario:
        - For an NFS shared file system, the value in the format of  *VPC_ID#IP_address#priority#user_permission*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
        """
        return pulumi.get(self, "access_to")

    @access_to.setter
    def access_to(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_to", value)

    @property
    @pulumi.getter(name="sfsId")
    def sfs_id(self) -> pulumi.Input[str]:
        """
        Specifies the UUID of the shared file system. Changing this will create a new
        access rule.
        """
        return pulumi.get(self, "sfs_id")

    @sfs_id.setter
    def sfs_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sfs_id", value)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the access level of the shared file system. Possible values
        are *ro* (read-only)
        and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the share access rule. The default value is *cert*.
        Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the sfs access rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new access rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AccessRuleState:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_to: Optional[pulumi.Input[str]] = None,
                 access_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sfs_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccessRule resources.
        :param pulumi.Input[str] access_level: Specifies the access level of the shared file system. Possible values
               are *ro* (read-only)
               and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        :param pulumi.Input[str] access_to: Specifies the value that defines the access rule. The value contains 1 to
               255 characters. Changing this will create a new access rule. The value varies according to the scenario:
               + Set the VPC ID in VPC authorization scenarios.
               + Set this parameter in IP address authorization scenario:
               - For an NFS shared file system, the value in the format of  *VPC_ID#IP_address#priority#user_permission*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
        :param pulumi.Input[str] access_type: Specifies the type of the share access rule. The default value is *cert*.
               Changing this will create a new access rule.
        :param pulumi.Input[str] region: The region in which to create the sfs access rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new access rule resource.
        :param pulumi.Input[str] sfs_id: Specifies the UUID of the shared file system. Changing this will create a new
               access rule.
        :param pulumi.Input[str] status: The status of the share access rule.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_to is not None:
            pulumi.set(__self__, "access_to", access_to)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sfs_id is not None:
            pulumi.set(__self__, "sfs_id", sfs_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the access level of the shared file system. Possible values
        are *ro* (read-only)
        and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the value that defines the access rule. The value contains 1 to
        255 characters. Changing this will create a new access rule. The value varies according to the scenario:
        + Set the VPC ID in VPC authorization scenarios.
        + Set this parameter in IP address authorization scenario:
        - For an NFS shared file system, the value in the format of  *VPC_ID#IP_address#priority#user_permission*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
        """
        return pulumi.get(self, "access_to")

    @access_to.setter
    def access_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_to", value)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the share access rule. The default value is *cert*.
        Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the sfs access rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new access rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sfsId")
    def sfs_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the UUID of the shared file system. Changing this will create a new
        access rule.
        """
        return pulumi.get(self, "sfs_id")

    @sfs_id.setter
    def sfs_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sfs_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the share access rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class AccessRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_to: Optional[pulumi.Input[str]] = None,
                 access_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sfs_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an access rule resource of Scalable File Resource (SFS).

        ## Example Usage
        ### Usage in VPC authorization scenarios

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        share_name = config.require_object("shareName")
        vpc_id = config.require_object("vpcId")
        share_file = huaweicloud.sfs.FileSystem("share-file",
            size=100,
            share_proto="NFS")
        rule1 = huaweicloud.sfs.AccessRule("rule1",
            sfs_id=share_file.id,
            access_to=vpc_id)
        ```

        ## Import

        SFS access rule can be imported by specifying the SFS ID and access rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Sfs/accessRule:AccessRule huaweicloud_sfs_access_rule <sfs_id>/<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_level: Specifies the access level of the shared file system. Possible values
               are *ro* (read-only)
               and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        :param pulumi.Input[str] access_to: Specifies the value that defines the access rule. The value contains 1 to
               255 characters. Changing this will create a new access rule. The value varies according to the scenario:
               + Set the VPC ID in VPC authorization scenarios.
               + Set this parameter in IP address authorization scenario:
               - For an NFS shared file system, the value in the format of  *VPC_ID#IP_address#priority#user_permission*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
        :param pulumi.Input[str] access_type: Specifies the type of the share access rule. The default value is *cert*.
               Changing this will create a new access rule.
        :param pulumi.Input[str] region: The region in which to create the sfs access rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new access rule resource.
        :param pulumi.Input[str] sfs_id: Specifies the UUID of the shared file system. Changing this will create a new
               access rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an access rule resource of Scalable File Resource (SFS).

        ## Example Usage
        ### Usage in VPC authorization scenarios

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        share_name = config.require_object("shareName")
        vpc_id = config.require_object("vpcId")
        share_file = huaweicloud.sfs.FileSystem("share-file",
            size=100,
            share_proto="NFS")
        rule1 = huaweicloud.sfs.AccessRule("rule1",
            sfs_id=share_file.id,
            access_to=vpc_id)
        ```

        ## Import

        SFS access rule can be imported by specifying the SFS ID and access rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Sfs/accessRule:AccessRule huaweicloud_sfs_access_rule <sfs_id>/<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param AccessRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_to: Optional[pulumi.Input[str]] = None,
                 access_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sfs_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessRuleArgs.__new__(AccessRuleArgs)

            __props__.__dict__["access_level"] = access_level
            if access_to is None and not opts.urn:
                raise TypeError("Missing required property 'access_to'")
            __props__.__dict__["access_to"] = access_to
            __props__.__dict__["access_type"] = access_type
            __props__.__dict__["region"] = region
            if sfs_id is None and not opts.urn:
                raise TypeError("Missing required property 'sfs_id'")
            __props__.__dict__["sfs_id"] = sfs_id
            __props__.__dict__["status"] = None
        super(AccessRule, __self__).__init__(
            'huaweicloud:Sfs/accessRule:AccessRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_level: Optional[pulumi.Input[str]] = None,
            access_to: Optional[pulumi.Input[str]] = None,
            access_type: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            sfs_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'AccessRule':
        """
        Get an existing AccessRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_level: Specifies the access level of the shared file system. Possible values
               are *ro* (read-only)
               and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        :param pulumi.Input[str] access_to: Specifies the value that defines the access rule. The value contains 1 to
               255 characters. Changing this will create a new access rule. The value varies according to the scenario:
               + Set the VPC ID in VPC authorization scenarios.
               + Set this parameter in IP address authorization scenario:
               - For an NFS shared file system, the value in the format of  *VPC_ID#IP_address#priority#user_permission*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
        :param pulumi.Input[str] access_type: Specifies the type of the share access rule. The default value is *cert*.
               Changing this will create a new access rule.
        :param pulumi.Input[str] region: The region in which to create the sfs access rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new access rule resource.
        :param pulumi.Input[str] sfs_id: Specifies the UUID of the shared file system. Changing this will create a new
               access rule.
        :param pulumi.Input[str] status: The status of the share access rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessRuleState.__new__(_AccessRuleState)

        __props__.__dict__["access_level"] = access_level
        __props__.__dict__["access_to"] = access_to
        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["region"] = region
        __props__.__dict__["sfs_id"] = sfs_id
        __props__.__dict__["status"] = status
        return AccessRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the access level of the shared file system. Possible values
        are *ro* (read-only)
        and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> pulumi.Output[str]:
        """
        Specifies the value that defines the access rule. The value contains 1 to
        255 characters. Changing this will create a new access rule. The value varies according to the scenario:
        + Set the VPC ID in VPC authorization scenarios.
        + Set this parameter in IP address authorization scenario:
        - For an NFS shared file system, the value in the format of  *VPC_ID#IP_address#priority#user_permission*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
        """
        return pulumi.get(self, "access_to")

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the share access rule. The default value is *cert*.
        Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the sfs access rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new access rule resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sfsId")
    def sfs_id(self) -> pulumi.Output[str]:
        """
        Specifies the UUID of the shared file system. Changing this will create a new
        access rule.
        """
        return pulumi.get(self, "sfs_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the share access rule.
        """
        return pulumi.get(self, "status")

