# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationEnvironment',
    'ApplicationEnvironmentVariable',
    'ComponentBuilder',
    'ComponentInstanceArtifact',
    'ComponentInstanceArtifactProperties',
    'ComponentInstanceConfiguration',
    'ComponentInstanceConfigurationEnvVariable',
    'ComponentInstanceConfigurationLifecycle',
    'ComponentInstanceConfigurationLifecycleEntrypoint',
    'ComponentInstanceConfigurationLifecyclePostStart',
    'ComponentInstanceConfigurationLifecyclePostStartParameters',
    'ComponentInstanceConfigurationLifecyclePreStop',
    'ComponentInstanceConfigurationLifecyclePreStopParameters',
    'ComponentInstanceConfigurationLogCollectionPolicy',
    'ComponentInstanceConfigurationLogCollectionPolicyContainerMounting',
    'ComponentInstanceConfigurationProbe',
    'ComponentInstanceConfigurationProbeLiveness',
    'ComponentInstanceConfigurationProbeLivenessCommandParam',
    'ComponentInstanceConfigurationProbeLivenessHttpParam',
    'ComponentInstanceConfigurationProbeLivenessTcpParam',
    'ComponentInstanceConfigurationProbeReadiness',
    'ComponentInstanceConfigurationProbeReadinessCommandParam',
    'ComponentInstanceConfigurationProbeReadinessHttpParam',
    'ComponentInstanceConfigurationProbeReadinessTcpParam',
    'ComponentInstanceConfigurationScheduler',
    'ComponentInstanceConfigurationSchedulerAffinity',
    'ComponentInstanceConfigurationSchedulerAntiAffinity',
    'ComponentInstanceConfigurationStorage',
    'ComponentInstanceConfigurationStorageMount',
    'ComponentInstanceConfigurationStorageParameter',
    'ComponentInstanceConfigurationStrategy',
    'ComponentInstanceExternalAccess',
    'ComponentInstanceReferResource',
    'ComponentSource',
    'EnvironmentBasicResource',
    'EnvironmentOptionalResource',
    'GetComponentRuntimesRuntimeResult',
]

@pulumi.output_type
class ApplicationEnvironment(dict):
    def __init__(__self__, *,
                 id: str,
                 variables: Sequence['outputs.ApplicationEnvironmentVariable']):
        """
        :param str id: Specifies the environment ID to which the variables belongs.
        :param Sequence['ApplicationEnvironmentVariableArgs'] variables: Specifies the list of environment variables.
               The object structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the environment ID to which the variables belongs.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.ApplicationEnvironmentVariable']:
        """
        Specifies the list of environment variables.
        The object structure is documented below.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class ApplicationEnvironmentVariable(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Specifies the variable name. The name can contain `1` to `64` characters, only letters,
               digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        :param str value: Specifies the variable value. The value can contian a maximum of `2,048` characters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the variable name. The name can contain `1` to `64` characters, only letters,
        digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the variable value. The value can contian a maximum of `2,048` characters.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ComponentBuilder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "nodeLabel":
            suggest = "node_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentBuilder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentBuilder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentBuilder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: str,
                 organization: str,
                 cmd: Optional[str] = None,
                 node_label: Optional[Mapping[str, str]] = None):
        """
        :param str cluster_id: Specifies the cluster ID.
        :param str organization: Specifies the organization name.
               The organization is usually **domain name**. You can find out in the organization management of SWR.
        :param str cmd: Specifies the build command. If omitted, the default command will be used.
               + About the  default command or script: build.sh in the root directory will be preferentially executed.
               If build.sh does not exist, the code will be compiled using the common method of the selected language,
               for example, mvn clean package for Java.
               + About the custom command: Commands will be customized using the selected language.
               Alternatively, the default command or script will be used after build.sh is modified.
        :param Mapping[str, str] node_label: Specifies the filter labels for CCE nodes.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "organization", organization)
        if cmd is not None:
            pulumi.set(__self__, "cmd", cmd)
        if node_label is not None:
            pulumi.set(__self__, "node_label", node_label)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        Specifies the cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        Specifies the organization name.
        The organization is usually **domain name**. You can find out in the organization management of SWR.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def cmd(self) -> Optional[str]:
        """
        Specifies the build command. If omitted, the default command will be used.
        + About the  default command or script: build.sh in the root directory will be preferentially executed.
        If build.sh does not exist, the code will be compiled using the common method of the selected language,
        for example, mvn clean package for Java.
        + About the custom command: Commands will be customized using the selected language.
        Alternatively, the default command or script will be used after build.sh is modified.
        """
        return pulumi.get(self, "cmd")

    @property
    @pulumi.getter(name="nodeLabel")
    def node_label(self) -> Optional[Mapping[str, str]]:
        """
        Specifies the filter labels for CCE nodes.
        """
        return pulumi.get(self, "node_label")


@pulumi.output_type
class ComponentInstanceArtifact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceArtifact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceArtifact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceArtifact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 storage: str,
                 type: str,
                 url: str,
                 auth_type: Optional[str] = None,
                 properties: Optional['outputs.ComponentInstanceArtifactProperties'] = None,
                 version: Optional[str] = None):
        """
        :param str name: Specifies the name of a configuration item or secret.
        :param str storage: Specifies the data storage configuration.
               The object structure is documented below.
        :param str type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        :param str url: Specifies the software package or image address.
               For a component deployed on a VM, this parameter is the software package address.
               For a component deployed based on a container, this parameter is the image address or component name:v${index}.
               The latter indicates that the component source code or the image automatically built using the software package
               will be used.
        :param str auth_type: Specifies the authentication mode.
               The valid values are **iam** and **none**. Defaults to **iam**.
        :param 'ComponentInstanceArtifactPropertiesArgs' properties: Specifies the properties of the OBS object.
               This parameter is available only `storage` is **obs**.
               The object structure is documented below.
        :param str version: Specifies the version number.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def storage(self) -> str:
        """
        Specifies the data storage configuration.
        The object structure is documented below.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Specifies the software package or image address.
        For a component deployed on a VM, this parameter is the software package address.
        For a component deployed based on a container, this parameter is the image address or component name:v${index}.
        The latter indicates that the component source code or the image automatically built using the software package
        will be used.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[str]:
        """
        Specifies the authentication mode.
        The valid values are **iam** and **none**. Defaults to **iam**.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ComponentInstanceArtifactProperties']:
        """
        Specifies the properties of the OBS object.
        This parameter is available only `storage` is **obs**.
        The object structure is documented below.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version number.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComponentInstanceArtifactProperties(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 key: Optional[str] = None):
        """
        :param str bucket: Specifies the OBS bucket name.
        :param str endpoint: Specifies the OBS bucket endpoint.
        :param str key: Specifies the key name of the OBS object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Specifies the OBS bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Specifies the OBS bucket endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Specifies the key name of the OBS object.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class ComponentInstanceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envVariables":
            suggest = "env_variables"
        elif key == "logCollectionPolicies":
            suggest = "log_collection_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env_variables: Optional[Sequence['outputs.ComponentInstanceConfigurationEnvVariable']] = None,
                 lifecycle: Optional['outputs.ComponentInstanceConfigurationLifecycle'] = None,
                 log_collection_policies: Optional[Sequence['outputs.ComponentInstanceConfigurationLogCollectionPolicy']] = None,
                 probe: Optional['outputs.ComponentInstanceConfigurationProbe'] = None,
                 scheduler: Optional['outputs.ComponentInstanceConfigurationScheduler'] = None,
                 storages: Optional[Sequence['outputs.ComponentInstanceConfigurationStorage']] = None,
                 strategy: Optional['outputs.ComponentInstanceConfigurationStrategy'] = None):
        """
        :param Sequence['ComponentInstanceConfigurationEnvVariableArgs'] env_variables: Specifies the environment variables.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationLifecycleArgs' lifecycle: Specifies the lifecycle.
               The object structure is documented below.
        :param Sequence['ComponentInstanceConfigurationLogCollectionPolicyArgs'] log_collection_policies: Specifies the policies of the log collection.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationProbeArgs' probe: Specifies the variable value.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationSchedulerArgs' scheduler: Specifies the scheduling policy.
               The key indicates the component name. In the Docker container scenario, key indicates the container name.
               If the source parameters of a component specify the software package source, this parameter is optional, and the
               software package source of the component is inherited by default. Otherwise, this parameter is required.
               The object structure is documented below.
        :param Sequence['ComponentInstanceConfigurationStorageArgs'] storages: Specifies the data storage configuration.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationStrategyArgs' strategy: Specifies the upgrade policy.
               The object structure is documented below.
        """
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if log_collection_policies is not None:
            pulumi.set(__self__, "log_collection_policies", log_collection_policies)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[Sequence['outputs.ComponentInstanceConfigurationEnvVariable']]:
        """
        Specifies the environment variables.
        The object structure is documented below.
        """
        return pulumi.get(self, "env_variables")

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional['outputs.ComponentInstanceConfigurationLifecycle']:
        """
        Specifies the lifecycle.
        The object structure is documented below.
        """
        return pulumi.get(self, "lifecycle")

    @property
    @pulumi.getter(name="logCollectionPolicies")
    def log_collection_policies(self) -> Optional[Sequence['outputs.ComponentInstanceConfigurationLogCollectionPolicy']]:
        """
        Specifies the policies of the log collection.
        The object structure is documented below.
        """
        return pulumi.get(self, "log_collection_policies")

    @property
    @pulumi.getter
    def probe(self) -> Optional['outputs.ComponentInstanceConfigurationProbe']:
        """
        Specifies the variable value.
        The object structure is documented below.
        """
        return pulumi.get(self, "probe")

    @property
    @pulumi.getter
    def scheduler(self) -> Optional['outputs.ComponentInstanceConfigurationScheduler']:
        """
        Specifies the scheduling policy.
        The key indicates the component name. In the Docker container scenario, key indicates the container name.
        If the source parameters of a component specify the software package source, this parameter is optional, and the
        software package source of the component is inherited by default. Otherwise, this parameter is required.
        The object structure is documented below.
        """
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter
    def storages(self) -> Optional[Sequence['outputs.ComponentInstanceConfigurationStorage']]:
        """
        Specifies the data storage configuration.
        The object structure is documented below.
        """
        return pulumi.get(self, "storages")

    @property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.ComponentInstanceConfigurationStrategy']:
        """
        Specifies the upgrade policy.
        The object structure is documented below.
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class ComponentInstanceConfigurationEnvVariable(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Specifies the name of a configuration item or secret.
        :param str value: Specifies the variable value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the variable value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ComponentInstanceConfigurationLifecycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStart":
            suggest = "post_start"
        elif key == "preStop":
            suggest = "pre_stop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationLifecycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationLifecycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationLifecycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entrypoint: Optional['outputs.ComponentInstanceConfigurationLifecycleEntrypoint'] = None,
                 post_start: Optional['outputs.ComponentInstanceConfigurationLifecyclePostStart'] = None,
                 pre_stop: Optional['outputs.ComponentInstanceConfigurationLifecyclePreStop'] = None):
        """
        :param 'ComponentInstanceConfigurationLifecycleEntrypointArgs' entrypoint: Specifies the startup commands.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationLifecyclePostStartArgs' post_start: Specifies the post-start processing.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationLifecyclePreStopArgs' pre_stop: Specifies the pre-stop processing.
               The object structure is documented below.
        """
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional['outputs.ComponentInstanceConfigurationLifecycleEntrypoint']:
        """
        Specifies the startup commands.
        The object structure is documented below.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional['outputs.ComponentInstanceConfigurationLifecyclePostStart']:
        """
        Specifies the post-start processing.
        The object structure is documented below.
        """
        return pulumi.get(self, "post_start")

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional['outputs.ComponentInstanceConfigurationLifecyclePreStop']:
        """
        Specifies the pre-stop processing.
        The object structure is documented below.
        """
        return pulumi.get(self, "pre_stop")


@pulumi.output_type
class ComponentInstanceConfigurationLifecycleEntrypoint(dict):
    def __init__(__self__, *,
                 args: Sequence[str],
                 commands: Sequence[str]):
        """
        :param Sequence[str] args: Specifies the running parameters.
        :param Sequence[str] commands: Specifies the command list.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Specifies the running parameters.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")


@pulumi.output_type
class ComponentInstanceConfigurationLifecyclePostStart(dict):
    def __init__(__self__, *,
                 parameters: 'outputs.ComponentInstanceConfigurationLifecyclePostStartParameters',
                 type: str):
        """
        :param 'ComponentInstanceConfigurationLifecyclePostStartParametersArgs' parameters: Specifies the start post-processing or stop pre-processing parameters.
               The object structure is documented below.
        :param str type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.ComponentInstanceConfigurationLifecyclePostStartParameters':
        """
        Specifies the start post-processing or stop pre-processing parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ComponentInstanceConfigurationLifecyclePostStartParameters(dict):
    def __init__(__self__, *,
                 commands: Sequence[str],
                 path: str,
                 port: int,
                 host: Optional[str] = None):
        """
        :param Sequence[str] commands: Specifies the command list.
        :param str path: Specifies the request path.
        :param int port: Specifies the listening port of the application component process.
        :param str host: Specifies the custom IP address. The defualt address is pod IP address.
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Specifies the custom IP address. The defualt address is pod IP address.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class ComponentInstanceConfigurationLifecyclePreStop(dict):
    def __init__(__self__, *,
                 parameters: 'outputs.ComponentInstanceConfigurationLifecyclePreStopParameters',
                 type: str):
        """
        :param 'ComponentInstanceConfigurationLifecyclePreStopParametersArgs' parameters: Specifies the start post-processing or stop pre-processing parameters.
               The object structure is documented below.
        :param str type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.ComponentInstanceConfigurationLifecyclePreStopParameters':
        """
        Specifies the start post-processing or stop pre-processing parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ComponentInstanceConfigurationLifecyclePreStopParameters(dict):
    def __init__(__self__, *,
                 commands: Sequence[str],
                 path: str,
                 port: int,
                 host: Optional[str] = None):
        """
        :param Sequence[str] commands: Specifies the command list.
        :param str path: Specifies the request path.
        :param int port: Specifies the listening port of the application component process.
        :param str host: Specifies the custom IP address. The defualt address is pod IP address.
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Specifies the custom IP address. The defualt address is pod IP address.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class ComponentInstanceConfigurationLogCollectionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerMountings":
            suggest = "container_mountings"
        elif key == "hostPath":
            suggest = "host_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationLogCollectionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationLogCollectionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationLogCollectionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_mountings: Sequence['outputs.ComponentInstanceConfigurationLogCollectionPolicyContainerMounting'],
                 host_path: Optional[str] = None):
        """
        :param Sequence['ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs'] container_mountings: Specifies the configurations of the container mounting.
               The object structure is documented below.
        :param str host_path: Specifies the The host path that will be mounted to the specified container path.
        """
        pulumi.set(__self__, "container_mountings", container_mountings)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)

    @property
    @pulumi.getter(name="containerMountings")
    def container_mountings(self) -> Sequence['outputs.ComponentInstanceConfigurationLogCollectionPolicyContainerMounting']:
        """
        Specifies the configurations of the container mounting.
        The object structure is documented below.
        """
        return pulumi.get(self, "container_mountings")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[str]:
        """
        Specifies the The host path that will be mounted to the specified container path.
        """
        return pulumi.get(self, "host_path")


@pulumi.output_type
class ComponentInstanceConfigurationLogCollectionPolicyContainerMounting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agingPeriod":
            suggest = "aging_period"
        elif key == "hostExtendPath":
            suggest = "host_extend_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationLogCollectionPolicyContainerMounting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationLogCollectionPolicyContainerMounting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationLogCollectionPolicyContainerMounting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 aging_period: Optional[str] = None,
                 host_extend_path: Optional[str] = None):
        """
        :param str path: Specifies the request path.
        :param str aging_period: Specifies the aging period.
               The valid values are **Hourly**, **Daily** and **Weekly**. The default value is **Hourly**.
        :param str host_extend_path: Specifies the extended host path.
               This parameter can be configured only when `host_path` is configured.
               The valid values are as follows:
               + **PodUID**
               + **PodName**
               + **PodUID/ContainerName**
               + **PodName/ContainerName**
        """
        pulumi.set(__self__, "path", path)
        if aging_period is not None:
            pulumi.set(__self__, "aging_period", aging_period)
        if host_extend_path is not None:
            pulumi.set(__self__, "host_extend_path", host_extend_path)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="agingPeriod")
    def aging_period(self) -> Optional[str]:
        """
        Specifies the aging period.
        The valid values are **Hourly**, **Daily** and **Weekly**. The default value is **Hourly**.
        """
        return pulumi.get(self, "aging_period")

    @property
    @pulumi.getter(name="hostExtendPath")
    def host_extend_path(self) -> Optional[str]:
        """
        Specifies the extended host path.
        This parameter can be configured only when `host_path` is configured.
        The valid values are as follows:
        + **PodUID**
        + **PodName**
        + **PodUID/ContainerName**
        + **PodName/ContainerName**
        """
        return pulumi.get(self, "host_extend_path")


@pulumi.output_type
class ComponentInstanceConfigurationProbe(dict):
    def __init__(__self__, *,
                 liveness: Optional['outputs.ComponentInstanceConfigurationProbeLiveness'] = None,
                 readiness: Optional['outputs.ComponentInstanceConfigurationProbeReadiness'] = None):
        """
        :param 'ComponentInstanceConfigurationProbeLivenessArgs' liveness: Specifies the component liveness probe.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationProbeReadinessArgs' readiness: Specifies the component service probe.
               The object structure is documented below.
        """
        if liveness is not None:
            pulumi.set(__self__, "liveness", liveness)
        if readiness is not None:
            pulumi.set(__self__, "readiness", readiness)

    @property
    @pulumi.getter
    def liveness(self) -> Optional['outputs.ComponentInstanceConfigurationProbeLiveness']:
        """
        Specifies the component liveness probe.
        The object structure is documented below.
        """
        return pulumi.get(self, "liveness")

    @property
    @pulumi.getter
    def readiness(self) -> Optional['outputs.ComponentInstanceConfigurationProbeReadiness']:
        """
        Specifies the component service probe.
        The object structure is documented below.
        """
        return pulumi.get(self, "readiness")


@pulumi.output_type
class ComponentInstanceConfigurationProbeLiveness(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandParam":
            suggest = "command_param"
        elif key == "httpParam":
            suggest = "http_param"
        elif key == "tcpParam":
            suggest = "tcp_param"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationProbeLiveness. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationProbeLiveness.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationProbeLiveness.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 command_param: Optional['outputs.ComponentInstanceConfigurationProbeLivenessCommandParam'] = None,
                 delay: Optional[int] = None,
                 http_param: Optional['outputs.ComponentInstanceConfigurationProbeLivenessHttpParam'] = None,
                 tcp_param: Optional['outputs.ComponentInstanceConfigurationProbeLivenessTcpParam'] = None,
                 timeout: Optional[int] = None):
        """
        :param str type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        :param 'ComponentInstanceConfigurationProbeLivenessCommandParamArgs' command_param: Specifies the commands. Required if `type` is **command**.
               The object structure is documented below.
        :param int delay: Specifies the interval between the startup and detection.
        :param 'ComponentInstanceConfigurationProbeLivenessHttpParamArgs' http_param: Specifies the commands. Required if `type` is **http**.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationProbeLivenessTcpParamArgs' tcp_param: Specifies the commands. Required if `type` is **tcp**.
               The object structure is documented below.
        :param int timeout: Specifies the detection timeout interval.
        """
        pulumi.set(__self__, "type", type)
        if command_param is not None:
            pulumi.set(__self__, "command_param", command_param)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if http_param is not None:
            pulumi.set(__self__, "http_param", http_param)
        if tcp_param is not None:
            pulumi.set(__self__, "tcp_param", tcp_param)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="commandParam")
    def command_param(self) -> Optional['outputs.ComponentInstanceConfigurationProbeLivenessCommandParam']:
        """
        Specifies the commands. Required if `type` is **command**.
        The object structure is documented below.
        """
        return pulumi.get(self, "command_param")

    @property
    @pulumi.getter
    def delay(self) -> Optional[int]:
        """
        Specifies the interval between the startup and detection.
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter(name="httpParam")
    def http_param(self) -> Optional['outputs.ComponentInstanceConfigurationProbeLivenessHttpParam']:
        """
        Specifies the commands. Required if `type` is **http**.
        The object structure is documented below.
        """
        return pulumi.get(self, "http_param")

    @property
    @pulumi.getter(name="tcpParam")
    def tcp_param(self) -> Optional['outputs.ComponentInstanceConfigurationProbeLivenessTcpParam']:
        """
        Specifies the commands. Required if `type` is **tcp**.
        The object structure is documented below.
        """
        return pulumi.get(self, "tcp_param")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Specifies the detection timeout interval.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ComponentInstanceConfigurationProbeLivenessCommandParam(dict):
    def __init__(__self__, *,
                 commands: Sequence[str]):
        """
        :param Sequence[str] commands: Specifies the command list.
        """
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")


@pulumi.output_type
class ComponentInstanceConfigurationProbeLivenessHttpParam(dict):
    def __init__(__self__, *,
                 path: str,
                 port: int,
                 scheme: str,
                 host: Optional[str] = None):
        """
        :param str path: Specifies the request path.
        :param int port: Specifies the listening port of the application component process.
        :param str scheme: Specifies the protocol scheme. The valid values are **HTTP** and **HTTPS**.
        :param str host: Specifies the custom IP address. The defualt address is pod IP address.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Specifies the protocol scheme. The valid values are **HTTP** and **HTTPS**.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Specifies the custom IP address. The defualt address is pod IP address.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class ComponentInstanceConfigurationProbeLivenessTcpParam(dict):
    def __init__(__self__, *,
                 port: int):
        """
        :param int port: Specifies the listening port of the application component process.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ComponentInstanceConfigurationProbeReadiness(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandParam":
            suggest = "command_param"
        elif key == "httpParam":
            suggest = "http_param"
        elif key == "tcpParam":
            suggest = "tcp_param"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationProbeReadiness. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationProbeReadiness.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationProbeReadiness.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 command_param: Optional['outputs.ComponentInstanceConfigurationProbeReadinessCommandParam'] = None,
                 delay: Optional[int] = None,
                 http_param: Optional['outputs.ComponentInstanceConfigurationProbeReadinessHttpParam'] = None,
                 tcp_param: Optional['outputs.ComponentInstanceConfigurationProbeReadinessTcpParam'] = None,
                 timeout: Optional[int] = None):
        """
        :param str type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        :param 'ComponentInstanceConfigurationProbeReadinessCommandParamArgs' command_param: Specifies the commands. Required if `type` is **command**.
               The object structure is documented below.
        :param int delay: Specifies the interval between the startup and detection.
        :param 'ComponentInstanceConfigurationProbeReadinessHttpParamArgs' http_param: Specifies the commands. Required if `type` is **http**.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationProbeReadinessTcpParamArgs' tcp_param: Specifies the commands. Required if `type` is **tcp**.
               The object structure is documented below.
        :param int timeout: Specifies the detection timeout interval.
        """
        pulumi.set(__self__, "type", type)
        if command_param is not None:
            pulumi.set(__self__, "command_param", command_param)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if http_param is not None:
            pulumi.set(__self__, "http_param", http_param)
        if tcp_param is not None:
            pulumi.set(__self__, "tcp_param", tcp_param)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="commandParam")
    def command_param(self) -> Optional['outputs.ComponentInstanceConfigurationProbeReadinessCommandParam']:
        """
        Specifies the commands. Required if `type` is **command**.
        The object structure is documented below.
        """
        return pulumi.get(self, "command_param")

    @property
    @pulumi.getter
    def delay(self) -> Optional[int]:
        """
        Specifies the interval between the startup and detection.
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter(name="httpParam")
    def http_param(self) -> Optional['outputs.ComponentInstanceConfigurationProbeReadinessHttpParam']:
        """
        Specifies the commands. Required if `type` is **http**.
        The object structure is documented below.
        """
        return pulumi.get(self, "http_param")

    @property
    @pulumi.getter(name="tcpParam")
    def tcp_param(self) -> Optional['outputs.ComponentInstanceConfigurationProbeReadinessTcpParam']:
        """
        Specifies the commands. Required if `type` is **tcp**.
        The object structure is documented below.
        """
        return pulumi.get(self, "tcp_param")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Specifies the detection timeout interval.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ComponentInstanceConfigurationProbeReadinessCommandParam(dict):
    def __init__(__self__, *,
                 commands: Sequence[str]):
        """
        :param Sequence[str] commands: Specifies the command list.
        """
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")


@pulumi.output_type
class ComponentInstanceConfigurationProbeReadinessHttpParam(dict):
    def __init__(__self__, *,
                 path: str,
                 port: int,
                 scheme: str,
                 host: Optional[str] = None):
        """
        :param str path: Specifies the request path.
        :param int port: Specifies the listening port of the application component process.
        :param str scheme: Specifies the protocol scheme. The valid values are **HTTP** and **HTTPS**.
        :param str host: Specifies the custom IP address. The defualt address is pod IP address.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Specifies the protocol scheme. The valid values are **HTTP** and **HTTPS**.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Specifies the custom IP address. The defualt address is pod IP address.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class ComponentInstanceConfigurationProbeReadinessTcpParam(dict):
    def __init__(__self__, *,
                 port: int):
        """
        :param int port: Specifies the listening port of the application component process.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ComponentInstanceConfigurationScheduler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "antiAffinity":
            suggest = "anti_affinity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationScheduler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationScheduler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationScheduler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affinity: Optional['outputs.ComponentInstanceConfigurationSchedulerAffinity'] = None,
                 anti_affinity: Optional['outputs.ComponentInstanceConfigurationSchedulerAntiAffinity'] = None):
        """
        :param 'ComponentInstanceConfigurationSchedulerAffinityArgs' affinity: Specifies the commands.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationSchedulerAntiAffinityArgs' anti_affinity: Specifies the commands.
               The object structure is documented below.
        """
        if affinity is not None:
            pulumi.set(__self__, "affinity", affinity)
        if anti_affinity is not None:
            pulumi.set(__self__, "anti_affinity", anti_affinity)

    @property
    @pulumi.getter
    def affinity(self) -> Optional['outputs.ComponentInstanceConfigurationSchedulerAffinity']:
        """
        Specifies the commands.
        The object structure is documented below.
        """
        return pulumi.get(self, "affinity")

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> Optional['outputs.ComponentInstanceConfigurationSchedulerAntiAffinity']:
        """
        Specifies the commands.
        The object structure is documented below.
        """
        return pulumi.get(self, "anti_affinity")


@pulumi.output_type
class ComponentInstanceConfigurationSchedulerAffinity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "privateIps":
            suggest = "private_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationSchedulerAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationSchedulerAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationSchedulerAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zones: Optional[Sequence[str]] = None,
                 instance_names: Optional[Sequence[str]] = None,
                 private_ips: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] availability_zones: Specifies the AZ list.
        :param Sequence[str] instance_names: Specifies the list of component instance names.
        :param Sequence[str] private_ips: Specifies the node private IP address list.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[str]]:
        """
        Specifies the AZ list.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[str]]:
        """
        Specifies the list of component instance names.
        """
        return pulumi.get(self, "instance_names")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[Sequence[str]]:
        """
        Specifies the node private IP address list.
        """
        return pulumi.get(self, "private_ips")


@pulumi.output_type
class ComponentInstanceConfigurationSchedulerAntiAffinity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "privateIps":
            suggest = "private_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationSchedulerAntiAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationSchedulerAntiAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationSchedulerAntiAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zones: Optional[Sequence[str]] = None,
                 instance_names: Optional[Sequence[str]] = None,
                 private_ips: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] availability_zones: Specifies the AZ list.
        :param Sequence[str] instance_names: Specifies the list of component instance names.
        :param Sequence[str] private_ips: Specifies the node private IP address list.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[str]]:
        """
        Specifies the AZ list.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[Sequence[str]]:
        """
        Specifies the list of component instance names.
        """
        return pulumi.get(self, "instance_names")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[Sequence[str]]:
        """
        Specifies the node private IP address list.
        """
        return pulumi.get(self, "private_ips")


@pulumi.output_type
class ComponentInstanceConfigurationStorage(dict):
    def __init__(__self__, *,
                 mounts: Sequence['outputs.ComponentInstanceConfigurationStorageMount'],
                 parameter: 'outputs.ComponentInstanceConfigurationStorageParameter',
                 type: str):
        """
        :param Sequence['ComponentInstanceConfigurationStorageMountArgs'] mounts: Specifies the directory mounted to the container.
               The object structure is documented below.
        :param 'ComponentInstanceConfigurationStorageParameterArgs' parameter: Specifies the storage parameters.
               The object structure is documented below.
        :param str type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        """
        pulumi.set(__self__, "mounts", mounts)
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def mounts(self) -> Sequence['outputs.ComponentInstanceConfigurationStorageMount']:
        """
        Specifies the directory mounted to the container.
        The object structure is documented below.
        """
        return pulumi.get(self, "mounts")

    @property
    @pulumi.getter
    def parameter(self) -> 'outputs.ComponentInstanceConfigurationStorageParameter':
        """
        Specifies the storage parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "parameter")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ComponentInstanceConfigurationStorageMount(dict):
    def __init__(__self__, *,
                 path: str,
                 readonly: bool,
                 subpath: Optional[str] = None):
        """
        :param str path: Specifies the request path.
        :param bool readonly: Specifies the mounted disk permission is read-only or read-write.
               + **true**: read-only.
               + **false**: read-write.
        :param str subpath: Specifies the subpath of the mounted disk.
               This parameter is applicable to `http` type.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "readonly", readonly)
        if subpath is not None:
            pulumi.set(__self__, "subpath", subpath)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def readonly(self) -> bool:
        """
        Specifies the mounted disk permission is read-only or read-write.
        + **true**: read-only.
        + **false**: read-write.
        """
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter
    def subpath(self) -> Optional[str]:
        """
        Specifies the subpath of the mounted disk.
        This parameter is applicable to `http` type.
        """
        return pulumi.get(self, "subpath")


@pulumi.output_type
class ComponentInstanceConfigurationStorageParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimName":
            suggest = "claim_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentInstanceConfigurationStorageParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentInstanceConfigurationStorageParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentInstanceConfigurationStorageParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_name: Optional[str] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str claim_name: Specifies the PVC name.
        :param str name: Specifies the name of a configuration item or secret.
        :param str path: Specifies the request path.
        """
        if claim_name is not None:
            pulumi.set(__self__, "claim_name", claim_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="claimName")
    def claim_name(self) -> Optional[str]:
        """
        Specifies the PVC name.
        """
        return pulumi.get(self, "claim_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ComponentInstanceConfigurationStrategy(dict):
    def __init__(__self__, *,
                 upgrade: Optional[str] = None):
        """
        :param str upgrade: Specifies the upgrade policy.
               The valid values are **Recreate** or **RollingUpdate**. The default value is **RollingUpdate**.
               The **Recreate** indicates in-place upgrade while the **RollingUpdate** indicates rolling upgrade.
        """
        if upgrade is not None:
            pulumi.set(__self__, "upgrade", upgrade)

    @property
    @pulumi.getter
    def upgrade(self) -> Optional[str]:
        """
        Specifies the upgrade policy.
        The valid values are **Recreate** or **RollingUpdate**. The default value is **RollingUpdate**.
        The **Recreate** indicates in-place upgrade while the **RollingUpdate** indicates rolling upgrade.
        """
        return pulumi.get(self, "upgrade")


@pulumi.output_type
class ComponentInstanceExternalAccess(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 port: Optional[int] = None,
                 protocol: Optional[str] = None):
        """
        :param str address: Specifies the access address. For example: www.example.com.
        :param int port: Specifies the listening port of the application component process.
        :param str protocol: Specifies the protocol. The valid values are **HTTP** and **HTTPS**.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Specifies the access address. For example: www.example.com.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Specifies the protocol. The valid values are **HTTP** and **HTTPS**.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ComponentInstanceReferResource(dict):
    def __init__(__self__, *,
                 id: str,
                 type: str,
                 alias: Optional[str] = None,
                 parameters: Optional[Mapping[str, str]] = None):
        """
        :param str id: Specifies the resource ID.
               If the `type` is set to **ecs**, the value of this parameter must be **Default**.
        :param str type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        :param str alias: Specifies the application alias, which is provided only in DCS scenario.
               The valid values are: **distributed_session**, **distributed_cache** and **distributed_session, distributed_cache**.
               Defaults to **distributed_session, distributed_cache**.
        :param Mapping[str, str] parameters: Specifies the start post-processing or stop pre-processing parameters.
               The object structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the resource ID.
        If the `type` is set to **ecs**, the value of this parameter must be **Default**.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        Specifies the application alias, which is provided only in DCS scenario.
        The valid values are: **distributed_session**, **distributed_cache** and **distributed_session, distributed_cache**.
        Defaults to **distributed_session, distributed_cache**.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Specifies the start post-processing or stop pre-processing parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ComponentSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoNamespace":
            suggest = "repo_namespace"
        elif key == "repoRef":
            suggest = "repo_ref"
        elif key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 url: str,
                 authorization: Optional[str] = None,
                 repo_namespace: Optional[str] = None,
                 repo_ref: Optional[str] = None,
                 storage_type: Optional[str] = None):
        """
        :param str type: Specifies the type of repository source or storage.
               The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        :param str url: Specifies the URL of the repository or package storage.
        :param str authorization: Specifies the authorization name.
               This parameter and `storage_type` are alternative.
        :param str repo_namespace: Specifies the namespace name.
        :param str repo_ref: Specifies the name of the branch of the code repository.
               The default value is `master`.
        :param str storage_type: Specifies the storage type, such as **obs**, **swr**.
               This parameter is conflict with `repo_ref` and `repo_namespace`.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if repo_namespace is not None:
            pulumi.set(__self__, "repo_namespace", repo_namespace)
        if repo_ref is not None:
            pulumi.set(__self__, "repo_ref", repo_ref)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of repository source or storage.
        The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Specifies the URL of the repository or package storage.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def authorization(self) -> Optional[str]:
        """
        Specifies the authorization name.
        This parameter and `storage_type` are alternative.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="repoNamespace")
    def repo_namespace(self) -> Optional[str]:
        """
        Specifies the namespace name.
        """
        return pulumi.get(self, "repo_namespace")

    @property
    @pulumi.getter(name="repoRef")
    def repo_ref(self) -> Optional[str]:
        """
        Specifies the name of the branch of the code repository.
        The default value is `master`.
        """
        return pulumi.get(self, "repo_ref")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[str]:
        """
        Specifies the storage type, such as **obs**, **swr**.
        This parameter is conflict with `repo_ref` and `repo_namespace`.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class EnvironmentBasicResource(dict):
    def __init__(__self__, *,
                 id: str,
                 type: str):
        """
        :param str id: Specifies the resource ID. For most resources, this parameter needs to fill in their **id**,
               but for CCI namespace, this parameter needs to fill in **name**.
        :param str type: Specifies the resource type.
               + The type of basic resource supports **cce**, **cci**, **ecs** and **as**.
               + The type of optional resource supports **elb**, **eip**, **rds**, **dcs** and **cse**.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the resource ID. For most resources, this parameter needs to fill in their **id**,
        but for CCI namespace, this parameter needs to fill in **name**.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the resource type.
        + The type of basic resource supports **cce**, **cci**, **ecs** and **as**.
        + The type of optional resource supports **elb**, **eip**, **rds**, **dcs** and **cse**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EnvironmentOptionalResource(dict):
    def __init__(__self__, *,
                 id: str,
                 type: str):
        """
        :param str id: Specifies the resource ID. For most resources, this parameter needs to fill in their **id**,
               but for CCI namespace, this parameter needs to fill in **name**.
        :param str type: Specifies the resource type.
               + The type of basic resource supports **cce**, **cci**, **ecs** and **as**.
               + The type of optional resource supports **elb**, **eip**, **rds**, **dcs** and **cse**.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the resource ID. For most resources, this parameter needs to fill in their **id**,
        but for CCI namespace, this parameter needs to fill in **name**.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the resource type.
        + The type of basic resource supports **cce**, **cci**, **ecs** and **as**.
        + The type of optional resource supports **elb**, **eip**, **rds**, **dcs** and **cse**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetComponentRuntimesRuntimeResult(dict):
    def __init__(__self__, *,
                 default_port: int,
                 description: str,
                 name: str):
        """
        :param int default_port: Specifies the default container port to use for filtering.
        :param str description: The runtime description.
        :param str name: Specifies the runtime name to use for filtering.
               For the runtime names corresponding to each type of component, please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-servicestage/servicestage_user_0411.html).
        """
        pulumi.set(__self__, "default_port", default_port)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="defaultPort")
    def default_port(self) -> int:
        """
        Specifies the default container port to use for filtering.
        """
        return pulumi.get(self, "default_port")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The runtime description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the runtime name to use for filtering.
        For the runtime names corresponding to each type of component, please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-servicestage/servicestage_user_0411.html).
        """
        return pulumi.get(self, "name")


