# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ParametergroupArgs', 'Parametergroup']

@pulumi.input_type
class ParametergroupArgs:
    def __init__(__self__, *,
                 datastore: pulumi.Input['ParametergroupDatastoreArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Parametergroup resource.
        :param pulumi.Input['ParametergroupDatastoreArgs'] datastore: Database object. The database object structure is documented below. Changing
               this creates a new parameter group.
        :param pulumi.Input[str] description: The parameter group description. It contains a maximum of 256 characters and cannot
               contain the following special characters:>!<"&'= the value is left blank by default.
        :param pulumi.Input[str] name: The parameter group name. It contains a maximum of 64 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] values: Parameter group values key/value pairs defined by users based on the default parameter
               groups.
        """
        pulumi.set(__self__, "datastore", datastore)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Input['ParametergroupDatastoreArgs']:
        """
        Database object. The database object structure is documented below. Changing
        this creates a new parameter group.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: pulumi.Input['ParametergroupDatastoreArgs']):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The parameter group description. It contains a maximum of 256 characters and cannot
        contain the following special characters:>!<"&'= the value is left blank by default.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The parameter group name. It contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Parameter group values key/value pairs defined by users based on the default parameter
        groups.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class _ParametergroupState:
    def __init__(__self__, *,
                 configuration_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ParametergroupConfigurationParameterArgs']]]] = None,
                 datastore: Optional[pulumi.Input['ParametergroupDatastoreArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Parametergroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['ParametergroupConfigurationParameterArgs']]] configuration_parameters: Indicates the parameter configuration defined by users based on the default parameters
               groups.
        :param pulumi.Input['ParametergroupDatastoreArgs'] datastore: Database object. The database object structure is documented below. Changing
               this creates a new parameter group.
        :param pulumi.Input[str] description: The parameter group description. It contains a maximum of 256 characters and cannot
               contain the following special characters:>!<"&'= the value is left blank by default.
        :param pulumi.Input[str] name: The parameter group name. It contains a maximum of 64 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] values: Parameter group values key/value pairs defined by users based on the default parameter
               groups.
        """
        if configuration_parameters is not None:
            pulumi.set(__self__, "configuration_parameters", configuration_parameters)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="configurationParameters")
    def configuration_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ParametergroupConfigurationParameterArgs']]]]:
        """
        Indicates the parameter configuration defined by users based on the default parameters
        groups.
        """
        return pulumi.get(self, "configuration_parameters")

    @configuration_parameters.setter
    def configuration_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ParametergroupConfigurationParameterArgs']]]]):
        pulumi.set(self, "configuration_parameters", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['ParametergroupDatastoreArgs']]:
        """
        Database object. The database object structure is documented below. Changing
        this creates a new parameter group.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['ParametergroupDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The parameter group description. It contains a maximum of 256 characters and cannot
        contain the following special characters:>!<"&'= the value is left blank by default.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The parameter group name. It contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Parameter group values key/value pairs defined by users based on the default parameter
        groups.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


class Parametergroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['ParametergroupDatastoreArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a RDS ParameterGroup resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        pg1 = huaweicloud.rds.Parametergroup("pg1",
            datastore=huaweicloud.rds.ParametergroupDatastoreArgs(
                type="mysql",
                version="5.6",
            ),
            description="description_1",
            values={
                "autocommit": "OFF",
                "max_connections": "10",
            })
        ```

        ## Import

        Parameter groups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/parametergroup:Parametergroup pg_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ParametergroupDatastoreArgs']] datastore: Database object. The database object structure is documented below. Changing
               this creates a new parameter group.
        :param pulumi.Input[str] description: The parameter group description. It contains a maximum of 256 characters and cannot
               contain the following special characters:>!<"&'= the value is left blank by default.
        :param pulumi.Input[str] name: The parameter group name. It contains a maximum of 64 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] values: Parameter group values key/value pairs defined by users based on the default parameter
               groups.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ParametergroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a RDS ParameterGroup resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        pg1 = huaweicloud.rds.Parametergroup("pg1",
            datastore=huaweicloud.rds.ParametergroupDatastoreArgs(
                type="mysql",
                version="5.6",
            ),
            description="description_1",
            values={
                "autocommit": "OFF",
                "max_connections": "10",
            })
        ```

        ## Import

        Parameter groups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/parametergroup:Parametergroup pg_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param ParametergroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ParametergroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['ParametergroupDatastoreArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ParametergroupArgs.__new__(ParametergroupArgs)

            if datastore is None and not opts.urn:
                raise TypeError("Missing required property 'datastore'")
            __props__.__dict__["datastore"] = datastore
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["values"] = values
            __props__.__dict__["configuration_parameters"] = None
        super(Parametergroup, __self__).__init__(
            'huaweicloud:Rds/parametergroup:Parametergroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ParametergroupConfigurationParameterArgs']]]]] = None,
            datastore: Optional[pulumi.Input[pulumi.InputType['ParametergroupDatastoreArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Parametergroup':
        """
        Get an existing Parametergroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ParametergroupConfigurationParameterArgs']]]] configuration_parameters: Indicates the parameter configuration defined by users based on the default parameters
               groups.
        :param pulumi.Input[pulumi.InputType['ParametergroupDatastoreArgs']] datastore: Database object. The database object structure is documented below. Changing
               this creates a new parameter group.
        :param pulumi.Input[str] description: The parameter group description. It contains a maximum of 256 characters and cannot
               contain the following special characters:>!<"&'= the value is left blank by default.
        :param pulumi.Input[str] name: The parameter group name. It contains a maximum of 64 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] values: Parameter group values key/value pairs defined by users based on the default parameter
               groups.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ParametergroupState.__new__(_ParametergroupState)

        __props__.__dict__["configuration_parameters"] = configuration_parameters
        __props__.__dict__["datastore"] = datastore
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["values"] = values
        return Parametergroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationParameters")
    def configuration_parameters(self) -> pulumi.Output[Sequence['outputs.ParametergroupConfigurationParameter']]:
        """
        Indicates the parameter configuration defined by users based on the default parameters
        groups.
        """
        return pulumi.get(self, "configuration_parameters")

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Output['outputs.ParametergroupDatastore']:
        """
        Database object. The database object structure is documented below. Changing
        this creates a new parameter group.
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The parameter group description. It contains a maximum of 256 characters and cannot
        contain the following special characters:>!<"&'= the value is left blank by default.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The parameter group name. It contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def values(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Parameter group values key/value pairs defined by users based on the default parameter
        groups.
        """
        return pulumi.get(self, "values")

