# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[str]]],
                 db: pulumi.Input['InstanceDbArgs'],
                 flavor: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 volume: pulumi.Input['InstanceVolumeArgs'],
                 vpc_id: pulumi.Input[str],
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['InstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 ha_replication_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 param_group_id: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input['InstanceDbArgs'] db: Specifies the database information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the specification code.
        :param pulumi.Input[str] security_group_id: Specifies the security group which the RDS DB instance belongs to.
        :param pulumi.Input[str] subnet_id: Specifies the network id of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input['InstanceVolumeArgs'] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input['InstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the RDS DB instance. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[str] collation: Specifies the Character Set, only available to Microsoft SQL Server DB instances.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the RDS instance. Changing this
               parameter creates a new RDS instance.
        :param pulumi.Input[str] fixed_ip: Specifies an intranet floating IP address of RDS DB instance. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] ha_replication_mode: Specifies the replication mode for the standby DB instance.
               Changing this parameter will create a new resource.
               + For MySQL, the value is *async* or *semisync*.
               + For PostgreSQL, the value is *async* or *sync*.
               + For Microsoft SQL Server, the value is *sync*.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[str] param_group_id: Specifies the parameter group ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the RDS DB instance. If `period_unit` is set
               to *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This
               parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the RDS DB instance. Valid values
               are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a
               new resource.
        :param pulumi.Input[str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new rds instance resource.
        :param pulumi.Input[bool] ssl_enable: Specifies whether to enable the SSL for MySQL database.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
               pair.
        :param pulumi.Input[str] time_zone: Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
               and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
               Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
               zone is expressed as a character string, refer to
               [HuaweiCloud Document](https://support.huaweicloud.com/intl/en-us/api-rds/rds_01_0002.html#rds_01_0002__table613473883617)
               .
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "db", db)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "volume", volume)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if ha_replication_mode is not None:
            pulumi.set(__self__, "ha_replication_mode", ha_replication_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if param_group_id is not None:
            pulumi.set(__self__, "param_group_id", param_group_id)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter
    def db(self) -> pulumi.Input['InstanceDbArgs']:
        """
        Specifies the database information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "db")

    @db.setter
    def db(self, value: pulumi.Input['InstanceDbArgs']):
        pulumi.set(self, "db", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the network id of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['InstanceVolumeArgs']:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['InstanceVolumeArgs']):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['InstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['InstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the RDS DB instance. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the RDS instance. Changing this
        parameter creates a new RDS instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an intranet floating IP address of RDS DB instance. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip", value)

    @property
    @pulumi.getter(name="haReplicationMode")
    def ha_replication_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the replication mode for the standby DB instance.
        Changing this parameter will create a new resource.
        + For MySQL, the value is *async* or *semisync*.
        + For PostgreSQL, the value is *async* or *sync*.
        + For Microsoft SQL Server, the value is *sync*.
        """
        return pulumi.get(self, "ha_replication_mode")

    @ha_replication_mode.setter
    def ha_replication_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_replication_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="paramGroupId")
    def param_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameter group ID. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "param_group_id")

    @param_group_id.setter
    def param_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_group_id", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the RDS DB instance. If `period_unit` is set
        to *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This
        parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the RDS DB instance. Valid values
        are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a
        new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new rds instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the SSL for MySQL database.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enable", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
        pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
        and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
        Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
        zone is expressed as a character string, refer to
        [HuaweiCloud Document](https://support.huaweicloud.com/intl/en-us/api-rds/rds_01_0002.html#rds_01_0002__table613473883617)
        .
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_strategy: Optional[pulumi.Input['InstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 created: Optional[pulumi.Input[str]] = None,
                 db: Optional[pulumi.Input['InstanceDbArgs']] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 ha_replication_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]] = None,
                 param_group_id: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input['InstanceVolumeArgs']] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input['InstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the RDS DB instance. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[str] collation: Specifies the Character Set, only available to Microsoft SQL Server DB instances.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] created: Indicates the creation time.
        :param pulumi.Input['InstanceDbArgs'] db: Specifies the database information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the RDS instance. Changing this
               parameter creates a new RDS instance.
        :param pulumi.Input[str] fixed_ip: Specifies an intranet floating IP address of RDS DB instance. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the specification code.
        :param pulumi.Input[str] ha_replication_mode: Specifies the replication mode for the standby DB instance.
               Changing this parameter will create a new resource.
               + For MySQL, the value is *async* or *semisync*.
               + For PostgreSQL, the value is *async* or *sync*.
               + For Microsoft SQL Server, the value is *sync*.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] param_group_id: Specifies the parameter group ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the RDS DB instance. If `period_unit` is set
               to *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This
               parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the RDS DB instance. Valid values
               are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a
               new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Indicates the private IP address list. It is a blank string until an ECS is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ips: Indicates the public IP address list.
        :param pulumi.Input[str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new rds instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group which the RDS DB instance belongs to.
        :param pulumi.Input[bool] ssl_enable: Specifies whether to enable the SSL for MySQL database.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the network id of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
               pair.
        :param pulumi.Input[str] time_zone: Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
               and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
               Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
               zone is expressed as a character string, refer to
               [HuaweiCloud Document](https://support.huaweicloud.com/intl/en-us/api-rds/rds_01_0002.html#rds_01_0002__table613473883617)
               .
        :param pulumi.Input['InstanceVolumeArgs'] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if db is not None:
            pulumi.set(__self__, "db", db)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if ha_replication_mode is not None:
            pulumi.set(__self__, "ha_replication_mode", ha_replication_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if param_group_id is not None:
            pulumi.set(__self__, "param_group_id", param_group_id)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['InstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['InstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the RDS DB instance. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the creation time.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def db(self) -> Optional[pulumi.Input['InstanceDbArgs']]:
        """
        Specifies the database information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "db")

    @db.setter
    def db(self, value: Optional[pulumi.Input['InstanceDbArgs']]):
        pulumi.set(self, "db", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the RDS instance. Changing this
        parameter creates a new RDS instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an intranet floating IP address of RDS DB instance. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="haReplicationMode")
    def ha_replication_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the replication mode for the standby DB instance.
        Changing this parameter will create a new resource.
        + For MySQL, the value is *async* or *semisync*.
        + For PostgreSQL, the value is *async* or *sync*.
        + For Microsoft SQL Server, the value is *sync*.
        """
        return pulumi.get(self, "ha_replication_mode")

    @ha_replication_mode.setter
    def ha_replication_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_replication_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="paramGroupId")
    def param_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameter group ID. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "param_group_id")

    @param_group_id.setter
    def param_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_group_id", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the RDS DB instance. If `period_unit` is set
        to *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This
        parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the RDS DB instance. Valid values
        are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a
        new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the private IP address list. It is a blank string until an ECS is created.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the public IP address list.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_ips", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new rds instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the SSL for MySQL database.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enable", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network id of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
        pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
        and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
        Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
        zone is expressed as a character string, refer to
        [HuaweiCloud Document](https://support.huaweicloud.com/intl/en-us/api-rds/rds_01_0002.html#rds_01_0002__table613473883617)
        .
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['InstanceVolumeArgs']]:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['InstanceVolumeArgs']]):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 db: Optional[pulumi.Input[pulumi.InputType['InstanceDbArgs']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 ha_replication_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 param_group_id: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input[pulumi.InputType['InstanceVolumeArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manage RDS instance resource within HuaweiCloud.

        ## Example Usage
        ### create a single db instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="terraform security group acceptance test")
        instance = huaweicloud.rds.Instance("instance",
            flavor="rds.pg.n1.large.2",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            availability_zones=["{{ availability_zone }}"],
            db=huaweicloud.rds.InstanceDbArgs(
                type="PostgreSQL",
                version="12",
                password="Huangwei!120521",
            ),
            volume=huaweicloud.rds.InstanceVolumeArgs(
                type="ULTRAHIGH",
                size=100,
            ),
            backup_strategy=huaweicloud.rds.InstanceBackupStrategyArgs(
                start_time="08:00-09:00",
                keep_days=1,
            ))
        ```
        ### create a primary/standby db instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="terraform security group acceptance test")
        instance = huaweicloud.rds.Instance("instance",
            flavor="rds.pg.n1.large.2.ha",
            ha_replication_mode="async",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            availability_zones=[
                "{{ availability_zone_1 }}",
                "{{ availability_zone_2 }}",
            ],
            db=huaweicloud.rds.InstanceDbArgs(
                type="PostgreSQL",
                version="12",
                password="Huangwei!120521",
            ),
            volume=huaweicloud.rds.InstanceVolumeArgs(
                type="ULTRAHIGH",
                size=100,
            ),
            backup_strategy=huaweicloud.rds.InstanceBackupStrategyArgs(
                start_time="08:00-09:00",
                keep_days=1,
            ))
        ```
        ### create a single db instance with encrypted volume

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        key = huaweicloud.dew.Key("key",
            key_alias="key_1",
            key_description="first test key",
            is_enabled=True)
        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="security group acceptance test")
        instance = huaweicloud.rds.Instance("instance",
            flavor="rds.pg.n1.large.2",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            availability_zones=["{{ availability_zone }}"],
            db=huaweicloud.rds.InstanceDbArgs(
                type="PostgreSQL",
                version="12",
                password="Huangwei!120521",
            ),
            volume=huaweicloud.rds.InstanceVolumeArgs(
                type="ULTRAHIGH",
                size=100,
                disk_encryption_id=key.id,
            ),
            backup_strategy=huaweicloud.rds.InstanceBackupStrategyArgs(
                start_time="08:00-09:00",
                keep_days=1,
            ))
        ```

        ## Import

        RDS instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/instance:Instance instance_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

         But due to some attributes missing from the API response, it's required to ignore changes as below. resource "huaweicloud_rds_instance" "instance_1" {

         ...

         lifecycle {

         ignore_changes = [

         "db", "collation"

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the RDS DB instance. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[str] collation: Specifies the Character Set, only available to Microsoft SQL Server DB instances.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['InstanceDbArgs']] db: Specifies the database information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the RDS instance. Changing this
               parameter creates a new RDS instance.
        :param pulumi.Input[str] fixed_ip: Specifies an intranet floating IP address of RDS DB instance. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the specification code.
        :param pulumi.Input[str] ha_replication_mode: Specifies the replication mode for the standby DB instance.
               Changing this parameter will create a new resource.
               + For MySQL, the value is *async* or *semisync*.
               + For PostgreSQL, the value is *async* or *sync*.
               + For Microsoft SQL Server, the value is *sync*.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[str] param_group_id: Specifies the parameter group ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the RDS DB instance. If `period_unit` is set
               to *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This
               parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the RDS DB instance. Valid values
               are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a
               new resource.
        :param pulumi.Input[str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new rds instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group which the RDS DB instance belongs to.
        :param pulumi.Input[bool] ssl_enable: Specifies whether to enable the SSL for MySQL database.
        :param pulumi.Input[str] subnet_id: Specifies the network id of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
               pair.
        :param pulumi.Input[str] time_zone: Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
               and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
               Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
               zone is expressed as a character string, refer to
               [HuaweiCloud Document](https://support.huaweicloud.com/intl/en-us/api-rds/rds_01_0002.html#rds_01_0002__table613473883617)
               .
        :param pulumi.Input[pulumi.InputType['InstanceVolumeArgs']] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage RDS instance resource within HuaweiCloud.

        ## Example Usage
        ### create a single db instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="terraform security group acceptance test")
        instance = huaweicloud.rds.Instance("instance",
            flavor="rds.pg.n1.large.2",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            availability_zones=["{{ availability_zone }}"],
            db=huaweicloud.rds.InstanceDbArgs(
                type="PostgreSQL",
                version="12",
                password="Huangwei!120521",
            ),
            volume=huaweicloud.rds.InstanceVolumeArgs(
                type="ULTRAHIGH",
                size=100,
            ),
            backup_strategy=huaweicloud.rds.InstanceBackupStrategyArgs(
                start_time="08:00-09:00",
                keep_days=1,
            ))
        ```
        ### create a primary/standby db instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="terraform security group acceptance test")
        instance = huaweicloud.rds.Instance("instance",
            flavor="rds.pg.n1.large.2.ha",
            ha_replication_mode="async",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            availability_zones=[
                "{{ availability_zone_1 }}",
                "{{ availability_zone_2 }}",
            ],
            db=huaweicloud.rds.InstanceDbArgs(
                type="PostgreSQL",
                version="12",
                password="Huangwei!120521",
            ),
            volume=huaweicloud.rds.InstanceVolumeArgs(
                type="ULTRAHIGH",
                size=100,
            ),
            backup_strategy=huaweicloud.rds.InstanceBackupStrategyArgs(
                start_time="08:00-09:00",
                keep_days=1,
            ))
        ```
        ### create a single db instance with encrypted volume

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        key = huaweicloud.dew.Key("key",
            key_alias="key_1",
            key_description="first test key",
            is_enabled=True)
        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="security group acceptance test")
        instance = huaweicloud.rds.Instance("instance",
            flavor="rds.pg.n1.large.2",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            availability_zones=["{{ availability_zone }}"],
            db=huaweicloud.rds.InstanceDbArgs(
                type="PostgreSQL",
                version="12",
                password="Huangwei!120521",
            ),
            volume=huaweicloud.rds.InstanceVolumeArgs(
                type="ULTRAHIGH",
                size=100,
                disk_encryption_id=key.id,
            ),
            backup_strategy=huaweicloud.rds.InstanceBackupStrategyArgs(
                start_time="08:00-09:00",
                keep_days=1,
            ))
        ```

        ## Import

        RDS instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/instance:Instance instance_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

         But due to some attributes missing from the API response, it's required to ignore changes as below. resource "huaweicloud_rds_instance" "instance_1" {

         ...

         lifecycle {

         ignore_changes = [

         "db", "collation"

         ]

         } }

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 db: Optional[pulumi.Input[pulumi.InputType['InstanceDbArgs']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 ha_replication_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 param_group_id: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input[pulumi.InputType['InstanceVolumeArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["collation"] = collation
            if db is None and not opts.urn:
                raise TypeError("Missing required property 'db'")
            __props__.__dict__["db"] = db
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["fixed_ip"] = fixed_ip
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["ha_replication_mode"] = ha_replication_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["param_group_id"] = param_group_id
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssl_enable"] = ssl_enable
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone"] = time_zone
            if volume is None and not opts.urn:
                raise TypeError("Missing required property 'volume'")
            __props__.__dict__["volume"] = volume
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["public_ips"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'huaweicloud:Rds/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backup_strategy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            collation: Optional[pulumi.Input[str]] = None,
            created: Optional[pulumi.Input[str]] = None,
            db: Optional[pulumi.Input[pulumi.InputType['InstanceDbArgs']]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            fixed_ip: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            ha_replication_mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNodeArgs']]]]] = None,
            param_group_id: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            ssl_enable: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            volume: Optional[pulumi.Input[pulumi.InputType['InstanceVolumeArgs']]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the RDS DB instance. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[str] collation: Specifies the Character Set, only available to Microsoft SQL Server DB instances.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] created: Indicates the creation time.
        :param pulumi.Input[pulumi.InputType['InstanceDbArgs']] db: Specifies the database information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the RDS instance. Changing this
               parameter creates a new RDS instance.
        :param pulumi.Input[str] fixed_ip: Specifies an intranet floating IP address of RDS DB instance. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the specification code.
        :param pulumi.Input[str] ha_replication_mode: Specifies the replication mode for the standby DB instance.
               Changing this parameter will create a new resource.
               + For MySQL, the value is *async* or *semisync*.
               + For PostgreSQL, the value is *async* or *sync*.
               + For Microsoft SQL Server, the value is *sync*.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNodeArgs']]]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] param_group_id: Specifies the parameter group ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the RDS DB instance. If `period_unit` is set
               to *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This
               parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the RDS DB instance. Valid values
               are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a
               new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Indicates the private IP address list. It is a blank string until an ECS is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ips: Indicates the public IP address list.
        :param pulumi.Input[str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new rds instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group which the RDS DB instance belongs to.
        :param pulumi.Input[bool] ssl_enable: Specifies whether to enable the SSL for MySQL database.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the network id of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
               pair.
        :param pulumi.Input[str] time_zone: Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
               and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
               Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
               zone is expressed as a character string, refer to
               [HuaweiCloud Document](https://support.huaweicloud.com/intl/en-us/api-rds/rds_01_0002.html#rds_01_0002__table613473883617)
               .
        :param pulumi.Input[pulumi.InputType['InstanceVolumeArgs']] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["collation"] = collation
        __props__.__dict__["created"] = created
        __props__.__dict__["db"] = db
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["fixed_ip"] = fixed_ip
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["ha_replication_mode"] = ha_replication_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["param_group_id"] = param_group_id
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["public_ips"] = public_ips
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["volume"] = volume
        __props__.__dict__["vpc_id"] = vpc_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output['outputs.InstanceBackupStrategy']:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the RDS DB instance. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter
    def collation(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        Indicates the creation time.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def db(self) -> pulumi.Output['outputs.InstanceDb']:
        """
        Specifies the database information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "db")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the RDS instance. Changing this
        parameter creates a new RDS instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> pulumi.Output[str]:
        """
        Specifies an intranet floating IP address of RDS DB instance. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="haReplicationMode")
    def ha_replication_mode(self) -> pulumi.Output[str]:
        """
        Specifies the replication mode for the standby DB instance.
        Changing this parameter will create a new resource.
        + For MySQL, the value is *async* or *semisync*.
        + For PostgreSQL, the value is *async* or *sync*.
        + For Microsoft SQL Server, the value is *sync*.
        """
        return pulumi.get(self, "ha_replication_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.InstanceNode']]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="paramGroupId")
    def param_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the parameter group ID. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "param_group_id")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the RDS DB instance. If `period_unit` is set
        to *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This
        parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the RDS DB instance. Valid values
        are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a
        new resource.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the private IP address list. It is a blank string until an ECS is created.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the public IP address list.
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new rds instance resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the SSL for MySQL database.
        """
        return pulumi.get(self, "ssl_enable")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the network id of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
        pair.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
        and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
        Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
        zone is expressed as a character string, refer to
        [HuaweiCloud Document](https://support.huaweicloud.com/intl/en-us/api-rds/rds_01_0002.html#rds_01_0002__table613473883617)
        .
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Output['outputs.InstanceVolume']:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

