# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, datastore_type=None, enterprise_project_id=None, id=None, instances=None, name=None, region=None, subnet_id=None, type=None, vpc_id=None):
        if datastore_type and not isinstance(datastore_type, str):
            raise TypeError("Expected argument 'datastore_type' to be a str")
        pulumi.set(__self__, "datastore_type", datastore_type)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> Optional[str]:
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        Indicates the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        An array of available instances.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Indicates the node name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of the instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Indicates the network ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Indicates the volume type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        Indicates the VPC ID.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            datastore_type=self.datastore_type,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            instances=self.instances,
            name=self.name,
            region=self.region,
            subnet_id=self.subnet_id,
            type=self.type,
            vpc_id=self.vpc_id)


def get_instances(datastore_type: Optional[str] = None,
                  enterprise_project_id: Optional[str] = None,
                  name: Optional[str] = None,
                  region: Optional[str] = None,
                  subnet_id: Optional[str] = None,
                  type: Optional[str] = None,
                  vpc_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to list all available RDS instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    this = huaweicloud.Rds.get_instances(name="rds-instance")
    ```


    :param str datastore_type: Specifies the type of the database. Valid values are: MySQL, PostgreSQL, and SQLServer.
    :param str enterprise_project_id: Specifies the enterprise project id.
    :param str name: Specifies the name of the instance.
    :param str region: The region in which to obtain the instances. If omitted, the provider-level region will
           be used.
    :param str subnet_id: Specifies the network ID of a subnet.
    :param str type: Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
    :param str vpc_id: Specifies the VPC ID.
    """
    __args__ = dict()
    __args__['datastoreType'] = datastore_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['subnetId'] = subnet_id
    __args__['type'] = type
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Rds/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        datastore_type=__ret__.datastore_type,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        instances=__ret__.instances,
        name=__ret__.name,
        region=__ret__.region,
        subnet_id=__ret__.subnet_id,
        type=__ret__.type,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_instances)
def get_instances_output(datastore_type: Optional[pulumi.Input[Optional[str]]] = None,
                         enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                         name: Optional[pulumi.Input[Optional[str]]] = None,
                         region: Optional[pulumi.Input[Optional[str]]] = None,
                         subnet_id: Optional[pulumi.Input[Optional[str]]] = None,
                         type: Optional[pulumi.Input[Optional[str]]] = None,
                         vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to list all available RDS instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    this = huaweicloud.Rds.get_instances(name="rds-instance")
    ```


    :param str datastore_type: Specifies the type of the database. Valid values are: MySQL, PostgreSQL, and SQLServer.
    :param str enterprise_project_id: Specifies the enterprise project id.
    :param str name: Specifies the name of the instance.
    :param str region: The region in which to obtain the instances. If omitted, the provider-level region will
           be used.
    :param str subnet_id: Specifies the network ID of a subnet.
    :param str type: Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
    :param str vpc_id: Specifies the VPC ID.
    """
    ...
