# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, availability_zone=None, db_type=None, db_version=None, flavors=None, group_type=None, id=None, instance_mode=None, memory=None, region=None, vcpus=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if db_type and not isinstance(db_type, str):
            raise TypeError("Expected argument 'db_type' to be a str")
        pulumi.set(__self__, "db_type", db_type)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if group_type and not isinstance(group_type, str):
            raise TypeError("Expected argument 'group_type' to be a str")
        pulumi.set(__self__, "group_type", group_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_mode and not isinstance(instance_mode, str):
            raise TypeError("Expected argument 'instance_mode' to be a str")
        pulumi.set(__self__, "instance_mode", instance_mode)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="dbType")
    def db_type(self) -> str:
        return pulumi.get(self, "db_type")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[str]:
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[str]:
        """
        The performance specification.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceMode")
    def instance_mode(self) -> Optional[str]:
        """
        The mode of instance.
        """
        return pulumi.get(self, "instance_mode")

    @property
    @pulumi.getter
    def memory(self) -> Optional[int]:
        """
        The memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[int]:
        """
        The CPU size.
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            availability_zone=self.availability_zone,
            db_type=self.db_type,
            db_version=self.db_version,
            flavors=self.flavors,
            group_type=self.group_type,
            id=self.id,
            instance_mode=self.instance_mode,
            memory=self.memory,
            region=self.region,
            vcpus=self.vcpus)


def get_flavors(availability_zone: Optional[str] = None,
                db_type: Optional[str] = None,
                db_version: Optional[str] = None,
                group_type: Optional[str] = None,
                instance_mode: Optional[str] = None,
                memory: Optional[int] = None,
                region: Optional[str] = None,
                vcpus: Optional[int] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get available HuaweiCloud rds flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavor = huaweicloud.Rds.get_flavors(db_type="PostgreSQL",
        db_version="9.5",
        instance_mode="ha")
    ```


    :param str availability_zone: Specifies the availability zone which the RDS flavor belongs to.
    :param str db_type: Specifies the DB engine. Value: MySQL, PostgreSQL, SQLServer.
    :param str db_version: Specifies the database version. For more detail, please see
           [DB Engines and Versions](https://support.huaweicloud.com/intl/en-us/productdesc-rds/en-us_topic_0043898356.html).
           Available value:
    :param str group_type: Specifies the performance specification, the valid values are as follows:
           + **normal**: General enhanced.
           + **normal2**: General enhanced type II.
           + **armFlavors**: KunPeng general enhancement.
           + **dedicatedNormal**: (dedicatedNormalLocalssd): Dedicated for x86.
           + **armLocalssd**: KunPeng general type.
           + **normalLocalssd**: x86 general type.
           + **general**: General type.
           + **dedicated**:
           For MySQL engine: Dedicated type.
           For PostgreSQL and SQL Server engines: Dedicated type, only supported by cloud disk SSD.
           + **rapid**:
           For MySQL engine: Dedicated (discontinued).
           For PostgreSQL and SQL Server engines: Dedicated, only supported by ultra-fast SSDs.
           + **bigmem**: Large memory type.
    :param str instance_mode: The mode of instance. Value: *ha*(indicates primary/standby instance),
           *single*(indicates single instance) and *replica*(indicates read replicas).
    :param int memory: Specifies the memory size(GB) in the RDS flavor.
    :param str region: The region in which to obtain the RDS flavors. If omitted, the provider-level region
           will be used.
    :param int vcpus: Specifies the number of vCPUs in the RDS flavor.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['dbType'] = db_type
    __args__['dbVersion'] = db_version
    __args__['groupType'] = group_type
    __args__['instanceMode'] = instance_mode
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Rds/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        availability_zone=__ret__.availability_zone,
        db_type=__ret__.db_type,
        db_version=__ret__.db_version,
        flavors=__ret__.flavors,
        group_type=__ret__.group_type,
        id=__ret__.id,
        instance_mode=__ret__.instance_mode,
        memory=__ret__.memory,
        region=__ret__.region,
        vcpus=__ret__.vcpus)


@_utilities.lift_output_func(get_flavors)
def get_flavors_output(availability_zone: Optional[pulumi.Input[Optional[str]]] = None,
                       db_type: Optional[pulumi.Input[str]] = None,
                       db_version: Optional[pulumi.Input[Optional[str]]] = None,
                       group_type: Optional[pulumi.Input[Optional[str]]] = None,
                       instance_mode: Optional[pulumi.Input[Optional[str]]] = None,
                       memory: Optional[pulumi.Input[Optional[int]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       vcpus: Optional[pulumi.Input[Optional[int]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get available HuaweiCloud rds flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavor = huaweicloud.Rds.get_flavors(db_type="PostgreSQL",
        db_version="9.5",
        instance_mode="ha")
    ```


    :param str availability_zone: Specifies the availability zone which the RDS flavor belongs to.
    :param str db_type: Specifies the DB engine. Value: MySQL, PostgreSQL, SQLServer.
    :param str db_version: Specifies the database version. For more detail, please see
           [DB Engines and Versions](https://support.huaweicloud.com/intl/en-us/productdesc-rds/en-us_topic_0043898356.html).
           Available value:
    :param str group_type: Specifies the performance specification, the valid values are as follows:
           + **normal**: General enhanced.
           + **normal2**: General enhanced type II.
           + **armFlavors**: KunPeng general enhancement.
           + **dedicatedNormal**: (dedicatedNormalLocalssd): Dedicated for x86.
           + **armLocalssd**: KunPeng general type.
           + **normalLocalssd**: x86 general type.
           + **general**: General type.
           + **dedicated**:
           For MySQL engine: Dedicated type.
           For PostgreSQL and SQL Server engines: Dedicated type, only supported by cloud disk SSD.
           + **rapid**:
           For MySQL engine: Dedicated (discontinued).
           For PostgreSQL and SQL Server engines: Dedicated, only supported by ultra-fast SSDs.
           + **bigmem**: Large memory type.
    :param str instance_mode: The mode of instance. Value: *ha*(indicates primary/standby instance),
           *single*(indicates single instance) and *replica*(indicates read replicas).
    :param int memory: Specifies the memory size(GB) in the RDS flavor.
    :param str region: The region in which to obtain the RDS flavors. If omitted, the provider-level region
           will be used.
    :param int vcpus: Specifies the number of vCPUs in the RDS flavor.
    """
    ...
