# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 character_set: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[str] character_set: Specifies the character set used by the database, For example **utf8**,
               **gbk**, **ascii**, etc. Changing this will create a new resource.
        :param pulumi.Input[str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[str] description: Specifies the database description. The value can contain **0** to **512** characters.
               This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
               or **8.0.21.4**.
        :param pulumi.Input[str] name: Specifies the database name. The database name contains **1** to **64**
               characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
               ($). The total number of hyphens (-) and dollar signs ($) cannot exceed **10**. RDS for **MySQL 8.0** does not
               support dollar signs ($). Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the RDS database resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "instance_id", instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Input[str]:
        """
        Specifies the character set used by the database, For example **utf8**,
        **gbk**, **ascii**, etc. Changing this will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: pulumi.Input[str]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database description. The value can contain **0** to **512** characters.
        This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
        or **8.0.21.4**.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database name. The database name contains **1** to **64**
        characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
        ($). The total number of hyphens (-) and dollar signs ($) cannot exceed **10**. RDS for **MySQL 8.0** does not
        support dollar signs ($). Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the RDS database resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 character_set: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[str] character_set: Specifies the character set used by the database, For example **utf8**,
               **gbk**, **ascii**, etc. Changing this will create a new resource.
        :param pulumi.Input[str] description: Specifies the database description. The value can contain **0** to **512** characters.
               This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
               or **8.0.21.4**.
        :param pulumi.Input[str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[str] name: Specifies the database name. The database name contains **1** to **64**
               characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
               ($). The total number of hyphens (-) and dollar signs ($) cannot exceed **10**. RDS for **MySQL 8.0** does not
               support dollar signs ($). Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the RDS database resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the character set used by the database, For example **utf8**,
        **gbk**, **ascii**, etc. Changing this will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database description. The value can contain **0** to **512** characters.
        This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
        or **8.0.21.4**.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database name. The database name contains **1** to **64**
        characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
        ($). The total number of hyphens (-) and dollar signs ($) cannot exceed **10**. RDS for **MySQL 8.0** does not
        support dollar signs ($). Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the RDS database resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 character_set: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages RDS Mysql database resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = huaweicloud.rds.Database("test",
            instance_id=instance_id,
            character_set="utf8",
            description="test database")
        ```

        ## Import

        RDS database can be imported using the `instance id` and `database name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/database:Database database_1 instance_id/database_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] character_set: Specifies the character set used by the database, For example **utf8**,
               **gbk**, **ascii**, etc. Changing this will create a new resource.
        :param pulumi.Input[str] description: Specifies the database description. The value can contain **0** to **512** characters.
               This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
               or **8.0.21.4**.
        :param pulumi.Input[str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[str] name: Specifies the database name. The database name contains **1** to **64**
               characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
               ($). The total number of hyphens (-) and dollar signs ($) cannot exceed **10**. RDS for **MySQL 8.0** does not
               support dollar signs ($). Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the RDS database resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS Mysql database resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = huaweicloud.rds.Database("test",
            instance_id=instance_id,
            character_set="utf8",
            description="test database")
        ```

        ## Import

        RDS database can be imported using the `instance id` and `database name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/database:Database database_1 instance_id/database_name
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 character_set: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            if character_set is None and not opts.urn:
                raise TypeError("Missing required property 'character_set'")
            __props__.__dict__["character_set"] = character_set
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
        super(Database, __self__).__init__(
            'huaweicloud:Rds/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] character_set: Specifies the character set used by the database, For example **utf8**,
               **gbk**, **ascii**, etc. Changing this will create a new resource.
        :param pulumi.Input[str] description: Specifies the database description. The value can contain **0** to **512** characters.
               This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
               or **8.0.21.4**.
        :param pulumi.Input[str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[str] name: Specifies the database name. The database name contains **1** to **64**
               characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
               ($). The total number of hyphens (-) and dollar signs ($) cannot exceed **10**. RDS for **MySQL 8.0** does not
               support dollar signs ($). Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the RDS database resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[str]:
        """
        Specifies the character set used by the database, For example **utf8**,
        **gbk**, **ascii**, etc. Changing this will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the database description. The value can contain **0** to **512** characters.
        This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
        or **8.0.21.4**.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the database name. The database name contains **1** to **64**
        characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
        ($). The total number of hyphens (-) and dollar signs ($) cannot exceed **10**. RDS for **MySQL 8.0** does not
        support dollar signs ($). Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the RDS database resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

