# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MigrationTaskArgs', 'MigrationTask']

@pulumi.input_type
class MigrationTaskArgs:
    def __init__(__self__, *,
                 destination_object: pulumi.Input['MigrationTaskDestinationObjectArgs'],
                 source_object: pulumi.Input['MigrationTaskSourceObjectArgs'],
                 type: pulumi.Input[str],
                 bandwidth_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationTaskBandwidthPolicyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_failed_object_recording: Optional[pulumi.Input[bool]] = None,
                 enable_kms: Optional[pulumi.Input[bool]] = None,
                 enable_restore: Optional[pulumi.Input[bool]] = None,
                 migrate_since: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn_config: Optional[pulumi.Input['MigrationTaskSmnConfigArgs']] = None,
                 source_cdn: Optional[pulumi.Input['MigrationTaskSourceCdnArgs']] = None,
                 start_task: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a MigrationTask resource.
        :param pulumi.Input['MigrationTaskDestinationObjectArgs'] destination_object: Specifies the destination information. The object
               structure is documented below. Changing this creates a new resource.
        :param pulumi.Input['MigrationTaskSourceObjectArgs'] source_object: Specifies the source information. The object
               structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[str] type: Specifies the task type. The value can be:
               + **list**: indicates migrating objects using an object list.
               + **url_list**: indicates migrating objects using a URL object list.
               + **object**: indicates migrating selected files or folders.
               + **prefix**: indicates migrating objects with specified prefixes.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationTaskBandwidthPolicyArgs']]] bandwidth_policies: Specifies the traffic limit rules. Each element in the array
               corresponds to the maximum bandwidth of a time segment. A maximum of 5 time segments are allowed, and the time
               segments must not overlap. The object structure is  documented below.
        :param pulumi.Input[str] description: Specifies the description of the task.
               Changing this creates a new resource.
        :param pulumi.Input[bool] enable_failed_object_recording: Specifies whether to record failed objects. If this
               function is enabled, information about objects that fail to be migrated will be stored in the destination bucket.
               Default value: **true**. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_kms: Specifies whether to enable the KMS encryption function.
               Default value: **false**. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_restore: Specifies whether to automatically restore the archive data. If enabled,
               archive data is automatically restored and migrated. Default value: **false**. Changing this creates a new resource.
        :param pulumi.Input[str] migrate_since: Specifies a time in format **yyyy-MM-dd HH:mm:ss**,
               e.g. **2006-01-02 15:04:05**. The system migrates only the objects that are modified after the specified time.
               No time is specified by default. Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region where the destination bucket is located.
               Changing this creates a new resource.
        :param pulumi.Input['MigrationTaskSmnConfigArgs'] smn_config: Specifies the SMN message sending configuration.
               The object structure is  documented below. Changing this creates a new resource.
        :param pulumi.Input['MigrationTaskSourceCdnArgs'] source_cdn: Specifies the CDN information. If this parameter is contained,
               using CDN to download source data is supported, the source objects to be migrated are obtained from the CDN domain
               name during migration. The object structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[bool] start_task: Specifies whether to start the task. Default value: **true**.
        """
        pulumi.set(__self__, "destination_object", destination_object)
        pulumi.set(__self__, "source_object", source_object)
        pulumi.set(__self__, "type", type)
        if bandwidth_policies is not None:
            pulumi.set(__self__, "bandwidth_policies", bandwidth_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_failed_object_recording is not None:
            pulumi.set(__self__, "enable_failed_object_recording", enable_failed_object_recording)
        if enable_kms is not None:
            pulumi.set(__self__, "enable_kms", enable_kms)
        if enable_restore is not None:
            pulumi.set(__self__, "enable_restore", enable_restore)
        if migrate_since is not None:
            pulumi.set(__self__, "migrate_since", migrate_since)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if smn_config is not None:
            pulumi.set(__self__, "smn_config", smn_config)
        if source_cdn is not None:
            pulumi.set(__self__, "source_cdn", source_cdn)
        if start_task is not None:
            pulumi.set(__self__, "start_task", start_task)

    @property
    @pulumi.getter(name="destinationObject")
    def destination_object(self) -> pulumi.Input['MigrationTaskDestinationObjectArgs']:
        """
        Specifies the destination information. The object
        structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "destination_object")

    @destination_object.setter
    def destination_object(self, value: pulumi.Input['MigrationTaskDestinationObjectArgs']):
        pulumi.set(self, "destination_object", value)

    @property
    @pulumi.getter(name="sourceObject")
    def source_object(self) -> pulumi.Input['MigrationTaskSourceObjectArgs']:
        """
        Specifies the source information. The object
        structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "source_object")

    @source_object.setter
    def source_object(self, value: pulumi.Input['MigrationTaskSourceObjectArgs']):
        pulumi.set(self, "source_object", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the task type. The value can be:
        + **list**: indicates migrating objects using an object list.
        + **url_list**: indicates migrating objects using a URL object list.
        + **object**: indicates migrating selected files or folders.
        + **prefix**: indicates migrating objects with specified prefixes.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="bandwidthPolicies")
    def bandwidth_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationTaskBandwidthPolicyArgs']]]]:
        """
        Specifies the traffic limit rules. Each element in the array
        corresponds to the maximum bandwidth of a time segment. A maximum of 5 time segments are allowed, and the time
        segments must not overlap. The object structure is  documented below.
        """
        return pulumi.get(self, "bandwidth_policies")

    @bandwidth_policies.setter
    def bandwidth_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationTaskBandwidthPolicyArgs']]]]):
        pulumi.set(self, "bandwidth_policies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the task.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableFailedObjectRecording")
    def enable_failed_object_recording(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to record failed objects. If this
        function is enabled, information about objects that fail to be migrated will be stored in the destination bucket.
        Default value: **true**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_failed_object_recording")

    @enable_failed_object_recording.setter
    def enable_failed_object_recording(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_failed_object_recording", value)

    @property
    @pulumi.getter(name="enableKms")
    def enable_kms(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the KMS encryption function.
        Default value: **false**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_kms")

    @enable_kms.setter
    def enable_kms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kms", value)

    @property
    @pulumi.getter(name="enableRestore")
    def enable_restore(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically restore the archive data. If enabled,
        archive data is automatically restored and migrated. Default value: **false**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_restore")

    @enable_restore.setter
    def enable_restore(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_restore", value)

    @property
    @pulumi.getter(name="migrateSince")
    def migrate_since(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a time in format **yyyy-MM-dd HH:mm:ss**,
        e.g. **2006-01-02 15:04:05**. The system migrates only the objects that are modified after the specified time.
        No time is specified by default. Changing this creates a new resource.
        """
        return pulumi.get(self, "migrate_since")

    @migrate_since.setter
    def migrate_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migrate_since", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the destination bucket is located.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="smnConfig")
    def smn_config(self) -> Optional[pulumi.Input['MigrationTaskSmnConfigArgs']]:
        """
        Specifies the SMN message sending configuration.
        The object structure is  documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "smn_config")

    @smn_config.setter
    def smn_config(self, value: Optional[pulumi.Input['MigrationTaskSmnConfigArgs']]):
        pulumi.set(self, "smn_config", value)

    @property
    @pulumi.getter(name="sourceCdn")
    def source_cdn(self) -> Optional[pulumi.Input['MigrationTaskSourceCdnArgs']]:
        """
        Specifies the CDN information. If this parameter is contained,
        using CDN to download source data is supported, the source objects to be migrated are obtained from the CDN domain
        name during migration. The object structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "source_cdn")

    @source_cdn.setter
    def source_cdn(self, value: Optional[pulumi.Input['MigrationTaskSourceCdnArgs']]):
        pulumi.set(self, "source_cdn", value)

    @property
    @pulumi.getter(name="startTask")
    def start_task(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to start the task. Default value: **true**.
        """
        return pulumi.get(self, "start_task")

    @start_task.setter
    def start_task(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_task", value)


@pulumi.input_type
class _MigrationTaskState:
    def __init__(__self__, *,
                 bandwidth_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationTaskBandwidthPolicyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_object: Optional[pulumi.Input['MigrationTaskDestinationObjectArgs']] = None,
                 enable_failed_object_recording: Optional[pulumi.Input[bool]] = None,
                 enable_kms: Optional[pulumi.Input[bool]] = None,
                 enable_restore: Optional[pulumi.Input[bool]] = None,
                 migrate_since: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn_config: Optional[pulumi.Input['MigrationTaskSmnConfigArgs']] = None,
                 source_cdn: Optional[pulumi.Input['MigrationTaskSourceCdnArgs']] = None,
                 source_object: Optional[pulumi.Input['MigrationTaskSourceObjectArgs']] = None,
                 start_task: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MigrationTask resources.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationTaskBandwidthPolicyArgs']]] bandwidth_policies: Specifies the traffic limit rules. Each element in the array
               corresponds to the maximum bandwidth of a time segment. A maximum of 5 time segments are allowed, and the time
               segments must not overlap. The object structure is  documented below.
        :param pulumi.Input[str] description: Specifies the description of the task.
               Changing this creates a new resource.
        :param pulumi.Input['MigrationTaskDestinationObjectArgs'] destination_object: Specifies the destination information. The object
               structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_failed_object_recording: Specifies whether to record failed objects. If this
               function is enabled, information about objects that fail to be migrated will be stored in the destination bucket.
               Default value: **true**. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_kms: Specifies whether to enable the KMS encryption function.
               Default value: **false**. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_restore: Specifies whether to automatically restore the archive data. If enabled,
               archive data is automatically restored and migrated. Default value: **false**. Changing this creates a new resource.
        :param pulumi.Input[str] migrate_since: Specifies a time in format **yyyy-MM-dd HH:mm:ss**,
               e.g. **2006-01-02 15:04:05**. The system migrates only the objects that are modified after the specified time.
               No time is specified by default. Changing this creates a new resource.
        :param pulumi.Input[str] name: The name of the migration task.
        :param pulumi.Input[str] region: Specifies the region where the destination bucket is located.
               Changing this creates a new resource.
        :param pulumi.Input['MigrationTaskSmnConfigArgs'] smn_config: Specifies the SMN message sending configuration.
               The object structure is  documented below. Changing this creates a new resource.
        :param pulumi.Input['MigrationTaskSourceCdnArgs'] source_cdn: Specifies the CDN information. If this parameter is contained,
               using CDN to download source data is supported, the source objects to be migrated are obtained from the CDN domain
               name during migration. The object structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input['MigrationTaskSourceObjectArgs'] source_object: Specifies the source information. The object
               structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[bool] start_task: Specifies whether to start the task. Default value: **true**.
        :param pulumi.Input[int] status: The status the migration task. The value can be:
               + **1**: Waiting to migrate.
               + **2**: Migrating.
               + **3**: Migration paused.
               + **4**: Migration failed.
               + **5**: Migration succeeded.
        :param pulumi.Input[str] type: Specifies the task type. The value can be:
               + **list**: indicates migrating objects using an object list.
               + **url_list**: indicates migrating objects using a URL object list.
               + **object**: indicates migrating selected files or folders.
               + **prefix**: indicates migrating objects with specified prefixes.
        """
        if bandwidth_policies is not None:
            pulumi.set(__self__, "bandwidth_policies", bandwidth_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_object is not None:
            pulumi.set(__self__, "destination_object", destination_object)
        if enable_failed_object_recording is not None:
            pulumi.set(__self__, "enable_failed_object_recording", enable_failed_object_recording)
        if enable_kms is not None:
            pulumi.set(__self__, "enable_kms", enable_kms)
        if enable_restore is not None:
            pulumi.set(__self__, "enable_restore", enable_restore)
        if migrate_since is not None:
            pulumi.set(__self__, "migrate_since", migrate_since)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if smn_config is not None:
            pulumi.set(__self__, "smn_config", smn_config)
        if source_cdn is not None:
            pulumi.set(__self__, "source_cdn", source_cdn)
        if source_object is not None:
            pulumi.set(__self__, "source_object", source_object)
        if start_task is not None:
            pulumi.set(__self__, "start_task", start_task)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="bandwidthPolicies")
    def bandwidth_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationTaskBandwidthPolicyArgs']]]]:
        """
        Specifies the traffic limit rules. Each element in the array
        corresponds to the maximum bandwidth of a time segment. A maximum of 5 time segments are allowed, and the time
        segments must not overlap. The object structure is  documented below.
        """
        return pulumi.get(self, "bandwidth_policies")

    @bandwidth_policies.setter
    def bandwidth_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationTaskBandwidthPolicyArgs']]]]):
        pulumi.set(self, "bandwidth_policies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the task.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationObject")
    def destination_object(self) -> Optional[pulumi.Input['MigrationTaskDestinationObjectArgs']]:
        """
        Specifies the destination information. The object
        structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "destination_object")

    @destination_object.setter
    def destination_object(self, value: Optional[pulumi.Input['MigrationTaskDestinationObjectArgs']]):
        pulumi.set(self, "destination_object", value)

    @property
    @pulumi.getter(name="enableFailedObjectRecording")
    def enable_failed_object_recording(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to record failed objects. If this
        function is enabled, information about objects that fail to be migrated will be stored in the destination bucket.
        Default value: **true**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_failed_object_recording")

    @enable_failed_object_recording.setter
    def enable_failed_object_recording(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_failed_object_recording", value)

    @property
    @pulumi.getter(name="enableKms")
    def enable_kms(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the KMS encryption function.
        Default value: **false**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_kms")

    @enable_kms.setter
    def enable_kms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kms", value)

    @property
    @pulumi.getter(name="enableRestore")
    def enable_restore(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically restore the archive data. If enabled,
        archive data is automatically restored and migrated. Default value: **false**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_restore")

    @enable_restore.setter
    def enable_restore(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_restore", value)

    @property
    @pulumi.getter(name="migrateSince")
    def migrate_since(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a time in format **yyyy-MM-dd HH:mm:ss**,
        e.g. **2006-01-02 15:04:05**. The system migrates only the objects that are modified after the specified time.
        No time is specified by default. Changing this creates a new resource.
        """
        return pulumi.get(self, "migrate_since")

    @migrate_since.setter
    def migrate_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migrate_since", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the migration task.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the destination bucket is located.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="smnConfig")
    def smn_config(self) -> Optional[pulumi.Input['MigrationTaskSmnConfigArgs']]:
        """
        Specifies the SMN message sending configuration.
        The object structure is  documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "smn_config")

    @smn_config.setter
    def smn_config(self, value: Optional[pulumi.Input['MigrationTaskSmnConfigArgs']]):
        pulumi.set(self, "smn_config", value)

    @property
    @pulumi.getter(name="sourceCdn")
    def source_cdn(self) -> Optional[pulumi.Input['MigrationTaskSourceCdnArgs']]:
        """
        Specifies the CDN information. If this parameter is contained,
        using CDN to download source data is supported, the source objects to be migrated are obtained from the CDN domain
        name during migration. The object structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "source_cdn")

    @source_cdn.setter
    def source_cdn(self, value: Optional[pulumi.Input['MigrationTaskSourceCdnArgs']]):
        pulumi.set(self, "source_cdn", value)

    @property
    @pulumi.getter(name="sourceObject")
    def source_object(self) -> Optional[pulumi.Input['MigrationTaskSourceObjectArgs']]:
        """
        Specifies the source information. The object
        structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "source_object")

    @source_object.setter
    def source_object(self, value: Optional[pulumi.Input['MigrationTaskSourceObjectArgs']]):
        pulumi.set(self, "source_object", value)

    @property
    @pulumi.getter(name="startTask")
    def start_task(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to start the task. Default value: **true**.
        """
        return pulumi.get(self, "start_task")

    @start_task.setter
    def start_task(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_task", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The status the migration task. The value can be:
        + **1**: Waiting to migrate.
        + **2**: Migrating.
        + **3**: Migration paused.
        + **4**: Migration failed.
        + **5**: Migration succeeded.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the task type. The value can be:
        + **list**: indicates migrating objects using an object list.
        + **url_list**: indicates migrating objects using a URL object list.
        + **object**: indicates migrating selected files or folders.
        + **prefix**: indicates migrating objects with specified prefixes.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class MigrationTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationTaskBandwidthPolicyArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_object: Optional[pulumi.Input[pulumi.InputType['MigrationTaskDestinationObjectArgs']]] = None,
                 enable_failed_object_recording: Optional[pulumi.Input[bool]] = None,
                 enable_kms: Optional[pulumi.Input[bool]] = None,
                 enable_restore: Optional[pulumi.Input[bool]] = None,
                 migrate_since: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn_config: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSmnConfigArgs']]] = None,
                 source_cdn: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSourceCdnArgs']]] = None,
                 source_object: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSourceObjectArgs']]] = None,
                 start_task: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an OMS migration task resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        source_region = config.require_object("sourceRegion")
        source_bucket = config.require_object("sourceBucket")
        source_access_key = config.require_object("sourceAccessKey")
        source_secret_key = config.require_object("sourceSecretKey")
        dest_region = config.require_object("destRegion")
        dest_bucket = config.require_object("destBucket")
        dest_access_key = config.require_object("destAccessKey")
        dest_secret_key = config.require_object("destSecretKey")
        topic_urn = config.require_object("topicUrn")
        test = huaweicloud.oms.MigrationTask("test",
            source_object=huaweicloud.oms.MigrationTaskSourceObjectArgs(
                data_source="Aliyun",
                region=source_region,
                bucket=source_bucket,
                access_key=source_access_key,
                secret_key=source_secret_key,
                objects=[""],
            ),
            destination_object=huaweicloud.oms.MigrationTaskDestinationObjectArgs(
                region=dest_region,
                bucket=dest_bucket,
                access_key=dest_access_key,
                secret_key=dest_secret_key,
            ),
            type="object",
            description="test task",
            bandwidth_policies=[huaweicloud.oms.MigrationTaskBandwidthPolicyArgs(
                max_bandwidth=2,
                start="15:00",
                end="16:00",
            )],
            smn_config=huaweicloud.oms.MigrationTaskSmnConfigArgs(
                topic_urn=topic_urn,
                trigger_conditions=[
                    "FAILURE",
                    "SUCCESS",
                ],
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationTaskBandwidthPolicyArgs']]]] bandwidth_policies: Specifies the traffic limit rules. Each element in the array
               corresponds to the maximum bandwidth of a time segment. A maximum of 5 time segments are allowed, and the time
               segments must not overlap. The object structure is  documented below.
        :param pulumi.Input[str] description: Specifies the description of the task.
               Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MigrationTaskDestinationObjectArgs']] destination_object: Specifies the destination information. The object
               structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_failed_object_recording: Specifies whether to record failed objects. If this
               function is enabled, information about objects that fail to be migrated will be stored in the destination bucket.
               Default value: **true**. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_kms: Specifies whether to enable the KMS encryption function.
               Default value: **false**. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_restore: Specifies whether to automatically restore the archive data. If enabled,
               archive data is automatically restored and migrated. Default value: **false**. Changing this creates a new resource.
        :param pulumi.Input[str] migrate_since: Specifies a time in format **yyyy-MM-dd HH:mm:ss**,
               e.g. **2006-01-02 15:04:05**. The system migrates only the objects that are modified after the specified time.
               No time is specified by default. Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region where the destination bucket is located.
               Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MigrationTaskSmnConfigArgs']] smn_config: Specifies the SMN message sending configuration.
               The object structure is  documented below. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MigrationTaskSourceCdnArgs']] source_cdn: Specifies the CDN information. If this parameter is contained,
               using CDN to download source data is supported, the source objects to be migrated are obtained from the CDN domain
               name during migration. The object structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MigrationTaskSourceObjectArgs']] source_object: Specifies the source information. The object
               structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[bool] start_task: Specifies whether to start the task. Default value: **true**.
        :param pulumi.Input[str] type: Specifies the task type. The value can be:
               + **list**: indicates migrating objects using an object list.
               + **url_list**: indicates migrating objects using a URL object list.
               + **object**: indicates migrating selected files or folders.
               + **prefix**: indicates migrating objects with specified prefixes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an OMS migration task resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        source_region = config.require_object("sourceRegion")
        source_bucket = config.require_object("sourceBucket")
        source_access_key = config.require_object("sourceAccessKey")
        source_secret_key = config.require_object("sourceSecretKey")
        dest_region = config.require_object("destRegion")
        dest_bucket = config.require_object("destBucket")
        dest_access_key = config.require_object("destAccessKey")
        dest_secret_key = config.require_object("destSecretKey")
        topic_urn = config.require_object("topicUrn")
        test = huaweicloud.oms.MigrationTask("test",
            source_object=huaweicloud.oms.MigrationTaskSourceObjectArgs(
                data_source="Aliyun",
                region=source_region,
                bucket=source_bucket,
                access_key=source_access_key,
                secret_key=source_secret_key,
                objects=[""],
            ),
            destination_object=huaweicloud.oms.MigrationTaskDestinationObjectArgs(
                region=dest_region,
                bucket=dest_bucket,
                access_key=dest_access_key,
                secret_key=dest_secret_key,
            ),
            type="object",
            description="test task",
            bandwidth_policies=[huaweicloud.oms.MigrationTaskBandwidthPolicyArgs(
                max_bandwidth=2,
                start="15:00",
                end="16:00",
            )],
            smn_config=huaweicloud.oms.MigrationTaskSmnConfigArgs(
                topic_urn=topic_urn,
                trigger_conditions=[
                    "FAILURE",
                    "SUCCESS",
                ],
            ))
        ```

        :param str resource_name: The name of the resource.
        :param MigrationTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationTaskBandwidthPolicyArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_object: Optional[pulumi.Input[pulumi.InputType['MigrationTaskDestinationObjectArgs']]] = None,
                 enable_failed_object_recording: Optional[pulumi.Input[bool]] = None,
                 enable_kms: Optional[pulumi.Input[bool]] = None,
                 enable_restore: Optional[pulumi.Input[bool]] = None,
                 migrate_since: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn_config: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSmnConfigArgs']]] = None,
                 source_cdn: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSourceCdnArgs']]] = None,
                 source_object: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSourceObjectArgs']]] = None,
                 start_task: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationTaskArgs.__new__(MigrationTaskArgs)

            __props__.__dict__["bandwidth_policies"] = bandwidth_policies
            __props__.__dict__["description"] = description
            if destination_object is None and not opts.urn:
                raise TypeError("Missing required property 'destination_object'")
            __props__.__dict__["destination_object"] = destination_object
            __props__.__dict__["enable_failed_object_recording"] = enable_failed_object_recording
            __props__.__dict__["enable_kms"] = enable_kms
            __props__.__dict__["enable_restore"] = enable_restore
            __props__.__dict__["migrate_since"] = migrate_since
            __props__.__dict__["region"] = region
            __props__.__dict__["smn_config"] = smn_config
            __props__.__dict__["source_cdn"] = source_cdn
            if source_object is None and not opts.urn:
                raise TypeError("Missing required property 'source_object'")
            __props__.__dict__["source_object"] = source_object
            __props__.__dict__["start_task"] = start_task
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["name"] = None
            __props__.__dict__["status"] = None
        super(MigrationTask, __self__).__init__(
            'huaweicloud:Oms/migrationTask:MigrationTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationTaskBandwidthPolicyArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_object: Optional[pulumi.Input[pulumi.InputType['MigrationTaskDestinationObjectArgs']]] = None,
            enable_failed_object_recording: Optional[pulumi.Input[bool]] = None,
            enable_kms: Optional[pulumi.Input[bool]] = None,
            enable_restore: Optional[pulumi.Input[bool]] = None,
            migrate_since: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            smn_config: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSmnConfigArgs']]] = None,
            source_cdn: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSourceCdnArgs']]] = None,
            source_object: Optional[pulumi.Input[pulumi.InputType['MigrationTaskSourceObjectArgs']]] = None,
            start_task: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'MigrationTask':
        """
        Get an existing MigrationTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationTaskBandwidthPolicyArgs']]]] bandwidth_policies: Specifies the traffic limit rules. Each element in the array
               corresponds to the maximum bandwidth of a time segment. A maximum of 5 time segments are allowed, and the time
               segments must not overlap. The object structure is  documented below.
        :param pulumi.Input[str] description: Specifies the description of the task.
               Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MigrationTaskDestinationObjectArgs']] destination_object: Specifies the destination information. The object
               structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_failed_object_recording: Specifies whether to record failed objects. If this
               function is enabled, information about objects that fail to be migrated will be stored in the destination bucket.
               Default value: **true**. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_kms: Specifies whether to enable the KMS encryption function.
               Default value: **false**. Changing this creates a new resource.
        :param pulumi.Input[bool] enable_restore: Specifies whether to automatically restore the archive data. If enabled,
               archive data is automatically restored and migrated. Default value: **false**. Changing this creates a new resource.
        :param pulumi.Input[str] migrate_since: Specifies a time in format **yyyy-MM-dd HH:mm:ss**,
               e.g. **2006-01-02 15:04:05**. The system migrates only the objects that are modified after the specified time.
               No time is specified by default. Changing this creates a new resource.
        :param pulumi.Input[str] name: The name of the migration task.
        :param pulumi.Input[str] region: Specifies the region where the destination bucket is located.
               Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MigrationTaskSmnConfigArgs']] smn_config: Specifies the SMN message sending configuration.
               The object structure is  documented below. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MigrationTaskSourceCdnArgs']] source_cdn: Specifies the CDN information. If this parameter is contained,
               using CDN to download source data is supported, the source objects to be migrated are obtained from the CDN domain
               name during migration. The object structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MigrationTaskSourceObjectArgs']] source_object: Specifies the source information. The object
               structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[bool] start_task: Specifies whether to start the task. Default value: **true**.
        :param pulumi.Input[int] status: The status the migration task. The value can be:
               + **1**: Waiting to migrate.
               + **2**: Migrating.
               + **3**: Migration paused.
               + **4**: Migration failed.
               + **5**: Migration succeeded.
        :param pulumi.Input[str] type: Specifies the task type. The value can be:
               + **list**: indicates migrating objects using an object list.
               + **url_list**: indicates migrating objects using a URL object list.
               + **object**: indicates migrating selected files or folders.
               + **prefix**: indicates migrating objects with specified prefixes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MigrationTaskState.__new__(_MigrationTaskState)

        __props__.__dict__["bandwidth_policies"] = bandwidth_policies
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_object"] = destination_object
        __props__.__dict__["enable_failed_object_recording"] = enable_failed_object_recording
        __props__.__dict__["enable_kms"] = enable_kms
        __props__.__dict__["enable_restore"] = enable_restore
        __props__.__dict__["migrate_since"] = migrate_since
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["smn_config"] = smn_config
        __props__.__dict__["source_cdn"] = source_cdn
        __props__.__dict__["source_object"] = source_object
        __props__.__dict__["start_task"] = start_task
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return MigrationTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bandwidthPolicies")
    def bandwidth_policies(self) -> pulumi.Output[Optional[Sequence['outputs.MigrationTaskBandwidthPolicy']]]:
        """
        Specifies the traffic limit rules. Each element in the array
        corresponds to the maximum bandwidth of a time segment. A maximum of 5 time segments are allowed, and the time
        segments must not overlap. The object structure is  documented below.
        """
        return pulumi.get(self, "bandwidth_policies")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the task.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationObject")
    def destination_object(self) -> pulumi.Output['outputs.MigrationTaskDestinationObject']:
        """
        Specifies the destination information. The object
        structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "destination_object")

    @property
    @pulumi.getter(name="enableFailedObjectRecording")
    def enable_failed_object_recording(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to record failed objects. If this
        function is enabled, information about objects that fail to be migrated will be stored in the destination bucket.
        Default value: **true**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_failed_object_recording")

    @property
    @pulumi.getter(name="enableKms")
    def enable_kms(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the KMS encryption function.
        Default value: **false**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_kms")

    @property
    @pulumi.getter(name="enableRestore")
    def enable_restore(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically restore the archive data. If enabled,
        archive data is automatically restored and migrated. Default value: **false**. Changing this creates a new resource.
        """
        return pulumi.get(self, "enable_restore")

    @property
    @pulumi.getter(name="migrateSince")
    def migrate_since(self) -> pulumi.Output[str]:
        """
        Specifies a time in format **yyyy-MM-dd HH:mm:ss**,
        e.g. **2006-01-02 15:04:05**. The system migrates only the objects that are modified after the specified time.
        No time is specified by default. Changing this creates a new resource.
        """
        return pulumi.get(self, "migrate_since")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the migration task.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region where the destination bucket is located.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="smnConfig")
    def smn_config(self) -> pulumi.Output[Optional['outputs.MigrationTaskSmnConfig']]:
        """
        Specifies the SMN message sending configuration.
        The object structure is  documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "smn_config")

    @property
    @pulumi.getter(name="sourceCdn")
    def source_cdn(self) -> pulumi.Output[Optional['outputs.MigrationTaskSourceCdn']]:
        """
        Specifies the CDN information. If this parameter is contained,
        using CDN to download source data is supported, the source objects to be migrated are obtained from the CDN domain
        name during migration. The object structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "source_cdn")

    @property
    @pulumi.getter(name="sourceObject")
    def source_object(self) -> pulumi.Output['outputs.MigrationTaskSourceObject']:
        """
        Specifies the source information. The object
        structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "source_object")

    @property
    @pulumi.getter(name="startTask")
    def start_task(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to start the task. Default value: **true**.
        """
        return pulumi.get(self, "start_task")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        The status the migration task. The value can be:
        + **1**: Waiting to migrate.
        + **2**: Migrating.
        + **3**: Migration paused.
        + **4**: Migration failed.
        + **5**: Migration succeeded.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the task type. The value can be:
        + **list**: indicates migrating objects using an object list.
        + **url_list**: indicates migrating objects using a URL object list.
        + **object**: indicates migrating selected files or folders.
        + **prefix**: indicates migrating objects with specified prefixes.
        """
        return pulumi.get(self, "type")

