# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'MigrationTaskBandwidthPolicyArgs',
    'MigrationTaskDestinationObjectArgs',
    'MigrationTaskSmnConfigArgs',
    'MigrationTaskSourceCdnArgs',
    'MigrationTaskSourceObjectArgs',
]

@pulumi.input_type
class MigrationTaskBandwidthPolicyArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 max_bandwidth: pulumi.Input[int],
                 start: pulumi.Input[str]):
        """
        :param pulumi.Input[str] end: Specifies the end time of the traffic limit rule. The format is **hh:mm**,
               e.g. **12:03**.
        :param pulumi.Input[int] max_bandwidth: Specifies the maximum traffic bandwidth allowed in the specified time
               segment. The unit is byte/s. The value ranges from **1** MB/s to **200** MB/s.
        :param pulumi.Input[str] start: Specifies the start time of the traffic limit rule. The format is **hh:mm**,
               e.g. **12:03**.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "max_bandwidth", max_bandwidth)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        Specifies the end time of the traffic limit rule. The format is **hh:mm**,
        e.g. **12:03**.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter(name="maxBandwidth")
    def max_bandwidth(self) -> pulumi.Input[int]:
        """
        Specifies the maximum traffic bandwidth allowed in the specified time
        segment. The unit is byte/s. The value ranges from **1** MB/s to **200** MB/s.
        """
        return pulumi.get(self, "max_bandwidth")

    @max_bandwidth.setter
    def max_bandwidth(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_bandwidth", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        Specifies the start time of the traffic limit rule. The format is **hh:mm**,
        e.g. **12:03**.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class MigrationTaskDestinationObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 region: pulumi.Input[str],
                 access_key: Optional[pulumi.Input[str]] = None,
                 save_prefix: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 security_token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Specifies the name of the destination bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region where the destination bucket is located.
               Changing this creates a new resource.
        :param pulumi.Input[str] access_key: Specifies the access key for accessing the destination bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] save_prefix: Specifies the path prefix in the destination bucket. The prefix is added
               before the object key to form a new key. Changing this creates a new resource.
        :param pulumi.Input[str] secret_key: Specifies the secret key for accessing the destination bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] security_token: Specifies the temporary token for accessing the destination bucket.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "region", region)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if save_prefix is not None:
            pulumi.set(__self__, "save_prefix", save_prefix)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if security_token is not None:
            pulumi.set(__self__, "security_token", security_token)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Specifies the name of the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Specifies the region where the destination bucket is located.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the access key for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="savePrefix")
    def save_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path prefix in the destination bucket. The prefix is added
        before the object key to form a new key. Changing this creates a new resource.
        """
        return pulumi.get(self, "save_prefix")

    @save_prefix.setter
    def save_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "save_prefix", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the secret key for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the temporary token for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "security_token")

    @security_token.setter
    def security_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_token", value)


@pulumi.input_type
class MigrationTaskSmnConfigArgs:
    def __init__(__self__, *,
                 topic_urn: pulumi.Input[str],
                 trigger_conditions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 language: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] topic_urn: Specifies the SMN message topic URN bound to a migration task.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trigger_conditions: Specifies the trigger conditions of sending messages using SMN.
               The value can be:
               + **FAILURE**: indicates that an SMN message will be sent after the migration task fails.
               + **SUCCESS**: indicates that an SMN message will be sent after the migration task succeeds.
        :param pulumi.Input[str] language: Specifies the SMN message language. The value can be **zh-cn** or
               **en-us**. Default value: **en-us**. Changing this creates a new resource.
        """
        pulumi.set(__self__, "topic_urn", topic_urn)
        pulumi.set(__self__, "trigger_conditions", trigger_conditions)
        if language is not None:
            pulumi.set(__self__, "language", language)

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Input[str]:
        """
        Specifies the SMN message topic URN bound to a migration task.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_urn", value)

    @property
    @pulumi.getter(name="triggerConditions")
    def trigger_conditions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the trigger conditions of sending messages using SMN.
        The value can be:
        + **FAILURE**: indicates that an SMN message will be sent after the migration task fails.
        + **SUCCESS**: indicates that an SMN message will be sent after the migration task succeeds.
        """
        return pulumi.get(self, "trigger_conditions")

    @trigger_conditions.setter
    def trigger_conditions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "trigger_conditions", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SMN message language. The value can be **zh-cn** or
        **en-us**. Default value: **en-us**. Changing this creates a new resource.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)


@pulumi.input_type
class MigrationTaskSourceCdnArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 authentication_key: Optional[pulumi.Input[str]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain: Specifies the domain name from which to obtain objects to be migrated.
               Changing this creates a new resource.
        :param pulumi.Input[str] protocol: Specifies the protocol type. Valid values are **HTTP** and **HTTPS**.
               Changing this creates a new resource.
        :param pulumi.Input[str] authentication_key: Specifies the CDN authentication key.
               Changing this creates a new resource.
        :param pulumi.Input[str] authentication_type: Specifies the authentication type. Valid values are **NONE**,
               **QINIU_PRIVATE_AUTHENTICATION**, **ALIYUN_OSS_A**, **ALIYUN_OSS_B**, **ALIYUN_OSS_C**,
               **KSYUN_PRIVATE_AUTHENTICATION**. Default value: **None**. Changing this creates a new resource.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "protocol", protocol)
        if authentication_key is not None:
            pulumi.set(__self__, "authentication_key", authentication_key)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        Specifies the domain name from which to obtain objects to be migrated.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Specifies the protocol type. Valid values are **HTTP** and **HTTPS**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="authenticationKey")
    def authentication_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the CDN authentication key.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "authentication_key")

    @authentication_key.setter
    def authentication_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_key", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authentication type. Valid values are **NONE**,
        **QINIU_PRIVATE_AUTHENTICATION**, **ALIYUN_OSS_A**, **ALIYUN_OSS_B**, **ALIYUN_OSS_C**,
        **KSYUN_PRIVATE_AUTHENTICATION**. Default value: **None**. Changing this creates a new resource.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)


@pulumi.input_type
class MigrationTaskSourceObjectArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 list_file_bucket: Optional[pulumi.Input[str]] = None,
                 list_file_key: Optional[pulumi.Input[str]] = None,
                 objects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 security_token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_key: Specifies the access key for accessing the destination bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] app_id: Specifies the APP ID. This parameter is mandatory when `data_source` is  
               **Tencent**. Changing this creates a new resource.
        :param pulumi.Input[str] bucket: Specifies the name of the destination bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] data_source: Specifies the source cloud service provider. If `type` is
               **url_list**,set this parameter to **URLSource**. The value can be **AWS**, **Azure**, **Aliyun**, **Tencent**,
               **HuaweiCloud**, **QingCloud**, **KingsoftCloud**, **Baidu**, **Qiniu**, **URLSource** and **UCloud**.
               The default value is **Aliyun**. Changing this creates a new resource.
        :param pulumi.Input[str] list_file_bucket: Specifies the name of the OBS bucket for storing the object list files.
               `list_file_bucket` is mandatory when `type` is set to **list** or **url_list**. Changing this creates a new resource.
        :param pulumi.Input[str] list_file_key: Specifies the object name of the list file or URL list file.
               `list_file_key` is mandatory when `type` is set to **list** or **url_list**. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] objects: Specifies the list of object keys.
               + If `type` is set to **object**, this parameter specifies the names of the objects to be migrated. The strings
               ending with a slash (/) indicate the folders to be migrated, and the strings not ending with a slash (/) indicate the
               files to be migrated.
               + If `type` is set to **prefix**, this parameter indicates the name prefixes of the objects to be migrated.
               Set this parameter to [""] to migrate the entire bucket
        :param pulumi.Input[str] region: Specifies the region where the destination bucket is located.
               Changing this creates a new resource.
        :param pulumi.Input[str] secret_key: Specifies the secret key for accessing the destination bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] security_token: Specifies the temporary token for accessing the destination bucket.
               Changing this creates a new resource.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if list_file_bucket is not None:
            pulumi.set(__self__, "list_file_bucket", list_file_bucket)
        if list_file_key is not None:
            pulumi.set(__self__, "list_file_key", list_file_key)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if security_token is not None:
            pulumi.set(__self__, "security_token", security_token)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the access key for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the APP ID. This parameter is mandatory when `data_source` is  
        **Tencent**. Changing this creates a new resource.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the source cloud service provider. If `type` is
        **url_list**,set this parameter to **URLSource**. The value can be **AWS**, **Azure**, **Aliyun**, **Tencent**,
        **HuaweiCloud**, **QingCloud**, **KingsoftCloud**, **Baidu**, **Qiniu**, **URLSource** and **UCloud**.
        The default value is **Aliyun**. Changing this creates a new resource.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="listFileBucket")
    def list_file_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the OBS bucket for storing the object list files.
        `list_file_bucket` is mandatory when `type` is set to **list** or **url_list**. Changing this creates a new resource.
        """
        return pulumi.get(self, "list_file_bucket")

    @list_file_bucket.setter
    def list_file_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "list_file_bucket", value)

    @property
    @pulumi.getter(name="listFileKey")
    def list_file_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the object name of the list file or URL list file.
        `list_file_key` is mandatory when `type` is set to **list** or **url_list**. Changing this creates a new resource.
        """
        return pulumi.get(self, "list_file_key")

    @list_file_key.setter
    def list_file_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "list_file_key", value)

    @property
    @pulumi.getter
    def objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of object keys.
        + If `type` is set to **object**, this parameter specifies the names of the objects to be migrated. The strings
        ending with a slash (/) indicate the folders to be migrated, and the strings not ending with a slash (/) indicate the
        files to be migrated.
        + If `type` is set to **prefix**, this parameter indicates the name prefixes of the objects to be migrated.
        Set this parameter to [""] to migrate the entire bucket
        """
        return pulumi.get(self, "objects")

    @objects.setter
    def objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "objects", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the destination bucket is located.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the secret key for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the temporary token for accessing the destination bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "security_token")

    @security_token.setter
    def security_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_token", value)


