# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBucketsResult',
    'AwaitableGetBucketsResult',
    'get_buckets',
    'get_buckets_output',
]

@pulumi.output_type
class GetBucketsResult:
    """
    A collection of values returned by getBuckets.
    """
    def __init__(__self__, bucket=None, buckets=None, enterprise_project_id=None, id=None, region=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if buckets and not isinstance(buckets, list):
            raise TypeError("Expected argument 'buckets' to be a list")
        pulumi.set(__self__, "buckets", buckets)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The name of the OBS bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def buckets(self) -> Sequence['outputs.GetBucketsBucketResult']:
        """
        A list of OBS buckets.
        """
        return pulumi.get(self, "buckets")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project id of the OBS bucket.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region where the OBS bucket belongs.
        """
        return pulumi.get(self, "region")


class AwaitableGetBucketsResult(GetBucketsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketsResult(
            bucket=self.bucket,
            buckets=self.buckets,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            region=self.region)


def get_buckets(bucket: Optional[str] = None,
                enterprise_project_id: Optional[str] = None,
                region: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketsResult:
    """
    Use this data source to get all OBS buckets.

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    buckets = huaweicloud.Obs.get_buckets(bucket="your-bucket-name")
    ```


    :param str bucket: The name of the OBS bucket.
    :param str enterprise_project_id: The enterprise project id of the OBS bucket.
    :param str region: The region in which to obtain the OBS bucket.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Obs/getBuckets:getBuckets', __args__, opts=opts, typ=GetBucketsResult).value

    return AwaitableGetBucketsResult(
        bucket=__ret__.bucket,
        buckets=__ret__.buckets,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        region=__ret__.region)


@_utilities.lift_output_func(get_buckets)
def get_buckets_output(bucket: Optional[pulumi.Input[Optional[str]]] = None,
                       enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBucketsResult]:
    """
    Use this data source to get all OBS buckets.

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    buckets = huaweicloud.Obs.get_buckets(bucket="your-bucket-name")
    ```


    :param str bucket: The name of the OBS bucket.
    :param str enterprise_project_id: The enterprise project id of the OBS bucket.
    :param str region: The region in which to obtain the OBS bucket.
           If omitted, the provider-level region will be used.
    """
    ...
