# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetBucketObjectResult',
    'AwaitableGetBucketObjectResult',
    'get_bucket_object',
    'get_bucket_object_output',
]

@pulumi.output_type
class GetBucketObjectResult:
    """
    A collection of values returned by getBucketObject.
    """
    def __init__(__self__, body=None, bucket=None, content_type=None, etag=None, id=None, key=None, region=None, size=None, storage_class=None, version_id=None):
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if storage_class and not isinstance(storage_class, str):
            raise TypeError("Expected argument 'storage_class' to be a str")
        pulumi.set(__self__, "storage_class", storage_class)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        The content of an object which is available only for objects which have a human-readable Content-Type
        (text/* and application/json) and smaller than **64KB**. This is to prevent printing unsafe characters and
        potentially downloading large amount of data.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        a standard MIME type describing the format of the object data, e.g. application/octet-stream. All
        Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        the ETag generated for the object (an MD5 sum of the object content). When the object is encrypted on the
        server side, the ETag value is not the MD5 value of the object, but the unique identifier calculated through the
        server-side encryption.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        the size of the object in bytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        specifies the storage class of the object.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> str:
        """
        a unique version ID value for the object, if bucket versioning is enabled.
        """
        return pulumi.get(self, "version_id")


class AwaitableGetBucketObjectResult(GetBucketObjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketObjectResult(
            body=self.body,
            bucket=self.bucket,
            content_type=self.content_type,
            etag=self.etag,
            id=self.id,
            key=self.key,
            region=self.region,
            size=self.size,
            storage_class=self.storage_class,
            version_id=self.version_id)


def get_bucket_object(bucket: Optional[str] = None,
                      key: Optional[str] = None,
                      region: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketObjectResult:
    """
    Use this data source to get info of special HuaweiCloud obs object.

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    object = huaweicloud.Obs.get_bucket_object(bucket="my-test-bucket",
        key="new-key")
    ```


    :param str bucket: The name of the bucket to put the file in.
    :param str key: The name of the object once it is in the bucket.
    :param str region: The region in which to obtain the OBS object. If omitted, the provider-level region will
           be used.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['key'] = key
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Obs/getBucketObject:getBucketObject', __args__, opts=opts, typ=GetBucketObjectResult).value

    return AwaitableGetBucketObjectResult(
        body=__ret__.body,
        bucket=__ret__.bucket,
        content_type=__ret__.content_type,
        etag=__ret__.etag,
        id=__ret__.id,
        key=__ret__.key,
        region=__ret__.region,
        size=__ret__.size,
        storage_class=__ret__.storage_class,
        version_id=__ret__.version_id)


@_utilities.lift_output_func(get_bucket_object)
def get_bucket_object_output(bucket: Optional[pulumi.Input[str]] = None,
                             key: Optional[pulumi.Input[str]] = None,
                             region: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBucketObjectResult]:
    """
    Use this data source to get info of special HuaweiCloud obs object.

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    object = huaweicloud.Obs.get_bucket_object(bucket="my-test-bucket",
        key="new-key")
    ```


    :param str bucket: The name of the bucket to put the file in.
    :param str key: The name of the object once it is in the bucket.
    :param str region: The region in which to obtain the OBS object. If omitted, the provider-level region will
           be used.
    """
    ...
