# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SnatRuleArgs', 'SnatRule']

@pulumi.input_type
class SnatRuleArgs:
    def __init__(__self__, *,
                 floating_ip_id: pulumi.Input[str],
                 nat_gateway_id: pulumi.Input[str],
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SnatRule resource.
        :param pulumi.Input[str] floating_ip_id: Specifies the EIP ID this snat rule connects to.
               Multiple EIPs are separated using commas (,). The number of EIP IDs cannot exceed 20.
        :param pulumi.Input[str] nat_gateway_id: ID of the nat gateway this snat rule belongs to. Changing this creates
               a new snat rule.
        :param pulumi.Input[str] cidr: Specifies CIDR, which can be in the format of a network segment or a host IP
               address. This parameter and `subnet_id` are alternative. Changing this creates a new snat rule.
        :param pulumi.Input[str] description: Specifies the description of the snat rule.
               The value is a string of no more than 255 characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[str] region: The region in which to create the snat rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new snat rule resource.
        :param pulumi.Input[int] source_type: Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct
               Connect scenario). Defaults to 0, only `cidr` can be specified over a Direct Connect connection. Changing this creates
               a new snat rule.
        :param pulumi.Input[str] subnet_id: ID of the subnet this snat rule connects to. This parameter and `cidr` are
               alternative. Changing this creates a new snat rule.
        """
        pulumi.set(__self__, "floating_ip_id", floating_ip_id)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_id is not None:
            warnings.warn("""use subnet_id instead""", DeprecationWarning)
            pulumi.log.warn("""network_id is deprecated: use subnet_id instead""")
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> pulumi.Input[str]:
        """
        Specifies the EIP ID this snat rule connects to.
        Multiple EIPs are separated using commas (,). The number of EIP IDs cannot exceed 20.
        """
        return pulumi.get(self, "floating_ip_id")

    @floating_ip_id.setter
    def floating_ip_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "floating_ip_id", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Input[str]:
        """
        ID of the nat gateway this snat rule belongs to. Changing this creates
        a new snat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies CIDR, which can be in the format of a network segment or a host IP
        address. This parameter and `subnet_id` are alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the snat rule.
        The value is a string of no more than 255 characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the snat rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new snat rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct
        Connect scenario). Defaults to 0, only `cidr` can be specified over a Direct Connect connection. Changing this creates
        a new snat rule.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the subnet this snat rule connects to. This parameter and `cidr` are
        alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _SnatRuleState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 floating_ip_address: Optional[pulumi.Input[str]] = None,
                 floating_ip_id: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SnatRule resources.
        :param pulumi.Input[str] cidr: Specifies CIDR, which can be in the format of a network segment or a host IP
               address. This parameter and `subnet_id` are alternative. Changing this creates a new snat rule.
        :param pulumi.Input[str] description: Specifies the description of the snat rule.
               The value is a string of no more than 255 characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[str] floating_ip_address: The actual floating IP address.
        :param pulumi.Input[str] floating_ip_id: Specifies the EIP ID this snat rule connects to.
               Multiple EIPs are separated using commas (,). The number of EIP IDs cannot exceed 20.
        :param pulumi.Input[str] nat_gateway_id: ID of the nat gateway this snat rule belongs to. Changing this creates
               a new snat rule.
        :param pulumi.Input[str] region: The region in which to create the snat rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new snat rule resource.
        :param pulumi.Input[int] source_type: Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct
               Connect scenario). Defaults to 0, only `cidr` can be specified over a Direct Connect connection. Changing this creates
               a new snat rule.
        :param pulumi.Input[str] status: The status of the snat rule.
        :param pulumi.Input[str] subnet_id: ID of the subnet this snat rule connects to. This parameter and `cidr` are
               alternative. Changing this creates a new snat rule.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if floating_ip_address is not None:
            pulumi.set(__self__, "floating_ip_address", floating_ip_address)
        if floating_ip_id is not None:
            pulumi.set(__self__, "floating_ip_id", floating_ip_id)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if network_id is not None:
            warnings.warn("""use subnet_id instead""", DeprecationWarning)
            pulumi.log.warn("""network_id is deprecated: use subnet_id instead""")
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies CIDR, which can be in the format of a network segment or a host IP
        address. This parameter and `subnet_id` are alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the snat rule.
        The value is a string of no more than 255 characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="floatingIpAddress")
    def floating_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The actual floating IP address.
        """
        return pulumi.get(self, "floating_ip_address")

    @floating_ip_address.setter
    def floating_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "floating_ip_address", value)

    @property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP ID this snat rule connects to.
        Multiple EIPs are separated using commas (,). The number of EIP IDs cannot exceed 20.
        """
        return pulumi.get(self, "floating_ip_id")

    @floating_ip_id.setter
    def floating_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "floating_ip_id", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the nat gateway this snat rule belongs to. Changing this creates
        a new snat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the snat rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new snat rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct
        Connect scenario). Defaults to 0, only `cidr` can be specified over a Direct Connect connection. Changing this creates
        a new snat rule.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the snat rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the subnet this snat rule connects to. This parameter and `cidr` are
        alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


class SnatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 floating_ip_id: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a SNAT rule resource within HuaweiCloud.

        ## Example Usage
        ### SNAT rule in VPC scenario

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        snat1 = huaweicloud.nat.SnatRule("snat1",
            nat_gateway_id=var["natgw_id"],
            floating_ip_id=var["publicip_id"],
            subnet_id=var["subent_id"])
        ```
        ### SNAT rule in Direct Connect scenario

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        snat2 = huaweicloud.nat.SnatRule("snat2",
            nat_gateway_id=var["natgw_id"],
            floating_ip_id=var["publicip_id"],
            source_type=1,
            cidr="192.168.10.0/24")
        ```

        ## Import

        SNAT rules can be imported using the following format

        ```sh
         $ pulumi import huaweicloud:Nat/snatRule:SnatRule snat_1 9e0713cb-0a2f-484e-8c7d-daecbb61dbe4
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: Specifies CIDR, which can be in the format of a network segment or a host IP
               address. This parameter and `subnet_id` are alternative. Changing this creates a new snat rule.
        :param pulumi.Input[str] description: Specifies the description of the snat rule.
               The value is a string of no more than 255 characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[str] floating_ip_id: Specifies the EIP ID this snat rule connects to.
               Multiple EIPs are separated using commas (,). The number of EIP IDs cannot exceed 20.
        :param pulumi.Input[str] nat_gateway_id: ID of the nat gateway this snat rule belongs to. Changing this creates
               a new snat rule.
        :param pulumi.Input[str] region: The region in which to create the snat rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new snat rule resource.
        :param pulumi.Input[int] source_type: Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct
               Connect scenario). Defaults to 0, only `cidr` can be specified over a Direct Connect connection. Changing this creates
               a new snat rule.
        :param pulumi.Input[str] subnet_id: ID of the subnet this snat rule connects to. This parameter and `cidr` are
               alternative. Changing this creates a new snat rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SNAT rule resource within HuaweiCloud.

        ## Example Usage
        ### SNAT rule in VPC scenario

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        snat1 = huaweicloud.nat.SnatRule("snat1",
            nat_gateway_id=var["natgw_id"],
            floating_ip_id=var["publicip_id"],
            subnet_id=var["subent_id"])
        ```
        ### SNAT rule in Direct Connect scenario

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        snat2 = huaweicloud.nat.SnatRule("snat2",
            nat_gateway_id=var["natgw_id"],
            floating_ip_id=var["publicip_id"],
            source_type=1,
            cidr="192.168.10.0/24")
        ```

        ## Import

        SNAT rules can be imported using the following format

        ```sh
         $ pulumi import huaweicloud:Nat/snatRule:SnatRule snat_1 9e0713cb-0a2f-484e-8c7d-daecbb61dbe4
        ```

        :param str resource_name: The name of the resource.
        :param SnatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 floating_ip_id: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnatRuleArgs.__new__(SnatRuleArgs)

            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["description"] = description
            if floating_ip_id is None and not opts.urn:
                raise TypeError("Missing required property 'floating_ip_id'")
            __props__.__dict__["floating_ip_id"] = floating_ip_id
            if nat_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'nat_gateway_id'")
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            if network_id is not None and not opts.urn:
                warnings.warn("""use subnet_id instead""", DeprecationWarning)
                pulumi.log.warn("""network_id is deprecated: use subnet_id instead""")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["region"] = region
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["floating_ip_address"] = None
            __props__.__dict__["status"] = None
        super(SnatRule, __self__).__init__(
            'huaweicloud:Nat/snatRule:SnatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            floating_ip_address: Optional[pulumi.Input[str]] = None,
            floating_ip_id: Optional[pulumi.Input[str]] = None,
            nat_gateway_id: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            source_type: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None) -> 'SnatRule':
        """
        Get an existing SnatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: Specifies CIDR, which can be in the format of a network segment or a host IP
               address. This parameter and `subnet_id` are alternative. Changing this creates a new snat rule.
        :param pulumi.Input[str] description: Specifies the description of the snat rule.
               The value is a string of no more than 255 characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[str] floating_ip_address: The actual floating IP address.
        :param pulumi.Input[str] floating_ip_id: Specifies the EIP ID this snat rule connects to.
               Multiple EIPs are separated using commas (,). The number of EIP IDs cannot exceed 20.
        :param pulumi.Input[str] nat_gateway_id: ID of the nat gateway this snat rule belongs to. Changing this creates
               a new snat rule.
        :param pulumi.Input[str] region: The region in which to create the snat rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new snat rule resource.
        :param pulumi.Input[int] source_type: Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct
               Connect scenario). Defaults to 0, only `cidr` can be specified over a Direct Connect connection. Changing this creates
               a new snat rule.
        :param pulumi.Input[str] status: The status of the snat rule.
        :param pulumi.Input[str] subnet_id: ID of the subnet this snat rule connects to. This parameter and `cidr` are
               alternative. Changing this creates a new snat rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnatRuleState.__new__(_SnatRuleState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["description"] = description
        __props__.__dict__["floating_ip_address"] = floating_ip_address
        __props__.__dict__["floating_ip_id"] = floating_ip_id
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        return SnatRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies CIDR, which can be in the format of a network segment or a host IP
        address. This parameter and `subnet_id` are alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the snat rule.
        The value is a string of no more than 255 characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="floatingIpAddress")
    def floating_ip_address(self) -> pulumi.Output[str]:
        """
        The actual floating IP address.
        """
        return pulumi.get(self, "floating_ip_address")

    @property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> pulumi.Output[str]:
        """
        Specifies the EIP ID this snat rule connects to.
        Multiple EIPs are separated using commas (,). The number of EIP IDs cannot exceed 20.
        """
        return pulumi.get(self, "floating_ip_id")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[str]:
        """
        ID of the nat gateway this snat rule belongs to. Changing this creates
        a new snat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the snat rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new snat rule resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct
        Connect scenario). Defaults to 0, only `cidr` can be specified over a Direct Connect connection. Changing this creates
        a new snat rule.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the snat rule.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        ID of the subnet this snat rule connects to. This parameter and `cidr` are
        alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "subnet_id")

