# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 component_lists: pulumi.Input[Sequence[pulumi.Input[str]]],
                 manager_admin_pass: pulumi.Input[str],
                 master_nodes: pulumi.Input['ClusterMasterNodesArgs'],
                 subnet_id: pulumi.Input[str],
                 version: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 analysis_core_nodes: Optional[pulumi.Input['ClusterAnalysisCoreNodesArgs']] = None,
                 analysis_task_nodes: Optional[pulumi.Input['ClusterAnalysisTaskNodesArgs']] = None,
                 custom_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCustomNodeArgs']]]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 log_collection: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_admin_pass: Optional[pulumi.Input[str]] = None,
                 node_key_pair: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 safe_mode: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 streaming_core_nodes: Optional[pulumi.Input['ClusterStreamingCoreNodesArgs']] = None,
                 streaming_task_nodes: Optional[pulumi.Input['ClusterStreamingTaskNodesArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the cluster.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?all)
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] component_lists: Specifies the list of component names. For the components supported by
               the cluster, please following [reference](https://support.huaweicloud.com/intl/en-us/productdesc-mrs/mrs_08_0005.html)
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] manager_admin_pass: Specifies the administrator password, which is used to log in to
               the cluster management page. The password can contain 8 to 26 charactors and cannot be the username or the username
               spelled backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
               characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input['ClusterMasterNodesArgs'] master_nodes: Specifies a list of the informations about the master nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `master_nodes` is documented below.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet which bound to the MapReduce cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] version: Specifies the MapReduce cluster version. The valid values are `MRS 1.9.2`
               , `MRS 3.0.5` and `MRS 3.1.0`. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the VPC which bound to the MapReduce cluster. Changing
               this will create a new MapReduce cluster resource.
        :param pulumi.Input['ClusterAnalysisCoreNodesArgs'] analysis_core_nodes: Specifies a list of the informations about the analysis core nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `analysis_core_nodes` is documented below.
        :param pulumi.Input['ClusterAnalysisTaskNodesArgs'] analysis_task_nodes: Specifies a list of the informations about the analysis task nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `analysis_task_nodes` is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCustomNodeArgs']]] custom_nodes: Specifies a list of the informations about the custom nodes in the MapReduce
               cluster.
               The `nodes` object structure of the `custom_nodes` is documented below.
               `Unlike other nodes, it needs to specify group_name`
        :param pulumi.Input[str] eip_id: Specifies the EIP ID which bound to the MapReduce cluster.
               The EIP must have been created and must be in the same region as the cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[bool] log_collection: Specifies whether logs are collected when cluster installation fails.
               Default to true. If `log_collection` set true, the OBS buckets will be created and only used to collect logs that
               record MapReduce cluster creation failures. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] name: Specifies the name of the MapReduce cluster. The name can contain 2 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce cluster resource.
        :param pulumi.Input[str] node_admin_pass: Specifies the administrator password, which is used to log in to the
               each nodes(/ECSs). The password can contain 8 to 26 charactors and cannot be the username or the username spelled
               backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
               characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource. This parameter
               and `node_key_pair` are alternative.
        :param pulumi.Input[str] node_key_pair: Specifies the name of a key pair, which is used to log in to the each
               nodes(/ECSs). Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] public_ip: Specifies the EIP address which bound to the MapReduce cluster.
               The EIP must have been created and must be in the same region as the cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] region: The region in which to create the MapReduce cluster resource. If omitted, the
               provider-level region will be used. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[bool] safe_mode: Specifies whether the running mode of the MapReduce cluster is secure,
               default to true.
               + true: enable Kerberos authentication.
               + false: disable Kerberos authentication. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Specifies an array of one or more security group ID to attach to the
               MapReduce cluster. If using the specified security group, the group need to open the specified port (9022) rules.
        :param pulumi.Input['ClusterStreamingCoreNodesArgs'] streaming_core_nodes: Specifies a list of the informations about the streaming core nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `streaming_core_nodes` is documented below.
        :param pulumi.Input['ClusterStreamingTaskNodesArgs'] streaming_task_nodes: Specifies a list of the informations about the streaming task nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `streaming_task_nodes` is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the cluster.
        :param pulumi.Input[str] template_id: Specifies the template used for node deployment when the cluster type is
               CUSTOM.
               + mgmt_control_combined_v2: template for jointly deploying the management and control nodes. The management and
               control roles are co-deployed on the Master node, and data instances are deployed in the same node group. This
               deployment mode applies to scenarios where the number of control nodes is less than 100, reducing costs.
               + mgmt_control_separated_v2: The management and control roles are deployed on different master nodes, and data
               instances are deployed in the same node group. This deployment mode is applicable to a cluster with 100 to 500 nodes
               and delivers better performance in high-concurrency load scenarios.
               + mgmt_control_data_separated_v2: The management role and control role are deployed on different Master nodes,
               and data instances are deployed in different node groups. This deployment mode is applicable to a cluster with more
               than 500 nodes. Components can be deployed separately, which can be used for a larger cluster scale.
        :param pulumi.Input[str] type: Specifies the type of the MapReduce cluster. The valid values are *ANALYSIS*,
               *STREAMING* and *MIXED*, default to *ANALYSIS*. Changing this will create a new MapReduce cluster resource.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "component_lists", component_lists)
        pulumi.set(__self__, "manager_admin_pass", manager_admin_pass)
        pulumi.set(__self__, "master_nodes", master_nodes)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if analysis_core_nodes is not None:
            pulumi.set(__self__, "analysis_core_nodes", analysis_core_nodes)
        if analysis_task_nodes is not None:
            pulumi.set(__self__, "analysis_task_nodes", analysis_task_nodes)
        if custom_nodes is not None:
            pulumi.set(__self__, "custom_nodes", custom_nodes)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if log_collection is not None:
            pulumi.set(__self__, "log_collection", log_collection)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_admin_pass is not None:
            pulumi.set(__self__, "node_admin_pass", node_admin_pass)
        if node_key_pair is not None:
            pulumi.set(__self__, "node_key_pair", node_key_pair)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if safe_mode is not None:
            pulumi.set(__self__, "safe_mode", safe_mode)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if streaming_core_nodes is not None:
            pulumi.set(__self__, "streaming_core_nodes", streaming_core_nodes)
        if streaming_task_nodes is not None:
            pulumi.set(__self__, "streaming_task_nodes", streaming_task_nodes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the availability zone in which to create the cluster.
        Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?all)
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="componentLists")
    def component_lists(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the list of component names. For the components supported by
        the cluster, please following [reference](https://support.huaweicloud.com/intl/en-us/productdesc-mrs/mrs_08_0005.html)
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "component_lists")

    @component_lists.setter
    def component_lists(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "component_lists", value)

    @property
    @pulumi.getter(name="managerAdminPass")
    def manager_admin_pass(self) -> pulumi.Input[str]:
        """
        Specifies the administrator password, which is used to log in to
        the cluster management page. The password can contain 8 to 26 charactors and cannot be the username or the username
        spelled backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
        characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "manager_admin_pass")

    @manager_admin_pass.setter
    def manager_admin_pass(self, value: pulumi.Input[str]):
        pulumi.set(self, "manager_admin_pass", value)

    @property
    @pulumi.getter(name="masterNodes")
    def master_nodes(self) -> pulumi.Input['ClusterMasterNodesArgs']:
        """
        Specifies a list of the informations about the master nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `master_nodes` is documented below.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "master_nodes")

    @master_nodes.setter
    def master_nodes(self, value: pulumi.Input['ClusterMasterNodesArgs']):
        pulumi.set(self, "master_nodes", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the network ID of a subnet which bound to the MapReduce cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Specifies the MapReduce cluster version. The valid values are `MRS 1.9.2`
        , `MRS 3.0.5` and `MRS 3.1.0`. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the VPC which bound to the MapReduce cluster. Changing
        this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="analysisCoreNodes")
    def analysis_core_nodes(self) -> Optional[pulumi.Input['ClusterAnalysisCoreNodesArgs']]:
        """
        Specifies a list of the informations about the analysis core nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `analysis_core_nodes` is documented below.
        """
        return pulumi.get(self, "analysis_core_nodes")

    @analysis_core_nodes.setter
    def analysis_core_nodes(self, value: Optional[pulumi.Input['ClusterAnalysisCoreNodesArgs']]):
        pulumi.set(self, "analysis_core_nodes", value)

    @property
    @pulumi.getter(name="analysisTaskNodes")
    def analysis_task_nodes(self) -> Optional[pulumi.Input['ClusterAnalysisTaskNodesArgs']]:
        """
        Specifies a list of the informations about the analysis task nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `analysis_task_nodes` is documented below.
        """
        return pulumi.get(self, "analysis_task_nodes")

    @analysis_task_nodes.setter
    def analysis_task_nodes(self, value: Optional[pulumi.Input['ClusterAnalysisTaskNodesArgs']]):
        pulumi.set(self, "analysis_task_nodes", value)

    @property
    @pulumi.getter(name="customNodes")
    def custom_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCustomNodeArgs']]]]:
        """
        Specifies a list of the informations about the custom nodes in the MapReduce
        cluster.
        The `nodes` object structure of the `custom_nodes` is documented below.
        `Unlike other nodes, it needs to specify group_name`
        """
        return pulumi.get(self, "custom_nodes")

    @custom_nodes.setter
    def custom_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCustomNodeArgs']]]]):
        pulumi.set(self, "custom_nodes", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP ID which bound to the MapReduce cluster.
        The EIP must have been created and must be in the same region as the cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="logCollection")
    def log_collection(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether logs are collected when cluster installation fails.
        Default to true. If `log_collection` set true, the OBS buckets will be created and only used to collect logs that
        record MapReduce cluster creation failures. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "log_collection")

    @log_collection.setter
    def log_collection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_collection", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeAdminPass")
    def node_admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the administrator password, which is used to log in to the
        each nodes(/ECSs). The password can contain 8 to 26 charactors and cannot be the username or the username spelled
        backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
        characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource. This parameter
        and `node_key_pair` are alternative.
        """
        return pulumi.get(self, "node_admin_pass")

    @node_admin_pass.setter
    def node_admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_admin_pass", value)

    @property
    @pulumi.getter(name="nodeKeyPair")
    def node_key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a key pair, which is used to log in to the each
        nodes(/ECSs). Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "node_key_pair")

    @node_key_pair.setter
    def node_key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_key_pair", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP address which bound to the MapReduce cluster.
        The EIP must have been created and must be in the same region as the cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the MapReduce cluster resource. If omitted, the
        provider-level region will be used. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="safeMode")
    def safe_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the running mode of the MapReduce cluster is secure,
        default to true.
        + true: enable Kerberos authentication.
        + false: disable Kerberos authentication. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "safe_mode")

    @safe_mode.setter
    def safe_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "safe_mode", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of one or more security group ID to attach to the
        MapReduce cluster. If using the specified security group, the group need to open the specified port (9022) rules.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="streamingCoreNodes")
    def streaming_core_nodes(self) -> Optional[pulumi.Input['ClusterStreamingCoreNodesArgs']]:
        """
        Specifies a list of the informations about the streaming core nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `streaming_core_nodes` is documented below.
        """
        return pulumi.get(self, "streaming_core_nodes")

    @streaming_core_nodes.setter
    def streaming_core_nodes(self, value: Optional[pulumi.Input['ClusterStreamingCoreNodesArgs']]):
        pulumi.set(self, "streaming_core_nodes", value)

    @property
    @pulumi.getter(name="streamingTaskNodes")
    def streaming_task_nodes(self) -> Optional[pulumi.Input['ClusterStreamingTaskNodesArgs']]:
        """
        Specifies a list of the informations about the streaming task nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `streaming_task_nodes` is documented below.
        """
        return pulumi.get(self, "streaming_task_nodes")

    @streaming_task_nodes.setter
    def streaming_task_nodes(self, value: Optional[pulumi.Input['ClusterStreamingTaskNodesArgs']]):
        pulumi.set(self, "streaming_task_nodes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the template used for node deployment when the cluster type is
        CUSTOM.
        + mgmt_control_combined_v2: template for jointly deploying the management and control nodes. The management and
        control roles are co-deployed on the Master node, and data instances are deployed in the same node group. This
        deployment mode applies to scenarios where the number of control nodes is less than 100, reducing costs.
        + mgmt_control_separated_v2: The management and control roles are deployed on different master nodes, and data
        instances are deployed in the same node group. This deployment mode is applicable to a cluster with 100 to 500 nodes
        and delivers better performance in high-concurrency load scenarios.
        + mgmt_control_data_separated_v2: The management role and control role are deployed on different Master nodes,
        and data instances are deployed in different node groups. This deployment mode is applicable to a cluster with more
        than 500 nodes. Components can be deployed separately, which can be used for a larger cluster scale.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the MapReduce cluster. The valid values are *ANALYSIS*,
        *STREAMING* and *MIXED*, default to *ANALYSIS*. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 analysis_core_nodes: Optional[pulumi.Input['ClusterAnalysisCoreNodesArgs']] = None,
                 analysis_task_nodes: Optional[pulumi.Input['ClusterAnalysisTaskNodesArgs']] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 charging_start_time: Optional[pulumi.Input[str]] = None,
                 component_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 custom_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCustomNodeArgs']]]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 log_collection: Optional[pulumi.Input[bool]] = None,
                 manager_admin_pass: Optional[pulumi.Input[str]] = None,
                 master_node_ip: Optional[pulumi.Input[str]] = None,
                 master_nodes: Optional[pulumi.Input['ClusterMasterNodesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_admin_pass: Optional[pulumi.Input[str]] = None,
                 node_key_pair: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 safe_mode: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 streaming_core_nodes: Optional[pulumi.Input['ClusterStreamingCoreNodesArgs']] = None,
                 streaming_task_nodes: Optional[pulumi.Input['ClusterStreamingTaskNodesArgs']] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template_id: Optional[pulumi.Input[str]] = None,
                 total_node_number: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input['ClusterAnalysisCoreNodesArgs'] analysis_core_nodes: Specifies a list of the informations about the analysis core nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `analysis_core_nodes` is documented below.
        :param pulumi.Input['ClusterAnalysisTaskNodesArgs'] analysis_task_nodes: Specifies a list of the informations about the analysis task nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `analysis_task_nodes` is documented below.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the cluster.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?all)
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] charging_start_time: The charging start time which is the start time of billing, in RFC-3339 format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] component_lists: Specifies the list of component names. For the components supported by
               the cluster, please following [reference](https://support.huaweicloud.com/intl/en-us/productdesc-mrs/mrs_08_0005.html)
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] create_time: The cluster creation time, in RFC-3339 format.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCustomNodeArgs']]] custom_nodes: Specifies a list of the informations about the custom nodes in the MapReduce
               cluster.
               The `nodes` object structure of the `custom_nodes` is documented below.
               `Unlike other nodes, it needs to specify group_name`
        :param pulumi.Input[str] eip_id: Specifies the EIP ID which bound to the MapReduce cluster.
               The EIP must have been created and must be in the same region as the cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[bool] log_collection: Specifies whether logs are collected when cluster installation fails.
               Default to true. If `log_collection` set true, the OBS buckets will be created and only used to collect logs that
               record MapReduce cluster creation failures. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] manager_admin_pass: Specifies the administrator password, which is used to log in to
               the cluster management page. The password can contain 8 to 26 charactors and cannot be the username or the username
               spelled backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
               characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] master_node_ip: The IP address of the master node.
        :param pulumi.Input['ClusterMasterNodesArgs'] master_nodes: Specifies a list of the informations about the master nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `master_nodes` is documented below.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] name: Specifies the name of the MapReduce cluster. The name can contain 2 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce cluster resource.
        :param pulumi.Input[str] node_admin_pass: Specifies the administrator password, which is used to log in to the
               each nodes(/ECSs). The password can contain 8 to 26 charactors and cannot be the username or the username spelled
               backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
               characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource. This parameter
               and `node_key_pair` are alternative.
        :param pulumi.Input[str] node_key_pair: Specifies the name of a key pair, which is used to log in to the each
               nodes(/ECSs). Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] private_ip: The preferred private IP address of the master node.
        :param pulumi.Input[str] public_ip: Specifies the EIP address which bound to the MapReduce cluster.
               The EIP must have been created and must be in the same region as the cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] region: The region in which to create the MapReduce cluster resource. If omitted, the
               provider-level region will be used. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[bool] safe_mode: Specifies whether the running mode of the MapReduce cluster is secure,
               default to true.
               + true: enable Kerberos authentication.
               + false: disable Kerberos authentication. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Specifies an array of one or more security group ID to attach to the
               MapReduce cluster. If using the specified security group, the group need to open the specified port (9022) rules.
        :param pulumi.Input[str] status: The cluster state, which include: running, frozen, abnormal and failed.
        :param pulumi.Input['ClusterStreamingCoreNodesArgs'] streaming_core_nodes: Specifies a list of the informations about the streaming core nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `streaming_core_nodes` is documented below.
        :param pulumi.Input['ClusterStreamingTaskNodesArgs'] streaming_task_nodes: Specifies a list of the informations about the streaming task nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `streaming_task_nodes` is documented below.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet which bound to the MapReduce cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the cluster.
        :param pulumi.Input[str] template_id: Specifies the template used for node deployment when the cluster type is
               CUSTOM.
               + mgmt_control_combined_v2: template for jointly deploying the management and control nodes. The management and
               control roles are co-deployed on the Master node, and data instances are deployed in the same node group. This
               deployment mode applies to scenarios where the number of control nodes is less than 100, reducing costs.
               + mgmt_control_separated_v2: The management and control roles are deployed on different master nodes, and data
               instances are deployed in the same node group. This deployment mode is applicable to a cluster with 100 to 500 nodes
               and delivers better performance in high-concurrency load scenarios.
               + mgmt_control_data_separated_v2: The management role and control role are deployed on different Master nodes,
               and data instances are deployed in different node groups. This deployment mode is applicable to a cluster with more
               than 500 nodes. Components can be deployed separately, which can be used for a larger cluster scale.
        :param pulumi.Input[int] total_node_number: The total number of nodes deployed in the cluster.
        :param pulumi.Input[str] type: Specifies the type of the MapReduce cluster. The valid values are *ANALYSIS*,
               *STREAMING* and *MIXED*, default to *ANALYSIS*. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] update_time: The cluster update time, in RFC-3339 format.
        :param pulumi.Input[str] version: Specifies the MapReduce cluster version. The valid values are `MRS 1.9.2`
               , `MRS 3.0.5` and `MRS 3.1.0`. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the VPC which bound to the MapReduce cluster. Changing
               this will create a new MapReduce cluster resource.
        """
        if analysis_core_nodes is not None:
            pulumi.set(__self__, "analysis_core_nodes", analysis_core_nodes)
        if analysis_task_nodes is not None:
            pulumi.set(__self__, "analysis_task_nodes", analysis_task_nodes)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if charging_start_time is not None:
            pulumi.set(__self__, "charging_start_time", charging_start_time)
        if component_lists is not None:
            pulumi.set(__self__, "component_lists", component_lists)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_nodes is not None:
            pulumi.set(__self__, "custom_nodes", custom_nodes)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if log_collection is not None:
            pulumi.set(__self__, "log_collection", log_collection)
        if manager_admin_pass is not None:
            pulumi.set(__self__, "manager_admin_pass", manager_admin_pass)
        if master_node_ip is not None:
            pulumi.set(__self__, "master_node_ip", master_node_ip)
        if master_nodes is not None:
            pulumi.set(__self__, "master_nodes", master_nodes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_admin_pass is not None:
            pulumi.set(__self__, "node_admin_pass", node_admin_pass)
        if node_key_pair is not None:
            pulumi.set(__self__, "node_key_pair", node_key_pair)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if safe_mode is not None:
            pulumi.set(__self__, "safe_mode", safe_mode)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if streaming_core_nodes is not None:
            pulumi.set(__self__, "streaming_core_nodes", streaming_core_nodes)
        if streaming_task_nodes is not None:
            pulumi.set(__self__, "streaming_task_nodes", streaming_task_nodes)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if total_node_number is not None:
            pulumi.set(__self__, "total_node_number", total_node_number)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="analysisCoreNodes")
    def analysis_core_nodes(self) -> Optional[pulumi.Input['ClusterAnalysisCoreNodesArgs']]:
        """
        Specifies a list of the informations about the analysis core nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `analysis_core_nodes` is documented below.
        """
        return pulumi.get(self, "analysis_core_nodes")

    @analysis_core_nodes.setter
    def analysis_core_nodes(self, value: Optional[pulumi.Input['ClusterAnalysisCoreNodesArgs']]):
        pulumi.set(self, "analysis_core_nodes", value)

    @property
    @pulumi.getter(name="analysisTaskNodes")
    def analysis_task_nodes(self) -> Optional[pulumi.Input['ClusterAnalysisTaskNodesArgs']]:
        """
        Specifies a list of the informations about the analysis task nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `analysis_task_nodes` is documented below.
        """
        return pulumi.get(self, "analysis_task_nodes")

    @analysis_task_nodes.setter
    def analysis_task_nodes(self, value: Optional[pulumi.Input['ClusterAnalysisTaskNodesArgs']]):
        pulumi.set(self, "analysis_task_nodes", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone in which to create the cluster.
        Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?all)
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="chargingStartTime")
    def charging_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The charging start time which is the start time of billing, in RFC-3339 format.
        """
        return pulumi.get(self, "charging_start_time")

    @charging_start_time.setter
    def charging_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_start_time", value)

    @property
    @pulumi.getter(name="componentLists")
    def component_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of component names. For the components supported by
        the cluster, please following [reference](https://support.huaweicloud.com/intl/en-us/productdesc-mrs/mrs_08_0005.html)
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "component_lists")

    @component_lists.setter
    def component_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "component_lists", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster creation time, in RFC-3339 format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="customNodes")
    def custom_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCustomNodeArgs']]]]:
        """
        Specifies a list of the informations about the custom nodes in the MapReduce
        cluster.
        The `nodes` object structure of the `custom_nodes` is documented below.
        `Unlike other nodes, it needs to specify group_name`
        """
        return pulumi.get(self, "custom_nodes")

    @custom_nodes.setter
    def custom_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCustomNodeArgs']]]]):
        pulumi.set(self, "custom_nodes", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP ID which bound to the MapReduce cluster.
        The EIP must have been created and must be in the same region as the cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="logCollection")
    def log_collection(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether logs are collected when cluster installation fails.
        Default to true. If `log_collection` set true, the OBS buckets will be created and only used to collect logs that
        record MapReduce cluster creation failures. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "log_collection")

    @log_collection.setter
    def log_collection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_collection", value)

    @property
    @pulumi.getter(name="managerAdminPass")
    def manager_admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the administrator password, which is used to log in to
        the cluster management page. The password can contain 8 to 26 charactors and cannot be the username or the username
        spelled backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
        characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "manager_admin_pass")

    @manager_admin_pass.setter
    def manager_admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manager_admin_pass", value)

    @property
    @pulumi.getter(name="masterNodeIp")
    def master_node_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the master node.
        """
        return pulumi.get(self, "master_node_ip")

    @master_node_ip.setter
    def master_node_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_node_ip", value)

    @property
    @pulumi.getter(name="masterNodes")
    def master_nodes(self) -> Optional[pulumi.Input['ClusterMasterNodesArgs']]:
        """
        Specifies a list of the informations about the master nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `master_nodes` is documented below.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "master_nodes")

    @master_nodes.setter
    def master_nodes(self, value: Optional[pulumi.Input['ClusterMasterNodesArgs']]):
        pulumi.set(self, "master_nodes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeAdminPass")
    def node_admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the administrator password, which is used to log in to the
        each nodes(/ECSs). The password can contain 8 to 26 charactors and cannot be the username or the username spelled
        backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
        characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource. This parameter
        and `node_key_pair` are alternative.
        """
        return pulumi.get(self, "node_admin_pass")

    @node_admin_pass.setter
    def node_admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_admin_pass", value)

    @property
    @pulumi.getter(name="nodeKeyPair")
    def node_key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a key pair, which is used to log in to the each
        nodes(/ECSs). Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "node_key_pair")

    @node_key_pair.setter
    def node_key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_key_pair", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred private IP address of the master node.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP address which bound to the MapReduce cluster.
        The EIP must have been created and must be in the same region as the cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the MapReduce cluster resource. If omitted, the
        provider-level region will be used. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="safeMode")
    def safe_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the running mode of the MapReduce cluster is secure,
        default to true.
        + true: enable Kerberos authentication.
        + false: disable Kerberos authentication. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "safe_mode")

    @safe_mode.setter
    def safe_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "safe_mode", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of one or more security group ID to attach to the
        MapReduce cluster. If using the specified security group, the group need to open the specified port (9022) rules.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster state, which include: running, frozen, abnormal and failed.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="streamingCoreNodes")
    def streaming_core_nodes(self) -> Optional[pulumi.Input['ClusterStreamingCoreNodesArgs']]:
        """
        Specifies a list of the informations about the streaming core nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `streaming_core_nodes` is documented below.
        """
        return pulumi.get(self, "streaming_core_nodes")

    @streaming_core_nodes.setter
    def streaming_core_nodes(self, value: Optional[pulumi.Input['ClusterStreamingCoreNodesArgs']]):
        pulumi.set(self, "streaming_core_nodes", value)

    @property
    @pulumi.getter(name="streamingTaskNodes")
    def streaming_task_nodes(self) -> Optional[pulumi.Input['ClusterStreamingTaskNodesArgs']]:
        """
        Specifies a list of the informations about the streaming task nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `streaming_task_nodes` is documented below.
        """
        return pulumi.get(self, "streaming_task_nodes")

    @streaming_task_nodes.setter
    def streaming_task_nodes(self, value: Optional[pulumi.Input['ClusterStreamingTaskNodesArgs']]):
        pulumi.set(self, "streaming_task_nodes", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ID of a subnet which bound to the MapReduce cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the template used for node deployment when the cluster type is
        CUSTOM.
        + mgmt_control_combined_v2: template for jointly deploying the management and control nodes. The management and
        control roles are co-deployed on the Master node, and data instances are deployed in the same node group. This
        deployment mode applies to scenarios where the number of control nodes is less than 100, reducing costs.
        + mgmt_control_separated_v2: The management and control roles are deployed on different master nodes, and data
        instances are deployed in the same node group. This deployment mode is applicable to a cluster with 100 to 500 nodes
        and delivers better performance in high-concurrency load scenarios.
        + mgmt_control_data_separated_v2: The management role and control role are deployed on different Master nodes,
        and data instances are deployed in different node groups. This deployment mode is applicable to a cluster with more
        than 500 nodes. Components can be deployed separately, which can be used for a larger cluster scale.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter(name="totalNodeNumber")
    def total_node_number(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of nodes deployed in the cluster.
        """
        return pulumi.get(self, "total_node_number")

    @total_node_number.setter
    def total_node_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_node_number", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the MapReduce cluster. The valid values are *ANALYSIS*,
        *STREAMING* and *MIXED*, default to *ANALYSIS*. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster update time, in RFC-3339 format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the MapReduce cluster version. The valid values are `MRS 1.9.2`
        , `MRS 3.0.5` and `MRS 3.1.0`. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the VPC which bound to the MapReduce cluster. Changing
        this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analysis_core_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterAnalysisCoreNodesArgs']]] = None,
                 analysis_task_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterAnalysisTaskNodesArgs']]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 component_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterCustomNodeArgs']]]]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 log_collection: Optional[pulumi.Input[bool]] = None,
                 manager_admin_pass: Optional[pulumi.Input[str]] = None,
                 master_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterMasterNodesArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_admin_pass: Optional[pulumi.Input[str]] = None,
                 node_key_pair: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 safe_mode: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 streaming_core_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterStreamingCoreNodesArgs']]] = None,
                 streaming_task_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterStreamingTaskNodesArgs']]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a cluster resource within HuaweiCloud MRS.

        ## Example Usage
        ### Create an analysis cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            version="MRS 1.9.2",
            type="ANALYSIS",
            component_lists=[
                "Hadoop",
                "Hive",
                "Tez",
            ],
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_core_nodes=huaweicloud.mrs.ClusterAnalysisCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_task_nodes=huaweicloud.mrs.ClusterAnalysisTaskNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=1,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### Create a stream cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            type="STREAMING",
            version="MRS 1.9.2",
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            component_lists=["Storm"],
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            streaming_core_nodes=huaweicloud.mrs.ClusterStreamingCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### Create a hybrid cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            version="MRS 1.9.2",
            type="MIXED",
            component_lists=[
                "Hadoop",
                "Spark",
                "Hive",
                "Tez",
                "Storm",
            ],
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_core_nodes=huaweicloud.mrs.ClusterAnalysisCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            streaming_core_nodes=huaweicloud.mrs.ClusterStreamingCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_task_nodes=huaweicloud.mrs.ClusterAnalysisTaskNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=1,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            streaming_task_nodes=huaweicloud.mrs.ClusterStreamingTaskNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=1,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### Create a custom cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            version="MRS 3.1.0",
            type="CUSTOM",
            safe_mode=True,
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            template_id="mgmt_control_combined_v4",
            component_lists=[
                "DBService",
                "Hadoop",
                "ZooKeeper",
                "Ranger",
            ],
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.4xlarge.4.linux.bigdata",
                node_number=3,
                root_volume_type="SAS",
                root_volume_size=480,
                data_volume_type="SAS",
                data_volume_size=600,
                data_volume_count=1,
                assigned_roles=[
                    "OMSServer:1,2",
                    "SlapdServer:1,2",
                    "KerberosServer:1,2",
                    "KerberosAdmin:1,2",
                    "quorumpeer:1,2,3",
                    "NameNode:2,3",
                    "Zkfc:2,3",
                    "JournalNode:1,2,3",
                    "ResourceManager:2,3",
                    "JobHistoryServer:3",
                    "DBServer:1,3",
                    "HttpFS:1,3",
                    "TimelineServer:3",
                    "RangerAdmin:1,2",
                    "UserSync:2",
                    "TagSync:2",
                    "KerberosClient",
                    "SlapdClient",
                    "meta",
                ],
            ),
            custom_nodes=[huaweicloud.mrs.ClusterCustomNodeArgs(
                group_name="node_group_1",
                flavor="c6.4xlarge.4.linux.bigdata",
                node_number=4,
                root_volume_type="SAS",
                root_volume_size=480,
                data_volume_type="SAS",
                data_volume_size=600,
                data_volume_count=1,
                assigned_roles=[
                    "DataNode",
                    "NodeManager",
                    "KerberosClient",
                    "SlapdClient",
                    "meta",
                ],
            )])
        ```
        ### Create an analysis cluster and bind public IP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        public_ip = config.require_object("publicIp")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            version="MRS 1.9.2",
            type="ANALYSIS",
            component_lists=[
                "Hadoop",
                "Hive",
                "Tez",
            ],
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            public_ip=public_ip,
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_core_nodes=huaweicloud.mrs.ClusterAnalysisCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_task_nodes=huaweicloud.mrs.ClusterAnalysisTaskNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=1,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        Clusters can be imported by their `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Mrs/cluster:cluster test b11b407c-e604-4e8d-8bc4-92398320b847
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`manager_admin_pass`, `node_admin_pass`,`template_id` and `assigned_roles`. It is generally recommended running `terraform plan` after importing a cluster. You can then decide if changes should be applied to the cluster, or the resource definition should be updated to align with the cluster. Also you can ignore changes as below. resource "huaweicloud_mapreduce_cluster" "test" {

         ...

         lifecycle {

         ignore_changes = [

         manager_admin_pass, node_admin_pass,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterAnalysisCoreNodesArgs']] analysis_core_nodes: Specifies a list of the informations about the analysis core nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `analysis_core_nodes` is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterAnalysisTaskNodesArgs']] analysis_task_nodes: Specifies a list of the informations about the analysis task nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `analysis_task_nodes` is documented below.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the cluster.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?all)
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] component_lists: Specifies the list of component names. For the components supported by
               the cluster, please following [reference](https://support.huaweicloud.com/intl/en-us/productdesc-mrs/mrs_08_0005.html)
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterCustomNodeArgs']]]] custom_nodes: Specifies a list of the informations about the custom nodes in the MapReduce
               cluster.
               The `nodes` object structure of the `custom_nodes` is documented below.
               `Unlike other nodes, it needs to specify group_name`
        :param pulumi.Input[str] eip_id: Specifies the EIP ID which bound to the MapReduce cluster.
               The EIP must have been created and must be in the same region as the cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[bool] log_collection: Specifies whether logs are collected when cluster installation fails.
               Default to true. If `log_collection` set true, the OBS buckets will be created and only used to collect logs that
               record MapReduce cluster creation failures. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] manager_admin_pass: Specifies the administrator password, which is used to log in to
               the cluster management page. The password can contain 8 to 26 charactors and cannot be the username or the username
               spelled backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
               characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[pulumi.InputType['ClusterMasterNodesArgs']] master_nodes: Specifies a list of the informations about the master nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `master_nodes` is documented below.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] name: Specifies the name of the MapReduce cluster. The name can contain 2 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce cluster resource.
        :param pulumi.Input[str] node_admin_pass: Specifies the administrator password, which is used to log in to the
               each nodes(/ECSs). The password can contain 8 to 26 charactors and cannot be the username or the username spelled
               backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
               characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource. This parameter
               and `node_key_pair` are alternative.
        :param pulumi.Input[str] node_key_pair: Specifies the name of a key pair, which is used to log in to the each
               nodes(/ECSs). Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] public_ip: Specifies the EIP address which bound to the MapReduce cluster.
               The EIP must have been created and must be in the same region as the cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] region: The region in which to create the MapReduce cluster resource. If omitted, the
               provider-level region will be used. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[bool] safe_mode: Specifies whether the running mode of the MapReduce cluster is secure,
               default to true.
               + true: enable Kerberos authentication.
               + false: disable Kerberos authentication. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Specifies an array of one or more security group ID to attach to the
               MapReduce cluster. If using the specified security group, the group need to open the specified port (9022) rules.
        :param pulumi.Input[pulumi.InputType['ClusterStreamingCoreNodesArgs']] streaming_core_nodes: Specifies a list of the informations about the streaming core nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `streaming_core_nodes` is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterStreamingTaskNodesArgs']] streaming_task_nodes: Specifies a list of the informations about the streaming task nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `streaming_task_nodes` is documented below.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet which bound to the MapReduce cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the cluster.
        :param pulumi.Input[str] template_id: Specifies the template used for node deployment when the cluster type is
               CUSTOM.
               + mgmt_control_combined_v2: template for jointly deploying the management and control nodes. The management and
               control roles are co-deployed on the Master node, and data instances are deployed in the same node group. This
               deployment mode applies to scenarios where the number of control nodes is less than 100, reducing costs.
               + mgmt_control_separated_v2: The management and control roles are deployed on different master nodes, and data
               instances are deployed in the same node group. This deployment mode is applicable to a cluster with 100 to 500 nodes
               and delivers better performance in high-concurrency load scenarios.
               + mgmt_control_data_separated_v2: The management role and control role are deployed on different Master nodes,
               and data instances are deployed in different node groups. This deployment mode is applicable to a cluster with more
               than 500 nodes. Components can be deployed separately, which can be used for a larger cluster scale.
        :param pulumi.Input[str] type: Specifies the type of the MapReduce cluster. The valid values are *ANALYSIS*,
               *STREAMING* and *MIXED*, default to *ANALYSIS*. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] version: Specifies the MapReduce cluster version. The valid values are `MRS 1.9.2`
               , `MRS 3.0.5` and `MRS 3.1.0`. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the VPC which bound to the MapReduce cluster. Changing
               this will create a new MapReduce cluster resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a cluster resource within HuaweiCloud MRS.

        ## Example Usage
        ### Create an analysis cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            version="MRS 1.9.2",
            type="ANALYSIS",
            component_lists=[
                "Hadoop",
                "Hive",
                "Tez",
            ],
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_core_nodes=huaweicloud.mrs.ClusterAnalysisCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_task_nodes=huaweicloud.mrs.ClusterAnalysisTaskNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=1,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### Create a stream cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            type="STREAMING",
            version="MRS 1.9.2",
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            component_lists=["Storm"],
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            streaming_core_nodes=huaweicloud.mrs.ClusterStreamingCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### Create a hybrid cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            version="MRS 1.9.2",
            type="MIXED",
            component_lists=[
                "Hadoop",
                "Spark",
                "Hive",
                "Tez",
                "Storm",
            ],
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_core_nodes=huaweicloud.mrs.ClusterAnalysisCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            streaming_core_nodes=huaweicloud.mrs.ClusterStreamingCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_task_nodes=huaweicloud.mrs.ClusterAnalysisTaskNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=1,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            streaming_task_nodes=huaweicloud.mrs.ClusterStreamingTaskNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=1,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### Create a custom cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            version="MRS 3.1.0",
            type="CUSTOM",
            safe_mode=True,
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            template_id="mgmt_control_combined_v4",
            component_lists=[
                "DBService",
                "Hadoop",
                "ZooKeeper",
                "Ranger",
            ],
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.4xlarge.4.linux.bigdata",
                node_number=3,
                root_volume_type="SAS",
                root_volume_size=480,
                data_volume_type="SAS",
                data_volume_size=600,
                data_volume_count=1,
                assigned_roles=[
                    "OMSServer:1,2",
                    "SlapdServer:1,2",
                    "KerberosServer:1,2",
                    "KerberosAdmin:1,2",
                    "quorumpeer:1,2,3",
                    "NameNode:2,3",
                    "Zkfc:2,3",
                    "JournalNode:1,2,3",
                    "ResourceManager:2,3",
                    "JobHistoryServer:3",
                    "DBServer:1,3",
                    "HttpFS:1,3",
                    "TimelineServer:3",
                    "RangerAdmin:1,2",
                    "UserSync:2",
                    "TagSync:2",
                    "KerberosClient",
                    "SlapdClient",
                    "meta",
                ],
            ),
            custom_nodes=[huaweicloud.mrs.ClusterCustomNodeArgs(
                group_name="node_group_1",
                flavor="c6.4xlarge.4.linux.bigdata",
                node_number=4,
                root_volume_type="SAS",
                root_volume_size=480,
                data_volume_type="SAS",
                data_volume_size=600,
                data_volume_count=1,
                assigned_roles=[
                    "DataNode",
                    "NodeManager",
                    "KerberosClient",
                    "SlapdClient",
                    "meta",
                ],
            )])
        ```
        ### Create an analysis cluster and bind public IP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_availability_zones = huaweicloud.get_availability_zones()
        config = pulumi.Config()
        cluster_name = config.require_object("clusterName")
        password = config.require_object("password")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        public_ip = config.require_object("publicIp")
        testcluster = huaweicloud.mrs.Cluster("testcluster",
            availability_zone=test_availability_zones.names[0],
            version="MRS 1.9.2",
            type="ANALYSIS",
            component_lists=[
                "Hadoop",
                "Hive",
                "Tez",
            ],
            manager_admin_pass=password,
            node_admin_pass=password,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            public_ip=public_ip,
            master_nodes=huaweicloud.mrs.ClusterMasterNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_core_nodes=huaweicloud.mrs.ClusterAnalysisCoreNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=2,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            analysis_task_nodes=huaweicloud.mrs.ClusterAnalysisTaskNodesArgs(
                flavor="c6.2xlarge.4.linux.bigdata",
                node_number=1,
                root_volume_type="SAS",
                root_volume_size=300,
                data_volume_type="SAS",
                data_volume_size=480,
                data_volume_count=1,
            ),
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        Clusters can be imported by their `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Mrs/cluster:cluster test b11b407c-e604-4e8d-8bc4-92398320b847
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`manager_admin_pass`, `node_admin_pass`,`template_id` and `assigned_roles`. It is generally recommended running `terraform plan` after importing a cluster. You can then decide if changes should be applied to the cluster, or the resource definition should be updated to align with the cluster. Also you can ignore changes as below. resource "huaweicloud_mapreduce_cluster" "test" {

         ...

         lifecycle {

         ignore_changes = [

         manager_admin_pass, node_admin_pass,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analysis_core_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterAnalysisCoreNodesArgs']]] = None,
                 analysis_task_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterAnalysisTaskNodesArgs']]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 component_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterCustomNodeArgs']]]]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 log_collection: Optional[pulumi.Input[bool]] = None,
                 manager_admin_pass: Optional[pulumi.Input[str]] = None,
                 master_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterMasterNodesArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_admin_pass: Optional[pulumi.Input[str]] = None,
                 node_key_pair: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 safe_mode: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 streaming_core_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterStreamingCoreNodesArgs']]] = None,
                 streaming_task_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterStreamingTaskNodesArgs']]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["analysis_core_nodes"] = analysis_core_nodes
            __props__.__dict__["analysis_task_nodes"] = analysis_task_nodes
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            if component_lists is None and not opts.urn:
                raise TypeError("Missing required property 'component_lists'")
            __props__.__dict__["component_lists"] = component_lists
            __props__.__dict__["custom_nodes"] = custom_nodes
            __props__.__dict__["eip_id"] = eip_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["log_collection"] = log_collection
            if manager_admin_pass is None and not opts.urn:
                raise TypeError("Missing required property 'manager_admin_pass'")
            __props__.__dict__["manager_admin_pass"] = manager_admin_pass
            if master_nodes is None and not opts.urn:
                raise TypeError("Missing required property 'master_nodes'")
            __props__.__dict__["master_nodes"] = master_nodes
            __props__.__dict__["name"] = name
            __props__.__dict__["node_admin_pass"] = node_admin_pass
            __props__.__dict__["node_key_pair"] = node_key_pair
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["region"] = region
            __props__.__dict__["safe_mode"] = safe_mode
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["streaming_core_nodes"] = streaming_core_nodes
            __props__.__dict__["streaming_task_nodes"] = streaming_task_nodes
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["type"] = type
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["charging_start_time"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["master_node_ip"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["total_node_number"] = None
            __props__.__dict__["update_time"] = None
        super(Cluster, __self__).__init__(
            'huaweicloud:Mrs/cluster:cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analysis_core_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterAnalysisCoreNodesArgs']]] = None,
            analysis_task_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterAnalysisTaskNodesArgs']]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            charging_start_time: Optional[pulumi.Input[str]] = None,
            component_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            custom_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterCustomNodeArgs']]]]] = None,
            eip_id: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            log_collection: Optional[pulumi.Input[bool]] = None,
            manager_admin_pass: Optional[pulumi.Input[str]] = None,
            master_node_ip: Optional[pulumi.Input[str]] = None,
            master_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterMasterNodesArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_admin_pass: Optional[pulumi.Input[str]] = None,
            node_key_pair: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            safe_mode: Optional[pulumi.Input[bool]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            streaming_core_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterStreamingCoreNodesArgs']]] = None,
            streaming_task_nodes: Optional[pulumi.Input[pulumi.InputType['ClusterStreamingTaskNodesArgs']]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            template_id: Optional[pulumi.Input[str]] = None,
            total_node_number: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterAnalysisCoreNodesArgs']] analysis_core_nodes: Specifies a list of the informations about the analysis core nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `analysis_core_nodes` is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterAnalysisTaskNodesArgs']] analysis_task_nodes: Specifies a list of the informations about the analysis task nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `analysis_task_nodes` is documented below.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the cluster.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?all)
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] charging_start_time: The charging start time which is the start time of billing, in RFC-3339 format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] component_lists: Specifies the list of component names. For the components supported by
               the cluster, please following [reference](https://support.huaweicloud.com/intl/en-us/productdesc-mrs/mrs_08_0005.html)
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] create_time: The cluster creation time, in RFC-3339 format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterCustomNodeArgs']]]] custom_nodes: Specifies a list of the informations about the custom nodes in the MapReduce
               cluster.
               The `nodes` object structure of the `custom_nodes` is documented below.
               `Unlike other nodes, it needs to specify group_name`
        :param pulumi.Input[str] eip_id: Specifies the EIP ID which bound to the MapReduce cluster.
               The EIP must have been created and must be in the same region as the cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[bool] log_collection: Specifies whether logs are collected when cluster installation fails.
               Default to true. If `log_collection` set true, the OBS buckets will be created and only used to collect logs that
               record MapReduce cluster creation failures. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] manager_admin_pass: Specifies the administrator password, which is used to log in to
               the cluster management page. The password can contain 8 to 26 charactors and cannot be the username or the username
               spelled backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
               characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] master_node_ip: The IP address of the master node.
        :param pulumi.Input[pulumi.InputType['ClusterMasterNodesArgs']] master_nodes: Specifies a list of the informations about the master nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `master_nodes` is documented below.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] name: Specifies the name of the MapReduce cluster. The name can contain 2 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce cluster resource.
        :param pulumi.Input[str] node_admin_pass: Specifies the administrator password, which is used to log in to the
               each nodes(/ECSs). The password can contain 8 to 26 charactors and cannot be the username or the username spelled
               backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
               characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource. This parameter
               and `node_key_pair` are alternative.
        :param pulumi.Input[str] node_key_pair: Specifies the name of a key pair, which is used to log in to the each
               nodes(/ECSs). Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] private_ip: The preferred private IP address of the master node.
        :param pulumi.Input[str] public_ip: Specifies the EIP address which bound to the MapReduce cluster.
               The EIP must have been created and must be in the same region as the cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] region: The region in which to create the MapReduce cluster resource. If omitted, the
               provider-level region will be used. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[bool] safe_mode: Specifies whether the running mode of the MapReduce cluster is secure,
               default to true.
               + true: enable Kerberos authentication.
               + false: disable Kerberos authentication. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Specifies an array of one or more security group ID to attach to the
               MapReduce cluster. If using the specified security group, the group need to open the specified port (9022) rules.
        :param pulumi.Input[str] status: The cluster state, which include: running, frozen, abnormal and failed.
        :param pulumi.Input[pulumi.InputType['ClusterStreamingCoreNodesArgs']] streaming_core_nodes: Specifies a list of the informations about the streaming core nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `streaming_core_nodes` is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterStreamingTaskNodesArgs']] streaming_task_nodes: Specifies a list of the informations about the streaming task nodes in the
               MapReduce cluster.
               The `nodes` object structure of the `streaming_task_nodes` is documented below.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet which bound to the MapReduce cluster.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the cluster.
        :param pulumi.Input[str] template_id: Specifies the template used for node deployment when the cluster type is
               CUSTOM.
               + mgmt_control_combined_v2: template for jointly deploying the management and control nodes. The management and
               control roles are co-deployed on the Master node, and data instances are deployed in the same node group. This
               deployment mode applies to scenarios where the number of control nodes is less than 100, reducing costs.
               + mgmt_control_separated_v2: The management and control roles are deployed on different master nodes, and data
               instances are deployed in the same node group. This deployment mode is applicable to a cluster with 100 to 500 nodes
               and delivers better performance in high-concurrency load scenarios.
               + mgmt_control_data_separated_v2: The management role and control role are deployed on different Master nodes,
               and data instances are deployed in different node groups. This deployment mode is applicable to a cluster with more
               than 500 nodes. Components can be deployed separately, which can be used for a larger cluster scale.
        :param pulumi.Input[int] total_node_number: The total number of nodes deployed in the cluster.
        :param pulumi.Input[str] type: Specifies the type of the MapReduce cluster. The valid values are *ANALYSIS*,
               *STREAMING* and *MIXED*, default to *ANALYSIS*. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] update_time: The cluster update time, in RFC-3339 format.
        :param pulumi.Input[str] version: Specifies the MapReduce cluster version. The valid values are `MRS 1.9.2`
               , `MRS 3.0.5` and `MRS 3.1.0`. Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the VPC which bound to the MapReduce cluster. Changing
               this will create a new MapReduce cluster resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["analysis_core_nodes"] = analysis_core_nodes
        __props__.__dict__["analysis_task_nodes"] = analysis_task_nodes
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["charging_start_time"] = charging_start_time
        __props__.__dict__["component_lists"] = component_lists
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_nodes"] = custom_nodes
        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["log_collection"] = log_collection
        __props__.__dict__["manager_admin_pass"] = manager_admin_pass
        __props__.__dict__["master_node_ip"] = master_node_ip
        __props__.__dict__["master_nodes"] = master_nodes
        __props__.__dict__["name"] = name
        __props__.__dict__["node_admin_pass"] = node_admin_pass
        __props__.__dict__["node_key_pair"] = node_key_pair
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["safe_mode"] = safe_mode
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["streaming_core_nodes"] = streaming_core_nodes
        __props__.__dict__["streaming_task_nodes"] = streaming_task_nodes
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["total_node_number"] = total_node_number
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analysisCoreNodes")
    def analysis_core_nodes(self) -> pulumi.Output[Optional['outputs.ClusterAnalysisCoreNodes']]:
        """
        Specifies a list of the informations about the analysis core nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `analysis_core_nodes` is documented below.
        """
        return pulumi.get(self, "analysis_core_nodes")

    @property
    @pulumi.getter(name="analysisTaskNodes")
    def analysis_task_nodes(self) -> pulumi.Output[Optional['outputs.ClusterAnalysisTaskNodes']]:
        """
        Specifies a list of the informations about the analysis task nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `analysis_task_nodes` is documented below.
        """
        return pulumi.get(self, "analysis_task_nodes")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone in which to create the cluster.
        Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?all)
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="chargingStartTime")
    def charging_start_time(self) -> pulumi.Output[str]:
        """
        The charging start time which is the start time of billing, in RFC-3339 format.
        """
        return pulumi.get(self, "charging_start_time")

    @property
    @pulumi.getter(name="componentLists")
    def component_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the list of component names. For the components supported by
        the cluster, please following [reference](https://support.huaweicloud.com/intl/en-us/productdesc-mrs/mrs_08_0005.html)
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "component_lists")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The cluster creation time, in RFC-3339 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customNodes")
    def custom_nodes(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterCustomNode']]]:
        """
        Specifies a list of the informations about the custom nodes in the MapReduce
        cluster.
        The `nodes` object structure of the `custom_nodes` is documented below.
        `Unlike other nodes, it needs to specify group_name`
        """
        return pulumi.get(self, "custom_nodes")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[str]:
        """
        Specifies the EIP ID which bound to the MapReduce cluster.
        The EIP must have been created and must be in the same region as the cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="logCollection")
    def log_collection(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether logs are collected when cluster installation fails.
        Default to true. If `log_collection` set true, the OBS buckets will be created and only used to collect logs that
        record MapReduce cluster creation failures. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "log_collection")

    @property
    @pulumi.getter(name="managerAdminPass")
    def manager_admin_pass(self) -> pulumi.Output[str]:
        """
        Specifies the administrator password, which is used to log in to
        the cluster management page. The password can contain 8 to 26 charactors and cannot be the username or the username
        spelled backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
        characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "manager_admin_pass")

    @property
    @pulumi.getter(name="masterNodeIp")
    def master_node_ip(self) -> pulumi.Output[str]:
        """
        The IP address of the master node.
        """
        return pulumi.get(self, "master_node_ip")

    @property
    @pulumi.getter(name="masterNodes")
    def master_nodes(self) -> pulumi.Output['outputs.ClusterMasterNodes']:
        """
        Specifies a list of the informations about the master nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `master_nodes` is documented below.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "master_nodes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeAdminPass")
    def node_admin_pass(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the administrator password, which is used to log in to the
        each nodes(/ECSs). The password can contain 8 to 26 charactors and cannot be the username or the username spelled
        backwards. The password must contain lowercase letters, uppercase letters, digits, spaces and the special
        characters: `!?,.:-_{}[]@$^+=/`. Changing this will create a new MapReduce cluster resource. This parameter
        and `node_key_pair` are alternative.
        """
        return pulumi.get(self, "node_admin_pass")

    @property
    @pulumi.getter(name="nodeKeyPair")
    def node_key_pair(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the name of a key pair, which is used to log in to the each
        nodes(/ECSs). Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "node_key_pair")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        The preferred private IP address of the master node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        Specifies the EIP address which bound to the MapReduce cluster.
        The EIP must have been created and must be in the same region as the cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the MapReduce cluster resource. If omitted, the
        provider-level region will be used. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="safeMode")
    def safe_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the running mode of the MapReduce cluster is secure,
        default to true.
        + true: enable Kerberos authentication.
        + false: disable Kerberos authentication. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "safe_mode")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies an array of one or more security group ID to attach to the
        MapReduce cluster. If using the specified security group, the group need to open the specified port (9022) rules.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The cluster state, which include: running, frozen, abnormal and failed.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="streamingCoreNodes")
    def streaming_core_nodes(self) -> pulumi.Output[Optional['outputs.ClusterStreamingCoreNodes']]:
        """
        Specifies a list of the informations about the streaming core nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `streaming_core_nodes` is documented below.
        """
        return pulumi.get(self, "streaming_core_nodes")

    @property
    @pulumi.getter(name="streamingTaskNodes")
    def streaming_task_nodes(self) -> pulumi.Output[Optional['outputs.ClusterStreamingTaskNodes']]:
        """
        Specifies a list of the informations about the streaming task nodes in the
        MapReduce cluster.
        The `nodes` object structure of the `streaming_task_nodes` is documented below.
        """
        return pulumi.get(self, "streaming_task_nodes")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the network ID of a subnet which bound to the MapReduce cluster.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the template used for node deployment when the cluster type is
        CUSTOM.
        + mgmt_control_combined_v2: template for jointly deploying the management and control nodes. The management and
        control roles are co-deployed on the Master node, and data instances are deployed in the same node group. This
        deployment mode applies to scenarios where the number of control nodes is less than 100, reducing costs.
        + mgmt_control_separated_v2: The management and control roles are deployed on different master nodes, and data
        instances are deployed in the same node group. This deployment mode is applicable to a cluster with 100 to 500 nodes
        and delivers better performance in high-concurrency load scenarios.
        + mgmt_control_data_separated_v2: The management role and control role are deployed on different Master nodes,
        and data instances are deployed in different node groups. This deployment mode is applicable to a cluster with more
        than 500 nodes. Components can be deployed separately, which can be used for a larger cluster scale.
        """
        return pulumi.get(self, "template_id")

    @property
    @pulumi.getter(name="totalNodeNumber")
    def total_node_number(self) -> pulumi.Output[int]:
        """
        The total number of nodes deployed in the cluster.
        """
        return pulumi.get(self, "total_node_number")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the MapReduce cluster. The valid values are *ANALYSIS*,
        *STREAMING* and *MIXED*, default to *ANALYSIS*. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The cluster update time, in RFC-3339 format.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Specifies the MapReduce cluster version. The valid values are `MRS 1.9.2`
        , `MRS 3.0.5` and `MRS 3.1.0`. Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the VPC which bound to the MapReduce cluster. Changing
        this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "vpc_id")

