# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterAnalysisCoreNodesArgs',
    'ClusterAnalysisTaskNodesArgs',
    'ClusterCustomNodeArgs',
    'ClusterMasterNodesArgs',
    'ClusterStreamingCoreNodesArgs',
    'ClusterStreamingTaskNodesArgs',
]

@pulumi.input_type
class ClusterAnalysisCoreNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[int],
                 flavor: pulumi.Input[str],
                 node_number: pulumi.Input[int],
                 root_volume_size: pulumi.Input[int],
                 root_volume_type: pulumi.Input[str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_volume_size: Optional[pulumi.Input[int]] = None,
                 data_volume_type: Optional[pulumi.Input[str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param pulumi.Input[str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[int] node_number: Specifies the number of nodes for the node group.
        :param pulumi.Input[int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param pulumi.Input[int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_volume_count", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_volume_type", value)

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_volume_size", value)

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_volume_type", value)

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_ips", value)


@pulumi.input_type
class ClusterAnalysisTaskNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[int],
                 flavor: pulumi.Input[str],
                 node_number: pulumi.Input[int],
                 root_volume_size: pulumi.Input[int],
                 root_volume_type: pulumi.Input[str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_volume_size: Optional[pulumi.Input[int]] = None,
                 data_volume_type: Optional[pulumi.Input[str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param pulumi.Input[str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[int] node_number: Specifies the number of nodes for the node group.
        :param pulumi.Input[int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param pulumi.Input[int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_volume_count", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_volume_type", value)

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_volume_size", value)

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_volume_type", value)

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_ips", value)


@pulumi.input_type
class ClusterCustomNodeArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[int],
                 flavor: pulumi.Input[str],
                 group_name: pulumi.Input[str],
                 node_number: pulumi.Input[int],
                 root_volume_size: pulumi.Input[int],
                 root_volume_type: pulumi.Input[str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_volume_size: Optional[pulumi.Input[int]] = None,
                 data_volume_type: Optional[pulumi.Input[str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param pulumi.Input[str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[str] group_name: Specifies the name of nodes for the node group.
        :param pulumi.Input[int] node_number: Specifies the number of nodes for the node group.
        :param pulumi.Input[int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param pulumi.Input[int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_volume_count", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of nodes for the node group.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_volume_type", value)

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_volume_size", value)

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_volume_type", value)

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_ips", value)


@pulumi.input_type
class ClusterMasterNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[int],
                 flavor: pulumi.Input[str],
                 node_number: pulumi.Input[int],
                 root_volume_size: pulumi.Input[int],
                 root_volume_type: pulumi.Input[str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_volume_size: Optional[pulumi.Input[int]] = None,
                 data_volume_type: Optional[pulumi.Input[str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param pulumi.Input[str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[int] node_number: Specifies the number of nodes for the node group.
        :param pulumi.Input[int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param pulumi.Input[int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_volume_count", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_volume_type", value)

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_volume_size", value)

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_volume_type", value)

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_ips", value)


@pulumi.input_type
class ClusterStreamingCoreNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[int],
                 flavor: pulumi.Input[str],
                 node_number: pulumi.Input[int],
                 root_volume_size: pulumi.Input[int],
                 root_volume_type: pulumi.Input[str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_volume_size: Optional[pulumi.Input[int]] = None,
                 data_volume_type: Optional[pulumi.Input[str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param pulumi.Input[str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[int] node_number: Specifies the number of nodes for the node group.
        :param pulumi.Input[int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param pulumi.Input[int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_volume_count", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_volume_type", value)

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_volume_size", value)

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_volume_type", value)

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_ips", value)


@pulumi.input_type
class ClusterStreamingTaskNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[int],
                 flavor: pulumi.Input[str],
                 node_number: pulumi.Input[int],
                 root_volume_size: pulumi.Input[int],
                 root_volume_type: pulumi.Input[str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_volume_size: Optional[pulumi.Input[int]] = None,
                 data_volume_type: Optional[pulumi.Input[str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        :param pulumi.Input[str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[int] node_number: Specifies the number of nodes for the node group.
        :param pulumi.Input[int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
        :param pulumi.Input[int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_volume_count", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of nodes for the node group.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_volume_type", value)

    @property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_volume_size", value)

    @property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_volume_type", value)

    @property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_ips", value)


