# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConferenceConfigurationArgs',
    'ConferenceCycleParamsArgs',
    'ConferenceJoinPasswordArgs',
    'ConferenceParticipantArgs',
    'ConferenceSubconferenceArgs',
    'ConferenceSubconferenceSubconfigurationArgs',
    'ConferenceSubconferenceSubconfigurationShowAudiencePolicyArgs',
]

@pulumi.input_type
class ConferenceConfigurationArgs:
    def __init__(__self__, *,
                 allow_guest_start: Optional[pulumi.Input[bool]] = None,
                 callin_restriction: Optional[pulumi.Input[int]] = None,
                 guest_password: Optional[pulumi.Input[str]] = None,
                 is_auto_mute: Optional[pulumi.Input[bool]] = None,
                 is_guest_free_password: Optional[pulumi.Input[bool]] = None,
                 is_hard_terminal_auto_mute: Optional[pulumi.Input[bool]] = None,
                 is_send_calendar: Optional[pulumi.Input[bool]] = None,
                 is_send_notify: Optional[pulumi.Input[bool]] = None,
                 is_send_sms: Optional[pulumi.Input[bool]] = None,
                 prolong_time: Optional[pulumi.Input[int]] = None,
                 waiting_room_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] allow_guest_start: Specifies whether to allow guests to start conferences (only valid for random
               ID conferences).
        :param pulumi.Input[int] callin_restriction: Specifies the range to allow incoming calls.
               + **0**: All users.
               + **2**: Users within the enterprise.
               + **3**: The invited user.
        :param pulumi.Input[str] guest_password: Specifies the guest password (pure number which is 4 to 16 digits long).
        :param pulumi.Input[bool] is_auto_mute: Specifies whether the soft terminal is automatically muted when the guest joins the
               conference.
        :param pulumi.Input[bool] is_guest_free_password: Specifies whether the guest is password-free (only valid for random
               conferences).
        :param pulumi.Input[bool] is_hard_terminal_auto_mute: Specifies whether the guest joins the conference, whether the hard
               terminal is automatically muted.
        :param pulumi.Input[bool] is_send_calendar: Specifies whether to send conference calendar notifications.
        :param pulumi.Input[bool] is_send_notify: Specifies whether to send conference email notification.
        :param pulumi.Input[bool] is_send_sms: Specifies whether to send conference SMS notification.
        :param pulumi.Input[int] prolong_time: Specifies the Automatically extend duration, the valid value is range from `0` to
               `60`.
        :param pulumi.Input[bool] waiting_room_enabled: Specifies whether to open the waiting room (only valid for RTC enterprises).
        """
        if allow_guest_start is not None:
            pulumi.set(__self__, "allow_guest_start", allow_guest_start)
        if callin_restriction is not None:
            pulumi.set(__self__, "callin_restriction", callin_restriction)
        if guest_password is not None:
            pulumi.set(__self__, "guest_password", guest_password)
        if is_auto_mute is not None:
            pulumi.set(__self__, "is_auto_mute", is_auto_mute)
        if is_guest_free_password is not None:
            pulumi.set(__self__, "is_guest_free_password", is_guest_free_password)
        if is_hard_terminal_auto_mute is not None:
            pulumi.set(__self__, "is_hard_terminal_auto_mute", is_hard_terminal_auto_mute)
        if is_send_calendar is not None:
            pulumi.set(__self__, "is_send_calendar", is_send_calendar)
        if is_send_notify is not None:
            pulumi.set(__self__, "is_send_notify", is_send_notify)
        if is_send_sms is not None:
            pulumi.set(__self__, "is_send_sms", is_send_sms)
        if prolong_time is not None:
            pulumi.set(__self__, "prolong_time", prolong_time)
        if waiting_room_enabled is not None:
            pulumi.set(__self__, "waiting_room_enabled", waiting_room_enabled)

    @property
    @pulumi.getter(name="allowGuestStart")
    def allow_guest_start(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to allow guests to start conferences (only valid for random
        ID conferences).
        """
        return pulumi.get(self, "allow_guest_start")

    @allow_guest_start.setter
    def allow_guest_start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_guest_start", value)

    @property
    @pulumi.getter(name="callinRestriction")
    def callin_restriction(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the range to allow incoming calls.
        + **0**: All users.
        + **2**: Users within the enterprise.
        + **3**: The invited user.
        """
        return pulumi.get(self, "callin_restriction")

    @callin_restriction.setter
    def callin_restriction(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "callin_restriction", value)

    @property
    @pulumi.getter(name="guestPassword")
    def guest_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the guest password (pure number which is 4 to 16 digits long).
        """
        return pulumi.get(self, "guest_password")

    @guest_password.setter
    def guest_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guest_password", value)

    @property
    @pulumi.getter(name="isAutoMute")
    def is_auto_mute(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the soft terminal is automatically muted when the guest joins the
        conference.
        """
        return pulumi.get(self, "is_auto_mute")

    @is_auto_mute.setter
    def is_auto_mute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_mute", value)

    @property
    @pulumi.getter(name="isGuestFreePassword")
    def is_guest_free_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the guest is password-free (only valid for random
        conferences).
        """
        return pulumi.get(self, "is_guest_free_password")

    @is_guest_free_password.setter
    def is_guest_free_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_guest_free_password", value)

    @property
    @pulumi.getter(name="isHardTerminalAutoMute")
    def is_hard_terminal_auto_mute(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the guest joins the conference, whether the hard
        terminal is automatically muted.
        """
        return pulumi.get(self, "is_hard_terminal_auto_mute")

    @is_hard_terminal_auto_mute.setter
    def is_hard_terminal_auto_mute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hard_terminal_auto_mute", value)

    @property
    @pulumi.getter(name="isSendCalendar")
    def is_send_calendar(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send conference calendar notifications.
        """
        return pulumi.get(self, "is_send_calendar")

    @is_send_calendar.setter
    def is_send_calendar(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_send_calendar", value)

    @property
    @pulumi.getter(name="isSendNotify")
    def is_send_notify(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send conference email notification.
        """
        return pulumi.get(self, "is_send_notify")

    @is_send_notify.setter
    def is_send_notify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_send_notify", value)

    @property
    @pulumi.getter(name="isSendSms")
    def is_send_sms(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send conference SMS notification.
        """
        return pulumi.get(self, "is_send_sms")

    @is_send_sms.setter
    def is_send_sms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_send_sms", value)

    @property
    @pulumi.getter(name="prolongTime")
    def prolong_time(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the Automatically extend duration, the valid value is range from `0` to
        `60`.
        """
        return pulumi.get(self, "prolong_time")

    @prolong_time.setter
    def prolong_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prolong_time", value)

    @property
    @pulumi.getter(name="waitingRoomEnabled")
    def waiting_room_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to open the waiting room (only valid for RTC enterprises).
        """
        return pulumi.get(self, "waiting_room_enabled")

    @waiting_room_enabled.setter
    def waiting_room_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "waiting_room_enabled", value)


@pulumi.input_type
class ConferenceCycleParamsArgs:
    def __init__(__self__, *,
                 cycle: pulumi.Input[str],
                 end_date: pulumi.Input[str],
                 pre_remind: pulumi.Input[int],
                 start_date: pulumi.Input[str],
                 interval: Optional[pulumi.Input[int]] = None,
                 points: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        :param pulumi.Input[str] cycle: Specifies the period type. The valid values are as follows:
               + **Day**
               + **Week**
               + **Month**
        :param pulumi.Input[str] end_date: Specifies the end date of the recurring conference.
               The format is `YYYY-MM-DD`.
        :param pulumi.Input[int] pre_remind: Specifies the number of days for advance conference notice.
               The valid value is range from `0` to `30`, defaults to `1`.
        :param pulumi.Input[str] start_date: Specifies the start date of the recurring conference.
               The format is `YYYY-MM-DD`.
        :param pulumi.Input[int] interval: Specifies the cycle interval.
               For different `cycle` types, the value range of interval are as follows:
               + **Day**: Means that it will be held every few days, and the valid value is range from `1` to `15`.
               + **Week**: Means that it is held every few weeks, and the valid value is range from `1` to `5`.
               + **Month**: Means every few months, the value range is `1` to `3`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] points: Specifies the conference point in the cycle. Only valid by **Week** and **Month**.
               For different `cycle` types, the value range of elements are as follows:
               + **Week**: The valid value is range from `0` to `6`. The **0** means Sunday, **6** means Saturday.
               + **Month**: The valid range for the elements is `1` to `31`. If the value does not exist in the current month, the
               value means the end of the month.
        """
        pulumi.set(__self__, "cycle", cycle)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "pre_remind", pre_remind)
        pulumi.set(__self__, "start_date", start_date)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if points is not None:
            pulumi.set(__self__, "points", points)

    @property
    @pulumi.getter
    def cycle(self) -> pulumi.Input[str]:
        """
        Specifies the period type. The valid values are as follows:
        + **Day**
        + **Week**
        + **Month**
        """
        return pulumi.get(self, "cycle")

    @cycle.setter
    def cycle(self, value: pulumi.Input[str]):
        pulumi.set(self, "cycle", value)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Input[str]:
        """
        Specifies the end date of the recurring conference.
        The format is `YYYY-MM-DD`.
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_date", value)

    @property
    @pulumi.getter(name="preRemind")
    def pre_remind(self) -> pulumi.Input[int]:
        """
        Specifies the number of days for advance conference notice.
        The valid value is range from `0` to `30`, defaults to `1`.
        """
        return pulumi.get(self, "pre_remind")

    @pre_remind.setter
    def pre_remind(self, value: pulumi.Input[int]):
        pulumi.set(self, "pre_remind", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Input[str]:
        """
        Specifies the start date of the recurring conference.
        The format is `YYYY-MM-DD`.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the cycle interval.
        For different `cycle` types, the value range of interval are as follows:
        + **Day**: Means that it will be held every few days, and the valid value is range from `1` to `15`.
        + **Week**: Means that it is held every few weeks, and the valid value is range from `1` to `5`.
        + **Month**: Means every few months, the value range is `1` to `3`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Specifies the conference point in the cycle. Only valid by **Week** and **Month**.
        For different `cycle` types, the value range of elements are as follows:
        + **Week**: The valid value is range from `0` to `6`. The **0** means Sunday, **6** means Saturday.
        + **Month**: The valid range for the elements is `1` to `31`. If the value does not exist in the current month, the
        value means the end of the month.
        """
        return pulumi.get(self, "points")

    @points.setter
    def points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "points", value)


@pulumi.input_type
class ConferenceJoinPasswordArgs:
    def __init__(__self__, *,
                 guest: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None):
        if guest is not None:
            pulumi.set(__self__, "guest", guest)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def guest(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "guest")

    @guest.setter
    def guest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guest", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class ConferenceParticipantArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 is_auto_invite: Optional[pulumi.Input[int]] = None,
                 is_mute: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[int]] = None,
                 sms: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] account_id: Specifies the account ID of the participant.
        :param pulumi.Input[str] email: Specifies the email address.
        :param pulumi.Input[int] is_auto_invite: Specifies whether to automatically invite this participant when the conference
               starts. The valid values are as follows:
               + **0**: Do not automatically invite.
               + **1**: Automatic invitation.
        :param pulumi.Input[int] is_mute: Specifies whether the user needs to be automatically muted when joining the conference
               (only effective when invited in the conference). The valid values are as follows:
               + **0**: No mute.
               + **1**: Mute.
        :param pulumi.Input[str] name: Specifies the attendee name or nickname.
        :param pulumi.Input[str] phone: Specifies the SIP or TEL number, maximum of 127 characters.
        :param pulumi.Input[int] role: Specifies the role in the conference. The valid values are as follows:
               + **0**: Normal attendee.
               + **1**: The conference chair.
        :param pulumi.Input[str] sms: Specifies the mobile number for SMS notification, maximum of 32 characters.
        :param pulumi.Input[str] type: Specifies the call-in type. The valid values are as follows:
               + **normal**: The soft terminal.
               + **terminal**: The conference room or hard terminal.
               + **outside**: The outside participant.
               + **mobile**: The user's landline phone.
               + **ideahub**: The ideahub.
        :param pulumi.Input[str] user_id: Specifies the user ID of the participant.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if is_auto_invite is not None:
            pulumi.set(__self__, "is_auto_invite", is_auto_invite)
        if is_mute is not None:
            pulumi.set(__self__, "is_mute", is_mute)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if sms is not None:
            pulumi.set(__self__, "sms", sms)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account ID of the participant.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="isAutoInvite")
    def is_auto_invite(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to automatically invite this participant when the conference
        starts. The valid values are as follows:
        + **0**: Do not automatically invite.
        + **1**: Automatic invitation.
        """
        return pulumi.get(self, "is_auto_invite")

    @is_auto_invite.setter
    def is_auto_invite(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "is_auto_invite", value)

    @property
    @pulumi.getter(name="isMute")
    def is_mute(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether the user needs to be automatically muted when joining the conference
        (only effective when invited in the conference). The valid values are as follows:
        + **0**: No mute.
        + **1**: Mute.
        """
        return pulumi.get(self, "is_mute")

    @is_mute.setter
    def is_mute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "is_mute", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the attendee name or nickname.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SIP or TEL number, maximum of 127 characters.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the role in the conference. The valid values are as follows:
        + **0**: Normal attendee.
        + **1**: The conference chair.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def sms(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mobile number for SMS notification, maximum of 32 characters.
        """
        return pulumi.get(self, "sms")

    @sms.setter
    def sms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the call-in type. The valid values are as follows:
        + **normal**: The soft terminal.
        + **terminal**: The conference room or hard terminal.
        + **outside**: The outside participant.
        + **mobile**: The user's landline phone.
        + **ideahub**: The ideahub.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user ID of the participant.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class ConferenceSubconferenceArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 is_auto_record: Optional[pulumi.Input[int]] = None,
                 media_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 record_auth_type: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 subconfigurations: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceSubconfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] end_time: The sub-conference end time.
        :param pulumi.Input[str] id: The sub-conference ID.
        :param pulumi.Input[int] is_auto_record: Specifies whether the conference automatically starts recording, it only takes
               effect when the recording type is:
               + **1**: Automatically start recording.
               + **0**: Do not start recording automatically.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_types: Specifies the conference media type list.
               It consists of one or more enumerations, and the valid values are as follows:
               + **Voice**: Voice.
               + **Video**: SD video.
               + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
               time, the system will select Video by default).
               + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        :param pulumi.Input[int] record_auth_type: Specifies the recording authentication method.
               **0**: Viewable/downloadable via link.
               **1**: Enterprise users can watch/download.
               **2**: Attendees can watch/download.
        :param pulumi.Input[str] start_time: Specifies the conference start time (UTC time).
               The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
               There is no need to set if you book a cyclical conference.
        :param pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceSubconfigurationArgs']]] subconfigurations: The other configuration information of periodic subconferences.
               The object structure is documented below.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_auto_record is not None:
            pulumi.set(__self__, "is_auto_record", is_auto_record)
        if media_types is not None:
            pulumi.set(__self__, "media_types", media_types)
        if record_auth_type is not None:
            pulumi.set(__self__, "record_auth_type", record_auth_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if subconfigurations is not None:
            pulumi.set(__self__, "subconfigurations", subconfigurations)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The sub-conference end time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The sub-conference ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isAutoRecord")
    def is_auto_record(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether the conference automatically starts recording, it only takes
        effect when the recording type is:
        + **1**: Automatically start recording.
        + **0**: Do not start recording automatically.
        """
        return pulumi.get(self, "is_auto_record")

    @is_auto_record.setter
    def is_auto_record(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "is_auto_record", value)

    @property
    @pulumi.getter(name="mediaTypes")
    def media_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the conference media type list.
        It consists of one or more enumerations, and the valid values are as follows:
        + **Voice**: Voice.
        + **Video**: SD video.
        + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
        time, the system will select Video by default).
        + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        """
        return pulumi.get(self, "media_types")

    @media_types.setter
    def media_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "media_types", value)

    @property
    @pulumi.getter(name="recordAuthType")
    def record_auth_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the recording authentication method.
        **0**: Viewable/downloadable via link.
        **1**: Enterprise users can watch/download.
        **2**: Attendees can watch/download.
        """
        return pulumi.get(self, "record_auth_type")

    @record_auth_type.setter
    def record_auth_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_auth_type", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the conference start time (UTC time).
        The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
        There is no need to set if you book a cyclical conference.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def subconfigurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceSubconfigurationArgs']]]]:
        """
        The other configuration information of periodic subconferences.
        The object structure is documented below.
        """
        return pulumi.get(self, "subconfigurations")

    @subconfigurations.setter
    def subconfigurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceSubconfigurationArgs']]]]):
        pulumi.set(self, "subconfigurations", value)


@pulumi.input_type
class ConferenceSubconferenceSubconfigurationArgs:
    def __init__(__self__, *,
                 allow_guest_start: Optional[pulumi.Input[bool]] = None,
                 audience_callin_restriction: Optional[pulumi.Input[int]] = None,
                 callin_restriction: Optional[pulumi.Input[int]] = None,
                 show_audience_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceSubconfigurationShowAudiencePolicyArgs']]]] = None,
                 waiting_room_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] allow_guest_start: Specifies whether to allow guests to start conferences (only valid for random
               ID conferences).
        :param pulumi.Input[int] audience_callin_restriction: The range that the webinar audience is allowed to call in.
               The valid values are as follows:
               + **0**: All users.
               + **2**: Users within the enterprise.
        :param pulumi.Input[int] callin_restriction: Specifies the range to allow incoming calls.
               + **0**: All users.
               + **2**: Users within the enterprise.
               + **3**: The invited user.
        :param pulumi.Input[bool] waiting_room_enabled: Specifies whether to open the waiting room (only valid for RTC enterprises).
        """
        if allow_guest_start is not None:
            pulumi.set(__self__, "allow_guest_start", allow_guest_start)
        if audience_callin_restriction is not None:
            pulumi.set(__self__, "audience_callin_restriction", audience_callin_restriction)
        if callin_restriction is not None:
            pulumi.set(__self__, "callin_restriction", callin_restriction)
        if show_audience_policies is not None:
            pulumi.set(__self__, "show_audience_policies", show_audience_policies)
        if waiting_room_enabled is not None:
            pulumi.set(__self__, "waiting_room_enabled", waiting_room_enabled)

    @property
    @pulumi.getter(name="allowGuestStart")
    def allow_guest_start(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to allow guests to start conferences (only valid for random
        ID conferences).
        """
        return pulumi.get(self, "allow_guest_start")

    @allow_guest_start.setter
    def allow_guest_start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_guest_start", value)

    @property
    @pulumi.getter(name="audienceCallinRestriction")
    def audience_callin_restriction(self) -> Optional[pulumi.Input[int]]:
        """
        The range that the webinar audience is allowed to call in.
        The valid values are as follows:
        + **0**: All users.
        + **2**: Users within the enterprise.
        """
        return pulumi.get(self, "audience_callin_restriction")

    @audience_callin_restriction.setter
    def audience_callin_restriction(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "audience_callin_restriction", value)

    @property
    @pulumi.getter(name="callinRestriction")
    def callin_restriction(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the range to allow incoming calls.
        + **0**: All users.
        + **2**: Users within the enterprise.
        + **3**: The invited user.
        """
        return pulumi.get(self, "callin_restriction")

    @callin_restriction.setter
    def callin_restriction(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "callin_restriction", value)

    @property
    @pulumi.getter(name="showAudiencePolicies")
    def show_audience_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceSubconfigurationShowAudiencePolicyArgs']]]]:
        return pulumi.get(self, "show_audience_policies")

    @show_audience_policies.setter
    def show_audience_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceSubconfigurationShowAudiencePolicyArgs']]]]):
        pulumi.set(self, "show_audience_policies", value)

    @property
    @pulumi.getter(name="waitingRoomEnabled")
    def waiting_room_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to open the waiting room (only valid for RTC enterprises).
        """
        return pulumi.get(self, "waiting_room_enabled")

    @waiting_room_enabled.setter
    def waiting_room_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "waiting_room_enabled", value)


@pulumi.input_type
class ConferenceSubconferenceSubconfigurationShowAudiencePolicyArgs:
    def __init__(__self__, *,
                 base_audience_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[int]] = None,
                 multiple: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[int] base_audience_count: Specifies the basic number of people, the valid values is range from `0` to `10,000`.
        :param pulumi.Input[int] mode: Audience display strategy: The server is used to calculate the number of audiences and send it to the client
               to control the audience display.
               + **0**: Do not display.
               + **1**: Multiply display the number of participants, based on the real-time number of participants or the cumulative
               number of participants, the multiplication setting can be performed.
        :param pulumi.Input[float] multiple: Specifies the multiplier. The valid values is range from `0` to `10`, it can be set to 1 decimal place.
        """
        if base_audience_count is not None:
            pulumi.set(__self__, "base_audience_count", base_audience_count)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if multiple is not None:
            pulumi.set(__self__, "multiple", multiple)

    @property
    @pulumi.getter(name="baseAudienceCount")
    def base_audience_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the basic number of people, the valid values is range from `0` to `10,000`.
        """
        return pulumi.get(self, "base_audience_count")

    @base_audience_count.setter
    def base_audience_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "base_audience_count", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[int]]:
        """
        Audience display strategy: The server is used to calculate the number of audiences and send it to the client
        to control the audience display.
        + **0**: Do not display.
        + **1**: Multiply display the number of participants, based on the real-time number of participants or the cumulative
        number of participants, the multiplication setting can be performed.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def multiple(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the multiplier. The valid values is range from `0` to `10`, it can be set to 1 decimal place.
        """
        return pulumi.get(self, "multiple")

    @multiple.setter
    def multiple(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "multiple", value)


