# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['StreamArgs', 'Stream']

@pulumi.input_type
class StreamArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[str],
                 stream_name: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Stream resource.
        :param pulumi.Input[str] group_id: Specifies the ID of a created log group. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] stream_name: Specifies the log stream name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] region: The region in which to create the log stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new log stream resource.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "stream_name", stream_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of a created log group. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Input[str]:
        """
        Specifies the log stream name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "stream_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the log stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new log stream resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _StreamState:
    def __init__(__self__, *,
                 filter_count: Optional[pulumi.Input[int]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stream_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Stream resources.
        :param pulumi.Input[int] filter_count: Number of log stream filters.
        :param pulumi.Input[str] group_id: Specifies the ID of a created log group. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] region: The region in which to create the log stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new log stream resource.
        :param pulumi.Input[str] stream_name: Specifies the log stream name. Changing this parameter will create a new
               resource.
        """
        if filter_count is not None:
            pulumi.set(__self__, "filter_count", filter_count)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter(name="filterCount")
    def filter_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of log stream filters.
        """
        return pulumi.get(self, "filter_count")

    @filter_count.setter
    def filter_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "filter_count", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a created log group. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the log stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new log stream resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the log stream name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_name", value)


class Stream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stream_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manage a log stream resource within HuaweiCloud.

        ## Example Usage
        ### create a log stream

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_group = huaweicloud.lts.Group("testGroup",
            group_name="test_group",
            ttl_in_days=1)
        test_stream = huaweicloud.lts.Stream("testStream",
            group_id=test_group.id,
            stream_name="testacc_stream")
        ```

        ## Import

        Log stream can be imported using the lts group ID and stream ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Lts/stream:Stream stream_1 393f2bfd-2244-11ea-adb7-286ed488c87f/72855918-20b1-11ea-80e0-286ed488c880
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_id: Specifies the ID of a created log group. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] region: The region in which to create the log stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new log stream resource.
        :param pulumi.Input[str] stream_name: Specifies the log stream name. Changing this parameter will create a new
               resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a log stream resource within HuaweiCloud.

        ## Example Usage
        ### create a log stream

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_group = huaweicloud.lts.Group("testGroup",
            group_name="test_group",
            ttl_in_days=1)
        test_stream = huaweicloud.lts.Stream("testStream",
            group_id=test_group.id,
            stream_name="testacc_stream")
        ```

        ## Import

        Log stream can be imported using the lts group ID and stream ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Lts/stream:Stream stream_1 393f2bfd-2244-11ea-adb7-286ed488c87f/72855918-20b1-11ea-80e0-286ed488c880
        ```

        :param str resource_name: The name of the resource.
        :param StreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stream_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamArgs.__new__(StreamArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["region"] = region
            if stream_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_name'")
            __props__.__dict__["stream_name"] = stream_name
            __props__.__dict__["filter_count"] = None
        super(Stream, __self__).__init__(
            'huaweicloud:Lts/stream:Stream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filter_count: Optional[pulumi.Input[int]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            stream_name: Optional[pulumi.Input[str]] = None) -> 'Stream':
        """
        Get an existing Stream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] filter_count: Number of log stream filters.
        :param pulumi.Input[str] group_id: Specifies the ID of a created log group. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] region: The region in which to create the log stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new log stream resource.
        :param pulumi.Input[str] stream_name: Specifies the log stream name. Changing this parameter will create a new
               resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamState.__new__(_StreamState)

        __props__.__dict__["filter_count"] = filter_count
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["region"] = region
        __props__.__dict__["stream_name"] = stream_name
        return Stream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="filterCount")
    def filter_count(self) -> pulumi.Output[int]:
        """
        Number of log stream filters.
        """
        return pulumi.get(self, "filter_count")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of a created log group. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the log stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new log stream resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Output[str]:
        """
        Specifies the log stream name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "stream_name")

