# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TranscodingArgs', 'Transcoding']

@pulumi.input_type
class TranscodingArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[str],
                 domain_name: pulumi.Input[str],
                 templates: pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateArgs']]],
                 video_encoding: pulumi.Input[str],
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Transcoding resource.
        :param pulumi.Input[str] app_name: Specifies the application name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] domain_name: Specifies the ingest domain name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateArgs']]] templates: Specifies the video quality templates.
               The object structure is documented below. A maximum of 4 templates can be added.
               For resolution and bitrate settings in the presets,
               please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-live/live01000802.html).
        :param pulumi.Input[str] video_encoding: Specifies the video codec. The valid values are **H264** and **H265**.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies whether to enable low bitrate HD rates. If enabled
               the output media will have a lower bitrate with the same image quality. Defaults to `false`.
        :param pulumi.Input[str] region: Specifies the region in which to create this resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "templates", templates)
        pulumi.set(__self__, "video_encoding", video_encoding)
        if low_bitrate_hd is not None:
            pulumi.set(__self__, "low_bitrate_hd", low_bitrate_hd)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[str]:
        """
        Specifies the application name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Specifies the ingest domain name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def templates(self) -> pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateArgs']]]:
        """
        Specifies the video quality templates.
        The object structure is documented below. A maximum of 4 templates can be added.
        For resolution and bitrate settings in the presets,
        please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-live/live01000802.html).
        """
        return pulumi.get(self, "templates")

    @templates.setter
    def templates(self, value: pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateArgs']]]):
        pulumi.set(self, "templates", value)

    @property
    @pulumi.getter(name="videoEncoding")
    def video_encoding(self) -> pulumi.Input[str]:
        """
        Specifies the video codec. The valid values are **H264** and **H265**.
        """
        return pulumi.get(self, "video_encoding")

    @video_encoding.setter
    def video_encoding(self, value: pulumi.Input[str]):
        pulumi.set(self, "video_encoding", value)

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable low bitrate HD rates. If enabled
        the output media will have a lower bitrate with the same image quality. Defaults to `false`.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @low_bitrate_hd.setter
    def low_bitrate_hd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "low_bitrate_hd", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create this resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TranscodingState:
    def __init__(__self__, *,
                 app_name: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 templates: Optional[pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateArgs']]]] = None,
                 video_encoding: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Transcoding resources.
        :param pulumi.Input[str] app_name: Specifies the application name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] domain_name: Specifies the ingest domain name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies whether to enable low bitrate HD rates. If enabled
               the output media will have a lower bitrate with the same image quality. Defaults to `false`.
        :param pulumi.Input[str] region: Specifies the region in which to create this resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateArgs']]] templates: Specifies the video quality templates.
               The object structure is documented below. A maximum of 4 templates can be added.
               For resolution and bitrate settings in the presets,
               please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-live/live01000802.html).
        :param pulumi.Input[str] video_encoding: Specifies the video codec. The valid values are **H264** and **H265**.
        """
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if low_bitrate_hd is not None:
            pulumi.set(__self__, "low_bitrate_hd", low_bitrate_hd)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)
        if video_encoding is not None:
            pulumi.set(__self__, "video_encoding", video_encoding)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the application name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ingest domain name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable low bitrate HD rates. If enabled
        the output media will have a lower bitrate with the same image quality. Defaults to `false`.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @low_bitrate_hd.setter
    def low_bitrate_hd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "low_bitrate_hd", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create this resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateArgs']]]]:
        """
        Specifies the video quality templates.
        The object structure is documented below. A maximum of 4 templates can be added.
        For resolution and bitrate settings in the presets,
        please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-live/live01000802.html).
        """
        return pulumi.get(self, "templates")

    @templates.setter
    def templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TranscodingTemplateArgs']]]]):
        pulumi.set(self, "templates", value)

    @property
    @pulumi.getter(name="videoEncoding")
    def video_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the video codec. The valid values are **H264** and **H265**.
        """
        return pulumi.get(self, "video_encoding")

    @video_encoding.setter
    def video_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "video_encoding", value)


class Transcoding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 templates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateArgs']]]]] = None,
                 video_encoding: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Live transcoding within HuaweiCloud.

        ## Example Usage
        ### Create a transcoding

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        ingest_domain_name = config.require_object("ingestDomainName")
        ingest_domain = huaweicloud.live.Domain("ingestDomain", type="push")
        test = huaweicloud.live.Transcoding("test",
            domain_name=ingest_domain.name,
            app_name="live",
            video_encoding="H264",
            templates=[huaweicloud.live.TranscodingTemplateArgs(
                name="L",
                width=300,
                height=400,
                bitrate=300,
            )])
        ```

        ## Import

        Transcodings can be imported using the `domain_name` and `app_name`, separated by a slash. e.g.

        ```sh
         $ pulumi import huaweicloud:Live/transcoding:Transcoding test play.example.demo.com/live
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_name: Specifies the application name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] domain_name: Specifies the ingest domain name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies whether to enable low bitrate HD rates. If enabled
               the output media will have a lower bitrate with the same image quality. Defaults to `false`.
        :param pulumi.Input[str] region: Specifies the region in which to create this resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateArgs']]]] templates: Specifies the video quality templates.
               The object structure is documented below. A maximum of 4 templates can be added.
               For resolution and bitrate settings in the presets,
               please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-live/live01000802.html).
        :param pulumi.Input[str] video_encoding: Specifies the video codec. The valid values are **H264** and **H265**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TranscodingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Live transcoding within HuaweiCloud.

        ## Example Usage
        ### Create a transcoding

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        ingest_domain_name = config.require_object("ingestDomainName")
        ingest_domain = huaweicloud.live.Domain("ingestDomain", type="push")
        test = huaweicloud.live.Transcoding("test",
            domain_name=ingest_domain.name,
            app_name="live",
            video_encoding="H264",
            templates=[huaweicloud.live.TranscodingTemplateArgs(
                name="L",
                width=300,
                height=400,
                bitrate=300,
            )])
        ```

        ## Import

        Transcodings can be imported using the `domain_name` and `app_name`, separated by a slash. e.g.

        ```sh
         $ pulumi import huaweicloud:Live/transcoding:Transcoding test play.example.demo.com/live
        ```

        :param str resource_name: The name of the resource.
        :param TranscodingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TranscodingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 templates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateArgs']]]]] = None,
                 video_encoding: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TranscodingArgs.__new__(TranscodingArgs)

            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["low_bitrate_hd"] = low_bitrate_hd
            __props__.__dict__["region"] = region
            if templates is None and not opts.urn:
                raise TypeError("Missing required property 'templates'")
            __props__.__dict__["templates"] = templates
            if video_encoding is None and not opts.urn:
                raise TypeError("Missing required property 'video_encoding'")
            __props__.__dict__["video_encoding"] = video_encoding
        super(Transcoding, __self__).__init__(
            'huaweicloud:Live/transcoding:Transcoding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_name: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            low_bitrate_hd: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            templates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateArgs']]]]] = None,
            video_encoding: Optional[pulumi.Input[str]] = None) -> 'Transcoding':
        """
        Get an existing Transcoding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_name: Specifies the application name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] domain_name: Specifies the ingest domain name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] low_bitrate_hd: Specifies whether to enable low bitrate HD rates. If enabled
               the output media will have a lower bitrate with the same image quality. Defaults to `false`.
        :param pulumi.Input[str] region: Specifies the region in which to create this resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TranscodingTemplateArgs']]]] templates: Specifies the video quality templates.
               The object structure is documented below. A maximum of 4 templates can be added.
               For resolution and bitrate settings in the presets,
               please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-live/live01000802.html).
        :param pulumi.Input[str] video_encoding: Specifies the video codec. The valid values are **H264** and **H265**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TranscodingState.__new__(_TranscodingState)

        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["low_bitrate_hd"] = low_bitrate_hd
        __props__.__dict__["region"] = region
        __props__.__dict__["templates"] = templates
        __props__.__dict__["video_encoding"] = video_encoding
        return Transcoding(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[str]:
        """
        Specifies the application name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Specifies the ingest domain name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="lowBitrateHd")
    def low_bitrate_hd(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable low bitrate HD rates. If enabled
        the output media will have a lower bitrate with the same image quality. Defaults to `false`.
        """
        return pulumi.get(self, "low_bitrate_hd")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create this resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def templates(self) -> pulumi.Output[Sequence['outputs.TranscodingTemplate']]:
        """
        Specifies the video quality templates.
        The object structure is documented below. A maximum of 4 templates can be added.
        For resolution and bitrate settings in the presets,
        please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-live/live01000802.html).
        """
        return pulumi.get(self, "templates")

    @property
    @pulumi.getter(name="videoEncoding")
    def video_encoding(self) -> pulumi.Output[str]:
        """
        Specifies the video codec. The valid values are **H264** and **H265**.
        """
        return pulumi.get(self, "video_encoding")

