# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'RecordingFlv',
    'RecordingHls',
    'RecordingMp4',
    'RecordingObs',
    'TranscodingTemplate',
]

@pulumi.output_type
class RecordingFlv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordingLength":
            suggest = "recording_length"
        elif key == "fileNaming":
            suggest = "file_naming"
        elif key == "maxStreamPauseLength":
            suggest = "max_stream_pause_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordingFlv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordingFlv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordingFlv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recording_length: int,
                 file_naming: Optional[str] = None,
                 max_stream_pause_length: Optional[int] = None):
        """
        :param int recording_length: Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
               A stream exceeding the recording length will generate a new recording.
        :param str file_naming: Specifies the path and file name prefix of a recording file. The default value is
               `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        :param int max_stream_pause_length: Specifies the interval threshold for combining recording chunks. If the
               stream pause length exceeds the value of this parameter, a new recording is generated.
               Value range: 0 ~ 300, unit: `second`.
               If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        pulumi.set(__self__, "recording_length", recording_length)
        if file_naming is not None:
            pulumi.set(__self__, "file_naming", file_naming)
        if max_stream_pause_length is not None:
            pulumi.set(__self__, "max_stream_pause_length", max_stream_pause_length)

    @property
    @pulumi.getter(name="recordingLength")
    def recording_length(self) -> int:
        """
        Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
        A stream exceeding the recording length will generate a new recording.
        """
        return pulumi.get(self, "recording_length")

    @property
    @pulumi.getter(name="fileNaming")
    def file_naming(self) -> Optional[str]:
        """
        Specifies the path and file name prefix of a recording file. The default value is
        `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        """
        return pulumi.get(self, "file_naming")

    @property
    @pulumi.getter(name="maxStreamPauseLength")
    def max_stream_pause_length(self) -> Optional[int]:
        """
        Specifies the interval threshold for combining recording chunks. If the
        stream pause length exceeds the value of this parameter, a new recording is generated.
        Value range: 0 ~ 300, unit: `second`.
        If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        return pulumi.get(self, "max_stream_pause_length")


@pulumi.output_type
class RecordingHls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordingLength":
            suggest = "recording_length"
        elif key == "fileNaming":
            suggest = "file_naming"
        elif key == "maxStreamPauseLength":
            suggest = "max_stream_pause_length"
        elif key == "tsFileNaming":
            suggest = "ts_file_naming"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordingHls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordingHls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordingHls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recording_length: int,
                 file_naming: Optional[str] = None,
                 max_stream_pause_length: Optional[int] = None,
                 ts_file_naming: Optional[str] = None):
        """
        :param int recording_length: Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
               A stream exceeding the recording length will generate a new recording.
        :param str file_naming: Specifies the path and file name prefix of a recording file. The default value is
               `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        :param int max_stream_pause_length: Specifies the interval threshold for combining recording chunks. If the
               stream pause length exceeds the value of this parameter, a new recording is generated.
               Value range: 0 ~ 300, unit: `second`.
               If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        :param str ts_file_naming: Specifies TS file name prefix.
               The default value is `{file_start_time_unix}_{file_end_time_unix}_{ts_sequence_number}`.
        """
        pulumi.set(__self__, "recording_length", recording_length)
        if file_naming is not None:
            pulumi.set(__self__, "file_naming", file_naming)
        if max_stream_pause_length is not None:
            pulumi.set(__self__, "max_stream_pause_length", max_stream_pause_length)
        if ts_file_naming is not None:
            pulumi.set(__self__, "ts_file_naming", ts_file_naming)

    @property
    @pulumi.getter(name="recordingLength")
    def recording_length(self) -> int:
        """
        Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
        A stream exceeding the recording length will generate a new recording.
        """
        return pulumi.get(self, "recording_length")

    @property
    @pulumi.getter(name="fileNaming")
    def file_naming(self) -> Optional[str]:
        """
        Specifies the path and file name prefix of a recording file. The default value is
        `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        """
        return pulumi.get(self, "file_naming")

    @property
    @pulumi.getter(name="maxStreamPauseLength")
    def max_stream_pause_length(self) -> Optional[int]:
        """
        Specifies the interval threshold for combining recording chunks. If the
        stream pause length exceeds the value of this parameter, a new recording is generated.
        Value range: 0 ~ 300, unit: `second`.
        If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        return pulumi.get(self, "max_stream_pause_length")

    @property
    @pulumi.getter(name="tsFileNaming")
    def ts_file_naming(self) -> Optional[str]:
        """
        Specifies TS file name prefix.
        The default value is `{file_start_time_unix}_{file_end_time_unix}_{ts_sequence_number}`.
        """
        return pulumi.get(self, "ts_file_naming")


@pulumi.output_type
class RecordingMp4(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordingLength":
            suggest = "recording_length"
        elif key == "fileNaming":
            suggest = "file_naming"
        elif key == "maxStreamPauseLength":
            suggest = "max_stream_pause_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordingMp4. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordingMp4.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordingMp4.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recording_length: int,
                 file_naming: Optional[str] = None,
                 max_stream_pause_length: Optional[int] = None):
        """
        :param int recording_length: Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
               A stream exceeding the recording length will generate a new recording.
        :param str file_naming: Specifies the path and file name prefix of a recording file. The default value is
               `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        :param int max_stream_pause_length: Specifies the interval threshold for combining recording chunks. If the
               stream pause length exceeds the value of this parameter, a new recording is generated.
               Value range: 0 ~ 300, unit: `second`.
               If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        pulumi.set(__self__, "recording_length", recording_length)
        if file_naming is not None:
            pulumi.set(__self__, "file_naming", file_naming)
        if max_stream_pause_length is not None:
            pulumi.set(__self__, "max_stream_pause_length", max_stream_pause_length)

    @property
    @pulumi.getter(name="recordingLength")
    def recording_length(self) -> int:
        """
        Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
        A stream exceeding the recording length will generate a new recording.
        """
        return pulumi.get(self, "recording_length")

    @property
    @pulumi.getter(name="fileNaming")
    def file_naming(self) -> Optional[str]:
        """
        Specifies the path and file name prefix of a recording file. The default value is
        `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        """
        return pulumi.get(self, "file_naming")

    @property
    @pulumi.getter(name="maxStreamPauseLength")
    def max_stream_pause_length(self) -> Optional[int]:
        """
        Specifies the interval threshold for combining recording chunks. If the
        stream pause length exceeds the value of this parameter, a new recording is generated.
        Value range: 0 ~ 300, unit: `second`.
        If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        return pulumi.get(self, "max_stream_pause_length")


@pulumi.output_type
class RecordingObs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 region: str,
                 object: Optional[str] = None):
        """
        :param str bucket: Specifies OBS bucket.
        :param str region: Specifies the region of OBS.
        :param str object: Specifies OBS object path. If omitted, recordings will be saved to the root directory.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "region", region)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Specifies OBS bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Specifies the region of OBS.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        Specifies OBS object path. If omitted, recordings will be saved to the root directory.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class TranscodingTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frameRate":
            suggest = "frame_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TranscodingTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TranscodingTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TranscodingTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitrate: int,
                 height: int,
                 name: str,
                 width: int,
                 frame_rate: Optional[int] = None):
        """
        :param int bitrate: Specifies the bitrate of a transcoded video, in kbit/s. Value range: 40 ~ 30000.
        :param int height: Specifies video height (unit: pixel).
               + **When the video encoding is H264**, value range: 32 ~ 2160 and must be a multiple of 2.
               + **When the video encoding is H265**, value range: 240 ~ 2160 and must be a multiple of 4.
        :param str name: Specifies the template name. The name can contain a maximum of 64 characters, and only
               contains letters, digits and hyphens (-).
        :param int width: Specifies video width (unit: pixel).
               + **When the video encoding is H264**, value range: 32 ~ 3840 and must be a multiple of 2.
               + **When the video encoding is H265**, value range: 320 ~ 3840 and must be a multiple of 4.
        :param int frame_rate: Specifies the frame rate of the transcoded video, in fps. Value range: 0 ~ 30.
               Value 0 indicates that the frame rate remains unchanged.
        """
        pulumi.set(__self__, "bitrate", bitrate)
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "width", width)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)

    @property
    @pulumi.getter
    def bitrate(self) -> int:
        """
        Specifies the bitrate of a transcoded video, in kbit/s. Value range: 40 ~ 30000.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter
    def height(self) -> int:
        """
        Specifies video height (unit: pixel).
        + **When the video encoding is H264**, value range: 32 ~ 2160 and must be a multiple of 2.
        + **When the video encoding is H265**, value range: 240 ~ 2160 and must be a multiple of 4.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the template name. The name can contain a maximum of 64 characters, and only
        contains letters, digits and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def width(self) -> int:
        """
        Specifies video width (unit: pixel).
        + **When the video encoding is H264**, value range: 32 ~ 3840 and must be a multiple of 2.
        + **When the video encoding is H265**, value range: 320 ~ 3840 and must be a multiple of 4.
        """
        return pulumi.get(self, "width")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[int]:
        """
        Specifies the frame rate of the transcoded video, in fps. Value range: 0 ~ 30.
        Value 0 indicates that the frame rate remains unchanged.
        """
        return pulumi.get(self, "frame_rate")


