# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 ingest_domain_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[str] type: Specifies the type of domain name. The options are as follows:
               + **pull**: streaming domain name.
               + **push**: ingest domain name.
        :param pulumi.Input[str] ingest_domain_name: Specifies the ingest domain name, which associates with the streaming
               domain name to push streams to nearby CDN nodes.
        :param pulumi.Input[str] name: Specifies the domain name. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the Live domain resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: Specifies status of the domain name. The options are as follows:
               + **on**: enable the domain name.
               + **off**: disable the domain name.
        """
        pulumi.set(__self__, "type", type)
        if ingest_domain_name is not None:
            pulumi.set(__self__, "ingest_domain_name", ingest_domain_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of domain name. The options are as follows:
        + **pull**: streaming domain name.
        + **push**: ingest domain name.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="ingestDomainName")
    def ingest_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ingest domain name, which associates with the streaming
        domain name to push streams to nearby CDN nodes.
        """
        return pulumi.get(self, "ingest_domain_name")

    @ingest_domain_name.setter
    def ingest_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingest_domain_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the domain name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the Live domain resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies status of the domain name. The options are as follows:
        + **on**: enable the domain name.
        + **off**: disable the domain name.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 cname: Optional[pulumi.Input[str]] = None,
                 ingest_domain_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[str] cname: CNAME record of the domain name.
        :param pulumi.Input[str] ingest_domain_name: Specifies the ingest domain name, which associates with the streaming
               domain name to push streams to nearby CDN nodes.
        :param pulumi.Input[str] name: Specifies the domain name. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the Live domain resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: Specifies status of the domain name. The options are as follows:
               + **on**: enable the domain name.
               + **off**: disable the domain name.
        :param pulumi.Input[str] type: Specifies the type of domain name. The options are as follows:
               + **pull**: streaming domain name.
               + **push**: ingest domain name.
        """
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if ingest_domain_name is not None:
            pulumi.set(__self__, "ingest_domain_name", ingest_domain_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[str]]:
        """
        CNAME record of the domain name.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname", value)

    @property
    @pulumi.getter(name="ingestDomainName")
    def ingest_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ingest domain name, which associates with the streaming
        domain name to push streams to nearby CDN nodes.
        """
        return pulumi.get(self, "ingest_domain_name")

    @ingest_domain_name.setter
    def ingest_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingest_domain_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the domain name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the Live domain resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies status of the domain name. The options are as follows:
        + **on**: enable the domain name.
        + **off**: disable the domain name.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of domain name. The options are as follows:
        + **pull**: streaming domain name.
        + **push**: ingest domain name.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingest_domain_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Live domain within HuaweiCloud.

        ## Example Usage
        ### Create an ingest domain name and a streaming domain name

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        ingest_domain_name = config.require_object("ingestDomainName")
        streaming_domain_name = config.require_object("streamingDomainName")
        ingest_domain = huaweicloud.live.Domain("ingestDomain", type="push")
        streaming_domain = huaweicloud.live.Domain("streamingDomain",
            type="pull",
            ingest_domain_name=ingest_domain.name)
        ```

        ## Import

        Domains can be imported using the `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Live/domain:Domain test domainName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ingest_domain_name: Specifies the ingest domain name, which associates with the streaming
               domain name to push streams to nearby CDN nodes.
        :param pulumi.Input[str] name: Specifies the domain name. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the Live domain resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: Specifies status of the domain name. The options are as follows:
               + **on**: enable the domain name.
               + **off**: disable the domain name.
        :param pulumi.Input[str] type: Specifies the type of domain name. The options are as follows:
               + **pull**: streaming domain name.
               + **push**: ingest domain name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Live domain within HuaweiCloud.

        ## Example Usage
        ### Create an ingest domain name and a streaming domain name

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        ingest_domain_name = config.require_object("ingestDomainName")
        streaming_domain_name = config.require_object("streamingDomainName")
        ingest_domain = huaweicloud.live.Domain("ingestDomain", type="push")
        streaming_domain = huaweicloud.live.Domain("streamingDomain",
            type="pull",
            ingest_domain_name=ingest_domain.name)
        ```

        ## Import

        Domains can be imported using the `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Live/domain:Domain test domainName
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingest_domain_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["ingest_domain_name"] = ingest_domain_name
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = status
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["cname"] = None
        super(Domain, __self__).__init__(
            'huaweicloud:Live/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cname: Optional[pulumi.Input[str]] = None,
            ingest_domain_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cname: CNAME record of the domain name.
        :param pulumi.Input[str] ingest_domain_name: Specifies the ingest domain name, which associates with the streaming
               domain name to push streams to nearby CDN nodes.
        :param pulumi.Input[str] name: Specifies the domain name. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the Live domain resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: Specifies status of the domain name. The options are as follows:
               + **on**: enable the domain name.
               + **off**: disable the domain name.
        :param pulumi.Input[str] type: Specifies the type of domain name. The options are as follows:
               + **pull**: streaming domain name.
               + **push**: ingest domain name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["cname"] = cname
        __props__.__dict__["ingest_domain_name"] = ingest_domain_name
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cname(self) -> pulumi.Output[str]:
        """
        CNAME record of the domain name.
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter(name="ingestDomainName")
    def ingest_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ingest domain name, which associates with the streaming
        domain name to push streams to nearby CDN nodes.
        """
        return pulumi.get(self, "ingest_domain_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the domain name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the Live domain resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Specifies status of the domain name. The options are as follows:
        + **on**: enable the domain name.
        + **off**: disable the domain name.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the type of domain name. The options are as follows:
        + **pull**: streaming domain name.
        + **push**: ingest domain name.
        """
        return pulumi.get(self, "type")

