# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DataforwardingRuleTarget',
    'DataforwardingRuleTargetAmqpForwarding',
    'DataforwardingRuleTargetDisForwarding',
    'DataforwardingRuleTargetHttpForwarding',
    'DataforwardingRuleTargetKafkaForwarding',
    'DataforwardingRuleTargetKafkaForwardingAddress',
    'DataforwardingRuleTargetObsForwarding',
    'DeviceLinkageRuleAction',
    'DeviceLinkageRuleActionDeviceAlarm',
    'DeviceLinkageRuleActionDeviceCommand',
    'DeviceLinkageRuleActionSmnForwarding',
    'DeviceLinkageRuleEffectivePeriod',
    'DeviceLinkageRuleTrigger',
    'DeviceLinkageRuleTriggerDailyTimerCondition',
    'DeviceLinkageRuleTriggerDeviceDataCondition',
    'DeviceLinkageRuleTriggerSimpleTimerCondition',
    'ProductService',
    'ProductServiceCommand',
    'ProductServiceCommandPara',
    'ProductServiceCommandResponse',
    'ProductServiceProperty',
]

@pulumi.output_type
class DataforwardingRuleTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amqpForwarding":
            suggest = "amqp_forwarding"
        elif key == "disForwarding":
            suggest = "dis_forwarding"
        elif key == "httpForwarding":
            suggest = "http_forwarding"
        elif key == "kafkaForwarding":
            suggest = "kafka_forwarding"
        elif key == "obsForwarding":
            suggest = "obs_forwarding"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataforwardingRuleTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataforwardingRuleTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataforwardingRuleTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 amqp_forwarding: Optional['outputs.DataforwardingRuleTargetAmqpForwarding'] = None,
                 dis_forwarding: Optional['outputs.DataforwardingRuleTargetDisForwarding'] = None,
                 http_forwarding: Optional['outputs.DataforwardingRuleTargetHttpForwarding'] = None,
                 id: Optional[str] = None,
                 kafka_forwarding: Optional['outputs.DataforwardingRuleTargetKafkaForwarding'] = None,
                 obs_forwarding: Optional['outputs.DataforwardingRuleTargetObsForwarding'] = None):
        """
        :param str type: Specifies the type of forwarding target. The options are as follows:
               + **HTTP_FORWARDING**: The platform can push specified device data to a Third-party application (HTTP push).
               You can set different addresses that different types of device data are pushed to.
               + **DIS_FORWARDING**: DIS provides efficient collection, transmission, and distribution of real-time data. It also
               provides an abundant selection of APIs to help you quickly create real-time data applications.
               + **OBS_FORWARDING**: OBS is a stable, secure, cloud storage service that is scalable, efficient and easy-to-use.
               It allows you to store any amount of unstructured data in any format, and provides REST APIs so you can access your
               data from anywhere.
               + **AMQP_FORWARDING**: AMQP provides a scalable, distributed message queue that supports high throughput with low
               latency. AMQP is ready from the get-go and is O&M free.
               + **DMS_KAFKA_FORWARDING**: Distributed Message Service (DMS) for Kafka features high throughput, concurrency, and
               scalability. It is suitable for real-time data transmission, stream data processing, system decoupling,
               and traffic balancing.
        :param 'DataforwardingRuleTargetAmqpForwardingArgs' amqp_forwarding: Specifies the detail of AMQP forwards. It is required when type
               is `AMQP_FORWARDING`. The amqp_forwarding structure is documented below.
        :param 'DataforwardingRuleTargetDisForwardingArgs' dis_forwarding: Specifies the detail of the DIS forwards. It is required when type
               is `DIS_FORWARDING`. The dis_forwarding structure is documented below.
        :param 'DataforwardingRuleTargetHttpForwardingArgs' http_forwarding: Specifies the detail of the HTTP forwards. It is required when type
               is `HTTP_FORWARDING`. The http_forwarding structure is documented below.
        :param str id: The resource ID in UUID format.
        :param 'DataforwardingRuleTargetKafkaForwardingArgs' kafka_forwarding: Specifies the detail of the KAFKA forwards. It is required when type
               is `DMS_KAFKA_FORWARDING`. The properties structure is documented below.
        :param 'DataforwardingRuleTargetObsForwardingArgs' obs_forwarding: Specifies the detail of the OBS forwards. It is required when type
               is `OBS_FORWARDING`. The obs_forwarding structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if amqp_forwarding is not None:
            pulumi.set(__self__, "amqp_forwarding", amqp_forwarding)
        if dis_forwarding is not None:
            pulumi.set(__self__, "dis_forwarding", dis_forwarding)
        if http_forwarding is not None:
            pulumi.set(__self__, "http_forwarding", http_forwarding)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kafka_forwarding is not None:
            pulumi.set(__self__, "kafka_forwarding", kafka_forwarding)
        if obs_forwarding is not None:
            pulumi.set(__self__, "obs_forwarding", obs_forwarding)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of forwarding target. The options are as follows:
        + **HTTP_FORWARDING**: The platform can push specified device data to a Third-party application (HTTP push).
        You can set different addresses that different types of device data are pushed to.
        + **DIS_FORWARDING**: DIS provides efficient collection, transmission, and distribution of real-time data. It also
        provides an abundant selection of APIs to help you quickly create real-time data applications.
        + **OBS_FORWARDING**: OBS is a stable, secure, cloud storage service that is scalable, efficient and easy-to-use.
        It allows you to store any amount of unstructured data in any format, and provides REST APIs so you can access your
        data from anywhere.
        + **AMQP_FORWARDING**: AMQP provides a scalable, distributed message queue that supports high throughput with low
        latency. AMQP is ready from the get-go and is O&M free.
        + **DMS_KAFKA_FORWARDING**: Distributed Message Service (DMS) for Kafka features high throughput, concurrency, and
        scalability. It is suitable for real-time data transmission, stream data processing, system decoupling,
        and traffic balancing.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="amqpForwarding")
    def amqp_forwarding(self) -> Optional['outputs.DataforwardingRuleTargetAmqpForwarding']:
        """
        Specifies the detail of AMQP forwards. It is required when type
        is `AMQP_FORWARDING`. The amqp_forwarding structure is documented below.
        """
        return pulumi.get(self, "amqp_forwarding")

    @property
    @pulumi.getter(name="disForwarding")
    def dis_forwarding(self) -> Optional['outputs.DataforwardingRuleTargetDisForwarding']:
        """
        Specifies the detail of the DIS forwards. It is required when type
        is `DIS_FORWARDING`. The dis_forwarding structure is documented below.
        """
        return pulumi.get(self, "dis_forwarding")

    @property
    @pulumi.getter(name="httpForwarding")
    def http_forwarding(self) -> Optional['outputs.DataforwardingRuleTargetHttpForwarding']:
        """
        Specifies the detail of the HTTP forwards. It is required when type
        is `HTTP_FORWARDING`. The http_forwarding structure is documented below.
        """
        return pulumi.get(self, "http_forwarding")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource ID in UUID format.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kafkaForwarding")
    def kafka_forwarding(self) -> Optional['outputs.DataforwardingRuleTargetKafkaForwarding']:
        """
        Specifies the detail of the KAFKA forwards. It is required when type
        is `DMS_KAFKA_FORWARDING`. The properties structure is documented below.
        """
        return pulumi.get(self, "kafka_forwarding")

    @property
    @pulumi.getter(name="obsForwarding")
    def obs_forwarding(self) -> Optional['outputs.DataforwardingRuleTargetObsForwarding']:
        """
        Specifies the detail of the OBS forwards. It is required when type
        is `OBS_FORWARDING`. The obs_forwarding structure is documented below.
        """
        return pulumi.get(self, "obs_forwarding")


@pulumi.output_type
class DataforwardingRuleTargetAmqpForwarding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataforwardingRuleTargetAmqpForwarding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataforwardingRuleTargetAmqpForwarding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataforwardingRuleTargetAmqpForwarding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue_name: str):
        """
        :param str queue_name: Specifies the AMQP Queue name.
        """
        pulumi.set(__self__, "queue_name", queue_name)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> str:
        """
        Specifies the AMQP Queue name.
        """
        return pulumi.get(self, "queue_name")


@pulumi.output_type
class DataforwardingRuleTargetDisForwarding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamId":
            suggest = "stream_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataforwardingRuleTargetDisForwarding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataforwardingRuleTargetDisForwarding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataforwardingRuleTargetDisForwarding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 stream_id: str,
                 project_id: Optional[str] = None):
        """
        :param str region: Specifies the region to which the KAFKA belongs.
        :param str stream_id: Specifies the DIS stream ID.
        :param str project_id: Specifies the project ID to which the KAFKA belongs.
               If omitted, the default project in the region will be used.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "stream_id", stream_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> str:
        """
        Specifies the DIS stream ID.
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Specifies the project ID to which the KAFKA belongs.
        If omitted, the default project in the region will be used.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class DataforwardingRuleTargetHttpForwarding(dict):
    def __init__(__self__, *,
                 url: str):
        """
        :param str url: Specifies the Push URL. The request method must is post.
        """
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Specifies the Push URL. The request method must is post.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DataforwardingRuleTargetKafkaForwarding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataforwardingRuleTargetKafkaForwarding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataforwardingRuleTargetKafkaForwarding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataforwardingRuleTargetKafkaForwarding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Sequence['outputs.DataforwardingRuleTargetKafkaForwardingAddress'],
                 region: str,
                 topic: str,
                 password: Optional[str] = None,
                 project_id: Optional[str] = None,
                 user_name: Optional[str] = None):
        """
        :param Sequence['DataforwardingRuleTargetKafkaForwardingAddressArgs'] addresses: Specifies the list of the connected service addresses.
               The addresses structure is documented below.
        :param str region: Specifies the region to which the KAFKA belongs.
        :param str topic: Specifies the topic.
        :param str password: Specifies the password.
        :param str project_id: Specifies the project ID to which the KAFKA belongs.
               If omitted, the default project in the region will be used.
        :param str user_name: Specifies the SASL user name.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "topic", topic)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.DataforwardingRuleTargetKafkaForwardingAddress']:
        """
        Specifies the list of the connected service addresses.
        The addresses structure is documented below.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        Specifies the topic.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Specifies the password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Specifies the project ID to which the KAFKA belongs.
        If omitted, the default project in the region will be used.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        Specifies the SASL user name.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class DataforwardingRuleTargetKafkaForwardingAddress(dict):
    def __init__(__self__, *,
                 port: int,
                 domain: Optional[str] = None,
                 ip: Optional[str] = None):
        """
        :param int port: Specifies the port of the connected service address.
        :param str domain: Specifies the domain of the connected service address.
               Exactly one of `ip` or `domain` must be provided.
        :param str ip: Specifies the IP of the connected service address.
               Exactly one of `ip` or `domain` must be provided.
        """
        pulumi.set(__self__, "port", port)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Specifies the port of the connected service address.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Specifies the domain of the connected service address.
        Exactly one of `ip` or `domain` must be provided.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        Specifies the IP of the connected service address.
        Exactly one of `ip` or `domain` must be provided.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class DataforwardingRuleTargetObsForwarding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customDirectory":
            suggest = "custom_directory"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataforwardingRuleTargetObsForwarding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataforwardingRuleTargetObsForwarding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataforwardingRuleTargetObsForwarding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 region: str,
                 custom_directory: Optional[str] = None,
                 project_id: Optional[str] = None):
        """
        :param str bucket: Specifies the OBS Bucket.
        :param str region: Specifies the region to which the KAFKA belongs.
        :param str custom_directory: Specifies the custom directory for storing channel files. The ID contains a
               maximum of 256 characters. Multi-level directories can be separated by (/), and cannot start or end with a slash (/),
               and cannot contain more than two adjacent slashes (/). Only letters, digits, hyphens (-), underscores (_), slash (/)
               and braces ({}) are allowed. Braces can be used only for the time template parameters. For example, if the custom
               directory is in the format of {YYYY}/{MM}/{DD}/{HH}, data is generated in the directory based on the current
               time(for example, 2022/06/14/10) when data is forwarded.
        :param str project_id: Specifies the project ID to which the KAFKA belongs.
               If omitted, the default project in the region will be used.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "region", region)
        if custom_directory is not None:
            pulumi.set(__self__, "custom_directory", custom_directory)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Specifies the OBS Bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="customDirectory")
    def custom_directory(self) -> Optional[str]:
        """
        Specifies the custom directory for storing channel files. The ID contains a
        maximum of 256 characters. Multi-level directories can be separated by (/), and cannot start or end with a slash (/),
        and cannot contain more than two adjacent slashes (/). Only letters, digits, hyphens (-), underscores (_), slash (/)
        and braces ({}) are allowed. Braces can be used only for the time template parameters. For example, if the custom
        directory is in the format of {YYYY}/{MM}/{DD}/{HH}, data is generated in the directory based on the current
        time(for example, 2022/06/14/10) when data is forwarded.
        """
        return pulumi.get(self, "custom_directory")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Specifies the project ID to which the KAFKA belongs.
        If omitted, the default project in the region will be used.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class DeviceLinkageRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceAlarm":
            suggest = "device_alarm"
        elif key == "deviceCommand":
            suggest = "device_command"
        elif key == "smnForwarding":
            suggest = "smn_forwarding"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceLinkageRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceLinkageRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceLinkageRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 device_alarm: Optional['outputs.DeviceLinkageRuleActionDeviceAlarm'] = None,
                 device_command: Optional['outputs.DeviceLinkageRuleActionDeviceCommand'] = None,
                 smn_forwarding: Optional['outputs.DeviceLinkageRuleActionSmnForwarding'] = None):
        """
        :param str type: Specifies the type of the alarm. The options are as follows:
               + **fault**: Report alarms.
               + **recovery**: Clear alarms.
        :param 'DeviceLinkageRuleActionDeviceAlarmArgs' device_alarm: Specifies the detail of device alarm. It is required when type
               is `DEVICE_ALARM`. The device_alarm structure is documented below.
        :param 'DeviceLinkageRuleActionDeviceCommandArgs' device_command: Specifies the detail of device command. It is required when type
               is `DEVICE_CMD`. The device_command structure is documented below.
        :param 'DeviceLinkageRuleActionSmnForwardingArgs' smn_forwarding: Specifies the detail of SMN notifications. It is required when type
               is `SMN_FORWARDING`. The smn_forwarding structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if device_alarm is not None:
            pulumi.set(__self__, "device_alarm", device_alarm)
        if device_command is not None:
            pulumi.set(__self__, "device_command", device_command)
        if smn_forwarding is not None:
            pulumi.set(__self__, "smn_forwarding", smn_forwarding)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the alarm. The options are as follows:
        + **fault**: Report alarms.
        + **recovery**: Clear alarms.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="deviceAlarm")
    def device_alarm(self) -> Optional['outputs.DeviceLinkageRuleActionDeviceAlarm']:
        """
        Specifies the detail of device alarm. It is required when type
        is `DEVICE_ALARM`. The device_alarm structure is documented below.
        """
        return pulumi.get(self, "device_alarm")

    @property
    @pulumi.getter(name="deviceCommand")
    def device_command(self) -> Optional['outputs.DeviceLinkageRuleActionDeviceCommand']:
        """
        Specifies the detail of device command. It is required when type
        is `DEVICE_CMD`. The device_command structure is documented below.
        """
        return pulumi.get(self, "device_command")

    @property
    @pulumi.getter(name="smnForwarding")
    def smn_forwarding(self) -> Optional['outputs.DeviceLinkageRuleActionSmnForwarding']:
        """
        Specifies the detail of SMN notifications. It is required when type
        is `SMN_FORWARDING`. The smn_forwarding structure is documented below.
        """
        return pulumi.get(self, "smn_forwarding")


@pulumi.output_type
class DeviceLinkageRuleActionDeviceAlarm(dict):
    def __init__(__self__, *,
                 name: str,
                 severity: str,
                 type: str,
                 description: Optional[str] = None):
        """
        :param str name: Specifies the name of the alarm.
        :param str severity: Specifies the severity level of the alarm.
               The valid values are **warning**, **minor**, **major** and **critical**.
        :param str type: Specifies the type of the alarm. The options are as follows:
               + **fault**: Report alarms.
               + **recovery**: Clear alarms.
        :param str description: Specifies the description of the alarm.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the alarm.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Specifies the severity level of the alarm.
        The valid values are **warning**, **minor**, **major** and **critical**.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the alarm. The options are as follows:
        + **fault**: Report alarms.
        + **recovery**: Clear alarms.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the alarm.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class DeviceLinkageRuleActionDeviceCommand(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandBody":
            suggest = "command_body"
        elif key == "commandName":
            suggest = "command_name"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "serviceId":
            suggest = "service_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceLinkageRuleActionDeviceCommand. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceLinkageRuleActionDeviceCommand.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceLinkageRuleActionDeviceCommand.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_body: str,
                 command_name: str,
                 device_id: str,
                 service_id: str):
        """
        :param str command_body: Specifies the command parameters, in json format.
               + Example of device command using LWM2M protocol: `{"value":"1"}`, there are key-value pairs, each key is the
               parameter name of the command in the product model.
               + Example of device command using MQTT protocol: `{"header": {"mode": "ACK","from": "/users/testUser","method":
               "SET_TEMPERATURE_READ_PERIOD","to":"/devices/{device_id }/services/{service_id}"},"body": {"value" : "1"}}`.
               - **mode**: Required, whether the device needs to reply to the confirmation message after receiving the command.
               The default is ACK mode. `ACK` indicates that the confirmation message needs to be replied,
               `NOACK` indicates that the confirmation message does not need to be replied.
               - **from**: Optional, the address of the command sender.
               When the App initiates a request, the format is /users/{userId},
               when the application server initiates a request, the format is /{serviceName},
               and when the IoT platform initiates a request, the format is /cloud/{serviceName}.
               - **to**: optional, the address of the command receiver, the format is /devices/{device_id}/services/{service_id}.
               - **method**: optional, the command name defined in the product model.
               - **body**: optional, the message body of the command, which contains key-value pairs, each key is the parameter
               name of the command in the product model. The specific format requires application and device conventions.
        :param str command_name: Specifies the command name.
        :param str device_id: Specifies the device id which excutes the command.
        :param str service_id: Specifies the service id to which the command belongs.
        """
        pulumi.set(__self__, "command_body", command_body)
        pulumi.set(__self__, "command_name", command_name)
        pulumi.set(__self__, "device_id", device_id)
        pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter(name="commandBody")
    def command_body(self) -> str:
        """
        Specifies the command parameters, in json format.
        + Example of device command using LWM2M protocol: `{"value":"1"}`, there are key-value pairs, each key is the
        parameter name of the command in the product model.
        + Example of device command using MQTT protocol: `{"header": {"mode": "ACK","from": "/users/testUser","method":
        "SET_TEMPERATURE_READ_PERIOD","to":"/devices/{device_id }/services/{service_id}"},"body": {"value" : "1"}}`.
        - **mode**: Required, whether the device needs to reply to the confirmation message after receiving the command.
        The default is ACK mode. `ACK` indicates that the confirmation message needs to be replied,
        `NOACK` indicates that the confirmation message does not need to be replied.
        - **from**: Optional, the address of the command sender.
        When the App initiates a request, the format is /users/{userId},
        when the application server initiates a request, the format is /{serviceName},
        and when the IoT platform initiates a request, the format is /cloud/{serviceName}.
        - **to**: optional, the address of the command receiver, the format is /devices/{device_id}/services/{service_id}.
        - **method**: optional, the command name defined in the product model.
        - **body**: optional, the message body of the command, which contains key-value pairs, each key is the parameter
        name of the command in the product model. The specific format requires application and device conventions.
        """
        return pulumi.get(self, "command_body")

    @property
    @pulumi.getter(name="commandName")
    def command_name(self) -> str:
        """
        Specifies the command name.
        """
        return pulumi.get(self, "command_name")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> str:
        """
        Specifies the device id which excutes the command.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> str:
        """
        Specifies the service id to which the command belongs.
        """
        return pulumi.get(self, "service_id")


@pulumi.output_type
class DeviceLinkageRuleActionSmnForwarding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageContent":
            suggest = "message_content"
        elif key == "messageTitle":
            suggest = "message_title"
        elif key == "topicName":
            suggest = "topic_name"
        elif key == "topicUrn":
            suggest = "topic_urn"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceLinkageRuleActionSmnForwarding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceLinkageRuleActionSmnForwarding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceLinkageRuleActionSmnForwarding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_content: str,
                 message_title: str,
                 region: str,
                 topic_name: str,
                 topic_urn: str,
                 project_id: Optional[str] = None):
        """
        :param str message_content: Specifies the message content.
        :param str message_title: Specifies the message title.
        :param str region: Specifies the region to which the SMN belongs.
        :param str topic_name: Specifies the topic name of the SMN.
        :param str topic_urn: Specifies the topic URN of the SMN.
        :param str project_id: Specifies the project ID to which the SMN belongs.
               If omitted, the default project in the region will be used.
        """
        pulumi.set(__self__, "message_content", message_content)
        pulumi.set(__self__, "message_title", message_title)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "topic_name", topic_name)
        pulumi.set(__self__, "topic_urn", topic_urn)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="messageContent")
    def message_content(self) -> str:
        """
        Specifies the message content.
        """
        return pulumi.get(self, "message_content")

    @property
    @pulumi.getter(name="messageTitle")
    def message_title(self) -> str:
        """
        Specifies the message title.
        """
        return pulumi.get(self, "message_title")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Specifies the region to which the SMN belongs.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> str:
        """
        Specifies the topic name of the SMN.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> str:
        """
        Specifies the topic URN of the SMN.
        """
        return pulumi.get(self, "topic_urn")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Specifies the project ID to which the SMN belongs.
        If omitted, the default project in the region will be used.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class DeviceLinkageRuleEffectivePeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "daysOfWeek":
            suggest = "days_of_week"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceLinkageRuleEffectivePeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceLinkageRuleEffectivePeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceLinkageRuleEffectivePeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 start_time: str,
                 days_of_week: Optional[str] = None):
        """
        :param str end_time: Specifies the end time, in the format: `HH:mm`.
               For example: `10:00`. If the end time is the same as the start time, the effective period is the whole day.
        :param str start_time: Specifies the start time, in the format: `HH:mm`.
               For example: `03:00`.
        :param str days_of_week: Specifies a list of days of week, separated by commas. 1 represents Sunday,
               2 represents Monday, and so on. Defaults to `1,2,3,4,5,6,7` (every day).
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Specifies the end time, in the format: `HH:mm`.
        For example: `10:00`. If the end time is the same as the start time, the effective period is the whole day.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the start time, in the format: `HH:mm`.
        For example: `03:00`.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[str]:
        """
        Specifies a list of days of week, separated by commas. 1 represents Sunday,
        2 represents Monday, and so on. Defaults to `1,2,3,4,5,6,7` (every day).
        """
        return pulumi.get(self, "days_of_week")


@pulumi.output_type
class DeviceLinkageRuleTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailyTimerCondition":
            suggest = "daily_timer_condition"
        elif key == "deviceDataCondition":
            suggest = "device_data_condition"
        elif key == "simpleTimerCondition":
            suggest = "simple_timer_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceLinkageRuleTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceLinkageRuleTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceLinkageRuleTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 daily_timer_condition: Optional['outputs.DeviceLinkageRuleTriggerDailyTimerCondition'] = None,
                 device_data_condition: Optional['outputs.DeviceLinkageRuleTriggerDeviceDataCondition'] = None,
                 simple_timer_condition: Optional['outputs.DeviceLinkageRuleTriggerSimpleTimerCondition'] = None):
        """
        :param str type: Specifies the type of the alarm. The options are as follows:
               + **fault**: Report alarms.
               + **recovery**: Clear alarms.
        :param 'DeviceLinkageRuleTriggerDailyTimerConditionArgs' daily_timer_condition: Specifies the condition triggered at specified time every day. It is
               required when type is `DAILY_TIMER`. The daily_timer_condition structure is
               documented below.
        :param 'DeviceLinkageRuleTriggerDeviceDataConditionArgs' device_data_condition: Specifies the condition triggered upon the property of device. It is
               required when type is `DEVICE_DATA`. The device_data_condition structure is
               documented below.
        :param 'DeviceLinkageRuleTriggerSimpleTimerConditionArgs' simple_timer_condition: Specifies the condition triggered by policy. It is required when type
               is `SIMPLE_TIMER`. The simple_timer_condition structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if daily_timer_condition is not None:
            pulumi.set(__self__, "daily_timer_condition", daily_timer_condition)
        if device_data_condition is not None:
            pulumi.set(__self__, "device_data_condition", device_data_condition)
        if simple_timer_condition is not None:
            pulumi.set(__self__, "simple_timer_condition", simple_timer_condition)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the alarm. The options are as follows:
        + **fault**: Report alarms.
        + **recovery**: Clear alarms.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dailyTimerCondition")
    def daily_timer_condition(self) -> Optional['outputs.DeviceLinkageRuleTriggerDailyTimerCondition']:
        """
        Specifies the condition triggered at specified time every day. It is
        required when type is `DAILY_TIMER`. The daily_timer_condition structure is
        documented below.
        """
        return pulumi.get(self, "daily_timer_condition")

    @property
    @pulumi.getter(name="deviceDataCondition")
    def device_data_condition(self) -> Optional['outputs.DeviceLinkageRuleTriggerDeviceDataCondition']:
        """
        Specifies the condition triggered upon the property of device. It is
        required when type is `DEVICE_DATA`. The device_data_condition structure is
        documented below.
        """
        return pulumi.get(self, "device_data_condition")

    @property
    @pulumi.getter(name="simpleTimerCondition")
    def simple_timer_condition(self) -> Optional['outputs.DeviceLinkageRuleTriggerSimpleTimerCondition']:
        """
        Specifies the condition triggered by policy. It is required when type
        is `SIMPLE_TIMER`. The simple_timer_condition structure is documented below.
        """
        return pulumi.get(self, "simple_timer_condition")


@pulumi.output_type
class DeviceLinkageRuleTriggerDailyTimerCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "daysOfWeek":
            suggest = "days_of_week"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceLinkageRuleTriggerDailyTimerCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceLinkageRuleTriggerDailyTimerCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceLinkageRuleTriggerDailyTimerCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 days_of_week: Optional[str] = None):
        """
        :param str start_time: Specifies the start time, in the format: `HH:mm`.
               For example: `03:00`.
        :param str days_of_week: Specifies a list of days of week, separated by commas. 1 represents Sunday,
               2 represents Monday, and so on. Defaults to `1,2,3,4,5,6,7` (every day).
        """
        pulumi.set(__self__, "start_time", start_time)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the start time, in the format: `HH:mm`.
        For example: `03:00`.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[str]:
        """
        Specifies a list of days of week, separated by commas. 1 represents Sunday,
        2 represents Monday, and so on. Defaults to `1,2,3,4,5,6,7` (every day).
        """
        return pulumi.get(self, "days_of_week")


@pulumi.output_type
class DeviceLinkageRuleTriggerDeviceDataCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataValidatiyPeriod":
            suggest = "data_validatiy_period"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "productId":
            suggest = "product_id"
        elif key == "triggerStrategy":
            suggest = "trigger_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceLinkageRuleTriggerDeviceDataCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceLinkageRuleTriggerDeviceDataCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceLinkageRuleTriggerDeviceDataCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: str,
                 path: str,
                 value: str,
                 data_validatiy_period: Optional[int] = None,
                 device_id: Optional[str] = None,
                 product_id: Optional[str] = None,
                 trigger_strategy: Optional[str] = None):
        """
        :param str operator: Specifies the data comparison operator. The valid values are: **>**, **<**,
               **>=**, **<=**, **=** and **between**.
        :param str path: Specifies the path of the device property, in the format: **service_id/DataProperty**.
        :param str value: Specifies the Rvalue of a data comparison expression. When the `operator` is `between`,
               the Rvalue represents the minimum and maximum values, separated by commas, such as "20,30",
               which means greater than or equal to 20 and less than 30.
        :param int data_validatiy_period: Specifies data validity period, Unit is `seconds`. Defaults to `300`.
               For example, if Data Validity Period is set to 30 minutes, a device generates data at 19:00, and the platform receives
               the data at 20:00, the action is nottriggered regardless of whether the conditions are met.
        :param str device_id: Specifies the device id which excutes the command.
        :param str product_id: Specifies the product id, all devices belonging to this product will trigger
               the rule. Exactly one of `device_id` or `product_id` must be provided.
        :param str trigger_strategy: Specifies the trigger strategy. The options are as follows:
               + **pulse**: When the data reported by the device meets the conditions, the rule can be triggered.
               + **reverse**: Repetition suppression. For example, if an alarm is configured to be triggered when the battery level
               is lower than 20%, the alarm will be triggered once the battery initially drops below 20% but will not be triggered
               again each time the battery drops to a lower level.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "value", value)
        if data_validatiy_period is not None:
            pulumi.set(__self__, "data_validatiy_period", data_validatiy_period)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if trigger_strategy is not None:
            pulumi.set(__self__, "trigger_strategy", trigger_strategy)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Specifies the data comparison operator. The valid values are: **>**, **<**,
        **>=**, **<=**, **=** and **between**.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the path of the device property, in the format: **service_id/DataProperty**.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the Rvalue of a data comparison expression. When the `operator` is `between`,
        the Rvalue represents the minimum and maximum values, separated by commas, such as "20,30",
        which means greater than or equal to 20 and less than 30.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="dataValidatiyPeriod")
    def data_validatiy_period(self) -> Optional[int]:
        """
        Specifies data validity period, Unit is `seconds`. Defaults to `300`.
        For example, if Data Validity Period is set to 30 minutes, a device generates data at 19:00, and the platform receives
        the data at 20:00, the action is nottriggered regardless of whether the conditions are met.
        """
        return pulumi.get(self, "data_validatiy_period")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[str]:
        """
        Specifies the device id which excutes the command.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[str]:
        """
        Specifies the product id, all devices belonging to this product will trigger
        the rule. Exactly one of `device_id` or `product_id` must be provided.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="triggerStrategy")
    def trigger_strategy(self) -> Optional[str]:
        """
        Specifies the trigger strategy. The options are as follows:
        + **pulse**: When the data reported by the device meets the conditions, the rule can be triggered.
        + **reverse**: Repetition suppression. For example, if an alarm is configured to be triggered when the battery level
        is lower than 20%, the alarm will be triggered once the battery initially drops below 20% but will not be triggered
        again each time the battery drops to a lower level.
        """
        return pulumi.get(self, "trigger_strategy")


@pulumi.output_type
class DeviceLinkageRuleTriggerSimpleTimerCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repeatCount":
            suggest = "repeat_count"
        elif key == "repeatInterval":
            suggest = "repeat_interval"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceLinkageRuleTriggerSimpleTimerCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceLinkageRuleTriggerSimpleTimerCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceLinkageRuleTriggerSimpleTimerCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repeat_count: int,
                 repeat_interval: int,
                 start_time: str):
        """
        :param int repeat_count: Specifies total number of repetition.
        :param int repeat_interval: Specifies the interval of repetition, Unit is `minutes`.
        :param str start_time: Specifies the start time, in the format: `HH:mm`.
               For example: `03:00`.
        """
        pulumi.set(__self__, "repeat_count", repeat_count)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="repeatCount")
    def repeat_count(self) -> int:
        """
        Specifies total number of repetition.
        """
        return pulumi.get(self, "repeat_count")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> int:
        """
        Specifies the interval of repetition, Unit is `minutes`.
        """
        return pulumi.get(self, "repeat_interval")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the start time, in the format: `HH:mm`.
        For example: `03:00`.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ProductService(dict):
    def __init__(__self__, *,
                 id: str,
                 commands: Optional[Sequence['outputs.ProductServiceCommand']] = None,
                 description: Optional[str] = None,
                 properties: Optional[Sequence['outputs.ProductServiceProperty']] = None,
                 type: Optional[str] = None):
        """
        :param str id: Specifies the service ID. The ID contains a maximum of 64 characters. Only letters,
               Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are allowed: `?'#().,&%@!`.
        :param Sequence['ProductServiceCommandArgs'] commands: Specifies the list of commands for the service.
               The commands structure is documented below.
        :param str description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param Sequence['ProductServicePropertyArgs'] properties: Specifies the list of properties for the service.
               The properties structure is documented below.
        :param str type: Specifies the type of the parameter.
               The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        pulumi.set(__self__, "id", id)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the service ID. The ID contains a maximum of 64 characters. Only letters,
        Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence['outputs.ProductServiceCommand']]:
        """
        Specifies the list of commands for the service.
        The commands structure is documented below.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence['outputs.ProductServiceProperty']]:
        """
        Specifies the list of properties for the service.
        The properties structure is documented below.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the parameter.
        The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ProductServiceCommand(dict):
    def __init__(__self__, *,
                 name: str,
                 paras: Optional[Sequence['outputs.ProductServiceCommandPara']] = None,
                 responses: Optional[Sequence['outputs.ProductServiceCommandResponse']] = None):
        """
        :param str name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param Sequence['ProductServiceCommandParaArgs'] paras: Specifies the list of parameters for the command.
               The paras structure is documented below.
        :param Sequence['ProductServiceCommandResponseArgs'] responses: Specifies the list of responses for the command.
               The responses structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if paras is not None:
            pulumi.set(__self__, "paras", paras)
        if responses is not None:
            pulumi.set(__self__, "responses", responses)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def paras(self) -> Optional[Sequence['outputs.ProductServiceCommandPara']]:
        """
        Specifies the list of parameters for the command.
        The paras structure is documented below.
        """
        return pulumi.get(self, "paras")

    @property
    @pulumi.getter
    def responses(self) -> Optional[Sequence['outputs.ProductServiceCommandResponse']]:
        """
        Specifies the list of responses for the command.
        The responses structure is documented below.
        """
        return pulumi.get(self, "responses")


@pulumi.output_type
class ProductServiceCommandPara(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enumLists":
            suggest = "enum_lists"
        elif key == "maxLength":
            suggest = "max_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProductServiceCommandPara. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProductServiceCommandPara.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProductServiceCommandPara.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 description: Optional[str] = None,
                 enum_lists: Optional[Sequence[str]] = None,
                 max: Optional[str] = None,
                 max_length: Optional[int] = None,
                 min: Optional[str] = None,
                 step: Optional[float] = None,
                 unit: Optional[str] = None):
        """
        :param str name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param str type: Specifies the type of the parameter.
               The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        :param str description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param str max: Specifies the max value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        :param int max_length: Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
               **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        :param str min: Specifies the min value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        :param float step: Specifies the step of the parameter when the `type` is **int** or **decimal**.
               Value range: 0 ~ 2147483647. Defaults to **0**.
        :param str unit: Specifies the unit of the parameter when the `type` is **int** or **decimal**.
               The unit contains a maximum of 16 characters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum_lists is not None:
            pulumi.set(__self__, "enum_lists", enum_lists)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the parameter.
        The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enumLists")
    def enum_lists(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "enum_lists")

    @property
    @pulumi.getter
    def max(self) -> Optional[str]:
        """
        Specifies the max value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[int]:
        """
        Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
        **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter
    def min(self) -> Optional[str]:
        """
        Specifies the min value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def step(self) -> Optional[float]:
        """
        Specifies the step of the parameter when the `type` is **int** or **decimal**.
        Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        Specifies the unit of the parameter when the `type` is **int** or **decimal**.
        The unit contains a maximum of 16 characters.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ProductServiceCommandResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enumLists":
            suggest = "enum_lists"
        elif key == "maxLength":
            suggest = "max_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProductServiceCommandResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProductServiceCommandResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProductServiceCommandResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 description: Optional[str] = None,
                 enum_lists: Optional[Sequence[str]] = None,
                 max: Optional[str] = None,
                 max_length: Optional[int] = None,
                 min: Optional[str] = None,
                 step: Optional[float] = None,
                 unit: Optional[str] = None):
        """
        :param str name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param str type: Specifies the type of the parameter.
               The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        :param str description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param str max: Specifies the max value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        :param int max_length: Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
               **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        :param str min: Specifies the min value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        :param float step: Specifies the step of the parameter when the `type` is **int** or **decimal**.
               Value range: 0 ~ 2147483647. Defaults to **0**.
        :param str unit: Specifies the unit of the parameter when the `type` is **int** or **decimal**.
               The unit contains a maximum of 16 characters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum_lists is not None:
            pulumi.set(__self__, "enum_lists", enum_lists)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the parameter.
        The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enumLists")
    def enum_lists(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "enum_lists")

    @property
    @pulumi.getter
    def max(self) -> Optional[str]:
        """
        Specifies the max value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[int]:
        """
        Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
        **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter
    def min(self) -> Optional[str]:
        """
        Specifies the min value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def step(self) -> Optional[float]:
        """
        Specifies the step of the parameter when the `type` is **int** or **decimal**.
        Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        Specifies the unit of the parameter when the `type` is **int** or **decimal**.
        The unit contains a maximum of 16 characters.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ProductServiceProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enumLists":
            suggest = "enum_lists"
        elif key == "maxLength":
            suggest = "max_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProductServiceProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProductServiceProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProductServiceProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: str,
                 name: str,
                 type: str,
                 description: Optional[str] = None,
                 enum_lists: Optional[Sequence[str]] = None,
                 max: Optional[str] = None,
                 max_length: Optional[int] = None,
                 min: Optional[str] = None,
                 step: Optional[float] = None,
                 unit: Optional[str] = None):
        """
        :param str name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param str type: Specifies the type of the parameter.
               The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        :param str description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param str max: Specifies the max value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        :param int max_length: Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
               **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        :param str min: Specifies the min value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        :param float step: Specifies the step of the parameter when the `type` is **int** or **decimal**.
               Value range: 0 ~ 2147483647. Defaults to **0**.
        :param str unit: Specifies the unit of the parameter when the `type` is **int** or **decimal**.
               The unit contains a maximum of 16 characters.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum_lists is not None:
            pulumi.set(__self__, "enum_lists", enum_lists)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def method(self) -> str:
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the parameter.
        The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enumLists")
    def enum_lists(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "enum_lists")

    @property
    @pulumi.getter
    def max(self) -> Optional[str]:
        """
        Specifies the max value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[int]:
        """
        Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
        **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter
    def min(self) -> Optional[str]:
        """
        Specifies the min value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def step(self) -> Optional[float]:
        """
        Specifies the step of the parameter when the `type` is **int** or **decimal**.
        Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        Specifies the unit of the parameter when the `type` is **int** or **decimal**.
        The unit contains a maximum of 16 characters.
        """
        return pulumi.get(self, "unit")


