# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DeviceArgs', 'Device']

@pulumi.input_type
class DeviceArgs:
    def __init__(__self__, *,
                 node_id: pulumi.Input[str],
                 product_id: pulumi.Input[str],
                 space_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 frozen: Optional[pulumi.Input[bool]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Device resource.
        :param pulumi.Input[str] node_id: Specifies the node ID, which contains 4 to 256 characters.
               The node ID can be IMEI, MAC address, or serial number. Changing this parameter will create a new resource.
        :param pulumi.Input[str] product_id: Specifies the product ID which the device belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which the device belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of device. The description contains a maximum of 2048
               characters. Only letters, Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters
               are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] device_id: Specifies the device ID, which contains 4 to 256 characters.
               Only letters, digits, hyphens (-) and underscore (_) are allowed. If omitted, the platform will automatically allocate
               a device ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] fingerprint: Specifies a fingerprint of X.509 certificate for identity authentication,
               which is a 40-digit or 64-digit hexadecimal string. For more detail, please see
               [Registering a Device Authenticated by an X.509 Certificate](https://support.huaweicloud.com/en-us/usermanual-iothub/iot_01_0055.html).
        :param pulumi.Input[bool] frozen: Specifies whether to freeze the device. Defaults to `false`.
        :param pulumi.Input[str] gateway_id: Specifies the gateway ID which is the device ID of the parent device.
               The child device is not directly connected to the platform. If omitted, it means to create a device directly connected
               to the platform, the `device_id` of the device is the same as the `gateway_id`.
        :param pulumi.Input[str] name: Specifies the device name, which contains 4 to 256 characters. Only letters,
               Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA device resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] secret: Specifies a secret for identity authentication, which contains 8 to 32 characters.
               Only letters, digits, hyphens (-) and underscore (_) are allowed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the device.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "space_id", space_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if frozen is not None:
            pulumi.set(__self__, "frozen", frozen)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Input[str]:
        """
        Specifies the node ID, which contains 4 to 256 characters.
        The node ID can be IMEI, MAC address, or serial number. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        """
        Specifies the product ID which the device belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> pulumi.Input[str]:
        """
        Specifies the resource space ID which the device belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "space_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of device. The description contains a maximum of 2048
        characters. Only letters, Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters
        are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device ID, which contains 4 to 256 characters.
        Only letters, digits, hyphens (-) and underscore (_) are allowed. If omitted, the platform will automatically allocate
        a device ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a fingerprint of X.509 certificate for identity authentication,
        which is a 40-digit or 64-digit hexadecimal string. For more detail, please see
        [Registering a Device Authenticated by an X.509 Certificate](https://support.huaweicloud.com/en-us/usermanual-iothub/iot_01_0055.html).
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def frozen(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to freeze the device. Defaults to `false`.
        """
        return pulumi.get(self, "frozen")

    @frozen.setter
    def frozen(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "frozen", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the gateway ID which is the device ID of the parent device.
        The child device is not directly connected to the platform. If omitted, it means to create a device directly connected
        to the platform, the `device_id` of the device is the same as the `gateway_id`.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device name, which contains 4 to 256 characters. Only letters,
        Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the IoTDA device resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a secret for identity authentication, which contains 8 to 32 characters.
        Only letters, digits, hyphens (-) and underscore (_) are allowed.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the device.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DeviceState:
    def __init__(__self__, *,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 frozen: Optional[pulumi.Input[bool]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_id: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Device resources.
        :param pulumi.Input[str] auth_type: The authentication type of device. The options are as follows:
               + **SECRET**: Use a secret for identity authentication.
               + **CERTIFICATES**: Use an x.509 certificate for identity authentication.
        :param pulumi.Input[str] description: Specifies the description of device. The description contains a maximum of 2048
               characters. Only letters, Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters
               are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] device_id: Specifies the device ID, which contains 4 to 256 characters.
               Only letters, digits, hyphens (-) and underscore (_) are allowed. If omitted, the platform will automatically allocate
               a device ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] fingerprint: Specifies a fingerprint of X.509 certificate for identity authentication,
               which is a 40-digit or 64-digit hexadecimal string. For more detail, please see
               [Registering a Device Authenticated by an X.509 Certificate](https://support.huaweicloud.com/en-us/usermanual-iothub/iot_01_0055.html).
        :param pulumi.Input[bool] frozen: Specifies whether to freeze the device. Defaults to `false`.
        :param pulumi.Input[str] gateway_id: Specifies the gateway ID which is the device ID of the parent device.
               The child device is not directly connected to the platform. If omitted, it means to create a device directly connected
               to the platform, the `device_id` of the device is the same as the `gateway_id`.
        :param pulumi.Input[str] name: Specifies the device name, which contains 4 to 256 characters. Only letters,
               Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] node_id: Specifies the node ID, which contains 4 to 256 characters.
               The node ID can be IMEI, MAC address, or serial number. Changing this parameter will create a new resource.
        :param pulumi.Input[str] node_type: The node type of device. The options are as follows:
               + **GATEWAY**: Directly connected device.
               + **ENDPOINT**: Indirectly connected device.
               + **UNKNOWN**: Unknown type.
        :param pulumi.Input[str] product_id: Specifies the product ID which the device belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA device resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] secret: Specifies a secret for identity authentication, which contains 8 to 32 characters.
               Only letters, digits, hyphens (-) and underscore (_) are allowed.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which the device belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The status of device. The valid values are **INACTIVE**, **ONLINE**, **OFFLINE**, **FROZEN**, **ABNORMAL**.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the device.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if frozen is not None:
            pulumi.set(__self__, "frozen", frozen)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if space_id is not None:
            pulumi.set(__self__, "space_id", space_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication type of device. The options are as follows:
        + **SECRET**: Use a secret for identity authentication.
        + **CERTIFICATES**: Use an x.509 certificate for identity authentication.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of device. The description contains a maximum of 2048
        characters. Only letters, Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters
        are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device ID, which contains 4 to 256 characters.
        Only letters, digits, hyphens (-) and underscore (_) are allowed. If omitted, the platform will automatically allocate
        a device ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a fingerprint of X.509 certificate for identity authentication,
        which is a 40-digit or 64-digit hexadecimal string. For more detail, please see
        [Registering a Device Authenticated by an X.509 Certificate](https://support.huaweicloud.com/en-us/usermanual-iothub/iot_01_0055.html).
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def frozen(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to freeze the device. Defaults to `false`.
        """
        return pulumi.get(self, "frozen")

    @frozen.setter
    def frozen(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "frozen", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the gateway ID which is the device ID of the parent device.
        The child device is not directly connected to the platform. If omitted, it means to create a device directly connected
        to the platform, the `device_id` of the device is the same as the `gateway_id`.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device name, which contains 4 to 256 characters. Only letters,
        Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the node ID, which contains 4 to 256 characters.
        The node ID can be IMEI, MAC address, or serial number. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        The node type of device. The options are as follows:
        + **GATEWAY**: Directly connected device.
        + **ENDPOINT**: Indirectly connected device.
        + **UNKNOWN**: Unknown type.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the product ID which the device belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the IoTDA device resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a secret for identity authentication, which contains 8 to 32 characters.
        Only letters, digits, hyphens (-) and underscore (_) are allowed.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource space ID which the device belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of device. The valid values are **INACTIVE**, **ONLINE**, **OFFLINE**, **FROZEN**, **ABNORMAL**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the device.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Device(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 frozen: Optional[pulumi.Input[bool]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_id: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages an IoTDA device within HuaweiCloud.

        ## Example Usage
        ### Create a directly connected device and an indirectly connected device

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        space_id = config.require_object("spaceId")
        product_id = config.require_object("productId")
        secret = config.require_object("secret")
        device = huaweicloud.io_tda.Device("device",
            node_id="device_SN_1",
            space_id=space_id,
            product_id=product_id,
            secret=secret,
            tags={
                "foo": "bar",
                "key": "value",
            })
        sub_device = huaweicloud.io_tda.Device("subDevice",
            node_id="device_SN_2",
            space_id=space_id,
            product_id=product_id,
            gateway_id=device.id)
        ```

        ## Import

        Devices can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/device:Device test 10022532f4f94f26b01daa1e424853e1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of device. The description contains a maximum of 2048
               characters. Only letters, Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters
               are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] device_id: Specifies the device ID, which contains 4 to 256 characters.
               Only letters, digits, hyphens (-) and underscore (_) are allowed. If omitted, the platform will automatically allocate
               a device ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] fingerprint: Specifies a fingerprint of X.509 certificate for identity authentication,
               which is a 40-digit or 64-digit hexadecimal string. For more detail, please see
               [Registering a Device Authenticated by an X.509 Certificate](https://support.huaweicloud.com/en-us/usermanual-iothub/iot_01_0055.html).
        :param pulumi.Input[bool] frozen: Specifies whether to freeze the device. Defaults to `false`.
        :param pulumi.Input[str] gateway_id: Specifies the gateway ID which is the device ID of the parent device.
               The child device is not directly connected to the platform. If omitted, it means to create a device directly connected
               to the platform, the `device_id` of the device is the same as the `gateway_id`.
        :param pulumi.Input[str] name: Specifies the device name, which contains 4 to 256 characters. Only letters,
               Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] node_id: Specifies the node ID, which contains 4 to 256 characters.
               The node ID can be IMEI, MAC address, or serial number. Changing this parameter will create a new resource.
        :param pulumi.Input[str] product_id: Specifies the product ID which the device belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA device resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] secret: Specifies a secret for identity authentication, which contains 8 to 32 characters.
               Only letters, digits, hyphens (-) and underscore (_) are allowed.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which the device belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the device.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IoTDA device within HuaweiCloud.

        ## Example Usage
        ### Create a directly connected device and an indirectly connected device

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        space_id = config.require_object("spaceId")
        product_id = config.require_object("productId")
        secret = config.require_object("secret")
        device = huaweicloud.io_tda.Device("device",
            node_id="device_SN_1",
            space_id=space_id,
            product_id=product_id,
            secret=secret,
            tags={
                "foo": "bar",
                "key": "value",
            })
        sub_device = huaweicloud.io_tda.Device("subDevice",
            node_id="device_SN_2",
            space_id=space_id,
            product_id=product_id,
            gateway_id=device.id)
        ```

        ## Import

        Devices can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/device:Device test 10022532f4f94f26b01daa1e424853e1
        ```

        :param str resource_name: The name of the resource.
        :param DeviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 frozen: Optional[pulumi.Input[bool]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_id: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceArgs.__new__(DeviceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["device_id"] = device_id
            __props__.__dict__["fingerprint"] = fingerprint
            __props__.__dict__["frozen"] = frozen
            __props__.__dict__["gateway_id"] = gateway_id
            __props__.__dict__["name"] = name
            if node_id is None and not opts.urn:
                raise TypeError("Missing required property 'node_id'")
            __props__.__dict__["node_id"] = node_id
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["region"] = region
            __props__.__dict__["secret"] = secret
            if space_id is None and not opts.urn:
                raise TypeError("Missing required property 'space_id'")
            __props__.__dict__["space_id"] = space_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["auth_type"] = None
            __props__.__dict__["node_type"] = None
            __props__.__dict__["status"] = None
        super(Device, __self__).__init__(
            'huaweicloud:IoTDA/device:Device',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_type: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_id: Optional[pulumi.Input[str]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            frozen: Optional[pulumi.Input[bool]] = None,
            gateway_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_id: Optional[pulumi.Input[str]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            secret: Optional[pulumi.Input[str]] = None,
            space_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Device':
        """
        Get an existing Device resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_type: The authentication type of device. The options are as follows:
               + **SECRET**: Use a secret for identity authentication.
               + **CERTIFICATES**: Use an x.509 certificate for identity authentication.
        :param pulumi.Input[str] description: Specifies the description of device. The description contains a maximum of 2048
               characters. Only letters, Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters
               are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] device_id: Specifies the device ID, which contains 4 to 256 characters.
               Only letters, digits, hyphens (-) and underscore (_) are allowed. If omitted, the platform will automatically allocate
               a device ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] fingerprint: Specifies a fingerprint of X.509 certificate for identity authentication,
               which is a 40-digit or 64-digit hexadecimal string. For more detail, please see
               [Registering a Device Authenticated by an X.509 Certificate](https://support.huaweicloud.com/en-us/usermanual-iothub/iot_01_0055.html).
        :param pulumi.Input[bool] frozen: Specifies whether to freeze the device. Defaults to `false`.
        :param pulumi.Input[str] gateway_id: Specifies the gateway ID which is the device ID of the parent device.
               The child device is not directly connected to the platform. If omitted, it means to create a device directly connected
               to the platform, the `device_id` of the device is the same as the `gateway_id`.
        :param pulumi.Input[str] name: Specifies the device name, which contains 4 to 256 characters. Only letters,
               Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] node_id: Specifies the node ID, which contains 4 to 256 characters.
               The node ID can be IMEI, MAC address, or serial number. Changing this parameter will create a new resource.
        :param pulumi.Input[str] node_type: The node type of device. The options are as follows:
               + **GATEWAY**: Directly connected device.
               + **ENDPOINT**: Indirectly connected device.
               + **UNKNOWN**: Unknown type.
        :param pulumi.Input[str] product_id: Specifies the product ID which the device belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA device resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] secret: Specifies a secret for identity authentication, which contains 8 to 32 characters.
               Only letters, digits, hyphens (-) and underscore (_) are allowed.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which the device belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The status of device. The valid values are **INACTIVE**, **ONLINE**, **OFFLINE**, **FROZEN**, **ABNORMAL**.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the device.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceState.__new__(_DeviceState)

        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["description"] = description
        __props__.__dict__["device_id"] = device_id
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["frozen"] = frozen
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["name"] = name
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["region"] = region
        __props__.__dict__["secret"] = secret
        __props__.__dict__["space_id"] = space_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Device(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[str]:
        """
        The authentication type of device. The options are as follows:
        + **SECRET**: Use a secret for identity authentication.
        + **CERTIFICATES**: Use an x.509 certificate for identity authentication.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of device. The description contains a maximum of 2048
        characters. Only letters, Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters
        are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> pulumi.Output[str]:
        """
        Specifies the device ID, which contains 4 to 256 characters.
        Only letters, digits, hyphens (-) and underscore (_) are allowed. If omitted, the platform will automatically allocate
        a device ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Specifies a fingerprint of X.509 certificate for identity authentication,
        which is a 40-digit or 64-digit hexadecimal string. For more detail, please see
        [Registering a Device Authenticated by an X.509 Certificate](https://support.huaweicloud.com/en-us/usermanual-iothub/iot_01_0055.html).
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def frozen(self) -> pulumi.Output[bool]:
        """
        Specifies whether to freeze the device. Defaults to `false`.
        """
        return pulumi.get(self, "frozen")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[str]:
        """
        Specifies the gateway ID which is the device ID of the parent device.
        The child device is not directly connected to the platform. If omitted, it means to create a device directly connected
        to the platform, the `device_id` of the device is the same as the `gateway_id`.
        """
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the device name, which contains 4 to 256 characters. Only letters,
        Chinese characters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[str]:
        """
        Specifies the node ID, which contains 4 to 256 characters.
        The node ID can be IMEI, MAC address, or serial number. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        The node type of device. The options are as follows:
        + **GATEWAY**: Directly connected device.
        + **ENDPOINT**: Indirectly connected device.
        + **UNKNOWN**: Unknown type.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        """
        Specifies the product ID which the device belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the IoTDA device resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[str]:
        """
        Specifies a secret for identity authentication, which contains 8 to 32 characters.
        Only letters, digits, hyphens (-) and underscore (_) are allowed.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> pulumi.Output[str]:
        """
        Specifies the resource space ID which the device belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of device. The valid values are **INACTIVE**, **ONLINE**, **OFFLINE**, **FROZEN**, **ABNORMAL**.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the device.
        """
        return pulumi.get(self, "tags")

