# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataforwardingRuleArgs', 'DataforwardingRule']

@pulumi.input_type
class DataforwardingRuleArgs:
    def __init__(__self__, *,
                 trigger: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 select: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetArgs']]]] = None,
                 where: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DataforwardingRule resource.
        :param pulumi.Input[str] trigger: Specifies the trigger event. The options are as follows:
               + **device:create**: Device added.
               + **device:delete**: Device deleted.
               + **device:update**: Device updated.
               + **device.status:update**: Device status changed.
               + **device.property:report**: Device property reported.
               + **device.message:report**: Device message reported.
               + **device.message.status:update**: Device message status changed.
               + **batchtask:update**: Batch task status changed.
               + **product:create**: Product added.
               + **product:delete**: Product deleted.
               + **product:update**: Product updated.
               + **device.command.status:update**: Update of the device asynchronous command status.
        :param pulumi.Input[str] description: Specifies the description of data forwarding rule. The description contains
               a maximum of 256 characters.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the data forwarding rule. Defaults to `false`.
               Can not enable without `targets`.
        :param pulumi.Input[str] name: Specifies the name of data forwarding rule. The name contains a maximum of 256 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] region: Specifies the region to which the KAFKA belongs.
        :param pulumi.Input[str] select: Specifies the SQL SELECT statement which contains a maximum of 500 characters.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which uses the data forwarding rule.
               If omitted, all resource space will use the data forwarding rule. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetArgs']]] targets: Specifies the list of the targets (HUAWEI CLOUD services or private servers) to which you
               want to forward the data. The targets structure is documented below.
        :param pulumi.Input[str] where: Specifies the SQL WHERE statement which contains a maximum of 500 characters.
        """
        pulumi.set(__self__, "trigger", trigger)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if select is not None:
            pulumi.set(__self__, "select", select)
        if space_id is not None:
            pulumi.set(__self__, "space_id", space_id)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if where is not None:
            pulumi.set(__self__, "where", where)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input[str]:
        """
        Specifies the trigger event. The options are as follows:
        + **device:create**: Device added.
        + **device:delete**: Device deleted.
        + **device:update**: Device updated.
        + **device.status:update**: Device status changed.
        + **device.property:report**: Device property reported.
        + **device.message:report**: Device message reported.
        + **device.message.status:update**: Device message status changed.
        + **batchtask:update**: Batch task status changed.
        + **product:create**: Product added.
        + **product:delete**: Product deleted.
        + **product:update**: Product updated.
        + **device.command.status:update**: Update of the device asynchronous command status.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input[str]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of data forwarding rule. The description contains
        a maximum of 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the data forwarding rule. Defaults to `false`.
        Can not enable without `targets`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of data forwarding rule. The name contains a maximum of 256 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def select(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SQL SELECT statement which contains a maximum of 500 characters.
        """
        return pulumi.get(self, "select")

    @select.setter
    def select(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "select", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource space ID which uses the data forwarding rule.
        If omitted, all resource space will use the data forwarding rule. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_id", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetArgs']]]]:
        """
        Specifies the list of the targets (HUAWEI CLOUD services or private servers) to which you
        want to forward the data. The targets structure is documented below.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter
    def where(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SQL WHERE statement which contains a maximum of 500 characters.
        """
        return pulumi.get(self, "where")

    @where.setter
    def where(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "where", value)


@pulumi.input_type
class _DataforwardingRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 select: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetArgs']]]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 where: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DataforwardingRule resources.
        :param pulumi.Input[str] description: Specifies the description of data forwarding rule. The description contains
               a maximum of 256 characters.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the data forwarding rule. Defaults to `false`.
               Can not enable without `targets`.
        :param pulumi.Input[str] name: Specifies the name of data forwarding rule. The name contains a maximum of 256 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] region: Specifies the region to which the KAFKA belongs.
        :param pulumi.Input[str] select: Specifies the SQL SELECT statement which contains a maximum of 500 characters.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which uses the data forwarding rule.
               If omitted, all resource space will use the data forwarding rule. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetArgs']]] targets: Specifies the list of the targets (HUAWEI CLOUD services or private servers) to which you
               want to forward the data. The targets structure is documented below.
        :param pulumi.Input[str] trigger: Specifies the trigger event. The options are as follows:
               + **device:create**: Device added.
               + **device:delete**: Device deleted.
               + **device:update**: Device updated.
               + **device.status:update**: Device status changed.
               + **device.property:report**: Device property reported.
               + **device.message:report**: Device message reported.
               + **device.message.status:update**: Device message status changed.
               + **batchtask:update**: Batch task status changed.
               + **product:create**: Product added.
               + **product:delete**: Product deleted.
               + **product:update**: Product updated.
               + **device.command.status:update**: Update of the device asynchronous command status.
        :param pulumi.Input[str] where: Specifies the SQL WHERE statement which contains a maximum of 500 characters.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if select is not None:
            pulumi.set(__self__, "select", select)
        if space_id is not None:
            pulumi.set(__self__, "space_id", space_id)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if where is not None:
            pulumi.set(__self__, "where", where)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of data forwarding rule. The description contains
        a maximum of 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the data forwarding rule. Defaults to `false`.
        Can not enable without `targets`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of data forwarding rule. The name contains a maximum of 256 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def select(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SQL SELECT statement which contains a maximum of 500 characters.
        """
        return pulumi.get(self, "select")

    @select.setter
    def select(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "select", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource space ID which uses the data forwarding rule.
        If omitted, all resource space will use the data forwarding rule. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_id", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetArgs']]]]:
        """
        Specifies the list of the targets (HUAWEI CLOUD services or private servers) to which you
        want to forward the data. The targets structure is documented below.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the trigger event. The options are as follows:
        + **device:create**: Device added.
        + **device:delete**: Device deleted.
        + **device:update**: Device updated.
        + **device.status:update**: Device status changed.
        + **device.property:report**: Device property reported.
        + **device.message:report**: Device message reported.
        + **device.message.status:update**: Device message status changed.
        + **batchtask:update**: Batch task status changed.
        + **product:create**: Product added.
        + **product:delete**: Product deleted.
        + **product:update**: Product updated.
        + **device.command.status:update**: Update of the device asynchronous command status.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def where(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SQL WHERE statement which contains a maximum of 500 characters.
        """
        return pulumi.get(self, "where")

    @where.setter
    def where(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "where", value)


class DataforwardingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 select: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataforwardingRuleTargetArgs']]]]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 where: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an IoTDA data forwarding rule within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        dis_region = config.require_object("disRegion")
        dis_stream_id = config.require_object("disStreamId")
        obs_region = config.require_object("obsRegion")
        obsbucket = config.require_object("obsbucket")
        test = huaweicloud.io_tda.DataforwardingRule("test",
            trigger="product:create",
            enabled=True,
            targets=[
                huaweicloud.io_tda.DataforwardingRuleTargetArgs(
                    type="DIS_FORWARDING",
                    dis_forwarding=huaweicloud.io_tda.DataforwardingRuleTargetDisForwardingArgs(
                        region=dis_region,
                        stream_id=dis_stream_id,
                    ),
                ),
                huaweicloud.io_tda.DataforwardingRuleTargetArgs(
                    type="HTTP_FORWARDING",
                    http_forwarding=huaweicloud.io_tda.DataforwardingRuleTargetHttpForwardingArgs(
                        url="http://www.yourDomain.com",
                    ),
                ),
                huaweicloud.io_tda.DataforwardingRuleTargetArgs(
                    type="OBS_FORWARDING",
                    obs_forwarding=huaweicloud.io_tda.DataforwardingRuleTargetObsForwardingArgs(
                        region=obs_region,
                        bucket=obsbucket,
                    ),
                ),
            ])
        ```

        ## Import

        Data forwarding rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/dataforwardingRule:DataforwardingRule test 10022532f4f94f26b01daa1e424853e1
        ```

         Note that the imported state may not be identical to your resource definition, due to some attrubutes missing from the API response, security or some other reason. The missing attributes include`password` of `kafka_forwarding`. It is generally recommended running `terraform plan` after importing the resource. You can then decide if changes should be applied to the resource, or the resource definition should be updated to align with the group. Also you can ignore changes as below. resource "huaweicloud_iotda_device_group" "test" {

         ...

         lifecycle {

         ignore_changes = [

         targets,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of data forwarding rule. The description contains
               a maximum of 256 characters.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the data forwarding rule. Defaults to `false`.
               Can not enable without `targets`.
        :param pulumi.Input[str] name: Specifies the name of data forwarding rule. The name contains a maximum of 256 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] region: Specifies the region to which the KAFKA belongs.
        :param pulumi.Input[str] select: Specifies the SQL SELECT statement which contains a maximum of 500 characters.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which uses the data forwarding rule.
               If omitted, all resource space will use the data forwarding rule. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataforwardingRuleTargetArgs']]]] targets: Specifies the list of the targets (HUAWEI CLOUD services or private servers) to which you
               want to forward the data. The targets structure is documented below.
        :param pulumi.Input[str] trigger: Specifies the trigger event. The options are as follows:
               + **device:create**: Device added.
               + **device:delete**: Device deleted.
               + **device:update**: Device updated.
               + **device.status:update**: Device status changed.
               + **device.property:report**: Device property reported.
               + **device.message:report**: Device message reported.
               + **device.message.status:update**: Device message status changed.
               + **batchtask:update**: Batch task status changed.
               + **product:create**: Product added.
               + **product:delete**: Product deleted.
               + **product:update**: Product updated.
               + **device.command.status:update**: Update of the device asynchronous command status.
        :param pulumi.Input[str] where: Specifies the SQL WHERE statement which contains a maximum of 500 characters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataforwardingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IoTDA data forwarding rule within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        dis_region = config.require_object("disRegion")
        dis_stream_id = config.require_object("disStreamId")
        obs_region = config.require_object("obsRegion")
        obsbucket = config.require_object("obsbucket")
        test = huaweicloud.io_tda.DataforwardingRule("test",
            trigger="product:create",
            enabled=True,
            targets=[
                huaweicloud.io_tda.DataforwardingRuleTargetArgs(
                    type="DIS_FORWARDING",
                    dis_forwarding=huaweicloud.io_tda.DataforwardingRuleTargetDisForwardingArgs(
                        region=dis_region,
                        stream_id=dis_stream_id,
                    ),
                ),
                huaweicloud.io_tda.DataforwardingRuleTargetArgs(
                    type="HTTP_FORWARDING",
                    http_forwarding=huaweicloud.io_tda.DataforwardingRuleTargetHttpForwardingArgs(
                        url="http://www.yourDomain.com",
                    ),
                ),
                huaweicloud.io_tda.DataforwardingRuleTargetArgs(
                    type="OBS_FORWARDING",
                    obs_forwarding=huaweicloud.io_tda.DataforwardingRuleTargetObsForwardingArgs(
                        region=obs_region,
                        bucket=obsbucket,
                    ),
                ),
            ])
        ```

        ## Import

        Data forwarding rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/dataforwardingRule:DataforwardingRule test 10022532f4f94f26b01daa1e424853e1
        ```

         Note that the imported state may not be identical to your resource definition, due to some attrubutes missing from the API response, security or some other reason. The missing attributes include`password` of `kafka_forwarding`. It is generally recommended running `terraform plan` after importing the resource. You can then decide if changes should be applied to the resource, or the resource definition should be updated to align with the group. Also you can ignore changes as below. resource "huaweicloud_iotda_device_group" "test" {

         ...

         lifecycle {

         ignore_changes = [

         targets,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param DataforwardingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataforwardingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 select: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataforwardingRuleTargetArgs']]]]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 where: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataforwardingRuleArgs.__new__(DataforwardingRuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["select"] = select
            __props__.__dict__["space_id"] = space_id
            __props__.__dict__["targets"] = targets
            if trigger is None and not opts.urn:
                raise TypeError("Missing required property 'trigger'")
            __props__.__dict__["trigger"] = trigger
            __props__.__dict__["where"] = where
        super(DataforwardingRule, __self__).__init__(
            'huaweicloud:IoTDA/dataforwardingRule:DataforwardingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            select: Optional[pulumi.Input[str]] = None,
            space_id: Optional[pulumi.Input[str]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataforwardingRuleTargetArgs']]]]] = None,
            trigger: Optional[pulumi.Input[str]] = None,
            where: Optional[pulumi.Input[str]] = None) -> 'DataforwardingRule':
        """
        Get an existing DataforwardingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of data forwarding rule. The description contains
               a maximum of 256 characters.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the data forwarding rule. Defaults to `false`.
               Can not enable without `targets`.
        :param pulumi.Input[str] name: Specifies the name of data forwarding rule. The name contains a maximum of 256 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] region: Specifies the region to which the KAFKA belongs.
        :param pulumi.Input[str] select: Specifies the SQL SELECT statement which contains a maximum of 500 characters.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which uses the data forwarding rule.
               If omitted, all resource space will use the data forwarding rule. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataforwardingRuleTargetArgs']]]] targets: Specifies the list of the targets (HUAWEI CLOUD services or private servers) to which you
               want to forward the data. The targets structure is documented below.
        :param pulumi.Input[str] trigger: Specifies the trigger event. The options are as follows:
               + **device:create**: Device added.
               + **device:delete**: Device deleted.
               + **device:update**: Device updated.
               + **device.status:update**: Device status changed.
               + **device.property:report**: Device property reported.
               + **device.message:report**: Device message reported.
               + **device.message.status:update**: Device message status changed.
               + **batchtask:update**: Batch task status changed.
               + **product:create**: Product added.
               + **product:delete**: Product deleted.
               + **product:update**: Product updated.
               + **device.command.status:update**: Update of the device asynchronous command status.
        :param pulumi.Input[str] where: Specifies the SQL WHERE statement which contains a maximum of 500 characters.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataforwardingRuleState.__new__(_DataforwardingRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["select"] = select
        __props__.__dict__["space_id"] = space_id
        __props__.__dict__["targets"] = targets
        __props__.__dict__["trigger"] = trigger
        __props__.__dict__["where"] = where
        return DataforwardingRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of data forwarding rule. The description contains
        a maximum of 256 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the data forwarding rule. Defaults to `false`.
        Can not enable without `targets`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of data forwarding rule. The name contains a maximum of 256 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def select(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the SQL SELECT statement which contains a maximum of 500 characters.
        """
        return pulumi.get(self, "select")

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> pulumi.Output[str]:
        """
        Specifies the resource space ID which uses the data forwarding rule.
        If omitted, all resource space will use the data forwarding rule. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Optional[Sequence['outputs.DataforwardingRuleTarget']]]:
        """
        Specifies the list of the targets (HUAWEI CLOUD services or private servers) to which you
        want to forward the data. The targets structure is documented below.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[str]:
        """
        Specifies the trigger event. The options are as follows:
        + **device:create**: Device added.
        + **device:delete**: Device deleted.
        + **device:update**: Device updated.
        + **device.status:update**: Device status changed.
        + **device.property:report**: Device property reported.
        + **device.message:report**: Device message reported.
        + **device.message.status:update**: Device message status changed.
        + **batchtask:update**: Batch task status changed.
        + **product:create**: Product added.
        + **product:delete**: Product deleted.
        + **product:update**: Product updated.
        + **device.command.status:update**: Update of the device asynchronous command status.
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter
    def where(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the SQL WHERE statement which contains a maximum of 500 characters.
        """
        return pulumi.get(self, "where")

