# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DataforwardingRuleTargetArgs',
    'DataforwardingRuleTargetAmqpForwardingArgs',
    'DataforwardingRuleTargetDisForwardingArgs',
    'DataforwardingRuleTargetHttpForwardingArgs',
    'DataforwardingRuleTargetKafkaForwardingArgs',
    'DataforwardingRuleTargetKafkaForwardingAddressArgs',
    'DataforwardingRuleTargetObsForwardingArgs',
    'DeviceLinkageRuleActionArgs',
    'DeviceLinkageRuleActionDeviceAlarmArgs',
    'DeviceLinkageRuleActionDeviceCommandArgs',
    'DeviceLinkageRuleActionSmnForwardingArgs',
    'DeviceLinkageRuleEffectivePeriodArgs',
    'DeviceLinkageRuleTriggerArgs',
    'DeviceLinkageRuleTriggerDailyTimerConditionArgs',
    'DeviceLinkageRuleTriggerDeviceDataConditionArgs',
    'DeviceLinkageRuleTriggerSimpleTimerConditionArgs',
    'ProductServiceArgs',
    'ProductServiceCommandArgs',
    'ProductServiceCommandParaArgs',
    'ProductServiceCommandResponseArgs',
    'ProductServicePropertyArgs',
]

@pulumi.input_type
class DataforwardingRuleTargetArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 amqp_forwarding: Optional[pulumi.Input['DataforwardingRuleTargetAmqpForwardingArgs']] = None,
                 dis_forwarding: Optional[pulumi.Input['DataforwardingRuleTargetDisForwardingArgs']] = None,
                 http_forwarding: Optional[pulumi.Input['DataforwardingRuleTargetHttpForwardingArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kafka_forwarding: Optional[pulumi.Input['DataforwardingRuleTargetKafkaForwardingArgs']] = None,
                 obs_forwarding: Optional[pulumi.Input['DataforwardingRuleTargetObsForwardingArgs']] = None):
        """
        :param pulumi.Input[str] type: Specifies the type of forwarding target. The options are as follows:
               + **HTTP_FORWARDING**: The platform can push specified device data to a Third-party application (HTTP push).
               You can set different addresses that different types of device data are pushed to.
               + **DIS_FORWARDING**: DIS provides efficient collection, transmission, and distribution of real-time data. It also
               provides an abundant selection of APIs to help you quickly create real-time data applications.
               + **OBS_FORWARDING**: OBS is a stable, secure, cloud storage service that is scalable, efficient and easy-to-use.
               It allows you to store any amount of unstructured data in any format, and provides REST APIs so you can access your
               data from anywhere.
               + **AMQP_FORWARDING**: AMQP provides a scalable, distributed message queue that supports high throughput with low
               latency. AMQP is ready from the get-go and is O&M free.
               + **DMS_KAFKA_FORWARDING**: Distributed Message Service (DMS) for Kafka features high throughput, concurrency, and
               scalability. It is suitable for real-time data transmission, stream data processing, system decoupling,
               and traffic balancing.
        :param pulumi.Input['DataforwardingRuleTargetAmqpForwardingArgs'] amqp_forwarding: Specifies the detail of AMQP forwards. It is required when type
               is `AMQP_FORWARDING`. The amqp_forwarding structure is documented below.
        :param pulumi.Input['DataforwardingRuleTargetDisForwardingArgs'] dis_forwarding: Specifies the detail of the DIS forwards. It is required when type
               is `DIS_FORWARDING`. The dis_forwarding structure is documented below.
        :param pulumi.Input['DataforwardingRuleTargetHttpForwardingArgs'] http_forwarding: Specifies the detail of the HTTP forwards. It is required when type
               is `HTTP_FORWARDING`. The http_forwarding structure is documented below.
        :param pulumi.Input[str] id: The resource ID in UUID format.
        :param pulumi.Input['DataforwardingRuleTargetKafkaForwardingArgs'] kafka_forwarding: Specifies the detail of the KAFKA forwards. It is required when type
               is `DMS_KAFKA_FORWARDING`. The properties structure is documented below.
        :param pulumi.Input['DataforwardingRuleTargetObsForwardingArgs'] obs_forwarding: Specifies the detail of the OBS forwards. It is required when type
               is `OBS_FORWARDING`. The obs_forwarding structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if amqp_forwarding is not None:
            pulumi.set(__self__, "amqp_forwarding", amqp_forwarding)
        if dis_forwarding is not None:
            pulumi.set(__self__, "dis_forwarding", dis_forwarding)
        if http_forwarding is not None:
            pulumi.set(__self__, "http_forwarding", http_forwarding)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kafka_forwarding is not None:
            pulumi.set(__self__, "kafka_forwarding", kafka_forwarding)
        if obs_forwarding is not None:
            pulumi.set(__self__, "obs_forwarding", obs_forwarding)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of forwarding target. The options are as follows:
        + **HTTP_FORWARDING**: The platform can push specified device data to a Third-party application (HTTP push).
        You can set different addresses that different types of device data are pushed to.
        + **DIS_FORWARDING**: DIS provides efficient collection, transmission, and distribution of real-time data. It also
        provides an abundant selection of APIs to help you quickly create real-time data applications.
        + **OBS_FORWARDING**: OBS is a stable, secure, cloud storage service that is scalable, efficient and easy-to-use.
        It allows you to store any amount of unstructured data in any format, and provides REST APIs so you can access your
        data from anywhere.
        + **AMQP_FORWARDING**: AMQP provides a scalable, distributed message queue that supports high throughput with low
        latency. AMQP is ready from the get-go and is O&M free.
        + **DMS_KAFKA_FORWARDING**: Distributed Message Service (DMS) for Kafka features high throughput, concurrency, and
        scalability. It is suitable for real-time data transmission, stream data processing, system decoupling,
        and traffic balancing.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="amqpForwarding")
    def amqp_forwarding(self) -> Optional[pulumi.Input['DataforwardingRuleTargetAmqpForwardingArgs']]:
        """
        Specifies the detail of AMQP forwards. It is required when type
        is `AMQP_FORWARDING`. The amqp_forwarding structure is documented below.
        """
        return pulumi.get(self, "amqp_forwarding")

    @amqp_forwarding.setter
    def amqp_forwarding(self, value: Optional[pulumi.Input['DataforwardingRuleTargetAmqpForwardingArgs']]):
        pulumi.set(self, "amqp_forwarding", value)

    @property
    @pulumi.getter(name="disForwarding")
    def dis_forwarding(self) -> Optional[pulumi.Input['DataforwardingRuleTargetDisForwardingArgs']]:
        """
        Specifies the detail of the DIS forwards. It is required when type
        is `DIS_FORWARDING`. The dis_forwarding structure is documented below.
        """
        return pulumi.get(self, "dis_forwarding")

    @dis_forwarding.setter
    def dis_forwarding(self, value: Optional[pulumi.Input['DataforwardingRuleTargetDisForwardingArgs']]):
        pulumi.set(self, "dis_forwarding", value)

    @property
    @pulumi.getter(name="httpForwarding")
    def http_forwarding(self) -> Optional[pulumi.Input['DataforwardingRuleTargetHttpForwardingArgs']]:
        """
        Specifies the detail of the HTTP forwards. It is required when type
        is `HTTP_FORWARDING`. The http_forwarding structure is documented below.
        """
        return pulumi.get(self, "http_forwarding")

    @http_forwarding.setter
    def http_forwarding(self, value: Optional[pulumi.Input['DataforwardingRuleTargetHttpForwardingArgs']]):
        pulumi.set(self, "http_forwarding", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID in UUID format.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="kafkaForwarding")
    def kafka_forwarding(self) -> Optional[pulumi.Input['DataforwardingRuleTargetKafkaForwardingArgs']]:
        """
        Specifies the detail of the KAFKA forwards. It is required when type
        is `DMS_KAFKA_FORWARDING`. The properties structure is documented below.
        """
        return pulumi.get(self, "kafka_forwarding")

    @kafka_forwarding.setter
    def kafka_forwarding(self, value: Optional[pulumi.Input['DataforwardingRuleTargetKafkaForwardingArgs']]):
        pulumi.set(self, "kafka_forwarding", value)

    @property
    @pulumi.getter(name="obsForwarding")
    def obs_forwarding(self) -> Optional[pulumi.Input['DataforwardingRuleTargetObsForwardingArgs']]:
        """
        Specifies the detail of the OBS forwards. It is required when type
        is `OBS_FORWARDING`. The obs_forwarding structure is documented below.
        """
        return pulumi.get(self, "obs_forwarding")

    @obs_forwarding.setter
    def obs_forwarding(self, value: Optional[pulumi.Input['DataforwardingRuleTargetObsForwardingArgs']]):
        pulumi.set(self, "obs_forwarding", value)


@pulumi.input_type
class DataforwardingRuleTargetAmqpForwardingArgs:
    def __init__(__self__, *,
                 queue_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] queue_name: Specifies the AMQP Queue name.
        """
        pulumi.set(__self__, "queue_name", queue_name)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Input[str]:
        """
        Specifies the AMQP Queue name.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_name", value)


@pulumi.input_type
class DataforwardingRuleTargetDisForwardingArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 stream_id: pulumi.Input[str],
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] region: Specifies the region to which the KAFKA belongs.
        :param pulumi.Input[str] stream_id: Specifies the DIS stream ID.
        :param pulumi.Input[str] project_id: Specifies the project ID to which the KAFKA belongs.
               If omitted, the default project in the region will be used.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "stream_id", stream_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Input[str]:
        """
        Specifies the DIS stream ID.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the project ID to which the KAFKA belongs.
        If omitted, the default project in the region will be used.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class DataforwardingRuleTargetHttpForwardingArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] url: Specifies the Push URL. The request method must is post.
        """
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Specifies the Push URL. The request method must is post.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class DataforwardingRuleTargetKafkaForwardingArgs:
    def __init__(__self__, *,
                 addresses: pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetKafkaForwardingAddressArgs']]],
                 region: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetKafkaForwardingAddressArgs']]] addresses: Specifies the list of the connected service addresses.
               The addresses structure is documented below.
        :param pulumi.Input[str] region: Specifies the region to which the KAFKA belongs.
        :param pulumi.Input[str] topic: Specifies the topic.
        :param pulumi.Input[str] password: Specifies the password.
        :param pulumi.Input[str] project_id: Specifies the project ID to which the KAFKA belongs.
               If omitted, the default project in the region will be used.
        :param pulumi.Input[str] user_name: Specifies the SASL user name.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "topic", topic)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetKafkaForwardingAddressArgs']]]:
        """
        Specifies the list of the connected service addresses.
        The addresses structure is documented below.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: pulumi.Input[Sequence[pulumi.Input['DataforwardingRuleTargetKafkaForwardingAddressArgs']]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        Specifies the topic.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the project ID to which the KAFKA belongs.
        If omitted, the default project in the region will be used.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SASL user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class DataforwardingRuleTargetKafkaForwardingAddressArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 domain: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: Specifies the port of the connected service address.
        :param pulumi.Input[str] domain: Specifies the domain of the connected service address.
               Exactly one of `ip` or `domain` must be provided.
        :param pulumi.Input[str] ip: Specifies the IP of the connected service address.
               Exactly one of `ip` or `domain` must be provided.
        """
        pulumi.set(__self__, "port", port)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the port of the connected service address.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the domain of the connected service address.
        Exactly one of `ip` or `domain` must be provided.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP of the connected service address.
        Exactly one of `ip` or `domain` must be provided.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class DataforwardingRuleTargetObsForwardingArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 region: pulumi.Input[str],
                 custom_directory: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Specifies the OBS Bucket.
        :param pulumi.Input[str] region: Specifies the region to which the KAFKA belongs.
        :param pulumi.Input[str] custom_directory: Specifies the custom directory for storing channel files. The ID contains a
               maximum of 256 characters. Multi-level directories can be separated by (/), and cannot start or end with a slash (/),
               and cannot contain more than two adjacent slashes (/). Only letters, digits, hyphens (-), underscores (_), slash (/)
               and braces ({}) are allowed. Braces can be used only for the time template parameters. For example, if the custom
               directory is in the format of {YYYY}/{MM}/{DD}/{HH}, data is generated in the directory based on the current
               time(for example, 2022/06/14/10) when data is forwarded.
        :param pulumi.Input[str] project_id: Specifies the project ID to which the KAFKA belongs.
               If omitted, the default project in the region will be used.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "region", region)
        if custom_directory is not None:
            pulumi.set(__self__, "custom_directory", custom_directory)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Specifies the OBS Bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Specifies the region to which the KAFKA belongs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="customDirectory")
    def custom_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the custom directory for storing channel files. The ID contains a
        maximum of 256 characters. Multi-level directories can be separated by (/), and cannot start or end with a slash (/),
        and cannot contain more than two adjacent slashes (/). Only letters, digits, hyphens (-), underscores (_), slash (/)
        and braces ({}) are allowed. Braces can be used only for the time template parameters. For example, if the custom
        directory is in the format of {YYYY}/{MM}/{DD}/{HH}, data is generated in the directory based on the current
        time(for example, 2022/06/14/10) when data is forwarded.
        """
        return pulumi.get(self, "custom_directory")

    @custom_directory.setter
    def custom_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_directory", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the project ID to which the KAFKA belongs.
        If omitted, the default project in the region will be used.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class DeviceLinkageRuleActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 device_alarm: Optional[pulumi.Input['DeviceLinkageRuleActionDeviceAlarmArgs']] = None,
                 device_command: Optional[pulumi.Input['DeviceLinkageRuleActionDeviceCommandArgs']] = None,
                 smn_forwarding: Optional[pulumi.Input['DeviceLinkageRuleActionSmnForwardingArgs']] = None):
        """
        :param pulumi.Input[str] type: Specifies the type of the alarm. The options are as follows:
               + **fault**: Report alarms.
               + **recovery**: Clear alarms.
        :param pulumi.Input['DeviceLinkageRuleActionDeviceAlarmArgs'] device_alarm: Specifies the detail of device alarm. It is required when type
               is `DEVICE_ALARM`. The device_alarm structure is documented below.
        :param pulumi.Input['DeviceLinkageRuleActionDeviceCommandArgs'] device_command: Specifies the detail of device command. It is required when type
               is `DEVICE_CMD`. The device_command structure is documented below.
        :param pulumi.Input['DeviceLinkageRuleActionSmnForwardingArgs'] smn_forwarding: Specifies the detail of SMN notifications. It is required when type
               is `SMN_FORWARDING`. The smn_forwarding structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if device_alarm is not None:
            pulumi.set(__self__, "device_alarm", device_alarm)
        if device_command is not None:
            pulumi.set(__self__, "device_command", device_command)
        if smn_forwarding is not None:
            pulumi.set(__self__, "smn_forwarding", smn_forwarding)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the alarm. The options are as follows:
        + **fault**: Report alarms.
        + **recovery**: Clear alarms.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="deviceAlarm")
    def device_alarm(self) -> Optional[pulumi.Input['DeviceLinkageRuleActionDeviceAlarmArgs']]:
        """
        Specifies the detail of device alarm. It is required when type
        is `DEVICE_ALARM`. The device_alarm structure is documented below.
        """
        return pulumi.get(self, "device_alarm")

    @device_alarm.setter
    def device_alarm(self, value: Optional[pulumi.Input['DeviceLinkageRuleActionDeviceAlarmArgs']]):
        pulumi.set(self, "device_alarm", value)

    @property
    @pulumi.getter(name="deviceCommand")
    def device_command(self) -> Optional[pulumi.Input['DeviceLinkageRuleActionDeviceCommandArgs']]:
        """
        Specifies the detail of device command. It is required when type
        is `DEVICE_CMD`. The device_command structure is documented below.
        """
        return pulumi.get(self, "device_command")

    @device_command.setter
    def device_command(self, value: Optional[pulumi.Input['DeviceLinkageRuleActionDeviceCommandArgs']]):
        pulumi.set(self, "device_command", value)

    @property
    @pulumi.getter(name="smnForwarding")
    def smn_forwarding(self) -> Optional[pulumi.Input['DeviceLinkageRuleActionSmnForwardingArgs']]:
        """
        Specifies the detail of SMN notifications. It is required when type
        is `SMN_FORWARDING`. The smn_forwarding structure is documented below.
        """
        return pulumi.get(self, "smn_forwarding")

    @smn_forwarding.setter
    def smn_forwarding(self, value: Optional[pulumi.Input['DeviceLinkageRuleActionSmnForwardingArgs']]):
        pulumi.set(self, "smn_forwarding", value)


@pulumi.input_type
class DeviceLinkageRuleActionDeviceAlarmArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 severity: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of the alarm.
        :param pulumi.Input[str] severity: Specifies the severity level of the alarm.
               The valid values are **warning**, **minor**, **major** and **critical**.
        :param pulumi.Input[str] type: Specifies the type of the alarm. The options are as follows:
               + **fault**: Report alarms.
               + **recovery**: Clear alarms.
        :param pulumi.Input[str] description: Specifies the description of the alarm.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the alarm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[str]:
        """
        Specifies the severity level of the alarm.
        The valid values are **warning**, **minor**, **major** and **critical**.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[str]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the alarm. The options are as follows:
        + **fault**: Report alarms.
        + **recovery**: Clear alarms.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the alarm.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class DeviceLinkageRuleActionDeviceCommandArgs:
    def __init__(__self__, *,
                 command_body: pulumi.Input[str],
                 command_name: pulumi.Input[str],
                 device_id: pulumi.Input[str],
                 service_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] command_body: Specifies the command parameters, in json format.
               + Example of device command using LWM2M protocol: `{"value":"1"}`, there are key-value pairs, each key is the
               parameter name of the command in the product model.
               + Example of device command using MQTT protocol: `{"header": {"mode": "ACK","from": "/users/testUser","method":
               "SET_TEMPERATURE_READ_PERIOD","to":"/devices/{device_id }/services/{service_id}"},"body": {"value" : "1"}}`.
               - **mode**: Required, whether the device needs to reply to the confirmation message after receiving the command.
               The default is ACK mode. `ACK` indicates that the confirmation message needs to be replied,
               `NOACK` indicates that the confirmation message does not need to be replied.
               - **from**: Optional, the address of the command sender.
               When the App initiates a request, the format is /users/{userId},
               when the application server initiates a request, the format is /{serviceName},
               and when the IoT platform initiates a request, the format is /cloud/{serviceName}.
               - **to**: optional, the address of the command receiver, the format is /devices/{device_id}/services/{service_id}.
               - **method**: optional, the command name defined in the product model.
               - **body**: optional, the message body of the command, which contains key-value pairs, each key is the parameter
               name of the command in the product model. The specific format requires application and device conventions.
        :param pulumi.Input[str] command_name: Specifies the command name.
        :param pulumi.Input[str] device_id: Specifies the device id which excutes the command.
        :param pulumi.Input[str] service_id: Specifies the service id to which the command belongs.
        """
        pulumi.set(__self__, "command_body", command_body)
        pulumi.set(__self__, "command_name", command_name)
        pulumi.set(__self__, "device_id", device_id)
        pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter(name="commandBody")
    def command_body(self) -> pulumi.Input[str]:
        """
        Specifies the command parameters, in json format.
        + Example of device command using LWM2M protocol: `{"value":"1"}`, there are key-value pairs, each key is the
        parameter name of the command in the product model.
        + Example of device command using MQTT protocol: `{"header": {"mode": "ACK","from": "/users/testUser","method":
        "SET_TEMPERATURE_READ_PERIOD","to":"/devices/{device_id }/services/{service_id}"},"body": {"value" : "1"}}`.
        - **mode**: Required, whether the device needs to reply to the confirmation message after receiving the command.
        The default is ACK mode. `ACK` indicates that the confirmation message needs to be replied,
        `NOACK` indicates that the confirmation message does not need to be replied.
        - **from**: Optional, the address of the command sender.
        When the App initiates a request, the format is /users/{userId},
        when the application server initiates a request, the format is /{serviceName},
        and when the IoT platform initiates a request, the format is /cloud/{serviceName}.
        - **to**: optional, the address of the command receiver, the format is /devices/{device_id}/services/{service_id}.
        - **method**: optional, the command name defined in the product model.
        - **body**: optional, the message body of the command, which contains key-value pairs, each key is the parameter
        name of the command in the product model. The specific format requires application and device conventions.
        """
        return pulumi.get(self, "command_body")

    @command_body.setter
    def command_body(self, value: pulumi.Input[str]):
        pulumi.set(self, "command_body", value)

    @property
    @pulumi.getter(name="commandName")
    def command_name(self) -> pulumi.Input[str]:
        """
        Specifies the command name.
        """
        return pulumi.get(self, "command_name")

    @command_name.setter
    def command_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "command_name", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> pulumi.Input[str]:
        """
        Specifies the device id which excutes the command.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        Specifies the service id to which the command belongs.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)


@pulumi.input_type
class DeviceLinkageRuleActionSmnForwardingArgs:
    def __init__(__self__, *,
                 message_content: pulumi.Input[str],
                 message_title: pulumi.Input[str],
                 region: pulumi.Input[str],
                 topic_name: pulumi.Input[str],
                 topic_urn: pulumi.Input[str],
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] message_content: Specifies the message content.
        :param pulumi.Input[str] message_title: Specifies the message title.
        :param pulumi.Input[str] region: Specifies the region to which the SMN belongs.
        :param pulumi.Input[str] topic_name: Specifies the topic name of the SMN.
        :param pulumi.Input[str] topic_urn: Specifies the topic URN of the SMN.
        :param pulumi.Input[str] project_id: Specifies the project ID to which the SMN belongs.
               If omitted, the default project in the region will be used.
        """
        pulumi.set(__self__, "message_content", message_content)
        pulumi.set(__self__, "message_title", message_title)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "topic_name", topic_name)
        pulumi.set(__self__, "topic_urn", topic_urn)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="messageContent")
    def message_content(self) -> pulumi.Input[str]:
        """
        Specifies the message content.
        """
        return pulumi.get(self, "message_content")

    @message_content.setter
    def message_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_content", value)

    @property
    @pulumi.getter(name="messageTitle")
    def message_title(self) -> pulumi.Input[str]:
        """
        Specifies the message title.
        """
        return pulumi.get(self, "message_title")

    @message_title.setter
    def message_title(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_title", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Specifies the region to which the SMN belongs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Input[str]:
        """
        Specifies the topic name of the SMN.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_name", value)

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Input[str]:
        """
        Specifies the topic URN of the SMN.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_urn", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the project ID to which the SMN belongs.
        If omitted, the default project in the region will be used.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class DeviceLinkageRuleEffectivePeriodArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[str],
                 start_time: pulumi.Input[str],
                 days_of_week: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_time: Specifies the end time, in the format: `HH:mm`.
               For example: `10:00`. If the end time is the same as the start time, the effective period is the whole day.
        :param pulumi.Input[str] start_time: Specifies the start time, in the format: `HH:mm`.
               For example: `03:00`.
        :param pulumi.Input[str] days_of_week: Specifies a list of days of week, separated by commas. 1 represents Sunday,
               2 represents Monday, and so on. Defaults to `1,2,3,4,5,6,7` (every day).
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[str]:
        """
        Specifies the end time, in the format: `HH:mm`.
        For example: `10:00`. If the end time is the same as the start time, the effective period is the whole day.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Specifies the start time, in the format: `HH:mm`.
        For example: `03:00`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a list of days of week, separated by commas. 1 represents Sunday,
        2 represents Monday, and so on. Defaults to `1,2,3,4,5,6,7` (every day).
        """
        return pulumi.get(self, "days_of_week")

    @days_of_week.setter
    def days_of_week(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "days_of_week", value)


@pulumi.input_type
class DeviceLinkageRuleTriggerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 daily_timer_condition: Optional[pulumi.Input['DeviceLinkageRuleTriggerDailyTimerConditionArgs']] = None,
                 device_data_condition: Optional[pulumi.Input['DeviceLinkageRuleTriggerDeviceDataConditionArgs']] = None,
                 simple_timer_condition: Optional[pulumi.Input['DeviceLinkageRuleTriggerSimpleTimerConditionArgs']] = None):
        """
        :param pulumi.Input[str] type: Specifies the type of the alarm. The options are as follows:
               + **fault**: Report alarms.
               + **recovery**: Clear alarms.
        :param pulumi.Input['DeviceLinkageRuleTriggerDailyTimerConditionArgs'] daily_timer_condition: Specifies the condition triggered at specified time every day. It is
               required when type is `DAILY_TIMER`. The daily_timer_condition structure is
               documented below.
        :param pulumi.Input['DeviceLinkageRuleTriggerDeviceDataConditionArgs'] device_data_condition: Specifies the condition triggered upon the property of device. It is
               required when type is `DEVICE_DATA`. The device_data_condition structure is
               documented below.
        :param pulumi.Input['DeviceLinkageRuleTriggerSimpleTimerConditionArgs'] simple_timer_condition: Specifies the condition triggered by policy. It is required when type
               is `SIMPLE_TIMER`. The simple_timer_condition structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if daily_timer_condition is not None:
            pulumi.set(__self__, "daily_timer_condition", daily_timer_condition)
        if device_data_condition is not None:
            pulumi.set(__self__, "device_data_condition", device_data_condition)
        if simple_timer_condition is not None:
            pulumi.set(__self__, "simple_timer_condition", simple_timer_condition)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the alarm. The options are as follows:
        + **fault**: Report alarms.
        + **recovery**: Clear alarms.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dailyTimerCondition")
    def daily_timer_condition(self) -> Optional[pulumi.Input['DeviceLinkageRuleTriggerDailyTimerConditionArgs']]:
        """
        Specifies the condition triggered at specified time every day. It is
        required when type is `DAILY_TIMER`. The daily_timer_condition structure is
        documented below.
        """
        return pulumi.get(self, "daily_timer_condition")

    @daily_timer_condition.setter
    def daily_timer_condition(self, value: Optional[pulumi.Input['DeviceLinkageRuleTriggerDailyTimerConditionArgs']]):
        pulumi.set(self, "daily_timer_condition", value)

    @property
    @pulumi.getter(name="deviceDataCondition")
    def device_data_condition(self) -> Optional[pulumi.Input['DeviceLinkageRuleTriggerDeviceDataConditionArgs']]:
        """
        Specifies the condition triggered upon the property of device. It is
        required when type is `DEVICE_DATA`. The device_data_condition structure is
        documented below.
        """
        return pulumi.get(self, "device_data_condition")

    @device_data_condition.setter
    def device_data_condition(self, value: Optional[pulumi.Input['DeviceLinkageRuleTriggerDeviceDataConditionArgs']]):
        pulumi.set(self, "device_data_condition", value)

    @property
    @pulumi.getter(name="simpleTimerCondition")
    def simple_timer_condition(self) -> Optional[pulumi.Input['DeviceLinkageRuleTriggerSimpleTimerConditionArgs']]:
        """
        Specifies the condition triggered by policy. It is required when type
        is `SIMPLE_TIMER`. The simple_timer_condition structure is documented below.
        """
        return pulumi.get(self, "simple_timer_condition")

    @simple_timer_condition.setter
    def simple_timer_condition(self, value: Optional[pulumi.Input['DeviceLinkageRuleTriggerSimpleTimerConditionArgs']]):
        pulumi.set(self, "simple_timer_condition", value)


@pulumi.input_type
class DeviceLinkageRuleTriggerDailyTimerConditionArgs:
    def __init__(__self__, *,
                 start_time: pulumi.Input[str],
                 days_of_week: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] start_time: Specifies the start time, in the format: `HH:mm`.
               For example: `03:00`.
        :param pulumi.Input[str] days_of_week: Specifies a list of days of week, separated by commas. 1 represents Sunday,
               2 represents Monday, and so on. Defaults to `1,2,3,4,5,6,7` (every day).
        """
        pulumi.set(__self__, "start_time", start_time)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Specifies the start time, in the format: `HH:mm`.
        For example: `03:00`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a list of days of week, separated by commas. 1 represents Sunday,
        2 represents Monday, and so on. Defaults to `1,2,3,4,5,6,7` (every day).
        """
        return pulumi.get(self, "days_of_week")

    @days_of_week.setter
    def days_of_week(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "days_of_week", value)


@pulumi.input_type
class DeviceLinkageRuleTriggerDeviceDataConditionArgs:
    def __init__(__self__, *,
                 operator: pulumi.Input[str],
                 path: pulumi.Input[str],
                 value: pulumi.Input[str],
                 data_validatiy_period: Optional[pulumi.Input[int]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 trigger_strategy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] operator: Specifies the data comparison operator. The valid values are: **>**, **<**,
               **>=**, **<=**, **=** and **between**.
        :param pulumi.Input[str] path: Specifies the path of the device property, in the format: **service_id/DataProperty**.
        :param pulumi.Input[str] value: Specifies the Rvalue of a data comparison expression. When the `operator` is `between`,
               the Rvalue represents the minimum and maximum values, separated by commas, such as "20,30",
               which means greater than or equal to 20 and less than 30.
        :param pulumi.Input[int] data_validatiy_period: Specifies data validity period, Unit is `seconds`. Defaults to `300`.
               For example, if Data Validity Period is set to 30 minutes, a device generates data at 19:00, and the platform receives
               the data at 20:00, the action is nottriggered regardless of whether the conditions are met.
        :param pulumi.Input[str] device_id: Specifies the device id which excutes the command.
        :param pulumi.Input[str] product_id: Specifies the product id, all devices belonging to this product will trigger
               the rule. Exactly one of `device_id` or `product_id` must be provided.
        :param pulumi.Input[str] trigger_strategy: Specifies the trigger strategy. The options are as follows:
               + **pulse**: When the data reported by the device meets the conditions, the rule can be triggered.
               + **reverse**: Repetition suppression. For example, if an alarm is configured to be triggered when the battery level
               is lower than 20%, the alarm will be triggered once the battery initially drops below 20% but will not be triggered
               again each time the battery drops to a lower level.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "value", value)
        if data_validatiy_period is not None:
            pulumi.set(__self__, "data_validatiy_period", data_validatiy_period)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if trigger_strategy is not None:
            pulumi.set(__self__, "trigger_strategy", trigger_strategy)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        Specifies the data comparison operator. The valid values are: **>**, **<**,
        **>=**, **<=**, **=** and **between**.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the path of the device property, in the format: **service_id/DataProperty**.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the Rvalue of a data comparison expression. When the `operator` is `between`,
        the Rvalue represents the minimum and maximum values, separated by commas, such as "20,30",
        which means greater than or equal to 20 and less than 30.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="dataValidatiyPeriod")
    def data_validatiy_period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies data validity period, Unit is `seconds`. Defaults to `300`.
        For example, if Data Validity Period is set to 30 minutes, a device generates data at 19:00, and the platform receives
        the data at 20:00, the action is nottriggered regardless of whether the conditions are met.
        """
        return pulumi.get(self, "data_validatiy_period")

    @data_validatiy_period.setter
    def data_validatiy_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_validatiy_period", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device id which excutes the command.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the product id, all devices belonging to this product will trigger
        the rule. Exactly one of `device_id` or `product_id` must be provided.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="triggerStrategy")
    def trigger_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the trigger strategy. The options are as follows:
        + **pulse**: When the data reported by the device meets the conditions, the rule can be triggered.
        + **reverse**: Repetition suppression. For example, if an alarm is configured to be triggered when the battery level
        is lower than 20%, the alarm will be triggered once the battery initially drops below 20% but will not be triggered
        again each time the battery drops to a lower level.
        """
        return pulumi.get(self, "trigger_strategy")

    @trigger_strategy.setter
    def trigger_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_strategy", value)


@pulumi.input_type
class DeviceLinkageRuleTriggerSimpleTimerConditionArgs:
    def __init__(__self__, *,
                 repeat_count: pulumi.Input[int],
                 repeat_interval: pulumi.Input[int],
                 start_time: pulumi.Input[str]):
        """
        :param pulumi.Input[int] repeat_count: Specifies total number of repetition.
        :param pulumi.Input[int] repeat_interval: Specifies the interval of repetition, Unit is `minutes`.
        :param pulumi.Input[str] start_time: Specifies the start time, in the format: `HH:mm`.
               For example: `03:00`.
        """
        pulumi.set(__self__, "repeat_count", repeat_count)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="repeatCount")
    def repeat_count(self) -> pulumi.Input[int]:
        """
        Specifies total number of repetition.
        """
        return pulumi.get(self, "repeat_count")

    @repeat_count.setter
    def repeat_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "repeat_count", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> pulumi.Input[int]:
        """
        Specifies the interval of repetition, Unit is `minutes`.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "repeat_interval", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Specifies the start time, in the format: `HH:mm`.
        For example: `03:00`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class ProductServiceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServicePropertyArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: Specifies the service ID. The ID contains a maximum of 64 characters. Only letters,
               Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandArgs']]] commands: Specifies the list of commands for the service.
               The commands structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[Sequence[pulumi.Input['ProductServicePropertyArgs']]] properties: Specifies the list of properties for the service.
               The properties structure is documented below.
        :param pulumi.Input[str] type: Specifies the type of the parameter.
               The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        pulumi.set(__self__, "id", id)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Specifies the service ID. The ID contains a maximum of 64 characters. Only letters,
        Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandArgs']]]]:
        """
        Specifies the list of commands for the service.
        The commands structure is documented below.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandArgs']]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProductServicePropertyArgs']]]]:
        """
        Specifies the list of properties for the service.
        The properties structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServicePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the parameter.
        The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ProductServiceCommandArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 paras: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandParaArgs']]]] = None,
                 responses: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandResponseArgs']]]] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandParaArgs']]] paras: Specifies the list of parameters for the command.
               The paras structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandResponseArgs']]] responses: Specifies the list of responses for the command.
               The responses structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if paras is not None:
            pulumi.set(__self__, "paras", paras)
        if responses is not None:
            pulumi.set(__self__, "responses", responses)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def paras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandParaArgs']]]]:
        """
        Specifies the list of parameters for the command.
        The paras structure is documented below.
        """
        return pulumi.get(self, "paras")

    @paras.setter
    def paras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandParaArgs']]]]):
        pulumi.set(self, "paras", value)

    @property
    @pulumi.getter
    def responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandResponseArgs']]]]:
        """
        Specifies the list of responses for the command.
        The responses structure is documented below.
        """
        return pulumi.get(self, "responses")

    @responses.setter
    def responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceCommandResponseArgs']]]]):
        pulumi.set(self, "responses", value)


@pulumi.input_type
class ProductServiceCommandParaArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enum_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max: Optional[pulumi.Input[str]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 min: Optional[pulumi.Input[str]] = None,
                 step: Optional[pulumi.Input[float]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] type: Specifies the type of the parameter.
               The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        :param pulumi.Input[str] description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] max: Specifies the max value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        :param pulumi.Input[int] max_length: Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
               **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        :param pulumi.Input[str] min: Specifies the min value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        :param pulumi.Input[float] step: Specifies the step of the parameter when the `type` is **int** or **decimal**.
               Value range: 0 ~ 2147483647. Defaults to **0**.
        :param pulumi.Input[str] unit: Specifies the unit of the parameter when the `type` is **int** or **decimal**.
               The unit contains a maximum of 16 characters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum_lists is not None:
            pulumi.set(__self__, "enum_lists", enum_lists)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the parameter.
        The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enumLists")
    def enum_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "enum_lists")

    @enum_lists.setter
    def enum_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enum_lists", value)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the max value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
        **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the min value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the step of the parameter when the `type` is **int** or **decimal**.
        Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unit of the parameter when the `type` is **int** or **decimal**.
        The unit contains a maximum of 16 characters.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class ProductServiceCommandResponseArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enum_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max: Optional[pulumi.Input[str]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 min: Optional[pulumi.Input[str]] = None,
                 step: Optional[pulumi.Input[float]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] type: Specifies the type of the parameter.
               The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        :param pulumi.Input[str] description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] max: Specifies the max value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        :param pulumi.Input[int] max_length: Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
               **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        :param pulumi.Input[str] min: Specifies the min value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        :param pulumi.Input[float] step: Specifies the step of the parameter when the `type` is **int** or **decimal**.
               Value range: 0 ~ 2147483647. Defaults to **0**.
        :param pulumi.Input[str] unit: Specifies the unit of the parameter when the `type` is **int** or **decimal**.
               The unit contains a maximum of 16 characters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum_lists is not None:
            pulumi.set(__self__, "enum_lists", enum_lists)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the parameter.
        The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enumLists")
    def enum_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "enum_lists")

    @enum_lists.setter
    def enum_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enum_lists", value)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the max value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
        **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the min value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the step of the parameter when the `type` is **int** or **decimal**.
        Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unit of the parameter when the `type` is **int** or **decimal**.
        The unit contains a maximum of 16 characters.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class ProductServicePropertyArgs:
    def __init__(__self__, *,
                 method: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enum_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max: Optional[pulumi.Input[str]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 min: Optional[pulumi.Input[str]] = None,
                 step: Optional[pulumi.Input[float]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] type: Specifies the type of the parameter.
               The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        :param pulumi.Input[str] description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] max: Specifies the max value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        :param pulumi.Input[int] max_length: Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
               **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        :param pulumi.Input[str] min: Specifies the min value of the parameter when the `type` is **int** or **decimal**.
               Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        :param pulumi.Input[float] step: Specifies the step of the parameter when the `type` is **int** or **decimal**.
               Value range: 0 ~ 2147483647. Defaults to **0**.
        :param pulumi.Input[str] unit: Specifies the unit of the parameter when the `type` is **int** or **decimal**.
               The unit contains a maximum of 16 characters.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum_lists is not None:
            pulumi.set(__self__, "enum_lists", enum_lists)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[str]:
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the parameter.
        The valid values are **int**, **decimal**, **string**, **DateTime**, **jsonObject** and **string list**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enumLists")
    def enum_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "enum_lists")

    @enum_lists.setter
    def enum_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enum_lists", value)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the max value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"65535"**.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the max length of the parameter when the `type` is **string**, **DateTime**,
        **jsonObject** or **string list**. Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the min value of the parameter when the `type` is **int** or **decimal**.
        Value range: -2147483647 ~ 2147483647. Defaults to **"0"**.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the step of the parameter when the `type` is **int** or **decimal**.
        Value range: 0 ~ 2147483647. Defaults to **0**.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unit of the parameter when the `type` is **int** or **decimal**.
        The unit contains a maximum of 16 characters.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


